import { jsx } from 'react/jsx-runtime';
import { memo, useCallback } from 'react';
import { FieldMatcherID, fieldMatchers } from '@grafana/data';
import { t } from '@grafana/i18n';
import { Input } from '../Input/Input.mjs';

"use strict";
const FieldNameByRegexMatcherEditor = memo((props) => {
  const { options, onChange } = props;
  const onBlur = useCallback(
    (e) => {
      return onChange(e.target.value);
    },
    [onChange]
  );
  return /* @__PURE__ */ jsx(
    Input,
    {
      placeholder: t("grafana-ui.field-name-by-regex-matcher.input-placeholder", "Enter regular expression"),
      defaultValue: options,
      onBlur
    }
  );
});
FieldNameByRegexMatcherEditor.displayName = "FieldNameByRegexMatcherEditor";
const getFieldNameByRegexMatcherItem = () => ({
  id: FieldMatcherID.byRegexp,
  component: FieldNameByRegexMatcherEditor,
  matcher: fieldMatchers.get(FieldMatcherID.byRegexp),
  name: t("grafana-ui.matchers-ui.name-field-name-by-regex-matcher", "Fields with name matching regex"),
  description: t(
    "grafana-ui.matchers-ui.description-field-name-by-regex-matcher",
    "Set properties for fields with names matching a regex"
  ),
  optionsToLabel: (options) => options
});

export { FieldNameByRegexMatcherEditor, getFieldNameByRegexMatcherItem };
//# sourceMappingURL=FieldNameByRegexMatcherEditor.mjs.map
