import { DataFrame, DataQueryRequest, Field, ScopedVars } from '@grafana/data';
import { PromQuery } from '../types';
type TargetIdent = string;
type TargetSignature = string;
type TimestampMs = number;
type SupportedQueryTypes = PromQuery;
type ApplyInterpolation = (str: string, scopedVars?: ScopedVars) => string;
export declare const defaultPrometheusQueryOverlapWindow = "10m";
interface TargetCache {
    signature: TargetSignature;
    prevTo: TimestampMs;
    frames: DataFrame[];
}
export interface CacheRequestInfo<T extends SupportedQueryTypes> {
    requests: Array<DataQueryRequest<T>>;
    targetSignatures: Map<TargetIdent, TargetSignature>;
    shouldCache: boolean;
}
/**
 * Get field identity
 * This is the string used to uniquely identify a field within a "target"
 * @param field
 */
export declare const getFieldIdentity: (field: Field) => string;
/**
 * NOMENCLATURE
 * Target: The request target (DataQueryRequest), i.e. a specific query reference within a panel
 * Identity: the string that is not expected to change
 * Signature: the string that is expected to change, upon which we wipe the cache fields
 */
export declare class QueryCache<T extends SupportedQueryTypes> {
    private overlapWindowMs;
    private getTargetSignature;
    private applyInterpolation;
    cache: Map<string, TargetCache>;
    constructor(options: {
        getTargetSignature: (request: DataQueryRequest<T>, target: T) => string;
        overlapString: string;
        applyInterpolation?: ApplyInterpolation;
    });
    requestInfo(request: DataQueryRequest<T>): CacheRequestInfo<T>;
    procFrames(request: DataQueryRequest<T>, requestInfo: CacheRequestInfo<T> | undefined, respFrames: DataFrame[]): DataFrame[];
}
export declare function findDatapointStep(request: DataQueryRequest<PromQuery>, respFrames: DataFrame[], applyInterpolation: ApplyInterpolation): number;
export {};
