"use strict";
let singleton;
function setPluginFunctionsHook(hook) {
  if (singleton && process.env.NODE_ENV !== "test") {
    throw new Error("setUsePluginFunctionsHook() function should only be called once, when Grafana is starting.");
  }
  singleton = hook;
}
function usePluginFunctions(options) {
  if (!singleton) {
    throw new Error("usePluginFunctions(options) can only be used after the Grafana instance has started.");
  }
  return singleton(options);
}

export { setPluginFunctionsHook, usePluginFunctions };
//# sourceMappingURL=usePluginFunctions.mjs.map
