import { QueryBuilderOperationParamEditorProps } from '../shared/types';
/**
 * Wrapper component that resolves and renders the appropriate editor component.
 *
 * This component:
 * 1. Takes a parameter definition that may specify an editor by string key or direct reference
 * 2. Resolves the editor component from the map if a string key is used
 * 3. Renders the editor with all necessary props, including the modeller instance
 *
 * This separation of concerns allows operation definitions to be simpler while ensuring
 * editors have access to all the dependencies they need, without creating circular dependencies.
 */
export declare function OperationParamEditorWrapper(props: QueryBuilderOperationParamEditorProps): import("react/jsx-runtime").JSX.Element | null;
