import { useMemo } from 'react';

"use strict";
function getChooserText(metricsLookupDisabled, hasSyntax, hasMetrics) {
  if (metricsLookupDisabled) {
    return "(Disabled)";
  }
  if (!hasSyntax) {
    return "Loading metrics...";
  }
  if (!hasMetrics) {
    return "(No metrics found)";
  }
  return "Metrics browser";
}
function useMetricsState(datasource, languageProvider, syntaxLoaded) {
  return useMemo(() => {
    const hasMetrics = languageProvider.retrieveMetrics().length > 0;
    const chooserText = getChooserText(datasource.lookupsDisabled, syntaxLoaded, hasMetrics);
    const buttonDisabled = !(syntaxLoaded && hasMetrics);
    return {
      hasMetrics,
      chooserText,
      buttonDisabled
    };
  }, [languageProvider, datasource.lookupsDisabled, syntaxLoaded]);
}

export { useMetricsState };
//# sourceMappingURL=useMetricsState.mjs.map
