/**
 * Selectors grouped/defined in Pages
 */
export declare const versionedPages: {
    Alerting: {
        AddAlertRule: {
            url: {
                '10.1.0': string;
                "8.5.0": string;
            };
        };
        EditAlertRule: {
            url: {
                "8.5.0": (alertRuleUid: string) => string;
            };
        };
    };
    Login: {
        url: {
            "8.5.0": string;
        };
        username: {
            '10.2.3': string;
            "8.5.0": string;
        };
        password: {
            '10.2.3': string;
            "8.5.0": string;
        };
        submit: {
            '10.2.3': string;
            "8.5.0": string;
        };
        skip: {
            '10.2.3': string;
        };
    };
    PasswordlessLogin: {
        url: {
            "8.5.0": string;
        };
        email: {
            '10.2.3': string;
            "8.5.0": string;
        };
        submit: {
            '10.2.3': string;
            "8.5.0": string;
        };
    };
    Home: {
        url: {
            "8.5.0": string;
        };
    };
    DataSource: {
        name: {
            '10.3.0': string;
            "8.5.0": string;
        };
        delete: {
            "8.5.0": string;
        };
        readOnly: {
            '10.3.0': string;
            "8.5.0": string;
        };
        saveAndTest: {
            '10.0.0': string;
            "8.5.0": string;
        };
        alert: {
            '10.3.0': string;
            "8.5.0": string;
        };
    };
    DataSources: {
        url: {
            "8.5.0": string;
        };
        dataSources: {
            "8.5.0": (dataSourceName: string) => string;
        };
    };
    EditDataSource: {
        url: {
            '9.5.0': (dataSourceUid: string) => string;
        };
        settings: {
            '9.5.0': string;
        };
    };
    AddDataSource: {
        url: {
            "8.5.0": string;
        };
        dataSourcePluginsV2: {
            '9.3.1': (pluginName: string) => string;
            "8.5.0": (pluginName: string) => string;
        };
    };
    ConfirmModal: {
        delete: {
            '10.0.0': string;
            "8.5.0": string;
        };
    };
    AddDashboard: {
        url: {
            "8.5.0": string;
        };
        itemButton: {
            '9.5.0': (title: string) => string;
        };
        addNewPanel: {
            '11.1.0': string;
            '8.0.0': string;
            "8.5.0": string;
        };
        itemButtonAddViz: {
            "8.5.0": string;
        };
        addNewRow: {
            '11.1.0': string;
            "8.5.0": string;
        };
        addNewPanelLibrary: {
            '11.1.0': string;
            "8.5.0": string;
        };
        Settings: {
            Annotations: {
                List: {
                    url: {
                        "8.5.0": string;
                    };
                };
                Edit: {
                    url: {
                        "8.5.0": (annotationIndex: string) => string;
                    };
                };
            };
            Variables: {
                List: {
                    url: {
                        '11.3.0': string;
                        "8.5.0": string;
                    };
                };
                Edit: {
                    url: {
                        '11.3.0': (editIndex: string) => string;
                        "8.5.0": (editIndex: string) => string;
                    };
                };
            };
        };
    };
    ImportDashboard: {
        url: {
            "8.5.0": string;
        };
    };
    Dashboard: {
        url: {
            "8.5.0": (uid: string) => string;
        };
        DashNav: {
            nav: {
                "8.5.0": string;
            };
            navV2: {
                "8.5.0": string;
            };
            publicDashboardTag: {
                '9.1.0': string;
            };
            shareButton: {
                '10.4.0': string;
            };
            scrollContainer: {
                '11.1.0': string;
            };
            newShareButton: {
                container: {
                    '11.1.0': string;
                };
                shareLink: {
                    '11.1.0': string;
                };
                arrowMenu: {
                    '11.1.0': string;
                };
                menu: {
                    container: {
                        '11.1.0': string;
                    };
                    shareInternally: {
                        '11.1.0': string;
                    };
                    shareExternally: {
                        '11.1.1': string;
                    };
                    shareSnapshot: {
                        '11.2.0': string;
                    };
                };
            };
            NewExportButton: {
                container: {
                    '11.2.0': string;
                };
                arrowMenu: {
                    '11.2.0': string;
                };
                Menu: {
                    container: {
                        '11.2.0': string;
                    };
                    exportAsJson: {
                        '11.2.0': string;
                    };
                };
            };
            playlistControls: {
                prev: {
                    '11.0.0': string;
                };
                stop: {
                    '11.0.0': string;
                };
                next: {
                    '11.0.0': string;
                };
            };
        };
        Controls: {
            '11.1.0': string;
        };
        SubMenu: {
            submenu: {
                "8.5.0": string;
            };
            submenuItem: {
                "8.5.0": string;
            };
            submenuItemLabels: {
                "8.5.0": (item: string) => string;
            };
            submenuItemValueDropDownValueLinkTexts: {
                "8.5.0": (item: string) => string;
            };
            submenuItemValueDropDownDropDown: {
                "8.5.0": string;
            };
            submenuItemValueDropDownOptionTexts: {
                "8.5.0": (item: string) => string;
            };
            Annotations: {
                annotationsWrapper: {
                    '10.0.0': string;
                };
                annotationLabel: {
                    '10.0.0': (label: string) => string;
                };
                annotationToggle: {
                    '10.0.0': (label: string) => string;
                };
            };
        };
        Settings: {
            Actions: {
                close: {
                    '9.5.0': string;
                };
            };
            General: {
                deleteDashBoard: {
                    '11.1.0': string;
                };
                sectionItems: {
                    "8.5.0": (item: string) => string;
                };
                saveDashBoard: {
                    "8.5.0": string;
                };
                saveAsDashBoard: {
                    "8.5.0": string;
                };
                title: {
                    '11.2.0': string;
                };
            };
            Annotations: {
                Edit: {
                    urlParams: {
                        "8.5.0": (annotationIndex: string) => string;
                    };
                };
                List: {
                    url: {
                        "8.5.0": (dashboardUid: string) => string;
                    };
                    addAnnotationCTAV2: {
                        "8.5.0": string;
                    };
                    annotations: {
                        '10.4.0': string;
                    };
                };
                Settings: {
                    name: {
                        '11.1.0': string;
                        "8.5.0": string;
                    };
                };
                NewAnnotation: {
                    panelFilterSelect: {
                        '10.0.0': string;
                    };
                    showInLabel: {
                        '11.1.0': string;
                    };
                    previewInDashboard: {
                        '10.0.0': string;
                    };
                    delete: {
                        '10.4.0': string;
                    };
                    apply: {
                        '10.4.0': string;
                    };
                    enable: {
                        '10.4.0': string;
                    };
                    hide: {
                        '10.4.0': string;
                    };
                };
            };
            Variables: {
                List: {
                    url: {
                        '11.3.0': (dashboardUid: string) => string;
                        "8.5.0": (dashboardUid: string) => string;
                    };
                    addVariableCTAV2: {
                        "8.5.0": string;
                    };
                    newButton: {
                        "8.5.0": string;
                    };
                    table: {
                        "8.5.0": string;
                    };
                    tableRowNameFields: {
                        "8.5.0": (variableName: string) => string;
                    };
                    tableRowDefinitionFields: {
                        '10.1.0': (variableName: string) => string;
                    };
                    tableRowArrowUpButtons: {
                        "8.5.0": (variableName: string) => string;
                    };
                    tableRowArrowDownButtons: {
                        "8.5.0": (variableName: string) => string;
                    };
                    tableRowDuplicateButtons: {
                        "8.5.0": (variableName: string) => string;
                    };
                    tableRowRemoveButtons: {
                        "8.5.0": (variableName: string) => string;
                    };
                };
                Edit: {
                    urlParams: {
                        '11.3.0': (editIndex: string) => string;
                        "8.5.0": (editIndex: string) => string;
                    };
                    General: {
                        headerLink: {
                            "8.5.0": string;
                        };
                        modeLabelNew: {
                            "8.5.0": string;
                        };
                        /**
                         * @deprecated
                         */
                        modeLabelEdit: {
                            "8.5.0": string;
                        };
                        generalNameInput: {
                            "8.5.0": string;
                        };
                        generalNameInputV2: {
                            "8.5.0": string;
                        };
                        generalTypeSelect: {
                            "8.5.0": string;
                        };
                        generalTypeSelectV2: {
                            "8.5.0": string;
                        };
                        generalLabelInput: {
                            "8.5.0": string;
                        };
                        generalLabelInputV2: {
                            "8.5.0": string;
                        };
                        generalHideSelect: {
                            "8.5.0": string;
                        };
                        generalHideSelectV2: {
                            "8.5.0": string;
                        };
                        selectionOptionsAllowCustomValueSwitch: {
                            "8.5.0": string;
                        };
                        selectionOptionsMultiSwitch: {
                            '10.4.0': string;
                            "8.5.0": string;
                        };
                        selectionOptionsIncludeAllSwitch: {
                            '10.4.0': string;
                            "8.5.0": string;
                        };
                        selectionOptionsCustomAllInput: {
                            '10.4.0': string;
                            "8.5.0": string;
                        };
                        previewOfValuesOption: {
                            '10.4.0': string;
                            "8.5.0": string;
                        };
                        submitButton: {
                            '10.4.0': string;
                            "8.5.0": string;
                        };
                        applyButton: {
                            '9.3.0': string;
                        };
                    };
                    QueryVariable: {
                        closeButton: {
                            "8.5.0": string;
                        };
                        editor: {
                            "8.5.0": string;
                        };
                        previewButton: {
                            "8.5.0": string;
                        };
                        queryOptionsDataSourceSelect: {
                            '10.4.0': string;
                            '10.0.0': string;
                            "8.5.0": string;
                        };
                        queryOptionsOpenButton: {
                            "8.5.0": string;
                        };
                        queryOptionsRefreshSelect: {
                            "8.5.0": string;
                        };
                        queryOptionsRefreshSelectV2: {
                            "8.5.0": string;
                        };
                        queryOptionsRegExInput: {
                            "8.5.0": string;
                        };
                        queryOptionsRegExInputV2: {
                            "8.5.0": string;
                        };
                        queryOptionsSortSelect: {
                            "8.5.0": string;
                        };
                        queryOptionsSortSelectV2: {
                            "8.5.0": string;
                        };
                        queryOptionsQueryInput: {
                            '10.4.0': string;
                        };
                        valueGroupsTagsEnabledSwitch: {
                            "8.5.0": string;
                        };
                        valueGroupsTagsTagsQueryInput: {
                            "8.5.0": string;
                        };
                        valueGroupsTagsTagsValuesQueryInput: {
                            "8.5.0": string;
                        };
                    };
                    ConstantVariable: {
                        constantOptionsQueryInput: {
                            "8.5.0": string;
                        };
                        constantOptionsQueryInputV2: {
                            "8.5.0": string;
                        };
                    };
                    DatasourceVariable: {
                        datasourceSelect: {
                            "8.5.0": string;
                        };
                        nameFilter: {
                            "8.5.0": string;
                        };
                    };
                    TextBoxVariable: {
                        textBoxOptionsQueryInput: {
                            "8.5.0": string;
                        };
                        textBoxOptionsQueryInputV2: {
                            "8.5.0": string;
                        };
                    };
                    CustomVariable: {
                        customValueInput: {
                            "8.5.0": string;
                        };
                    };
                    IntervalVariable: {
                        intervalsValueInput: {
                            "8.5.0": string;
                        };
                        autoEnabledCheckbox: {
                            '10.4.0': string;
                        };
                        stepCountIntervalSelect: {
                            '10.4.0': string;
                        };
                        minIntervalInput: {
                            '10.4.0': string;
                        };
                    };
                    GroupByVariable: {
                        dataSourceSelect: {
                            '10.4.0': string;
                        };
                        infoText: {
                            '10.4.0': string;
                        };
                        modeToggle: {
                            '10.4.0': string;
                        };
                    };
                    AdHocFiltersVariable: {
                        datasourceSelect: {
                            '10.4.0': string;
                        };
                        infoText: {
                            '10.4.0': string;
                        };
                        modeToggle: {
                            '11.0.0': string;
                        };
                    };
                };
            };
        };
        Annotations: {
            marker: {
                '10.0.0': string;
            };
        };
        Rows: {
            Repeated: {
                ConfigSection: {
                    warningMessage: {
                        '10.2.0': string;
                    };
                };
            };
        };
    };
    Dashboards: {
        url: {
            "8.5.0": string;
        };
        dashboards: {
            '10.2.0': (title: string) => string;
        };
        toggleView: {
            "8.5.0": string;
        };
    };
    SaveDashboardAsModal: {
        newName: {
            '10.2.0': string;
        };
        save: {
            '10.2.0': string;
        };
    };
    SaveDashboardModal: {
        save: {
            '10.2.0': string;
        };
        saveVariables: {
            '10.2.0': string;
        };
        saveTimerange: {
            '10.2.0': string;
        };
        saveRefresh: {
            '11.1.0': string;
        };
    };
    SharePanelModal: {
        linkToRenderedImage: {
            "8.5.0": string;
        };
    };
    ShareDashboardModal: {
        PublicDashboard: {
            WillBePublicCheckbox: {
                '9.1.0': string;
            };
            LimitedDSCheckbox: {
                '9.1.0': string;
            };
            CostIncreaseCheckbox: {
                '9.1.0': string;
            };
            PauseSwitch: {
                '9.5.0': string;
            };
            EnableAnnotationsSwitch: {
                '9.3.0': string;
            };
            CreateButton: {
                '9.5.0': string;
            };
            DeleteButton: {
                '9.3.0': string;
            };
            CopyUrlInput: {
                '9.1.0': string;
            };
            CopyUrlButton: {
                '9.1.0': string;
            };
            SettingsDropdown: {
                '10.1.0': string;
            };
            TemplateVariablesWarningAlert: {
                '9.1.0': string;
            };
            UnsupportedDataSourcesWarningAlert: {
                '9.5.0': string;
            };
            NoUpsertPermissionsWarningAlert: {
                '9.5.0': string;
            };
            EnableTimeRangeSwitch: {
                '9.4.0': string;
            };
            EmailSharingConfiguration: {
                Container: {
                    '9.5.0': string;
                };
                ShareType: {
                    '9.5.0': string;
                };
                EmailSharingInput: {
                    '9.5.0': string;
                };
                EmailSharingInviteButton: {
                    '9.5.0': string;
                };
                EmailSharingList: {
                    '9.5.0': string;
                };
                DeleteEmail: {
                    '9.5.0': string;
                };
                ReshareLink: {
                    '9.5.0': string;
                };
            };
        };
        SnapshotScene: {
            url: {
                '11.1.0': (key: string) => string;
            };
            PublishSnapshot: {
                '11.1.0': string;
            };
            CopyUrlButton: {
                '11.1.0': string;
            };
            CopyUrlInput: {
                '11.1.0': string;
            };
        };
    };
    ShareDashboardDrawer: {
        ShareInternally: {
            container: {
                '11.3.0': string;
            };
            lockTimeRangeSwitch: {
                '11.3.0': string;
            };
            shortenUrlSwitch: {
                '11.3.0': string;
            };
            copyUrlButton: {
                '11.3.0': string;
            };
            SharePanel: {
                preview: {
                    '11.5.0': string;
                };
                widthInput: {
                    '11.5.0': string;
                };
                heightInput: {
                    '11.5.0': string;
                };
                scaleFactorInput: {
                    '11.5.0': string;
                };
                generateImageButton: {
                    '11.5.0': string;
                };
                downloadImageButton: {
                    '11.5.0': string;
                };
            };
        };
        ShareExternally: {
            container: {
                '11.3.0': string;
            };
            publicAlert: {
                '11.3.0': string;
            };
            emailSharingAlert: {
                '11.3.0': string;
            };
            shareTypeSelect: {
                '11.3.0': string;
            };
            Creation: {
                PublicShare: {
                    createButton: {
                        '11.3.0': string;
                    };
                    cancelButton: {
                        '11.3.0': string;
                    };
                };
                EmailShare: {
                    createButton: {
                        '11.3.0': string;
                    };
                    cancelButton: {
                        '11.3.0': string;
                    };
                };
                willBePublicCheckbox: {
                    '11.3.0': string;
                };
            };
            Configuration: {
                enableTimeRangeSwitch: {
                    '11.3.0': string;
                };
                enableAnnotationsSwitch: {
                    '11.3.0': string;
                };
                copyUrlButton: {
                    '11.3.0': string;
                };
                revokeAccessButton: {
                    '11.3.0': string;
                };
                toggleAccessButton: {
                    '11.3.0': string;
                };
            };
        };
        ShareSnapshot: {
            url: {
                '11.3.0': (key: string) => string;
            };
            container: {
                '11.3.0': string;
            };
            publishSnapshot: {
                '11.3.0': string;
            };
            copyUrlButton: {
                '11.3.0': string;
            };
        };
    };
    ExportDashboardDrawer: {
        ExportAsJson: {
            container: {
                '11.3.0': string;
            };
            codeEditor: {
                '11.3.0': string;
            };
            exportExternallyToggle: {
                '11.3.0': string;
            };
            saveToFileButton: {
                '11.3.0': string;
            };
            copyToClipboardButton: {
                '11.3.0': string;
            };
            cancelButton: {
                '11.3.0': string;
            };
        };
    };
    PublicDashboard: {
        page: {
            '9.5.0': string;
        };
        NotAvailable: {
            container: {
                '9.5.0': string;
            };
            title: {
                '9.5.0': string;
            };
            pausedDescription: {
                '9.5.0': string;
            };
        };
        footer: {
            '11.0.0': string;
        };
    };
    PublicDashboardScene: {
        loadingPage: {
            '11.0.0': string;
        };
        page: {
            '11.0.0': string;
        };
        controls: {
            '11.0.0': string;
        };
    };
    RequestViewAccess: {
        form: {
            '9.5.0': string;
        };
        recipientInput: {
            '9.5.0': string;
        };
        submitButton: {
            '9.5.0': string;
        };
    };
    PublicDashboardConfirmAccess: {
        submitButton: {
            '10.2.0': string;
        };
    };
    Explore: {
        url: {
            "8.5.0": string;
        };
        General: {
            container: {
                "8.5.0": string;
            };
            graph: {
                "8.5.0": string;
            };
            table: {
                "8.5.0": string;
            };
            scrollView: {
                '9.0.0': string;
            };
            addFromQueryLibrary: {
                '11.5.0': string;
            };
        };
        QueryHistory: {
            container: {
                '11.1.0': string;
            };
        };
    };
    SoloPanel: {
        url: {
            "8.5.0": (page: string) => string;
        };
    };
    PluginsList: {
        page: {
            "8.5.0": string;
        };
        list: {
            "8.5.0": string;
        };
        listItem: {
            "8.5.0": string;
        };
        signatureErrorNotice: {
            '10.3.0': string;
            "8.5.0": string;
        };
    };
    PluginPage: {
        page: {
            "8.5.0": string;
        };
        signatureInfo: {
            '10.3.0': string;
            "8.5.0": string;
        };
        disabledInfo: {
            '10.3.0': string;
            "8.5.0": string;
        };
    };
    PlaylistForm: {
        name: {
            "8.5.0": string;
        };
        interval: {
            "8.5.0": string;
        };
        itemDelete: {
            '10.2.0': string;
        };
    };
    BrowseDashboards: {
        table: {
            body: {
                '10.2.0': string;
            };
            row: {
                '10.2.0': (name: string) => string;
            };
            checkbox: {
                '10.0.0': (uid: string) => string;
            };
        };
        NewFolderForm: {
            form: {
                '10.2.0': string;
            };
            nameInput: {
                '10.2.0': string;
            };
            createButton: {
                '10.2.0': string;
            };
        };
    };
    SearchDashboards: {
        table: {
            '10.2.0': string;
        };
    };
    Search: {
        url: {
            '9.3.0': string;
        };
        FolderView: {
            url: {
                '9.3.0': string;
            };
        };
    };
    PublicDashboards: {
        ListItem: {
            linkButton: {
                '9.3.0': string;
            };
            configButton: {
                '9.3.0': string;
            };
            trashcanButton: {
                '9.3.0': string;
            };
            pauseSwitch: {
                '10.1.0': string;
            };
        };
    };
    UserListPage: {
        tabs: {
            allUsers: {
                '10.0.0': string;
            };
            orgUsers: {
                '10.0.0': string;
            };
            anonUserDevices: {
                '10.2.3': string;
            };
            publicDashboardsUsers: {
                '10.0.0': string;
            };
            users: {
                '10.0.0': string;
            };
        };
        org: {
            url: {
                '10.2.0': string;
                '9.5.0': string;
            };
        };
        admin: {
            url: {
                '9.5.0': string;
            };
        };
        publicDashboards: {
            container: {
                '11.1.0': string;
            };
        };
        UserListAdminPage: {
            container: {
                '10.0.0': string;
            };
        };
        UsersListPage: {
            container: {
                '10.0.0': string;
            };
        };
        UserAnonListPage: {
            container: {
                '10.4.0': string;
            };
        };
        UsersListPublicDashboardsPage: {
            container: {
                '10.0.0': string;
            };
            DashboardsListModal: {
                listItem: {
                    '10.0.0': (uid: string) => string;
                };
            };
        };
    };
    ProfilePage: {
        url: {
            '10.2.0': string;
        };
    };
    Plugin: {
        url: {
            "8.5.0": (pluginId: string) => string;
        };
    };
    MigrateToCloud: {
        url: {
            '11.2.0': string;
        };
    };
};
export type VersionedPages = typeof versionedPages;
