import { jsx } from 'react/jsx-runtime';
import { FeatureState } from '@grafana/data';
import { t } from '@grafana/i18n';
import { Badge } from '../Badge/Badge.mjs';

"use strict";
const FeatureBadge = ({ featureState, tooltip }) => {
  const display = getPanelStateBadgeDisplayModel(featureState);
  return /* @__PURE__ */ jsx(Badge, { text: display.text, color: display.color, icon: display.icon, tooltip });
};
function getPanelStateBadgeDisplayModel(featureState) {
  switch (featureState) {
    case FeatureState.alpha:
      return {
        text: "Alpha",
        icon: "exclamation-triangle",
        color: "orange"
      };
    case FeatureState.beta:
      return {
        text: "Beta",
        icon: "rocket",
        color: "blue"
      };
    case FeatureState.experimental:
      return {
        text: t("grafana-ui.feature-badge.experimental", "Experimental"),
        icon: "exclamation-triangle",
        color: "orange"
      };
    case FeatureState.preview:
      return {
        text: t("grafana-ui.feature-badge.preview", "Preview"),
        icon: "rocket",
        color: "blue"
      };
    case FeatureState.privatePreview:
      return {
        text: t("grafana-ui.feature-badge.private-preview", "Private preview"),
        icon: "rocket",
        color: "blue"
      };
    case FeatureState.new:
      return {
        text: t("grafana-ui.feature-badge.new", "New!"),
        icon: "rocket",
        color: "blue"
      };
  }
}

export { FeatureBadge };
//# sourceMappingURL=FeatureBadge.mjs.map
