import { t } from '@grafana/i18n';

"use strict";
function addTextSizeOptions(builder, withTitle = true) {
  const category = [t("grafana-ui.builder.text.category-text-size", "Text size")];
  if (withTitle) {
    builder.addNumberInput({
      path: "text.titleSize",
      category,
      name: t("grafana-ui.builder.text.name-title", "Title"),
      settings: {
        placeholder: t("grafana-ui.builder.text.placeholder-title", "Auto"),
        integer: false,
        min: 1,
        max: 200
      },
      defaultValue: void 0
    });
  }
  builder.addNumberInput({
    path: "text.valueSize",
    category,
    name: t("grafana-ui.builder.text.name-value", "Value"),
    settings: {
      placeholder: t("grafana-ui.builder.text.placeholder-value", "Auto"),
      integer: false,
      min: 1,
      max: 200
    },
    defaultValue: void 0
  });
  builder.addNumberInput({
    path: "text.percentSize",
    category,
    name: t("grafana-ui.builder.text.name-percent-change", "Percent change"),
    settings: {
      placeholder: t("grafana-ui.builder.text.placeholder-percent-change", "Auto"),
      integer: false,
      min: 1,
      max: 200
    },
    defaultValue: void 0
  });
}

export { addTextSizeOptions };
//# sourceMappingURL=text.mjs.map
