import { jsx } from 'react/jsx-runtime';
import { Tab } from '../Tabs/Tab.mjs';
import { TabsBar } from '../Tabs/TabsBar.mjs';
import { ModalHeader } from './ModalHeader.mjs';

"use strict";
const ModalTabsHeader = ({ icon, title, tabs, activeTab, onChangeTab }) => {
  return /* @__PURE__ */ jsx(ModalHeader, { icon, title, children: /* @__PURE__ */ jsx(TabsBar, { hideBorder: true, children: tabs.map((t, index) => {
    return /* @__PURE__ */ jsx(
      Tab,
      {
        label: t.label,
        icon: t.icon,
        suffix: t.tabSuffix,
        active: t.value === activeTab,
        onChangeTab: () => onChangeTab(t)
      },
      `${t.value}-${index}`
    );
  }) }) });
};

export { ModalTabsHeader };
//# sourceMappingURL=ModalTabsHeader.mjs.map
