/**
 * This file contains enhanced and type-narrowed versions of the types generated by the RTKQ codegen package.
 */
import { MergeDeep, MergeExclusive, OverrideProperties } from 'type-fest';
import type { ListReceiverApiResponse, Receiver, ReceiverIntegration } from './api.gen';
type GenericIntegration = OverrideProperties<ReceiverIntegration, {
    settings: Record<string, unknown>;
}>;
type EmailIntegration = OverrideProperties<GenericIntegration, {
    type: 'email';
    settings: {
        singleEmail?: boolean;
        addresses: string;
        message?: string;
        subject?: string;
    };
    secureFields: never;
}>;
type SlackIntegration = OverrideProperties<GenericIntegration, {
    type: 'slack';
    settings: {
        endpointUrl?: string;
        url?: string;
        recipient?: string;
        text?: string;
        title?: string;
        username?: string;
        icon_emoji?: string;
        icon_url?: string;
        mentionChannel?: string;
        mentionUsers?: string;
        mentionGroups?: string;
        color?: string;
    };
    secureFields: MergeExclusive<{
        token: string;
    }, {
        url: string;
    }>;
}>;
type OnCallIntegration = OverrideProperties<GenericIntegration, {
    type: 'OnCall';
    settings: {
        url: string;
        httpMethod?: 'POST' | 'PUT';
        maxAlerts?: number;
        authorization_scheme?: string;
        authorization_credentials?: string;
        username?: string;
        password?: string;
        title?: string;
        message?: string;
    };
}>;
export type Integration = EmailIntegration | SlackIntegration | OnCallIntegration | GenericIntegration;
export type ContactPoint = MergeDeep<Receiver, {
    metadata: {
        annotations: ContactPointMetadataAnnotations;
    };
    spec: {
        integrations: Integration[];
    };
}>;
export type ContactPointMetadataAnnotations = AlertingEntityMetadataAnnotations & Partial<{
    'grafana.com/access/canReadSecrets': 'true' | 'false';
    'grafana.com/inUse/routes': `${number}`;
    'grafana.com/inUse/rules': `${number}`;
}>;
export type AlertingEntityMetadataAnnotations = Partial<{
    'grafana.com/access/canAdmin': 'true' | 'false';
    'grafana.com/access/canDelete': 'true' | 'false';
    'grafana.com/access/canWrite': 'true' | 'false';
    'grafana.com/provenance': string;
}>;
export type EnhancedListReceiverApiResponse = OverrideProperties<ListReceiverApiResponse, {
    items: ContactPoint[];
}>;
export {};
