/**
 * Selectors grouped/defined in Components
 */
export declare const versionedComponents: {
    RadioButton: {
        container: {
            '10.2.3': string;
        };
    };
    Breadcrumbs: {
        breadcrumb: {
            '9.4.0': (title: string) => string;
        };
    };
    CanvasGridAddActions: {
        addPanel: {
            '12.1.0': string;
        };
        groupPanels: {
            '12.1.0': string;
        };
        ungroup: {
            '12.1.0': string;
        };
        addRow: {
            '12.1.0': string;
        };
        pasteRow: {
            '12.1.0': string;
        };
        addTab: {
            '12.1.0': string;
        };
        pasteTab: {
            '12.1.0': string;
        };
    };
    DashboardEditPaneSplitter: {
        primaryBody: {
            '12.1.0': string;
        };
    };
    EditPaneHeader: {
        deleteButton: {
            '12.1.0': string;
        };
        copyDropdown: {
            '12.1.0': string;
        };
        copy: {
            '12.1.0': string;
        };
        duplicate: {
            '12.1.0': string;
        };
        backButton: {
            '12.1.0': string;
        };
    };
    TimePicker: {
        openButton: {
            "8.5.0": string;
        };
        overlayContent: {
            '10.2.3': string;
        };
        fromField: {
            '10.2.3': string;
            "8.5.0": string;
        };
        toField: {
            '10.2.3': string;
            "8.5.0": string;
        };
        applyTimeRange: {
            "8.5.0": string;
        };
        copyTimeRange: {
            '10.4.0': string;
        };
        pasteTimeRange: {
            '10.4.0': string;
        };
        calendar: {
            label: {
                '10.2.3': string;
                "8.5.0": string;
            };
            openButton: {
                '10.2.3': string;
                "8.5.0": string;
            };
            closeButton: {
                '10.2.3': string;
                "8.5.0": string;
            };
        };
        absoluteTimeRangeTitle: {
            "8.5.0": string;
        };
    };
    DataSourcePermissions: {
        form: {
            '9.5.0': () => string;
        };
        roleType: {
            '9.5.0': string;
        };
        rolePicker: {
            '9.5.0': string;
        };
        permissionLevel: {
            '12.0.0': string;
            '9.5.0': string;
        };
    };
    DateTimePicker: {
        input: {
            '10.2.3': string;
        };
    };
    DataSource: {
        TestData: {
            QueryTab: {
                scenarioSelectContainer: {
                    "8.5.0": string;
                };
                scenarioSelect: {
                    "8.5.0": string;
                };
                max: {
                    "8.5.0": string;
                };
                min: {
                    "8.5.0": string;
                };
                noise: {
                    "8.5.0": string;
                };
                seriesCount: {
                    "8.5.0": string;
                };
                spread: {
                    "8.5.0": string;
                };
                startValue: {
                    "8.5.0": string;
                };
                drop: {
                    "8.5.0": string;
                };
            };
        };
        DataSourceHttpSettings: {
            urlInput: {
                '10.4.0': string;
                "8.5.0": string;
            };
        };
        Jaeger: {
            traceIDInput: {
                "8.5.0": string;
            };
        };
        Prometheus: {
            configPage: {
                connectionSettings: {
                    "8.5.0": string;
                };
                manageAlerts: {
                    '10.4.0': string;
                };
                allowAsRecordingRulesTarget: {
                    '12.1.0': string;
                };
                scrapeInterval: {
                    '10.4.0': string;
                };
                queryTimeout: {
                    '10.4.0': string;
                };
                defaultEditor: {
                    '10.4.0': string;
                };
                disableMetricLookup: {
                    '10.4.0': string;
                };
                prometheusType: {
                    '10.4.0': string;
                };
                prometheusVersion: {
                    '10.4.0': string;
                };
                cacheLevel: {
                    '10.4.0': string;
                };
                incrementalQuerying: {
                    '10.4.0': string;
                };
                queryOverlapWindow: {
                    '10.4.0': string;
                };
                disableRecordingRules: {
                    '10.4.0': string;
                };
                customQueryParameters: {
                    '10.4.0': string;
                };
                httpMethod: {
                    '10.4.0': string;
                };
                exemplarsAddButton: {
                    '10.3.0': string;
                    "8.5.0": string;
                };
                internalLinkSwitch: {
                    '10.3.0': string;
                    "8.5.0": string;
                };
                codeModeMetricNamesSuggestionLimit: {
                    '11.1.0': string;
                };
                seriesLimit: {
                    '12.0.2': string;
                };
            };
            queryEditor: {
                explain: {
                    '10.4.0': string;
                };
                editorToggle: {
                    '10.4.0': string;
                };
                options: {
                    '10.4.0': string;
                };
                legend: {
                    '10.4.0': string;
                };
                format: {
                    '10.4.0': string;
                };
                step: {
                    '10.4.0': string;
                };
                type: {
                    '10.4.0': string;
                };
                exemplars: {
                    '10.4.0': string;
                };
                builder: {
                    metricSelect: {
                        '10.4.0': string;
                    };
                    hints: {
                        '10.4.0': string;
                    };
                    metricsExplorer: {
                        '10.4.0': string;
                    };
                    queryAdvisor: {
                        '10.4.0': string;
                    };
                };
                code: {
                    queryField: {
                        '10.4.0': string;
                    };
                    metricsCountInfo: {
                        '11.1.0': string;
                    };
                    metricsBrowser: {
                        openButton: {
                            '10.4.0': string;
                        };
                        selectMetric: {
                            '10.4.0': string;
                        };
                        seriesLimit: {
                            '10.3.1': string;
                        };
                        metricList: {
                            '10.4.0': string;
                        };
                        labelNamesFilter: {
                            '10.4.0': string;
                        };
                        labelValuesFilter: {
                            '10.4.0': string;
                        };
                        useQuery: {
                            '10.4.0': string;
                        };
                        useAsRateQuery: {
                            '10.4.0': string;
                        };
                        validateSelector: {
                            '10.4.0': string;
                        };
                        clear: {
                            '10.4.0': string;
                        };
                    };
                };
            };
            exemplarMarker: {
                '10.3.0': string;
                "8.5.0": string;
            };
            variableQueryEditor: {
                queryType: {
                    '10.4.0': string;
                };
                labelnames: {
                    metricRegex: {
                        '10.4.0': string;
                    };
                };
                labelValues: {
                    labelSelect: {
                        '10.4.0': string;
                    };
                };
                metricNames: {
                    metricRegex: {
                        '10.4.0': string;
                    };
                };
                varQueryResult: {
                    '10.4.0': string;
                };
                seriesQuery: {
                    '10.4.0': string;
                };
                classicQuery: {
                    '10.4.0': string;
                };
            };
            annotations: {
                minStep: {
                    '10.4.0': string;
                };
                title: {
                    '10.4.0': string;
                };
                tags: {
                    '10.4.0': string;
                };
                text: {
                    '10.4.0': string;
                };
                seriesValueAsTimestamp: {
                    '10.4.0': string;
                };
            };
        };
    };
    Menu: {
        MenuComponent: {
            "8.5.0": (title: string) => string;
        };
        MenuGroup: {
            "8.5.0": (title: string) => string;
        };
        MenuItem: {
            "8.5.0": (title: string) => string;
        };
        SubMenu: {
            container: {
                '10.3.0': string;
                "8.5.0": string;
            };
            icon: {
                '10.3.0': string;
                "8.5.0": string;
            };
        };
    };
    Panels: {
        Panel: {
            title: {
                "8.5.0": (title: string) => string;
            };
            content: {
                '11.1.0': string;
            };
            headerContainer: {
                '9.5.0': string;
            };
            headerItems: {
                '10.2.0': (item: string) => string;
            };
            menuItems: {
                '9.5.0': (item: string) => string;
            };
            menu: {
                '9.5.0': (title: string) => string;
            };
            containerByTitle: {
                "8.5.0": (title: string) => string;
            };
            headerCornerInfo: {
                "8.5.0": (mode: string) => string;
            };
            status: {
                '10.2.0': (status: string) => string;
                "8.5.0": (_: string) => string;
            };
            loadingBar: {
                '10.0.0': () => string;
            };
            HoverWidget: {
                container: {
                    '10.1.0': string;
                    "8.5.0": string;
                };
                dragIcon: {
                    '10.0.0': string;
                };
            };
            PanelDataErrorMessage: {
                '10.4.0': string;
            };
        };
        Visualization: {
            Graph: {
                container: {
                    '9.5.0': string;
                };
                VisualizationTab: {
                    legendSection: {
                        "8.5.0": string;
                    };
                };
                Legend: {
                    legendItemAlias: {
                        "8.5.0": (name: string) => string;
                    };
                    showLegendSwitch: {
                        "8.5.0": string;
                    };
                };
                xAxis: {
                    labels: {
                        "8.5.0": () => string;
                    };
                };
            };
            BarGauge: {
                valueV2: {
                    "8.5.0": string;
                };
            };
            PieChart: {
                svgSlice: {
                    '10.3.0': string;
                };
            };
            Text: {
                container: {
                    "8.5.0": () => string;
                };
            };
            Table: {
                header: {
                    "8.5.0": string;
                };
                footer: {
                    "8.5.0": string;
                };
                body: {
                    '10.2.0': string;
                };
            };
        };
    };
    VizLegend: {
        seriesName: {
            '10.3.0': (name: string) => string;
        };
    };
    Drawer: {
        General: {
            title: {
                "8.5.0": (title: string) => string;
            };
            expand: {
                "8.5.0": string;
            };
            contract: {
                "8.5.0": string;
            };
            close: {
                '10.3.0': string;
                "8.5.0": string;
            };
            rcContentWrapper: {
                '9.4.0': () => string;
            };
            subtitle: {
                '10.4.0': string;
            };
        };
        DashboardSaveDrawer: {
            saveButton: {
                '11.1.0': string;
            };
            saveAsButton: {
                '11.1.0': string;
            };
            saveAsTitleInput: {
                '11.1.0': string;
            };
        };
    };
    PanelEditor: {
        General: {
            content: {
                '11.1.0': string;
                '8.0.0': string;
            };
        };
        OptionsPane: {
            content: {
                '11.1.0': string;
                "8.5.0": string;
            };
            select: {
                "8.5.0": string;
            };
            fieldLabel: {
                "8.5.0": (type: string) => string;
            };
            fieldInput: {
                '11.0.0': (title: string) => string;
            };
        };
        DataPane: {
            content: {
                '11.1.0': string;
                "8.5.0": string;
            };
        };
        applyButton: {
            '9.2.0': string;
            '9.1.0': string;
            '8.0.0': string;
        };
        toggleVizPicker: {
            '10.0.0': string;
            '8.0.0': string;
        };
        toggleVizOptions: {
            '10.1.0': string;
            "8.5.0": string;
        };
        toggleTableView: {
            '11.1.0': string;
            "8.5.0": string;
        };
        showZoomField: {
            '10.2.0': string;
        };
        showAttributionField: {
            '10.2.0': string;
        };
        showScaleField: {
            '10.2.0': string;
        };
        showMeasureField: {
            '10.2.0': string;
        };
        showDebugField: {
            '10.2.0': string;
        };
        measureButton: {
            '12.1.0': string;
            '9.2.0': string;
        };
        Outline: {
            section: {
                '12.0.0': string;
            };
            node: {
                '12.0.0': (type: string) => string;
            };
            item: {
                '12.0.0': (type: string) => string;
            };
        };
        ElementEditPane: {
            variableType: {
                '12.0.0': (type?: string) => string;
            };
            addVariableButton: {
                '12.0.0': string;
            };
            variableNameInput: {
                '12.0.0': string;
            };
            variableLabelInput: {
                '12.0.0': string;
            };
            AutoGridLayout: {
                minColumnWidth: {
                    '12.1.0': string;
                };
                customMinColumnWidth: {
                    '12.1.0': string;
                };
                clearCustomMinColumnWidth: {
                    '12.1.0': string;
                };
                maxColumns: {
                    '12.1.0': string;
                };
                rowHeight: {
                    '12.1.0': string;
                };
                customRowHeight: {
                    '12.1.0': string;
                };
                clearCustomRowHeight: {
                    '12.1.0': string;
                };
                fillScreen: {
                    '12.1.0': string;
                };
            };
        };
    };
    PanelInspector: {
        Data: {
            content: {
                "8.5.0": string;
            };
        };
        Stats: {
            content: {
                "8.5.0": string;
            };
        };
        Json: {
            content: {
                '11.1.0': string;
                "8.5.0": string;
            };
        };
        Query: {
            content: {
                "8.5.0": string;
            };
            refreshButton: {
                "8.5.0": string;
            };
            jsonObjectKeys: {
                "8.5.0": () => string;
            };
        };
    };
    Tab: {
        title: {
            '11.2.0': (title: string) => string;
        };
        active: {
            "8.5.0": () => string;
        };
    };
    RefreshPicker: {
        runButtonV2: {
            "8.5.0": string;
        };
        intervalButtonV2: {
            "8.5.0": string;
        };
    };
    QueryTab: {
        content: {
            "8.5.0": string;
        };
        queryInspectorButton: {
            "8.5.0": string;
        };
        queryHistoryButton: {
            '10.2.0': string;
            "8.5.0": string;
        };
        addQuery: {
            '10.2.0': string;
            "8.5.0": string;
        };
        addQueryFromLibrary: {
            '11.5.0': string;
        };
        queryGroupTopSection: {
            '11.2.0': string;
        };
        addExpression: {
            '11.2.0': string;
        };
    };
    QueryHistory: {
        queryText: {
            '9.0.0': string;
        };
    };
    QueryEditorRows: {
        rows: {
            "8.5.0": string;
        };
    };
    QueryEditorRow: {
        actionButton: {
            '10.4.0': (title: string) => string;
        };
        title: {
            "8.5.0": (refId: string) => string;
        };
        container: {
            "8.5.0": (refId: string) => string;
        };
    };
    AlertTab: {
        content: {
            '10.2.3': string;
            "8.5.0": string;
        };
    };
    AlertRules: {
        groupToggle: {
            '11.0.0': string;
        };
        toggle: {
            '11.0.0': string;
        };
        expandedContent: {
            '11.0.0': string;
        };
        previewButton: {
            '11.1.0': string;
        };
        ruleNameField: {
            '11.1.0': string;
        };
        newFolderButton: {
            '11.1.0': string;
        };
        newFolderNameField: {
            '11.1.0': string;
        };
        newFolderNameCreateButton: {
            '11.1.0': string;
        };
        newEvaluationGroupButton: {
            '11.1.0': string;
        };
        newEvaluationGroupName: {
            '11.1.0': string;
        };
        newEvaluationGroupInterval: {
            '11.1.0': string;
        };
        newEvaluationGroupCreate: {
            '11.1.0': string;
        };
        step: {
            '11.5.0': (stepNo: string) => string;
        };
        stepAdvancedModeSwitch: {
            '11.5.0': (stepNo: string) => string;
        };
    };
    Alert: {
        alertV2: {
            "8.5.0": (severity: string) => string;
        };
    };
    TransformTab: {
        content: {
            '10.1.0': string;
            "8.5.0": string;
        };
        newTransform: {
            '10.1.0': (name: string) => string;
        };
        transformationEditor: {
            '10.1.0': (name: string) => string;
        };
        transformationEditorDebugger: {
            '10.1.0': (name: string) => string;
        };
    };
    Transforms: {
        card: {
            '10.1.0': (name: string) => string;
        };
        disableTransformationButton: {
            '10.4.0': string;
        };
        Reduce: {
            modeLabel: {
                '10.2.3': string;
                "8.5.0": string;
            };
            calculationsLabel: {
                '10.2.3': string;
                "8.5.0": string;
            };
        };
        SpatialOperations: {
            actionLabel: {
                '9.1.2': string;
            };
            locationLabel: {
                '10.2.0': string;
            };
            location: {
                autoOption: {
                    '9.1.2': string;
                };
                coords: {
                    option: {
                        '9.1.2': string;
                    };
                    latitudeFieldLabel: {
                        '9.1.2': string;
                    };
                    longitudeFieldLabel: {
                        '9.1.2': string;
                    };
                };
                geohash: {
                    option: {
                        '9.1.2': string;
                    };
                    geohashFieldLabel: {
                        '9.1.2': string;
                    };
                };
                lookup: {
                    option: {
                        '9.1.2': string;
                    };
                    lookupFieldLabel: {
                        '9.1.2': string;
                    };
                    gazetteerFieldLabel: {
                        '9.1.2': string;
                    };
                };
            };
        };
        searchInput: {
            '10.2.3': string;
            "8.5.0": string;
        };
        noTransformationsMessage: {
            '10.2.3': string;
        };
        addTransformationButton: {
            '10.1.0': string;
            "8.5.0": string;
        };
        removeAllTransformationsButton: {
            '10.4.0': string;
        };
    };
    NavBar: {
        Configuration: {
            button: {
                '9.5.0': string;
            };
        };
        Toggle: {
            button: {
                '10.2.3': string;
                "8.5.0": string;
            };
        };
        Reporting: {
            button: {
                '9.5.0': string;
            };
        };
    };
    NavMenu: {
        Menu: {
            '10.2.3': string;
        };
        item: {
            '9.5.0': string;
        };
    };
    NavToolbar: {
        container: {
            '9.4.0': string;
        };
        commandPaletteTrigger: {
            '11.5.0': string;
        };
        shareDashboard: {
            '11.1.0': string;
        };
        markAsFavorite: {
            '11.1.0': string;
        };
        editDashboard: {
            editButton: {
                '11.1.0': string;
            };
            saveButton: {
                '11.1.0': string;
            };
            exitButton: {
                '11.1.0': string;
            };
            settingsButton: {
                '11.1.0': string;
            };
            addRowButton: {
                '11.1.0': string;
            };
            addLibraryPanelButton: {
                '11.1.0': string;
            };
            addVisualizationButton: {
                '11.1.0': string;
            };
            pastePanelButton: {
                '11.1.0': string;
            };
            discardChangesButton: {
                '11.1.0': string;
            };
            discardLibraryPanelButton: {
                '11.1.0': string;
            };
            unlinkLibraryPanelButton: {
                '11.1.0': string;
            };
            saveLibraryPanelButton: {
                '11.1.0': string;
            };
            backToDashboardButton: {
                '11.1.0': string;
            };
        };
    };
    PageToolbar: {
        container: {
            "8.5.0": () => string;
        };
        item: {
            "8.5.0": (tooltip: string) => string;
        };
        itemButton: {
            '9.5.0': (title: string) => string;
        };
    };
    QueryEditorToolbarItem: {
        button: {
            "8.5.0": (title: string) => string;
        };
    };
    BackButton: {
        backArrow: {
            '10.3.0': string;
            "8.5.0": string;
        };
    };
    OptionsGroup: {
        group: {
            '11.1.0': (title?: string) => string;
            "8.5.0": (title?: string) => string;
        };
        toggle: {
            '11.1.0': (title?: string) => string;
            "8.5.0": (title?: string) => string;
        };
    };
    PluginVisualization: {
        item: {
            "8.5.0": (title: string) => string;
        };
        current: {
            "8.5.0": () => string;
        };
    };
    Select: {
        menu: {
            '11.5.0': string;
            "8.5.0": string;
        };
        option: {
            '11.1.0': string;
            "8.5.0": string;
        };
        toggleAllOptions: {
            '11.3.0': string;
        };
        input: {
            "8.5.0": () => string;
        };
        singleValue: {
            "8.5.0": () => string;
        };
    };
    FieldConfigEditor: {
        content: {
            "8.5.0": string;
        };
    };
    OverridesConfigEditor: {
        content: {
            "8.5.0": string;
        };
    };
    FolderPicker: {
        containerV2: {
            "8.5.0": string;
        };
        input: {
            '10.4.0': string;
        };
    };
    ReadonlyFolderPicker: {
        container: {
            "8.5.0": string;
        };
    };
    DataSourcePicker: {
        container: {
            '10.0.0': string;
            '8.0.0': string;
        };
        inputV2: {
            '10.1.0': string;
            "8.5.0": string;
        };
        dataSourceList: {
            '10.4.0': string;
        };
        advancedModal: {
            dataSourceList: {
                '10.4.0': string;
            };
            builtInDataSourceList: {
                '10.4.0': string;
            };
        };
    };
    TimeZonePicker: {
        containerV2: {
            "8.5.0": string;
        };
        changeTimeSettingsButton: {
            '11.0.0': string;
        };
    };
    WeekStartPicker: {
        containerV2: {
            "8.5.0": string;
        };
        placeholder: {
            "8.5.0": string;
        };
    };
    TraceViewer: {
        spanBar: {
            '9.0.0': string;
        };
    };
    QueryField: {
        container: {
            '10.3.0': string;
            "8.5.0": string;
        };
    };
    QueryBuilder: {
        queryPatterns: {
            '10.3.0': string;
            "8.5.0": string;
        };
        labelSelect: {
            '10.3.0': string;
            "8.5.0": string;
        };
        inputSelect: {
            '11.1.0': string;
        };
        valueSelect: {
            '10.3.0': string;
            "8.5.0": string;
        };
        matchOperatorSelect: {
            '10.3.0': string;
            "8.5.0": string;
        };
    };
    ValuePicker: {
        button: {
            '10.3.0': (name: string) => string;
        };
        select: {
            '10.3.0': (name: string) => string;
        };
    };
    Search: {
        sectionV2: {
            "8.5.0": string;
        };
        itemsV2: {
            "8.5.0": string;
        };
        cards: {
            "8.5.0": string;
        };
        collapseFolder: {
            "8.5.0": (sectionId: string) => string;
        };
        expandFolder: {
            "8.5.0": (sectionId: string) => string;
        };
        dashboardItem: {
            "8.5.0": (item: string) => string;
        };
        dashboardCard: {
            "8.5.0": (item: string) => string;
        };
        folderHeader: {
            '9.3.0': (folderName: string) => string;
        };
        folderContent: {
            '9.3.0': (folderName: string) => string;
        };
        dashboardItems: {
            "8.5.0": string;
        };
    };
    DashboardLinks: {
        container: {
            "8.5.0": string;
        };
        dropDown: {
            "8.5.0": string;
        };
        link: {
            "8.5.0": string;
        };
    };
    LoadingIndicator: {
        icon: {
            '10.4.0': string;
            "8.5.0": string;
        };
    };
    CallToActionCard: {
        buttonV2: {
            "8.5.0": (name: string) => string;
        };
    };
    DataLinksContextMenu: {
        singleLink: {
            '10.3.0': string;
            "8.5.0": string;
        };
    };
    DataLinksActionsTooltip: {
        tooltipWrapper: {
            '12.1.0': string;
        };
    };
    CodeEditor: {
        container: {
            '10.2.3': string;
            "8.5.0": string;
        };
    };
    ReactMonacoEditor: {
        editorLazy: {
            '11.1.0': string;
        };
    };
    DashboardImportPage: {
        textarea: {
            "8.5.0": string;
        };
        submit: {
            "8.5.0": string;
        };
    };
    ImportDashboardForm: {
        name: {
            "8.5.0": string;
        };
        submit: {
            "8.5.0": string;
        };
    };
    PanelAlertTabContent: {
        content: {
            '10.2.3': string;
            "8.5.0": string;
        };
    };
    VisualizationPreview: {
        card: {
            "8.5.0": (name: string) => string;
        };
    };
    ColorSwatch: {
        name: {
            "8.5.0": string;
        };
    };
    DashboardRow: {
        title: {
            "8.5.0": (title: string) => string;
        };
    };
    UserProfile: {
        profileSaveButton: {
            "8.5.0": string;
        };
        preferencesSaveButton: {
            "8.5.0": string;
        };
        orgsTable: {
            "8.5.0": string;
        };
        sessionsTable: {
            "8.5.0": string;
        };
        extensionPointTabs: {
            '10.2.3': string;
        };
        extensionPointTab: {
            '10.2.3': (tabId: string) => string;
        };
    };
    FileUpload: {
        inputField: {
            '9.0.0': string;
        };
        fileNameSpan: {
            '9.0.0': string;
        };
    };
    DebugOverlay: {
        wrapper: {
            '9.2.0': string;
        };
    };
    OrgRolePicker: {
        input: {
            '9.5.0': string;
        };
    };
    AnalyticsToolbarButton: {
        button: {
            '9.5.0': string;
        };
    };
    Variables: {
        variableOption: {
            '9.5.0': string;
        };
        variableLinkWrapper: {
            '11.1.1': string;
        };
    };
    Annotations: {
        annotationsTypeInput: {
            '11.1.0': string;
            "8.5.0": string;
        };
        annotationsChoosePanelInput: {
            '11.1.0': string;
            "8.5.0": string;
        };
        editor: {
            testButton: {
                '11.0.0': string;
            };
            resultContainer: {
                '11.0.0': string;
            };
        };
    };
    Tooltip: {
        container: {
            '10.2.0': string;
        };
    };
    ReturnToPrevious: {
        buttonGroup: {
            '11.0.0': string;
        };
        backButton: {
            '11.0.0': string;
        };
        dismissButton: {
            '11.0.0': string;
        };
    };
    SQLQueryEditor: {
        selectColumn: {
            '11.0.0': string;
        };
        selectColumnInput: {
            '11.0.0': string;
        };
        selectFunctionParameter: {
            '11.0.0': (name: string) => string;
        };
        selectAggregation: {
            '11.0.0': string;
        };
        selectAggregationInput: {
            '11.0.0': string;
        };
        selectAlias: {
            '11.0.0': string;
        };
        selectAliasInput: {
            '11.0.0': string;
        };
        selectInputParameter: {
            '11.0.0': string;
        };
        filterConjunction: {
            '11.0.0': string;
        };
        filterField: {
            '11.0.0': string;
        };
        filterOperator: {
            '11.0.0': string;
        };
        headerTableSelector: {
            '11.0.0': string;
        };
        headerFilterSwitch: {
            '11.0.0': string;
        };
        headerGroupSwitch: {
            '11.0.0': string;
        };
        headerOrderSwitch: {
            '11.0.0': string;
        };
        headerPreviewSwitch: {
            '11.0.0': string;
        };
    };
    EntityNotFound: {
        container: {
            '11.2.0': string;
        };
    };
    Portal: {
        container: {
            '11.5.0': string;
        };
    };
};
export type VersionedComponents = typeof versionedComponents;
