import { TimeZone } from '@grafana/schema';
import { DateTime, DateTimeInput } from './moment_wrapper';
/**
 * Determine if a string contains a relative date time.
 * @param text
 */
export declare function isMathString(text: string | DateTime | Date): boolean;
/**
 * @deprecated use toDateTime instead
 * Parses different types input to a moment instance. There is a specific formatting language that can be used
 * if text arg is string. See unit tests for examples.
 * @param text
 * @param roundUp See parseDateMath function.
 * @param timezone Only string 'utc' is acceptable here, for anything else, local timezone is used.
 */
export declare function parse(text?: string | DateTime | Date | null, roundUp?: boolean, timezone?: TimeZone, fiscalYearStartMonth?: number): DateTime | undefined;
export interface ConversionOptions {
    /**
     * Set the time to endOf time unit, otherwise to startOf time unit.
     */
    roundUp?: boolean;
    /**
     * Only string 'utc' is acceptable here, for anything else, local timezone is used.
     */
    timezone?: TimeZone;
    /**
     * Setting for which month is the first month of the fiscal year.
     */
    fiscalYearStartMonth?: number;
    /**
     * DateTimeInput to use as now. Useful when parsing multiple values and now needs to be the same. Without this, comparing results from subsequent parses is not guaranteed to be deterministic.
     */
    now?: DateTimeInput;
}
/**
 * @param dateTimeRep A DateTime object, a Date object or a string representation of a specific time.
 * @param options Options for converting to DateTime
 * @returns A DateTime object if possible, undefined if not.
 */
export declare function toDateTime(dateTimeRep: string | DateTime | Date, options: ConversionOptions): DateTime | undefined;
/**
 * Checks if text is a valid date which in this context means that it is either a Moment instance or it can be parsed
 * by parse function. See parse function to see what is considered acceptable.
 * @param text
 */
export declare function isValid(text: string | DateTime): boolean;
/**
 * Parses math part of the time string and shifts supplied time according to that math. See unit tests for examples.
 * @param mathString
 * @param time
 * @param roundUp If true it will round the time to endOf time unit, otherwise to startOf time unit.
 */
export declare function parseDateMath(mathString: string, time: DateTime, roundUp?: boolean, fiscalYearStartMonth?: number): DateTime | undefined;
export declare function roundToFiscal(fyStartMonth: number, dateTime: DateTime, unit: string, roundUp: boolean | undefined): DateTime | undefined;
