import { KeyValue } from '../types/data';
import { Field } from '../types/dataFrame';
export interface Dimension<T = unknown> {
    name: string;
    columns: Array<Field<T>>;
}
export type Dimensions<T = unknown> = KeyValue<Dimension<T>>;
export declare const createDimension: <T>(name: string, columns: Array<Field<T>>) => Dimension<T>;
export declare const getColumnsFromDimension: <T>(dimension: Dimension<T>) => Field<T>[];
export declare const getColumnFromDimension: <T>(dimension: Dimension<T>, column: number) => Field<T>;
export declare const getValueFromDimension: <T>(dimension: Dimension<T>, column: number, row: number) => T;
export declare const getAllValuesFromDimension: <T>(dimension: Dimension<T>, column: number, row: number) => T[];
export declare const getDimensionByName: <T>(dimensions: Dimensions<T>, name: string) => Dimension<T>;
