import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { onUpdateDatasourceJsonDataOptionChecked, updateDatasourcePluginJsonDataOption } from '@grafana/data';
import { selectors } from '@grafana/e2e-selectors';
import { t, Trans } from '@grafana/i18n';
import { ConfigSubSection } from '@grafana/plugin-ui';
import { config } from '@grafana/runtime';
import { useTheme2, InlineField, Input, Select, Switch, TextLink } from '@grafana/ui';
import { DEFAULT_SERIES_LIMIT, PROM_CONFIG_LABEL_WIDTH, DURATION_REGEX, durationError, SUGGESTIONS_LIMIT, NON_NEGATIVE_INTEGER_REGEX, countError, MULTIPLE_DURATION_REGEX, seriesLimitError } from '../constants.mjs';
import { QueryEditorMode } from '../querybuilder/shared/types.mjs';
import { defaultPrometheusQueryOverlapWindow } from '../querycache/QueryCache.mjs';
import { PrometheusCacheLevel, PromApplication } from '../types.mjs';
import { ExemplarsSettings } from './ExemplarsSettings.mjs';
import { PromFlavorVersions } from './PromFlavorVersions.mjs';
import { overhaulStyles, docsTip, validateInput } from './shared/utils.mjs';

"use strict";
const httpOptions = [
  { value: "POST", label: "POST" },
  { value: "GET", label: "GET" }
];
const cacheValueOptions = [
  { value: PrometheusCacheLevel.Low, label: "Low" },
  { value: PrometheusCacheLevel.Medium, label: "Medium" },
  { value: PrometheusCacheLevel.High, label: "High" },
  { value: PrometheusCacheLevel.None, label: "None" }
];
const prometheusFlavorSelectItems = [
  { value: PromApplication.Prometheus, label: PromApplication.Prometheus },
  { value: PromApplication.Cortex, label: PromApplication.Cortex },
  { value: PromApplication.Mimir, label: PromApplication.Mimir },
  { value: PromApplication.Thanos, label: PromApplication.Thanos }
];
const getOptionsWithDefaults = (options) => {
  if (options.jsonData.httpMethod) {
    return options;
  }
  return { ...options, jsonData: { ...options.jsonData, httpMethod: "POST" } };
};
const PromSettings = (props) => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  const theme = useTheme2();
  const styles = overhaulStyles(theme);
  const { onOptionsChange } = props;
  const editorOptions = [
    {
      value: QueryEditorMode.Builder,
      label: t("grafana-prometheus.configuration.prom-settings.editor-options.label-builder", "Builder")
    },
    {
      value: QueryEditorMode.Code,
      label: t("grafana-prometheus.configuration.prom-settings.editor-options.label-code", "Code")
    }
  ];
  const optionsWithDefaults = getOptionsWithDefaults(props.options);
  const [validDuration, updateValidDuration] = useState({
    timeInterval: "",
    queryTimeout: "",
    incrementalQueryOverlapWindow: ""
  });
  const [validCount, updateValidCount] = useState({
    codeModeMetricNamesSuggestionLimit: ""
  });
  const [seriesLimit, setSeriesLimit] = useState(
    ((_a = optionsWithDefaults.jsonData.seriesLimit) == null ? void 0 : _a.toString()) || `${DEFAULT_SERIES_LIMIT}`
  );
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      ConfigSubSection,
      {
        title: t("grafana-prometheus.configuration.prom-settings.title-interval-behaviour", "Interval behaviour"),
        className: styles.container,
        children: /* @__PURE__ */ jsxs("div", { className: "gf-form-group", children: [
          /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
            InlineField,
            {
              label: t("grafana-prometheus.configuration.prom-settings.label-scrape-interval", "Scrape interval"),
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsxs(
                  Trans,
                  {
                    i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-scrape-interval",
                    values: { default: "15s" },
                    children: [
                      "This interval is how frequently Prometheus scrapes targets. Set this to the typical scrape and evaluation interval configured in your Prometheus config file. If you set this to a greater value than your Prometheus config file interval, Grafana will evaluate the data according to this interval and you will see less data points. Defaults to ",
                      "{{default}}",
                      "."
                    ]
                  }
                ),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsx(
                  Input,
                  {
                    className: "width-20",
                    value: optionsWithDefaults.jsonData.timeInterval,
                    spellCheck: false,
                    placeholder: "15s",
                    onChange: onChangeHandler("timeInterval", optionsWithDefaults, onOptionsChange),
                    onBlur: (e) => updateValidDuration({
                      ...validDuration,
                      timeInterval: e.currentTarget.value
                    }),
                    "data-testid": selectors.components.DataSource.Prometheus.configPage.scrapeInterval
                  }
                ),
                validateInput(validDuration.timeInterval, DURATION_REGEX, durationError)
              ] })
            }
          ) }) }),
          /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
            InlineField,
            {
              label: t("grafana-prometheus.configuration.prom-settings.label-query-timeout", "Query timeout"),
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-query-timeout", children: "Set the Prometheus query timeout." }),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsx(
                  Input,
                  {
                    className: "width-20",
                    value: optionsWithDefaults.jsonData.queryTimeout,
                    onChange: onChangeHandler("queryTimeout", optionsWithDefaults, onOptionsChange),
                    spellCheck: false,
                    placeholder: "60s",
                    onBlur: (e) => updateValidDuration({
                      ...validDuration,
                      queryTimeout: e.currentTarget.value
                    }),
                    "data-testid": selectors.components.DataSource.Prometheus.configPage.queryTimeout
                  }
                ),
                validateInput(validDuration.queryTimeout, DURATION_REGEX, durationError)
              ] })
            }
          ) }) })
        ] })
      }
    ),
    /* @__PURE__ */ jsx(
      ConfigSubSection,
      {
        title: t("grafana-prometheus.configuration.prom-settings.title-query-editor", "Query editor"),
        className: styles.container,
        children: /* @__PURE__ */ jsxs("div", { className: "gf-form-group", children: [
          /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
            InlineField,
            {
              label: t("grafana-prometheus.configuration.prom-settings.label-default-editor", "Default editor"),
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-default-editor", children: "Set default editor option for all users of this data source." }),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsx(
                Select,
                {
                  "aria-label": t(
                    "grafana-prometheus.configuration.prom-settings.aria-label-default-editor",
                    "Default Editor (Code or Builder)"
                  ),
                  options: editorOptions,
                  value: (_b = editorOptions.find((o) => o.value === optionsWithDefaults.jsonData.defaultEditor)) != null ? _b : editorOptions.find((o) => o.value === QueryEditorMode.Builder),
                  onChange: onChangeHandler("defaultEditor", optionsWithDefaults, onOptionsChange),
                  width: 40,
                  "data-testid": selectors.components.DataSource.Prometheus.configPage.defaultEditor
                }
              )
            }
          ) }),
          /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
            InlineField,
            {
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              label: t(
                "grafana-prometheus.configuration.prom-settings.label-disable-metrics-lookup",
                "Disable metrics lookup"
              ),
              tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsxs(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-disable-metrics-lookup", children: [
                  "Checking this option will disable the metrics chooser and metric/label support in the query field's autocomplete. This helps if you have performance issues with bigger Prometheus instances.",
                  " "
                ] }),
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              className: styles.switchField,
              children: /* @__PURE__ */ jsx(
                Switch,
                {
                  value: (_c = optionsWithDefaults.jsonData.disableMetricsLookup) != null ? _c : false,
                  onChange: onUpdateDatasourceJsonDataOptionChecked(props, "disableMetricsLookup"),
                  id: selectors.components.DataSource.Prometheus.configPage.disableMetricLookup
                }
              )
            }
          ) })
        ] })
      }
    ),
    /* @__PURE__ */ jsxs(
      ConfigSubSection,
      {
        title: t("grafana-prometheus.configuration.prom-settings.title-performance", "Performance"),
        className: styles.container,
        children: [
          !optionsWithDefaults.jsonData.prometheusType && !optionsWithDefaults.jsonData.prometheusVersion && optionsWithDefaults.readOnly && /* @__PURE__ */ jsx("div", { className: styles.versionMargin, children: /* @__PURE__ */ jsxs(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.more-info", children: [
            "For more information on configuring prometheus type and version in data sources, see the",
            " ",
            /* @__PURE__ */ jsx(TextLink, { external: true, href: "https://grafana.com/docs/grafana/latest/administration/provisioning/", children: "provisioning documentation" }),
            "."
          ] }) }),
          /* @__PURE__ */ jsxs("div", { className: "gf-form-group", children: [
            /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
              InlineField,
              {
                label: t("grafana-prometheus.configuration.prom-settings.label-prometheus-type", "Prometheus type"),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                  /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-prometheus-type", children: "Set this to the type of your prometheus database, e.g. Prometheus, Cortex, Mimir or Thanos. Changing this field will save your current settings. Certain types of Prometheus supports or does not support various APIs. For example, some types support regex matching for label queries to improve performance. Some types have an API for metadata. If you set this incorrectly you may experience odd behavior when querying metrics and labels. Please check your Prometheus documentation to ensure you enter the correct type." }),
                  " ",
                  docsTip()
                ] }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsx(
                  Select,
                  {
                    "aria-label": t(
                      "grafana-prometheus.configuration.prom-settings.aria-label-prometheus-type",
                      "Prometheus type"
                    ),
                    options: prometheusFlavorSelectItems,
                    value: prometheusFlavorSelectItems.find(
                      (o) => o.value === optionsWithDefaults.jsonData.prometheusType
                    ),
                    onChange: onChangeHandler("prometheusType", optionsWithDefaults, onOptionsChange),
                    width: 40,
                    "data-testid": selectors.components.DataSource.Prometheus.configPage.prometheusType
                  }
                )
              }
            ) }) }),
            /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: optionsWithDefaults.jsonData.prometheusType && /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
              InlineField,
              {
                label: t(
                  "grafana-prometheus.configuration.prom-settings.label-prom-type-version",
                  "{{promType}} version",
                  {
                    promType: optionsWithDefaults.jsonData.prometheusType
                  }
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                  /* @__PURE__ */ jsxs(
                    Trans,
                    {
                      i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-prom-type-version",
                      values: { promType: optionsWithDefaults.jsonData.prometheusType },
                      children: [
                        "Use this to set the version of your ",
                        "{{promType}}",
                        " instance if it is not automatically configured."
                      ]
                    }
                  ),
                  " ",
                  docsTip()
                ] }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsx(
                  Select,
                  {
                    "aria-label": t(
                      "grafana-prometheus.configuration.prom-settings.aria-label-prom-type-type",
                      "{{promType}} type",
                      {
                        promType: optionsWithDefaults.jsonData.prometheusType
                      }
                    ),
                    options: PromFlavorVersions[optionsWithDefaults.jsonData.prometheusType],
                    value: (_d = PromFlavorVersions[optionsWithDefaults.jsonData.prometheusType]) == null ? void 0 : _d.find(
                      (o) => o.value === optionsWithDefaults.jsonData.prometheusVersion
                    ),
                    onChange: onChangeHandler("prometheusVersion", optionsWithDefaults, onOptionsChange),
                    width: 40,
                    "data-testid": selectors.components.DataSource.Prometheus.configPage.prometheusVersion
                  }
                )
              }
            ) }) }),
            /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form max-width-30", children: /* @__PURE__ */ jsx(
              InlineField,
              {
                label: t("grafana-prometheus.configuration.prom-settings.label-cache-level", "Cache level"),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-cache-level", children: "Sets the browser caching level for editor queries. Higher cache settings are recommended for high cardinality data sources." }) }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsx(
                  Select,
                  {
                    width: 40,
                    onChange: onChangeHandler("cacheLevel", optionsWithDefaults, onOptionsChange),
                    options: cacheValueOptions,
                    value: (_e = cacheValueOptions.find((o) => o.value === optionsWithDefaults.jsonData.cacheLevel)) != null ? _e : PrometheusCacheLevel.Low,
                    "data-testid": selectors.components.DataSource.Prometheus.configPage.cacheLevel
                  }
                )
              }
            ) }) }),
            config.featureToggles.prometheusCodeModeMetricNamesSearch && /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
              InlineField,
              {
                label: t(
                  "grafana-prometheus.configuration.prom-settings.label-metric-names-suggestion-limit",
                  "Metric names suggestion limit"
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-metric-names-suggestion-limit", children: "The maximum number of metric names that may appear as autocomplete suggestions in the query editor's Code mode." }) }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsxs(Fragment, { children: [
                  /* @__PURE__ */ jsx(
                    Input,
                    {
                      className: "width-20",
                      value: optionsWithDefaults.jsonData.codeModeMetricNamesSuggestionLimit,
                      onChange: onChangeHandler(
                        "codeModeMetricNamesSuggestionLimit",
                        optionsWithDefaults,
                        onOptionsChange
                      ),
                      spellCheck: false,
                      placeholder: SUGGESTIONS_LIMIT.toString(),
                      onBlur: (e) => updateValidCount({
                        ...validCount,
                        codeModeMetricNamesSuggestionLimit: e.currentTarget.value
                      }),
                      "data-testid": selectors.components.DataSource.Prometheus.configPage.codeModeMetricNamesSuggestionLimit
                    }
                  ),
                  validateInput(
                    validCount.codeModeMetricNamesSuggestionLimit,
                    NON_NEGATIVE_INTEGER_REGEX,
                    countError
                  )
                ] })
              }
            ) }) }),
            /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form max-width-30", children: /* @__PURE__ */ jsx(
              InlineField,
              {
                label: t(
                  "grafana-prometheus.configuration.prom-settings.label-incremental-querying-beta",
                  "Incremental querying (beta)"
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-incremental-querying-beta", children: "This feature will change the default behavior of relative queries to always request fresh data from the prometheus instance, instead query results will be cached, and only new records are requested. Turn this on to decrease database and network load." }) }),
                interactive: true,
                className: styles.switchField,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsx(
                  Switch,
                  {
                    value: (_f = optionsWithDefaults.jsonData.incrementalQuerying) != null ? _f : false,
                    onChange: onUpdateDatasourceJsonDataOptionChecked(props, "incrementalQuerying"),
                    id: selectors.components.DataSource.Prometheus.configPage.incrementalQuerying
                  }
                )
              }
            ) }) }),
            /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: optionsWithDefaults.jsonData.incrementalQuerying && /* @__PURE__ */ jsx(
              InlineField,
              {
                label: t(
                  "grafana-prometheus.configuration.prom-settings.label-query-overlap-window",
                  "Query overlap window"
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsxs(
                  Trans,
                  {
                    i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-query-overlap-window",
                    values: {
                      example1: "10m",
                      example2: "120s",
                      example3: "0s",
                      default: "10m"
                    },
                    children: [
                      "Set a duration like ",
                      "{{example1}}",
                      " or ",
                      "{{example2}}",
                      " or ",
                      "{{example3}}",
                      ". Default of",
                      " ",
                      "{{default}}",
                      ". This duration will be added to the duration of each incremental request."
                    ]
                  }
                ) }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsxs(Fragment, { children: [
                  /* @__PURE__ */ jsx(
                    Input,
                    {
                      onBlur: (e) => updateValidDuration({
                        ...validDuration,
                        incrementalQueryOverlapWindow: e.currentTarget.value
                      }),
                      className: "width-20",
                      value: (_g = optionsWithDefaults.jsonData.incrementalQueryOverlapWindow) != null ? _g : defaultPrometheusQueryOverlapWindow,
                      onChange: onChangeHandler("incrementalQueryOverlapWindow", optionsWithDefaults, onOptionsChange),
                      spellCheck: false,
                      "data-testid": selectors.components.DataSource.Prometheus.configPage.queryOverlapWindow
                    }
                  ),
                  validateInput(validDuration.incrementalQueryOverlapWindow, MULTIPLE_DURATION_REGEX, durationError)
                ] })
              }
            ) }),
            /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form max-width-30", children: /* @__PURE__ */ jsx(
              InlineField,
              {
                label: t(
                  "grafana-prometheus.configuration.prom-settings.label-disable-recording-rules-beta",
                  "Disable recording rules (beta)"
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-disable-recording-rules-beta", children: "This feature will disable recording rules. Turn this on to improve dashboard performance" }) }),
                interactive: true,
                className: styles.switchField,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsx(
                  Switch,
                  {
                    value: (_h = optionsWithDefaults.jsonData.disableRecordingRules) != null ? _h : false,
                    onChange: onUpdateDatasourceJsonDataOptionChecked(props, "disableRecordingRules"),
                    id: selectors.components.DataSource.Prometheus.configPage.disableRecordingRules
                  }
                )
              }
            ) }) })
          ] })
        ]
      }
    ),
    /* @__PURE__ */ jsx(
      ConfigSubSection,
      {
        title: t("grafana-prometheus.configuration.prom-settings.title-other", "Other"),
        className: styles.container,
        children: /* @__PURE__ */ jsxs("div", { className: "gf-form-group", children: [
          /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form max-width-30", children: /* @__PURE__ */ jsx(
            InlineField,
            {
              label: t(
                "grafana-prometheus.configuration.prom-settings.label-custom-query-parameters",
                "Custom query parameters"
              ),
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsxs(
                  Trans,
                  {
                    i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-custom-query-parameters",
                    values: {
                      example1: "timeout",
                      example2: "partial_response",
                      example3: "dedup",
                      example4: "max_source_resolution",
                      concatenationChar: "\u2018&\u2019"
                    },
                    children: [
                      "Add custom parameters to the Prometheus query URL. For example ",
                      "{{example1}}",
                      ", ",
                      "{{example2}}",
                      ",",
                      " ",
                      "{{example3}}",
                      ", or",
                      "{{example4}}",
                      ". Multiple parameters should be concatenated together with",
                      " ",
                      "{{concatenationChar}}",
                      "."
                    ]
                  }
                ),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsx(
                Input,
                {
                  className: "width-20",
                  value: optionsWithDefaults.jsonData.customQueryParameters,
                  onChange: onChangeHandler("customQueryParameters", optionsWithDefaults, onOptionsChange),
                  spellCheck: false,
                  placeholder: t(
                    "grafana-prometheus.configuration.prom-settings.placeholder-example-maxsourceresolutionmtimeout",
                    "Example: {{example}}",
                    { example: "max_source_resolution=5m&timeout=10" }
                  ),
                  "data-testid": selectors.components.DataSource.Prometheus.configPage.customQueryParameters
                }
              )
            }
          ) }) }),
          /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
            InlineField,
            {
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-http-method", children: "You can use either POST or GET HTTP method to query your Prometheus data source. POST is the recommended method as it allows bigger queries. Change this to GET if you have a Prometheus version older than 2.1 or if POST requests are restricted in your network." }),
                " ",
                docsTip()
              ] }),
              interactive: true,
              label: t("grafana-prometheus.configuration.prom-settings.label-http-method", "HTTP method"),
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsx(
                Select,
                {
                  width: 40,
                  "aria-label": t(
                    "grafana-prometheus.configuration.prom-settings.aria-label-select-http-method",
                    "Select HTTP method"
                  ),
                  options: httpOptions,
                  value: httpOptions.find((o) => o.value === optionsWithDefaults.jsonData.httpMethod),
                  onChange: onChangeHandler("httpMethod", optionsWithDefaults, onOptionsChange),
                  "data-testid": selectors.components.DataSource.Prometheus.configPage.httpMethod
                }
              )
            }
          ) }) }),
          /* @__PURE__ */ jsx(
            InlineField,
            {
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              label: t("grafana-prometheus.configuration.prom-settings.label-series-limit", "Series limit"),
              tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-series-limit", children: "The limit applies to all resources (metrics, labels, and values) for both endpoints (series and labels). Leave the field empty to use the default limit (40000). Set to 0 to disable the limit and fetch everything \u2014 this may cause performance issues. Default limit is 40000." }),
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsx(
                  Input,
                  {
                    className: "width-20",
                    value: seriesLimit,
                    spellCheck: false,
                    placeholder: "40000",
                    onChange: (event) => {
                      setSeriesLimit(event.currentTarget.value);
                      onOptionsChange({
                        ...optionsWithDefaults,
                        jsonData: {
                          ...optionsWithDefaults.jsonData,
                          seriesLimit: parseInt(event.currentTarget.value, 10)
                        }
                      });
                    },
                    onBlur: (e) => validateInput(e.currentTarget.value, NON_NEGATIVE_INTEGER_REGEX, seriesLimitError),
                    "data-testid": selectors.components.DataSource.Prometheus.configPage.seriesLimit
                  }
                ),
                validateInput(seriesLimit, NON_NEGATIVE_INTEGER_REGEX, seriesLimitError)
              ] })
            }
          ),
          /* @__PURE__ */ jsx(
            InlineField,
            {
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              label: t("grafana-prometheus.configuration.prom-settings.label-use-series-endpoint", "Use series endpoint"),
              tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
                /* @__PURE__ */ jsxs(
                  Trans,
                  {
                    i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-use-series-endpoint",
                    values: { exampleParameter: "match[]" },
                    children: [
                      "Checking this option will favor the series endpoint with ",
                      "{{exampleParameter}}",
                      " parameter over the label values endpoint with ",
                      "{{exampleParameter}}",
                      " parameter. While the label values endpoint is considered more performant, some users may prefer the series because it has a POST method while the label values endpoint only has a GET method."
                    ]
                  }
                ),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              className: styles.switchField,
              children: /* @__PURE__ */ jsx(
                Switch,
                {
                  value: (_i = optionsWithDefaults.jsonData.seriesEndpoint) != null ? _i : false,
                  onChange: onUpdateDatasourceJsonDataOptionChecked(props, "seriesEndpoint")
                }
              )
            }
          )
        ] })
      }
    ),
    /* @__PURE__ */ jsx(
      ExemplarsSettings,
      {
        options: optionsWithDefaults.jsonData.exemplarTraceIdDestinations,
        onChange: (exemplarOptions) => updateDatasourcePluginJsonDataOption(
          { onOptionsChange, options: optionsWithDefaults },
          "exemplarTraceIdDestinations",
          exemplarOptions
        ),
        disabled: optionsWithDefaults.readOnly
      }
    )
  ] });
};
const getValueFromEventItem = (eventItem) => {
  if (!eventItem) {
    return "";
  }
  if ("currentTarget" in eventItem) {
    return eventItem.currentTarget.value;
  }
  return eventItem.value;
};
const onChangeHandler = (key, options, onOptionsChange) => (eventItem) => {
  onOptionsChange({
    ...options,
    jsonData: {
      ...options.jsonData,
      [key]: getValueFromEventItem(eventItem)
    }
  });
};

export { PromSettings, getValueFromEventItem };
//# sourceMappingURL=PromSettings.mjs.map
