import { type ComponentTypeWithExtensionMeta } from '@grafana/data';
export type UsePluginComponentsOptions = {
    extensionPointId: string;
    limitPerPlugin?: number;
};
export type UsePluginComponentsResult<Props = {}> = {
    components: Array<ComponentTypeWithExtensionMeta<Props>>;
    isLoading: boolean;
};
export type UsePluginComponents<Props extends object = {}> = (options: UsePluginComponentsOptions) => UsePluginComponentsResult<Props>;
export declare function setPluginComponentsHook(hook: UsePluginComponents): void;
export declare function usePluginComponents<Props extends object = {}>(options: UsePluginComponentsOptions): UsePluginComponentsResult<Props>;
