"use strict";
let singleton;
function setPluginComponentsHook(hook) {
  if (singleton && process.env.NODE_ENV !== "test") {
    throw new Error("setPluginComponentsHook() function should only be called once, when Grafana is starting.");
  }
  singleton = hook;
}
function usePluginComponents(options) {
  if (!singleton) {
    throw new Error("setPluginComponentsHook(options) can only be used after the Grafana instance has started.");
  }
  return singleton(options);
}

export { setPluginComponentsHook, usePluginComponents };
//# sourceMappingURL=usePluginComponents.mjs.map
