import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { formattedValueToString } from '@grafana/data';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import { renderSingleLink } from '../../DataLinksActionsTooltip.mjs';
import '../../types.mjs';
import { useSingleLink } from '../hooks.mjs';
import { TableCellDisplayMode } from '@grafana/schema';

"use strict";
function AutoCell({ value, field, justifyContent, rowIdx, cellOptions }) {
  const styles = useStyles2(getStyles, justifyContent);
  const displayValue = field.display(value);
  const formattedValue = formattedValueToString(displayValue);
  const link = useSingleLink(field, rowIdx);
  return /* @__PURE__ */ jsx("div", { className: styles.cell, children: link == null ? formattedValue : renderSingleLink(link, formattedValue, getLinkStyle(styles, cellOptions)) });
}
const getLinkStyle = (styles, cellOptions) => {
  if (cellOptions.type === TableCellDisplayMode.Auto) {
    return styles.linkCell;
  }
  return styles.cellLinkForColoredCell;
};
const getStyles = (theme, justifyContent) => ({
  cell: css({
    display: "flex",
    justifyContent,
    a: {
      color: "inherit"
    }
  }),
  cellLinkForColoredCell: css({
    cursor: "pointer",
    overflow: "hidden",
    textOverflow: "ellipsis",
    userSelect: "text",
    whiteSpace: "nowrap",
    fontWeight: theme.typography.fontWeightMedium,
    textDecoration: "underline"
  }),
  linkCell: css({
    cursor: "pointer",
    overflow: "hidden",
    textOverflow: "ellipsis",
    userSelect: "text",
    whiteSpace: "nowrap",
    color: `${theme.colors.text.link} !important`,
    fontWeight: theme.typography.fontWeightMedium,
    paddingRight: theme.spacing(1.5),
    "&:hover": {
      textDecoration: "underline",
      color: theme.colors.text.link
    }
  })
});

export { AutoCell as default };
//# sourceMappingURL=AutoCell.mjs.map
