import { jsx, Fragment } from 'react/jsx-runtime';
import { useState, useEffect } from 'react';

"use strict";
function DelayRender({ children, delay }) {
  const [shouldRender, setShouldRender] = useState(false);
  useEffect(() => {
    window.setTimeout(() => {
      setShouldRender(true);
    }, delay);
  }, [children, delay]);
  return /* @__PURE__ */ jsx(Fragment, { children: shouldRender ? children : null });
}

export { DelayRender };
//# sourceMappingURL=DelayRender.mjs.map
