import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import { renderSingleLink } from '../../DataLinksActionsTooltip.mjs';
import { useSingleLink } from '../hooks.mjs';

"use strict";
const JSONCell = ({ value, justifyContent, field, rowIdx }) => {
  const styles = useStyles2(getStyles, justifyContent);
  let displayValue = value;
  if (typeof value === "string") {
    try {
      const parsed = JSON.parse(value);
      displayValue = JSON.stringify(parsed, null, " ");
    } catch (e) {
      displayValue = value;
    }
  } else {
    try {
      displayValue = JSON.stringify(value, null, " ");
    } catch (error) {
      displayValue = String(value);
    }
  }
  const link = useSingleLink(field, rowIdx);
  return /* @__PURE__ */ jsx("div", { className: styles.jsonText, children: link == null ? displayValue : renderSingleLink(link, displayValue) });
};
const getStyles = (theme, justifyContent) => ({
  jsonText: css({
    display: "flex",
    cursor: "pointer",
    fontFamily: "monospace",
    justifyContent
  })
});

export { JSONCell };
//# sourceMappingURL=JSONCell.mjs.map
