import { jsx } from 'react/jsx-runtime';
import { getCellLinks } from '../../../utils/table.mjs';

"use strict";
const DataLinksCell = (props) => {
  const { field, row, cellProps, tableStyles } = props;
  const links = getCellLinks(field, row);
  return /* @__PURE__ */ jsx("div", { ...cellProps, className: tableStyles.cellContainerText, children: links == null ? void 0 : links.map((link, idx) => {
    return !link.href && link.onClick == null ? /* @__PURE__ */ jsx("span", { className: tableStyles.cellLinkEmpty, children: link.title }, idx) : (
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
      /* @__PURE__ */ jsx("span", { className: tableStyles.cellLink, onClick: link.onClick, children: /* @__PURE__ */ jsx("a", { href: link.href, target: link.target, children: link.title }) }, idx)
    );
  }) });
};

export { DataLinksCell };
//# sourceMappingURL=DataLinksCell.mjs.map
