import { jsxs, jsx, Fragment } from 'react/jsx-runtime';
import { Button } from '../Button/Button.mjs';
import { Input } from '../Input/Input.mjs';
import { Stack } from '../Layout/Stack/Stack.mjs';

"use strict";
const CONFIGURED_TEXT = "configured";
const RESET_BUTTON_TEXT = "Reset";
const SecretInput = ({ isConfigured, onReset, ...props }) => /* @__PURE__ */ jsxs(Stack, { children: [
  !isConfigured && /* @__PURE__ */ jsx(Input, { ...props, type: "password" }),
  isConfigured && /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(Input, { ...props, type: "text", disabled: true, value: CONFIGURED_TEXT }),
    /* @__PURE__ */ jsx(Button, { onClick: onReset, variant: "secondary", children: RESET_BUTTON_TEXT })
  ] })
] });

export { CONFIGURED_TEXT, RESET_BUTTON_TEXT, SecretInput };
//# sourceMappingURL=SecretInput.mjs.map
