import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { Trans } from '@grafana/i18n';
import { convertLegacyAuthProps, ConnectionSettings, Auth, AuthMethod } from '@grafana/plugin-ui';
import { useTheme2, SecureSocksProxySettings } from '@grafana/ui';
import { overhaulStyles, docsTip } from './shared/utils.mjs';

"use strict";
const DataSourceHttpSettingsOverhaul = (props) => {
  const { options, onOptionsChange, secureSocksDSProxyEnabled } = props;
  const newAuthProps = convertLegacyAuthProps({
    config: options,
    onChange: onOptionsChange
  });
  const theme = useTheme2();
  const styles = overhaulStyles(theme);
  function returnSelectedMethod() {
    return newAuthProps.selectedMethod;
  }
  let urlTooltip;
  switch (options.access) {
    case "direct":
      urlTooltip = /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsxs(Trans, { i18nKey: "grafana-prometheus.configuration.data-source-http-settings-overhaul.tooltip-browser-access-mode", children: [
          "Your access method is ",
          /* @__PURE__ */ jsx("em", { children: "Browser" }),
          ", this means the URL needs to be accessible from the browser."
        ] }),
        docsTip()
      ] });
      break;
    case "proxy":
      urlTooltip = /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsxs(Trans, { i18nKey: "grafana-prometheus.configuration.data-source-http-settings-overhaul.tooltip-server-access-mode", children: [
          "Your access method is ",
          /* @__PURE__ */ jsx("em", { children: "Server" }),
          ", this means the URL needs to be accessible from the grafana backend/server."
        ] }),
        docsTip()
      ] });
      break;
    default:
      urlTooltip = /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsxs(
          Trans,
          {
            i18nKey: "grafana-prometheus.configuration.data-source-http-settings-overhaul.tooltip-http-url",
            values: { exampleURL: "http://your_server:8080" },
            children: [
              "Specify a complete HTTP URL (for example ",
              "{{exampleURL}}",
              ")"
            ]
          }
        ),
        docsTip()
      ] });
  }
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      ConnectionSettings,
      {
        urlPlaceholder: "http://localhost:9090",
        config: options,
        onChange: onOptionsChange,
        urlLabel: "Prometheus server URL",
        urlTooltip
      }
    ),
    /* @__PURE__ */ jsx("hr", { className: `${styles.hrTopSpace} ${styles.hrBottomSpace}` }),
    /* @__PURE__ */ jsx(
      Auth,
      {
        ...newAuthProps,
        onAuthMethodSelect: (method) => {
          onOptionsChange({
            ...options,
            basicAuth: method === AuthMethod.BasicAuth,
            withCredentials: method === AuthMethod.CrossSiteCredentials,
            jsonData: {
              ...options.jsonData,
              oauthPassThru: method === AuthMethod.OAuthForward
            }
          });
        },
        selectedMethod: returnSelectedMethod()
      }
    ),
    /* @__PURE__ */ jsx("div", { className: styles.sectionBottomPadding }),
    secureSocksDSProxyEnabled && /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(SecureSocksProxySettings, { options, onOptionsChange }),
      /* @__PURE__ */ jsx("div", { className: styles.sectionBottomPadding })
    ] })
  ] });
};

export { DataSourceHttpSettingsOverhaul };
//# sourceMappingURL=DataSourceHttpSettingsOverhaul.mjs.map
