import { useMemo } from 'react';
import { usePluginContext, isDataSourcePluginContext } from '@grafana/data';
import { reportInteraction } from '../utils.mjs';
import { createDataSourcePluginEventProperties, createPluginEventProperties } from './eventProperties.mjs';

"use strict";
const namePrefix = "grafana_plugin_";
function usePluginInteractionReporter() {
  const context = usePluginContext();
  return useMemo(() => {
    if (!context) {
      throw new Error(
        `No PluginContext found. The usePluginInteractionReporter() hook can only be used from a plugin.`
      );
    }
    const info = isDataSourcePluginContext(context) ? createDataSourcePluginEventProperties(context.instanceSettings) : createPluginEventProperties(context.meta);
    return (interactionName, properties) => {
      if (!validInteractionName(interactionName)) {
        throw new Error(`Interactions reported in plugins should start with: "${namePrefix}".`);
      }
      return reportInteraction(interactionName, { ...properties, ...info });
    };
  }, [context]);
}
function validInteractionName(interactionName) {
  return interactionName.startsWith(namePrefix) && interactionName.length > namePrefix.length;
}

export { usePluginInteractionReporter };
//# sourceMappingURL=usePluginInteractionReporter.mjs.map
