import { GrafanaTheme, GrafanaTheme2 } from '@grafana/data';
export declare function cardChrome(theme: GrafanaTheme2): string;
export declare function hoverColor(color: string, theme: GrafanaTheme2): string;
export declare function listItem(theme: GrafanaTheme2): string;
export declare function listItemSelected(theme: GrafanaTheme2): string;
export declare function mediaUp(breakpoint: string): string;
export declare const focusCss: (theme: GrafanaTheme | GrafanaTheme2) => string;
export declare function getMouseFocusStyles(theme: GrafanaTheme | GrafanaTheme2): {
    outline: string;
    boxShadow: string;
};
export declare function getFocusStyles(theme: GrafanaTheme2): {
    outline: string;
    outlineOffset: string;
    boxShadow: string;
    transitionTimingFunction: string;
    transitionDuration: string;
    transitionProperty: string;
};
export declare const getTooltipContainerStyles: (theme: GrafanaTheme2) => {
    overflow: string;
    background: string;
    boxShadow: string;
    maxWidth: string;
    padding: string;
    borderRadius: string;
    zIndex: number;
};
interface ExternalRadiusAdditionalOptions {
    selfBorderWidth?: number;
    childBorderRadius?: number;
}
/**
 * Calculates a border radius for an element, based on border radius of its child.
 *
 * @param theme
 * @param offset - The distance to offset from the child element, should be >= 0.
 * @param additionalOptions
 * @param additionalOptions.selfBorderWidth - The border width of the element itself (default: 1)
 * @param additionalOptions.childBorderRadius - The border radius of the child element (default: theme default radius)
 * @returns A CSS calc() expression that returns the relative external radius value
 */
export declare const getExternalRadius: (theme: GrafanaTheme2, offset: number, additionalOptions?: ExternalRadiusAdditionalOptions) => string;
interface InternalRadiusAdditionalOptions {
    parentBorderWidth?: number;
    parentBorderRadius?: number;
}
/**
 * Calculates a border radius for an element, based on border radius of its parent.
 *
 * @param theme
 * @param offset - The distance to offset from the parent element, should be >= 0.
 * @param additionalOptions
 * @param additionalOptions.parentBorderWidth - The border width of the parent element (default: 1)
 * @param additionalOptions.parentBorderRadius - The border radius of the parent element (default: theme default radius)
 * @returns A CSS calc() expression that returns the relative internal radius value
 */
export declare const getInternalRadius: (theme: GrafanaTheme2, offset: number, additionalOptions?: InternalRadiusAdditionalOptions) => string;
export {};
