import { HTMLAttributes } from 'react';
import { SelectableValue } from '@grafana/data';
import { ToolbarButtonVariant } from '../ToolbarButton/ToolbarButton';
import { PopoverContent } from '../Tooltip/types';
export interface Props<T> extends HTMLAttributes<HTMLButtonElement> {
    className?: string;
    options: Array<SelectableValue<T>>;
    value?: SelectableValue<T>;
    onChange: (item: SelectableValue<T>) => void;
    /** @deprecated use tooltip instead, tooltipContent is not being processed in ToolbarButton*/
    tooltipContent?: PopoverContent;
    narrow?: boolean;
    variant?: ToolbarButtonVariant;
    tooltip?: string;
}
/**
 * @deprecated Use Combobox or Dropdown instead
 */
declare const ButtonSelectComponent: {
    <T>(props: Props<T>): import("react/jsx-runtime").JSX.Element;
    displayName: string;
};
export declare const ButtonSelect: typeof ButtonSelectComponent;
export {};
