import { ComponentType } from 'react';
import { QueryBuilderOperationParamDef, QueryBuilderOperationParamEditorProps } from './types';
/**
 * Resolves an operation parameter editor based on the parameter definition.
 *
 * The editor can be specified in three ways:
 * 1. As a string key referencing a registered editor in editorMap
 * 2. As a direct component reference
 * 3. Based on the parameter type (string, number, boolean) or options
 *
 * This flexibility allows operation definitions to be decoupled from editor implementations
 * while maintaining type safety and clear dependencies.
 */
export declare function getOperationParamEditor(paramDef: QueryBuilderOperationParamDef): ComponentType<QueryBuilderOperationParamEditorProps>;
