import { languages } from 'monaco-editor';
import { TimeRange } from '@grafana/data';
import { DataProvider } from './data_provider';
import type { Situation } from './situation';
export type CompletionType = 'HISTORY' | 'FUNCTION' | 'METRIC_NAME' | 'DURATION' | 'LABEL_NAME' | 'LABEL_VALUE';
type Completion = {
    type: CompletionType;
    label: string;
    insertText: string;
    insertTextRules?: languages.CompletionItemInsertTextRule;
    detail?: string;
    documentation?: string;
    triggerOnInsert?: boolean;
};
interface MetricFilterOptions {
    metricNames: string[];
    inputText: string;
    limit: number;
}
export declare function filterMetricNames({ metricNames, inputText, limit }: MetricFilterOptions): string[];
export declare function getCompletions(situation: Situation, dataProvider: DataProvider, timeRange: TimeRange): Promise<Completion[]>;
export {};
