import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { uniqueId } from 'lodash';
import { useRef } from 'react';
import { useStyles2, Stack, Switch } from '@grafana/ui';

"use strict";
function QueryHeaderSwitch({ label, ...inputProps }) {
  const dashedLabel = label.replace(" ", "-");
  const switchIdRef = useRef(uniqueId(`switch-${dashedLabel}`));
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs(Stack, { gap: 1, children: [
    /* @__PURE__ */ jsx("label", { htmlFor: switchIdRef.current, className: styles.switchLabel, children: label }),
    /* @__PURE__ */ jsx(Switch, { ...inputProps, id: switchIdRef.current })
  ] });
}
const getStyles = (theme) => {
  return {
    switchLabel: css({
      color: theme.colors.text.secondary,
      cursor: "pointer",
      fontSize: theme.typography.bodySmall.fontSize,
      "&:hover": {
        color: theme.colors.text.primary
      }
    })
  };
};

export { QueryHeaderSwitch };
//# sourceMappingURL=QueryHeaderSwitch.mjs.map
