import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { isEqual } from 'lodash';
import { useState, useEffect } from 'react';
import { Trans, t } from '@grafana/i18n';
import { EditorList, EditorFieldGroup, EditorField } from '@grafana/plugin-ui';
import { InlineFieldRow, InlineLabel } from '@grafana/ui';
import { LabelFilterItem } from './LabelFilterItem.mjs';

"use strict";
const MISSING_LABEL_FILTER_ERROR_MESSAGE = "Select at least 1 label filter (label and value)";
function LabelFilters({
  labelsFilters,
  onChange,
  onGetLabelNames,
  onGetLabelValues,
  labelFilterRequired,
  getLabelValuesAutofillSuggestions,
  debounceDuration,
  variableEditor
}) {
  const defaultOp = "=";
  const [items, setItems] = useState([{ op: defaultOp }]);
  useEffect(() => {
    if (labelsFilters.length > 0) {
      setItems(labelsFilters);
    } else {
      setItems([{ op: defaultOp }]);
    }
  }, [labelsFilters]);
  const onLabelsChange = (newItems) => {
    setItems(newItems);
    const newLabels = newItems.filter((x) => x.label != null && x.value != null);
    if (!isEqual(newLabels, labelsFilters)) {
      onChange(newLabels);
    }
  };
  const hasLabelFilter = items.some((item) => item.label && item.value);
  const editorList = () => {
    return /* @__PURE__ */ jsx(
      EditorList,
      {
        items,
        onChange: onLabelsChange,
        renderItem: (item, onChangeItem, onDelete) => /* @__PURE__ */ jsx(
          LabelFilterItem,
          {
            debounceDuration,
            item,
            defaultOp,
            onChange: onChangeItem,
            onDelete,
            onGetLabelNames,
            onGetLabelValues,
            invalidLabel: labelFilterRequired && !item.label,
            invalidValue: labelFilterRequired && !item.value,
            getLabelValuesAutofillSuggestions
          }
        )
      }
    );
  };
  return /* @__PURE__ */ jsx(Fragment, { children: variableEditor ? /* @__PURE__ */ jsx(InlineFieldRow, { children: /* @__PURE__ */ jsxs(
    "div",
    {
      className: cx(
        css({
          display: "flex"
        })
      ),
      children: [
        /* @__PURE__ */ jsx(
          InlineLabel,
          {
            width: 20,
            tooltip: /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.querybuilder.label-filters.tooltip-label-filters", children: "Optional: used to filter the metric select for this query type." }) }),
            children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.querybuilder.label-filters.label-filters", children: "Label filters" })
          }
        ),
        editorList()
      ]
    }
  ) }) : /* @__PURE__ */ jsx(EditorFieldGroup, { children: /* @__PURE__ */ jsx(
    EditorField,
    {
      label: t("grafana-prometheus.querybuilder.label-filters.label-label-filters", "Label filters"),
      error: MISSING_LABEL_FILTER_ERROR_MESSAGE,
      invalid: labelFilterRequired && !hasLabelFilter,
      children: editorList()
    }
  ) }) });
}

export { LabelFilters, MISSING_LABEL_FILTER_ERROR_MESSAGE };
//# sourceMappingURL=LabelFilters.mjs.map
