import { QueryBuilderOperationParamEditorProps } from '../shared/types';
import { PromQueryModellerInterface } from '../types';
/**
 * Props for the LabelParamEditor component.
 * This editor specifically requires a Prometheus query modeller instance.
 */
export interface LabelParamEditorProps extends Omit<QueryBuilderOperationParamEditorProps, 'queryModeller'> {
    queryModeller: PromQueryModellerInterface;
}
/**
 * Editor for label parameters that requires a Prometheus query modeller instance.
 * This is used by the OperationParamEditorWrapper which ensures the modeller is always provided.
 */
export declare function LabelParamEditor({ onChange, index, operationId, value, query, datasource, timeRange, queryModeller, }: LabelParamEditorProps): import("react/jsx-runtime").JSX.Element;
