import { Observable } from 'rxjs';
import { AbstractQuery, AdHocVariableFilter, CoreApp, CustomVariableModel, DataQueryRequest, DataQueryResponse, DataSourceGetTagKeysOptions, DataSourceGetTagValuesOptions, DataSourceInstanceSettings, DataSourceWithQueryExportSupport, DataSourceWithQueryImportSupport, LegacyMetricFindQueryOptions, MetricFindValue, QueryFixAction, QueryVariableModel, ScopedVars, ScopeSpecFilter, TimeRange } from '@grafana/data';
import { BackendSrvRequest, DataSourceWithBackend, FetchResponse, TemplateSrv } from '@grafana/runtime';
import { PrometheusLanguageProviderInterface } from './language_provider';
import { QueryEditorMode } from './querybuilder/shared/types';
import { QueryCache } from './querycache/QueryCache';
import { ExemplarTraceIdDestination, PromApplication, PrometheusCacheLevel, PromOptions, PromQuery, PromQueryRequest, RawRecordingRules, RuleQueryMapping } from './types';
export declare class PrometheusDatasource extends DataSourceWithBackend<PromQuery, PromOptions> implements DataSourceWithQueryImportSupport<PromQuery>, DataSourceWithQueryExportSupport<PromQuery> {
    private readonly templateSrv;
    access: 'direct' | 'proxy';
    basicAuth: any;
    cache: QueryCache<PromQuery>;
    cacheLevel: PrometheusCacheLevel;
    customQueryParameters: URLSearchParams;
    datasourceConfigurationPrometheusFlavor?: PromApplication;
    datasourceConfigurationPrometheusVersion?: string;
    disableRecordingRules: boolean;
    exemplarTraceIdDestinations: ExemplarTraceIdDestination[] | undefined;
    exemplarsAvailable: boolean;
    hasIncrementalQuery: boolean;
    httpMethod: string;
    id: number;
    interval: string;
    languageProvider: PrometheusLanguageProviderInterface;
    lookupsDisabled: boolean;
    metricNamesAutocompleteSuggestionLimit: number;
    ruleMappings: RuleQueryMapping;
    seriesEndpoint: boolean;
    seriesLimit: number;
    type: string;
    url: string;
    withCredentials: boolean;
    defaultEditor?: QueryEditorMode;
    constructor(instanceSettings: DataSourceInstanceSettings<PromOptions>, templateSrv?: TemplateSrv, languageProvider?: PrometheusLanguageProviderInterface);
    /**
     * Initializes the Prometheus datasource by loading recording rules and checking exemplar availability.
     *
     * This method performs two key initialization tasks: Loads recording rules from the
     * Prometheus API and checks if exemplars are available by testing the exemplars API endpoint.
     */
    init: () => Promise<void>;
    /**
     * Loads recording rules from the Prometheus API and extracts rule mappings.
     *
     * This method fetches rules from the `/api/v1/rules` endpoint and processes
     * them to create a mapping of rule names to their corresponding queries and labels.
     * The rules API is experimental, so errors are logged but not thrown.
     */
    private loadRules;
    /**
     * Checks if exemplars are available by testing the exemplars API endpoint.
     *
     * This method makes a test request to the `/api/v1/query_exemplars` endpoint to determine
     * if the Prometheus instance supports exemplars. The test uses a simple query with a
     * 30-minute time range. If the request succeeds with a 'success' status, exemplars
     * are considered available. Errors are caught and return false to avoid breaking
     * the datasource initialization.
     */
    private areExemplarsAvailable;
    getQueryDisplayText(query: PromQuery): string;
    /**
     * Get target signature for query caching
     * @param request
     * @param query
     */
    getPrometheusTargetSignature(request: DataQueryRequest<PromQuery>, query: PromQuery): string;
    hasLabelsMatchAPISupport(): boolean;
    _isDatasourceVersionGreaterOrEqualTo(targetVersion: string, targetFlavor: PromApplication): boolean;
    _addTracingHeaders(httpOptions: PromQueryRequest, options: DataQueryRequest<PromQuery>): void;
    directAccessError(): Observable<never>;
    /**
     * Any request done from this data source should go through here as it contains some common processing for the
     * request. Any processing done here needs to be also copied on the backend as this goes through data source proxy
     * but not through the same code as alerting.
     */
    _request<T = unknown>(url: string, data: Record<string, string> | null, overrides?: Partial<BackendSrvRequest>): Observable<FetchResponse<T>>;
    importFromAbstractQueries(abstractQueries: AbstractQuery[]): Promise<PromQuery[]>;
    exportToAbstractQueries(queries: PromQuery[]): Promise<AbstractQuery[]>;
    metadataRequest<T = any>(url: string, params?: {}, options?: Partial<BackendSrvRequest>): Promise<FetchResponse<T>>;
    interpolateQueryExpr(value: string | string[] | undefined, variable: QueryVariableModel | CustomVariableModel): string | string[];
    targetContainsTemplate(target: PromQuery): boolean;
    shouldRunExemplarQuery(target: PromQuery, request: DataQueryRequest<PromQuery>): boolean;
    processTargetV2(target: PromQuery, request: DataQueryRequest<PromQuery>): PromQuery[];
    query(request: DataQueryRequest<PromQuery>): Observable<DataQueryResponse>;
    metricFindQuery(query: string, options?: LegacyMetricFindQueryOptions): Promise<MetricFindValue[]>;
    getIntervalVars(): {
        __interval: {
            text: string;
            value: string;
        };
        __interval_ms: {
            text: number;
            value: number;
        };
    };
    getRangeScopedVars(range: TimeRange): {
        __range_ms: {
            text: number;
            value: number;
        };
        __range_s: {
            text: number;
            value: number;
        };
        __range: {
            text: string;
            value: string;
        };
    };
    getTagKeys(options: DataSourceGetTagKeysOptions<PromQuery>): Promise<MetricFindValue[]>;
    getTagValues(options: DataSourceGetTagValuesOptions<PromQuery>): Promise<MetricFindValue[]>;
    interpolateVariablesInQueries(queries: PromQuery[], scopedVars: ScopedVars, filters?: AdHocVariableFilter[]): PromQuery[];
    getQueryHints(query: PromQuery, result: unknown[]): import("@grafana/data").QueryHint[];
    modifyQuery(query: PromQuery, action: QueryFixAction): PromQuery;
    /**
     * Returns the adjusted "snapped" interval parameters
     */
    getAdjustedInterval(timeRange: TimeRange): {
        start: string;
        end: string;
    };
    /**
     * This will return a time range that always includes the users current time range,
     * and then a little extra padding to round up/down to the nearest nth minute,
     * defined by the result of the getCacheDurationInMinutes.
     *
     * For longer cache durations, and shorter query durations,
     * the window we're calculating might be much bigger then the user's current window,
     * resulting in us returning labels/values that might not be applicable for the given window,
     * this is a necessary trade-off if we want to cache larger durations
     */
    getTimeRangeParams(timeRange: TimeRange): {
        start: string;
        end: string;
    };
    /**
     * This converts the adhocVariableFilter array and converts it to scopeFilter array
     * @param filters
     */
    generateScopeFilters(filters?: AdHocVariableFilter[]): ScopeSpecFilter[];
    enhanceExprWithAdHocFilters(filters: AdHocVariableFilter[] | undefined, expr: string): string;
    filterQuery(query: PromQuery): boolean;
    applyTemplateVariables(target: PromQuery, scopedVars: ScopedVars, filters?: AdHocVariableFilter[]): {
        expr: string;
        interval: string;
        legendFormat: string;
        adhocFilters?: ScopeSpecFilter[];
        utcOffsetSec?: number;
        valueWithRefId?: boolean;
        showingGraph?: boolean;
        showingTable?: boolean;
        hinting?: boolean;
        useBackend?: boolean;
        disableTextWrap?: boolean;
        fullMetaSearch?: boolean;
        includeNullMetadata?: boolean;
        fromExploreMetrics?: boolean;
        editorMode?: import("./dataquery").QueryEditorMode;
        exemplar?: boolean;
        format?: import("./dataquery").PromQueryFormat;
        instant?: boolean;
        intervalFactor?: number;
        range?: boolean;
        scopes?: Array<import("@grafana/data").ScopeSpec & Pick<import("@grafana/data").Scope["metadata"], "name">>;
        groupByKeys?: string[];
        key?: string;
        datasource?: import("@grafana/schema").DataSourceRef | null;
        hide?: boolean;
        queryType?: string;
        refId: string;
    };
    getVariables(): string[];
    interpolateString(string: string, scopedVars?: ScopedVars): string;
    interpolateExploreMetrics(fromExploreMetrics?: boolean): (value: string | string[] | undefined, variable: QueryVariableModel | CustomVariableModel) => string | string[];
    isUsingRelativeTimeRange(range: TimeRange): boolean;
    getDefaultQuery(app: CoreApp): PromQuery;
}
export declare function extractRuleMappingFromGroups(groups: RawRecordingRules[]): RuleQueryMapping;
/**
 * It creates a matcher string for resource calls
 * @param queries
 * @param adhocFilters
 *
 * @example
 * queries<PromQuery>=[{expr:`metricName{label="value"}`}]
 * adhocFilters={key:"instance", operator:"=", value:"localhost"}
 * returns {__name__=~"metricName", instance="localhost"}
 */
export declare const extractResourceMatcher: (queries: PromQuery[], adhocFilters: AdHocVariableFilter[]) => string | undefined;
