import { jsxs, jsx } from 'react/jsx-runtime';
import { useState, useMemo } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { t, Trans } from '@grafana/i18n';
import { useStyles2, Label, Input, BrowserLabel } from '@grafana/ui';
import { METRIC_LABEL } from '../../constants.mjs';
import { useMetricsBrowser } from './MetricsBrowserContext.mjs';
import { getStylesLabelSelector } from './styles.mjs';

"use strict";
function LabelSelector() {
  const styles = useStyles2(getStylesLabelSelector);
  const [labelSearchTerm, setLabelSearchTerm] = useState("");
  const { labelKeys, selectedLabelKeys, onLabelKeyClick } = useMetricsBrowser();
  const filteredLabelKeys = useMemo(() => {
    return labelKeys.filter(
      (lk) => lk !== METRIC_LABEL && (selectedLabelKeys.includes(lk) || lk.includes(labelSearchTerm))
    );
  }, [labelKeys, labelSearchTerm, selectedLabelKeys]);
  return /* @__PURE__ */ jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsx(
      Label,
      {
        description: t(
          "grafana-prometheus.components.label-selector.description-select-labels",
          "Once label values are selected, only possible label combinations are shown."
        ),
        children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.components.label-selector.select-labels-to-search-in", children: "2. Select labels to search in" })
      }
    ),
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(
      Input,
      {
        onChange: (e) => setLabelSearchTerm(e.currentTarget.value),
        "aria-label": t(
          "grafana-prometheus.components.label-selector.aria-label-filter-expression-for-label",
          "Filter expression for label"
        ),
        value: labelSearchTerm,
        "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.labelNamesFilter
      }
    ) }),
    /* @__PURE__ */ jsx("div", { className: styles.list, style: { height: 120 }, children: filteredLabelKeys.map((label) => /* @__PURE__ */ jsx(
      BrowserLabel,
      {
        name: label,
        loading: false,
        active: selectedLabelKeys.includes(label),
        hidden: false,
        facets: void 0,
        onClick: (name) => {
          setLabelSearchTerm("");
          onLabelKeyClick(name);
        },
        searchTerm: labelSearchTerm
      },
      label
    )) })
  ] });
}

export { LabelSelector };
//# sourceMappingURL=LabelSelector.mjs.map
