'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var data = require('@grafana/data');
var lodash = require('lodash');
var e2eSelectors = require('@grafana/e2e-selectors');
var i18n = require('@grafana/i18n');
var pluginUi = require('@grafana/plugin-ui');
var runtime = require('@grafana/runtime');
var ui = require('@grafana/ui');
var css = require('@emotion/css');
var Prism = require('prismjs');
var pluralize = require('pluralize');
var lezerPromql = require('@prometheus-io/lezer-promql');
var toolkit = require('@reduxjs/toolkit');
var dnd = require('@hello-pangea/dnd');
var reactUse = require('react-use');
var react = require('@floating-ui/react');
var debounce = require('debounce-promise');
var Highlighter = require('react-highlight-words');
var uFuzzy = require('@leeoniya/ufuzzy');
var reactWindow = require('react-window');
var monacoPromql = require('monaco-promql');
var uuid = require('uuid');
var momentTimezone = require('moment-timezone');
var rxjs = require('rxjs');
var operators$3 = require('rxjs/operators');
var semver = require('semver');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e : { default: e }; }

function _interopNamespaceCompat(e) {
  if (e && typeof e === 'object' && 'default' in e) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceCompat(React);
var Prism__default = /*#__PURE__*/_interopDefaultCompat(Prism);
var pluralize__default = /*#__PURE__*/_interopDefaultCompat(pluralize);
var debounce__default = /*#__PURE__*/_interopDefaultCompat(debounce);
var Highlighter__default = /*#__PURE__*/_interopDefaultCompat(Highlighter);
var uFuzzy__default = /*#__PURE__*/_interopDefaultCompat(uFuzzy);

"use strict";
const RATE_RANGES = [
  { label: "$__interval", sortValue: "$__interval" },
  { label: "$__rate_interval", sortValue: "$__rate_interval" },
  { label: "$__range", sortValue: "$__range" },
  { label: "1m", sortValue: "00:01:00" },
  { label: "5m", sortValue: "00:05:00" },
  { label: "10m", sortValue: "00:10:00" },
  { label: "30m", sortValue: "00:30:00" },
  { label: "1h", sortValue: "01:00:00" },
  { label: "1d", sortValue: "24:00:00" }
];
const OPERATORS = ["by", "group_left", "group_right", "ignoring", "on", "offset", "without"];
const LOGICAL_OPERATORS = ["or", "and", "unless"];
const TRIGONOMETRIC_FUNCTIONS = [
  {
    label: "acos",
    insertText: "acos",
    detail: "acos(v instant-vector)",
    documentation: "calculates the arccosine of all elements in v"
  },
  {
    label: "acosh",
    insertText: "acosh",
    detail: "acosh(v instant-vector)",
    documentation: "calculates the inverse hyperbolic cosine of all elements in v"
  },
  {
    label: "asin",
    insertText: "asin",
    detail: "asin(v instant-vector)",
    documentation: "calculates the arcsine of all elements in v"
  },
  {
    label: "asinh",
    insertText: "asinh",
    detail: "asinh(v instant-vector)",
    documentation: "calculates the inverse hyperbolic sine of all elements in v"
  },
  {
    label: "atan",
    insertText: "atan",
    detail: "atan(v instant-vector)",
    documentation: "calculates the arctangent of all elements in v"
  },
  {
    label: "atanh",
    insertText: "atanh",
    detail: "atanh(v instant-vector)",
    documentation: "calculates the inverse hyperbolic tangent of all elements in v"
  },
  {
    label: "cos",
    insertText: "cos",
    detail: "cos(v instant-vector)",
    documentation: "calculates the cosine of all elements in v"
  },
  {
    label: "cosh",
    insertText: "cosh",
    detail: "cosh(v instant-vector)",
    documentation: "calculates the hyperbolic cosine of all elements in v"
  },
  {
    label: "sin",
    insertText: "sin",
    detail: "sin(v instant-vector)",
    documentation: "calculates the sine of all elements in v"
  },
  {
    label: "sinh",
    insertText: "sinh",
    detail: "sinh(v instant-vector)",
    documentation: "calculates the hyperbolic sine of all elements in v"
  },
  {
    label: "tan",
    insertText: "tan",
    detail: "tan(v instant-vector)",
    documentation: "calculates the tangent of all elements in v"
  },
  {
    label: "tanh",
    insertText: "tanh",
    detail: "tanh(v instant-vector)",
    documentation: "calculates the hyperbolic tangent of all elements in v"
  }
];
const AGGREGATION_OPERATORS = [
  {
    label: "sum",
    insertText: "sum",
    documentation: "Calculate sum over dimensions"
  },
  {
    label: "min",
    insertText: "min",
    documentation: "Select minimum over dimensions"
  },
  {
    label: "max",
    insertText: "max",
    documentation: "Select maximum over dimensions"
  },
  {
    label: "avg",
    insertText: "avg",
    documentation: "Calculate the average over dimensions"
  },
  {
    label: "group",
    insertText: "group",
    documentation: "All values in the resulting vector are 1"
  },
  {
    label: "stddev",
    insertText: "stddev",
    documentation: "Calculate population standard deviation over dimensions"
  },
  {
    label: "stdvar",
    insertText: "stdvar",
    documentation: "Calculate population standard variance over dimensions"
  },
  {
    label: "count",
    insertText: "count",
    documentation: "Count number of elements in the vector"
  },
  {
    label: "count_values",
    insertText: "count_values",
    documentation: "Count number of elements with the same value"
  },
  {
    label: "bottomk",
    insertText: "bottomk",
    documentation: "Smallest k elements by sample value"
  },
  {
    label: "topk",
    insertText: "topk",
    documentation: "Largest k elements by sample value"
  },
  {
    label: "quantile",
    insertText: "quantile",
    documentation: "Calculate \u03C6-quantile (0 \u2264 \u03C6 \u2264 1) over dimensions"
  }
];
const FUNCTIONS = [
  ...AGGREGATION_OPERATORS,
  ...TRIGONOMETRIC_FUNCTIONS,
  {
    insertText: "abs",
    label: "abs",
    detail: "abs(v instant-vector)",
    documentation: "Returns the input vector with all sample values converted to their absolute value."
  },
  {
    insertText: "absent",
    label: "absent",
    detail: "absent(v instant-vector)",
    documentation: "Returns an empty vector if the vector passed to it has any elements and a 1-element vector with the value 1 if the vector passed to it has no elements. This is useful for alerting on when no time series exist for a given metric name and label combination."
  },
  {
    insertText: "absent_over_time",
    label: "absent_over_time",
    detail: "absent(v range-vector)",
    documentation: "Returns an empty vector if the range vector passed to it has any elements and a 1-element vector with the value 1 if the range vector passed to it has no elements."
  },
  {
    insertText: "ceil",
    label: "ceil",
    detail: "ceil(v instant-vector)",
    documentation: "Rounds the sample values of all elements in `v` up to the nearest integer."
  },
  {
    insertText: "changes",
    label: "changes",
    detail: "changes(v range-vector)",
    documentation: "For each input time series, `changes(v range-vector)` returns the number of times its value has changed within the provided time range as an instant vector."
  },
  {
    insertText: "clamp",
    label: "clamp",
    detail: "clamp(v instant-vector, min scalar, max scalar)",
    documentation: "Clamps the sample values of all elements in `v` to have a lower limit of `min` and an upper limit of `max`."
  },
  {
    insertText: "clamp_max",
    label: "clamp_max",
    detail: "clamp_max(v instant-vector, max scalar)",
    documentation: "Clamps the sample values of all elements in `v` to have an upper limit of `max`."
  },
  {
    insertText: "clamp_min",
    label: "clamp_min",
    detail: "clamp_min(v instant-vector, min scalar)",
    documentation: "Clamps the sample values of all elements in `v` to have a lower limit of `min`."
  },
  {
    insertText: "count_scalar",
    label: "count_scalar",
    detail: "count_scalar(v instant-vector)",
    documentation: "Returns the number of elements in a time series vector as a scalar. This is in contrast to the `count()` aggregation operator, which always returns a vector (an empty one if the input vector is empty) and allows grouping by labels via a `by` clause."
  },
  {
    insertText: "deg",
    label: "deg",
    detail: "deg(v instant-vector)",
    documentation: "Converts radians to degrees for all elements in v"
  },
  {
    insertText: "day_of_month",
    label: "day_of_month",
    detail: "day_of_month(v=vector(time()) instant-vector)",
    documentation: "Returns the day of the month for each of the given times in UTC. Returned values are from 1 to 31."
  },
  {
    insertText: "day_of_week",
    label: "day_of_week",
    detail: "day_of_week(v=vector(time()) instant-vector)",
    documentation: "Returns the day of the week for each of the given times in UTC. Returned values are from 0 to 6, where 0 means Sunday etc."
  },
  {
    insertText: "day_of_year",
    label: "day_of_year",
    detail: "day_of_year(v=vector(time()) instant-vector)",
    documentation: "Returns the day of the year for each of the given times in UTC. Returned values are from 1 to 365 for non-leap years, and 1 to 366 in leap years."
  },
  {
    insertText: "days_in_month",
    label: "days_in_month",
    detail: "days_in_month(v=vector(time()) instant-vector)",
    documentation: "Returns number of days in the month for each of the given times in UTC. Returned values are from 28 to 31."
  },
  {
    insertText: "delta",
    label: "delta",
    detail: "delta(v range-vector)",
    documentation: "Calculates the difference between the first and last value of each time series element in a range vector `v`, returning an instant vector with the given deltas and equivalent labels. The delta is extrapolated to cover the full time range as specified in the range vector selector, so that it is possible to get a non-integer result even if the sample values are all integers."
  },
  {
    insertText: "deriv",
    label: "deriv",
    detail: "deriv(v range-vector)",
    documentation: "Calculates the per-second derivative of the time series in a range vector `v`, using simple linear regression."
  },
  {
    insertText: "double_exponential_smoothing",
    label: "double_exponential_smoothing",
    detail: "double_exponential_smoothing(v range-vector, sf scalar, tf scalar)",
    documentation: "Produces a smoothed value for time series based on the range in `v`. The lower the smoothing factor `sf`, the more importance is given to old data. The higher the trend factor `tf`, the more trends in the data is considered. Both `sf` and `tf` must be between 0 and 1."
  },
  {
    insertText: "drop_common_labels",
    label: "drop_common_labels",
    detail: "drop_common_labels(instant-vector)",
    documentation: "Drops all labels that have the same name and value across all series in the input vector."
  },
  {
    insertText: "exp",
    label: "exp",
    detail: "exp(v instant-vector)",
    documentation: "Calculates the exponential function for all elements in `v`.\nSpecial cases are:\n* `Exp(+Inf) = +Inf` \n* `Exp(NaN) = NaN`"
  },
  {
    insertText: "floor",
    label: "floor",
    detail: "floor(v instant-vector)",
    documentation: "Rounds the sample values of all elements in `v` down to the nearest integer."
  },
  {
    insertText: "histogram_quantile",
    label: "histogram_quantile",
    detail: "histogram_quantile(\u03C6 float, b instant-vector)",
    documentation: "Calculates the \u03C6-quantile (0 \u2264 \u03C6 \u2264 1) from the buckets `b` of a histogram. The samples in `b` are the counts of observations in each bucket. Each sample must have a label `le` where the label value denotes the inclusive upper bound of the bucket. (Samples without such a label are silently ignored.) The histogram metric type automatically provides time series with the `_bucket` suffix and the appropriate labels."
  },
  {
    insertText: "holt_winters",
    label: "holt_winters",
    detail: "holt_winters(v range-vector, sf scalar, tf scalar)",
    documentation: "Renamed as double_exponential_smoothing in prometheus v3.x. For prometheus versions equal and greater than v3.0 please use double_exponential_smoothing. \n\nProduces a smoothed value for time series based on the range in `v`. The lower the smoothing factor `sf`, the more importance is given to old data. The higher the trend factor `tf`, the more trends in the data is considered. Both `sf` and `tf` must be between 0 and 1."
  },
  {
    insertText: "hour",
    label: "hour",
    detail: "hour(v=vector(time()) instant-vector)",
    documentation: "Returns the hour of the day for each of the given times in UTC. Returned values are from 0 to 23."
  },
  {
    insertText: "idelta",
    label: "idelta",
    detail: "idelta(v range-vector)",
    documentation: "Calculates the difference between the last two samples in the range vector `v`, returning an instant vector with the given deltas and equivalent labels."
  },
  {
    insertText: "increase",
    label: "increase",
    detail: "increase(v range-vector)",
    documentation: "Calculates the increase in the time series in the range vector. Breaks in monotonicity (such as counter resets due to target restarts) are automatically adjusted for. The increase is extrapolated to cover the full time range as specified in the range vector selector, so that it is possible to get a non-integer result even if a counter increases only by integer increments."
  },
  {
    insertText: "info",
    label: "info",
    detail: "info(v instant-vector, [data-label-selector instant-vector])",
    documentation: "Returns latest details and metadata about a group of metrics, such as their labels and current values, without doing any calculations"
  },
  {
    insertText: "irate",
    label: "irate",
    detail: "irate(v range-vector)",
    documentation: "Calculates the per-second instant rate of increase of the time series in the range vector. This is based on the last two data points. Breaks in monotonicity (such as counter resets due to target restarts) are automatically adjusted for."
  },
  {
    insertText: "label_join",
    label: "label_join",
    detail: "label_join(v instant-vector, dst_label string, separator string, src_label_1 string, src_label_2 string, ...)",
    documentation: "For each timeseries in `v`, joins all the values of all the `src_labels` using `separator` and returns the timeseries with the label `dst_label` containing the joined value. There can be any number of `src_labels` in this function."
  },
  {
    insertText: "label_replace",
    label: "label_replace",
    detail: "label_replace(v instant-vector, dst_label string, replacement string, src_label string, regex string)",
    documentation: "For each timeseries in `v`, `label_replace(v instant-vector, dst_label string, replacement string, src_label string, regex string)`  matches the regular expression `regex` against the label `src_label`.  If it matches, then the timeseries is returned with the label `dst_label` replaced by the expansion of `replacement`. `$1` is replaced with the first matching subgroup, `$2` with the second etc. If the regular expression doesn't match then the timeseries is returned unchanged."
  },
  {
    insertText: "ln",
    label: "ln",
    detail: "ln(v instant-vector)",
    documentation: "Calculates the natural logarithm for all elements in `v`.\nSpecial cases are:\n * `ln(+Inf) = +Inf`\n * `ln(0) = -Inf`\n * `ln(x < 0) = NaN`\n * `ln(NaN) = NaN`"
  },
  {
    insertText: "log2",
    label: "log2",
    detail: "log2(v instant-vector)",
    documentation: "Calculates the binary logarithm for all elements in `v`. The special cases are equivalent to those in `ln`."
  },
  {
    insertText: "log10",
    label: "log10",
    detail: "log10(v instant-vector)",
    documentation: "Calculates the decimal logarithm for all elements in `v`. The special cases are equivalent to those in `ln`."
  },
  {
    insertText: "minute",
    label: "minute",
    detail: "minute(v=vector(time()) instant-vector)",
    documentation: "Returns the minute of the hour for each of the given times in UTC. Returned values are from 0 to 59."
  },
  {
    insertText: "month",
    label: "month",
    detail: "month(v=vector(time()) instant-vector)",
    documentation: "Returns the month of the year for each of the given times in UTC. Returned values are from 1 to 12, where 1 means January etc."
  },
  {
    insertText: "pi",
    label: "pi",
    detail: "pi()",
    documentation: "Returns pi"
  },
  {
    insertText: "predict_linear",
    label: "predict_linear",
    detail: "predict_linear(v range-vector, t scalar)",
    documentation: "Predicts the value of time series `t` seconds from now, based on the range vector `v`, using simple linear regression."
  },
  {
    insertText: "rad",
    label: "rad",
    detail: "rad(v instant-vector)",
    documentation: "Converts degrees to radians for all elements in v"
  },
  {
    insertText: "rate",
    label: "rate",
    detail: "rate(v range-vector)",
    documentation: "Calculates the per-second average rate of increase of the time series in the range vector. Breaks in monotonicity (such as counter resets due to target restarts) are automatically adjusted for. Also, the calculation extrapolates to the ends of the time range, allowing for missed scrapes or imperfect alignment of scrape cycles with the range's time period."
  },
  {
    insertText: "resets",
    label: "resets",
    detail: "resets(v range-vector)",
    documentation: "For each input time series, `resets(v range-vector)` returns the number of counter resets within the provided time range as an instant vector. Any decrease in the value between two consecutive samples is interpreted as a counter reset."
  },
  {
    insertText: "round",
    label: "round",
    detail: "round(v instant-vector, to_nearest=1 scalar)",
    documentation: "Rounds the sample values of all elements in `v` to the nearest integer. Ties are resolved by rounding up. The optional `to_nearest` argument allows specifying the nearest multiple to which the sample values should be rounded. This multiple may also be a fraction."
  },
  {
    insertText: "scalar",
    label: "scalar",
    detail: "scalar(v instant-vector)",
    documentation: "Given a single-element input vector, `scalar(v instant-vector)` returns the sample value of that single element as a scalar. If the input vector does not have exactly one element, `scalar` will return `NaN`."
  },
  {
    insertText: "sgn",
    label: "sgn",
    detail: "sgn(v instant-vector)",
    documentation: "Returns a vector with all sample values converted to their sign, defined as this: 1 if v is positive, -1 if v is negative and 0 if v is equal to zero."
  },
  {
    insertText: "sort",
    label: "sort",
    detail: "sort(v instant-vector)",
    documentation: "Returns vector elements sorted by their sample values, in ascending order."
  },
  {
    insertText: "sort_desc",
    label: "sort_desc",
    detail: "sort_desc(v instant-vector)",
    documentation: "Returns vector elements sorted by their sample values, in descending order."
  },
  {
    insertText: "sqrt",
    label: "sqrt",
    detail: "sqrt(v instant-vector)",
    documentation: "Calculates the square root of all elements in `v`."
  },
  {
    insertText: "time",
    label: "time",
    detail: "time()",
    documentation: "Returns the number of seconds since January 1, 1970 UTC. Note that this does not actually return the current time, but the time at which the expression is to be evaluated."
  },
  {
    insertText: "timestamp",
    label: "timestamp",
    detail: "timestamp(v instant-vector)",
    documentation: "Returns the timestamp of each of the samples of the given vector as the number of seconds since January 1, 1970 UTC."
  },
  {
    insertText: "vector",
    label: "vector",
    detail: "vector(s scalar)",
    documentation: "Returns the scalar `s` as a vector with no labels."
  },
  {
    insertText: "year",
    label: "year",
    detail: "year(v=vector(time()) instant-vector)",
    documentation: "Returns the year for each of the given times in UTC."
  },
  {
    insertText: "avg_over_time",
    label: "avg_over_time",
    detail: "avg_over_time(range-vector)",
    documentation: "The average value of all points in the specified interval."
  },
  {
    insertText: "min_over_time",
    label: "min_over_time",
    detail: "min_over_time(range-vector)",
    documentation: "The minimum value of all points in the specified interval."
  },
  {
    insertText: "max_over_time",
    label: "max_over_time",
    detail: "max_over_time(range-vector)",
    documentation: "The maximum value of all points in the specified interval."
  },
  {
    insertText: "sum_over_time",
    label: "sum_over_time",
    detail: "sum_over_time(range-vector)",
    documentation: "The sum of all values in the specified interval."
  },
  {
    insertText: "count_over_time",
    label: "count_over_time",
    detail: "count_over_time(range-vector)",
    documentation: "The count of all values in the specified interval."
  },
  {
    insertText: "quantile_over_time",
    label: "quantile_over_time",
    detail: "quantile_over_time(scalar, range-vector)",
    documentation: "The \u03C6-quantile (0 \u2264 \u03C6 \u2264 1) of the values in the specified interval."
  },
  {
    insertText: "stddev_over_time",
    label: "stddev_over_time",
    detail: "stddev_over_time(range-vector)",
    documentation: "The population standard deviation of the values in the specified interval."
  },
  {
    insertText: "stdvar_over_time",
    label: "stdvar_over_time",
    detail: "stdvar_over_time(range-vector)",
    documentation: "The population standard variance of the values in the specified interval."
  },
  {
    insertText: "last_over_time",
    label: "last_over_time",
    detail: "last_over_time(range-vector)",
    documentation: "The most recent point value in specified interval."
  },
  {
    insertText: "present_over_time",
    label: "present_over_time",
    detail: "present_over_time(range-vector)",
    documentation: "The value 1 for any series in the specified interval."
  },
  {
    insertText: "histogram_avg",
    label: "histogram_avg",
    detail: "histogram_avg(v instant-vector)",
    documentation: "Returns the arithmetic average of observed values stored in a native histogram. Samples that are not native histograms are ignored and do not show up in the returned vector."
  },
  {
    insertText: "histogram_count",
    label: "histogram_count",
    detail: "histogram_count(v instant-vector)",
    documentation: "Returns the count of observations stored in a native histogram."
  },
  {
    insertText: "histogram_sum",
    label: "histogram_sum",
    detail: "histogram_sum(v instant-vector)",
    documentation: "Returns the sum of observations stored in a native histogram."
  },
  {
    insertText: "histogram_fraction",
    label: "histogram_fraction",
    detail: "histogram_fraction(lower scalar, upper scalar, v instant-vector)",
    documentation: "Returns the estimated fraction of observations between the provided lower and upper values."
  },
  {
    insertText: "histogram_stddev",
    label: "histogram_stddev",
    detail: "histogram_stddev(v instant-vector)",
    documentation: "Returns the estimated standard deviation of observations in a native histogram, based on the geometric mean of the buckets where the observations lie."
  },
  {
    insertText: "histogram_stdvar",
    label: "histogram_stdvar",
    detail: "histogram_stdvar(v instant-vector)",
    documentation: "Returns the estimated standard variance of observations in a native histogram."
  }
];
const PROM_KEYWORDS = FUNCTIONS.map((keyword) => keyword.label);
const promqlGrammar = {
  comment: {
    pattern: /#.*/
  },
  "context-aggregation": {
    pattern: /((by|without)\s*)\([^)]*\)/,
    // by ()
    lookbehind: true,
    inside: {
      "label-key": {
        pattern: /[^(),\s][^,)]*[^),\s]*/,
        alias: "attr-name"
      },
      punctuation: /[()]/
    }
  },
  "context-labels": {
    pattern: /\{[^}]*(?=}?)/,
    greedy: true,
    inside: {
      comment: {
        pattern: /#.*/
      },
      "label-key": {
        pattern: /[a-z_]\w*(?=\s*(=|!=|=~|!~))/,
        alias: "attr-name",
        greedy: true
      },
      "label-value": {
        pattern: /"(?:\\.|[^\\"])*"/,
        greedy: true,
        alias: "attr-value"
      },
      punctuation: /[{]/
    }
  },
  function: new RegExp(`\\b(?:${FUNCTIONS.map((f) => f.label).join("|")})(?=\\s*\\()`, "i"),
  "context-range": [
    {
      pattern: /\[[^\]]*(?=])/,
      // [1m]
      inside: {
        "range-duration": {
          pattern: /\b\d+[smhdwy]\b/i,
          alias: "number"
        }
      }
    },
    {
      pattern: /(offset\s+)\w+/,
      // offset 1m
      lookbehind: true,
      inside: {
        "range-duration": {
          pattern: /\b\d+[smhdwy]\b/i,
          alias: "number"
        }
      }
    }
  ],
  idList: {
    pattern: /\d+(\|\d+)+/,
    alias: "number"
  },
  number: /\b-?\d+((\.\d*)?([eE][+-]?\d+)?)?\b/,
  operator: new RegExp(`/[-+*/=%^~]|&&?|\\|?\\||!=?|<(?:=>?|<|>)?|>[>=]?|\\b(?:${OPERATORS.join("|")})\\b`, "i"),
  punctuation: /[{};()`,.]/
};

"use strict";
function RawQuery({ query, lang, className }) {
  const theme = ui.useTheme2();
  const styles = getStyles$m(theme);
  const highlighted = Prism__default.default.highlight(query, lang.grammar, lang.name);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      className: css.cx(styles.editorField, "prism-syntax-highlight", className),
      "aria-label": i18n.t("grafana-prometheus.querybuilder.raw-query.aria-label-selector", "selector"),
      dangerouslySetInnerHTML: { __html: highlighted }
    }
  );
}
const getStyles$m = (theme) => {
  return {
    editorField: css.css({
      fontFamily: theme.typography.fontFamilyMonospace,
      fontSize: theme.typography.bodySmall.fontSize
    })
  };
};

"use strict";
var PromVisualQueryOperationCategory = /* @__PURE__ */ ((PromVisualQueryOperationCategory2) => {
  PromVisualQueryOperationCategory2["Aggregations"] = "Aggregations";
  PromVisualQueryOperationCategory2["RangeFunctions"] = "Range functions";
  PromVisualQueryOperationCategory2["Functions"] = "Functions";
  PromVisualQueryOperationCategory2["BinaryOps"] = "Binary operations";
  PromVisualQueryOperationCategory2["Trigonometric"] = "Trigonometric";
  PromVisualQueryOperationCategory2["Time"] = "Time Functions";
  return PromVisualQueryOperationCategory2;
})(PromVisualQueryOperationCategory || {});
var PromOperationId = /* @__PURE__ */ ((PromOperationId2) => {
  PromOperationId2["Abs"] = "abs";
  PromOperationId2["Absent"] = "absent";
  PromOperationId2["AbsentOverTime"] = "absent_over_time";
  PromOperationId2["Acos"] = "acos";
  PromOperationId2["Acosh"] = "acosh";
  PromOperationId2["Asin"] = "asin";
  PromOperationId2["Asinh"] = "asinh";
  PromOperationId2["Atan"] = "atan";
  PromOperationId2["Atanh"] = "atanh";
  PromOperationId2["Avg"] = "avg";
  PromOperationId2["AvgOverTime"] = "avg_over_time";
  PromOperationId2["BottomK"] = "bottomk";
  PromOperationId2["Ceil"] = "ceil";
  PromOperationId2["Changes"] = "changes";
  PromOperationId2["Clamp"] = "clamp";
  PromOperationId2["ClampMax"] = "clamp_max";
  PromOperationId2["ClampMin"] = "clamp_min";
  PromOperationId2["Cos"] = "cos";
  PromOperationId2["Cosh"] = "cosh";
  PromOperationId2["Count"] = "count";
  PromOperationId2["CountOverTime"] = "count_over_time";
  PromOperationId2["CountScalar"] = "count_scalar";
  PromOperationId2["CountValues"] = "count_values";
  PromOperationId2["DayOfMonth"] = "day_of_month";
  PromOperationId2["DayOfWeek"] = "day_of_week";
  PromOperationId2["DayOfYear"] = "day_of_year";
  PromOperationId2["DaysInMonth"] = "days_in_month";
  PromOperationId2["Deg"] = "deg";
  PromOperationId2["Delta"] = "delta";
  PromOperationId2["Deriv"] = "deriv";
  PromOperationId2["DoubleExponentialSmoothing"] = "double_exponential_smoothing";
  PromOperationId2["DropCommonLabels"] = "drop_common_labels";
  PromOperationId2["Exp"] = "exp";
  PromOperationId2["Floor"] = "floor";
  PromOperationId2["Group"] = "group";
  PromOperationId2["HistogramQuantile"] = "histogram_quantile";
  PromOperationId2["HistogramAvg"] = "histogram_avg";
  PromOperationId2["HistogramCount"] = "histogram_count";
  PromOperationId2["HistogramSum"] = "histogram_sum";
  PromOperationId2["HistogramFraction"] = "histogram_fraction";
  PromOperationId2["HistogramStddev"] = "histogram_stddev";
  PromOperationId2["HistogramStdvar"] = "histogram_stdvar";
  PromOperationId2["HoltWinters"] = "holt_winters";
  PromOperationId2["Hour"] = "hour";
  PromOperationId2["Idelta"] = "idelta";
  PromOperationId2["Increase"] = "increase";
  PromOperationId2["Info"] = "info";
  PromOperationId2["Irate"] = "irate";
  PromOperationId2["LabelJoin"] = "label_join";
  PromOperationId2["LabelReplace"] = "label_replace";
  PromOperationId2["Last"] = "last";
  PromOperationId2["LastOverTime"] = "last_over_time";
  PromOperationId2["Ln"] = "ln";
  PromOperationId2["Log10"] = "log10";
  PromOperationId2["Log2"] = "log2";
  PromOperationId2["Max"] = "max";
  PromOperationId2["MaxOverTime"] = "max_over_time";
  PromOperationId2["Min"] = "min";
  PromOperationId2["MinOverTime"] = "min_over_time";
  PromOperationId2["Minute"] = "minute";
  PromOperationId2["Month"] = "month";
  PromOperationId2["Pi"] = "pi";
  PromOperationId2["PredictLinear"] = "predict_linear";
  PromOperationId2["Present"] = "present";
  PromOperationId2["PresentOverTime"] = "present_over_time";
  PromOperationId2["Quantile"] = "quantile";
  PromOperationId2["QuantileOverTime"] = "quantile_over_time";
  PromOperationId2["Rad"] = "rad";
  PromOperationId2["Rate"] = "rate";
  PromOperationId2["Resets"] = "resets";
  PromOperationId2["Round"] = "round";
  PromOperationId2["Scalar"] = "scalar";
  PromOperationId2["Sgn"] = "sgn";
  PromOperationId2["Sin"] = "sin";
  PromOperationId2["Sinh"] = "sinh";
  PromOperationId2["Sort"] = "sort";
  PromOperationId2["SortDesc"] = "sort_desc";
  PromOperationId2["Sqrt"] = "sqrt";
  PromOperationId2["Stddev"] = "stddev";
  PromOperationId2["StddevOverTime"] = "stddev_over_time";
  PromOperationId2["Sum"] = "sum";
  PromOperationId2["SumOverTime"] = "sum_over_time";
  PromOperationId2["Tan"] = "tan";
  PromOperationId2["Tanh"] = "tanh";
  PromOperationId2["Time"] = "time";
  PromOperationId2["Timestamp"] = "timestamp";
  PromOperationId2["TopK"] = "topk";
  PromOperationId2["Vector"] = "vector";
  PromOperationId2["Year"] = "year";
  PromOperationId2["Addition"] = "__addition";
  PromOperationId2["Subtraction"] = "__subtraction";
  PromOperationId2["MultiplyBy"] = "__multiply_by";
  PromOperationId2["DivideBy"] = "__divide_by";
  PromOperationId2["Modulo"] = "__modulo";
  PromOperationId2["Exponent"] = "__exponent";
  PromOperationId2["NestedQuery"] = "__nested_query";
  PromOperationId2["EqualTo"] = "__equal_to";
  PromOperationId2["NotEqualTo"] = "__not_equal_to";
  PromOperationId2["GreaterThan"] = "__greater_than";
  PromOperationId2["LessThan"] = "__less_than";
  PromOperationId2["GreaterOrEqual"] = "__greater_or_equal";
  PromOperationId2["LessOrEqual"] = "__less_or_equal";
  return PromOperationId2;
})(PromOperationId || {});
var PromQueryPatternType = /* @__PURE__ */ ((PromQueryPatternType2) => {
  PromQueryPatternType2["Rate"] = "rate";
  PromQueryPatternType2["Histogram"] = "histogram";
  PromQueryPatternType2["Binary"] = "binary";
  return PromQueryPatternType2;
})(PromQueryPatternType || {});

"use strict";
function functionRendererLeft(model, def, innerExpr) {
  const params = renderParams(model, def, innerExpr);
  const str = model.id + "(";
  if (innerExpr) {
    params.push(innerExpr);
  }
  return str + params.join(", ") + ")";
}
function functionRendererRight(model, def, innerExpr) {
  const params = renderParams(model, def, innerExpr);
  const str = model.id + "(";
  if (innerExpr) {
    params.unshift(innerExpr);
  }
  return str + params.join(", ") + ")";
}
function rangeRendererWithParams(model, def, innerExpr, renderLeft) {
  var _a, _b;
  if (def.params.length < 2) {
    throw `Cannot render a function with params of length [${def.params.length}]`;
  }
  let rangeVector = (_b = ((_a = model.params) != null ? _a : [])[0]) != null ? _b : "5m";
  const params = renderParams(
    {
      ...model,
      params: model.params.slice(1)
    },
    {
      ...def,
      params: def.params.slice(1),
      defaultParams: def.defaultParams.slice(1)
    },
    innerExpr
  );
  const str = model.id + "(";
  if (innerExpr) {
    renderLeft ? params.push(`${innerExpr}[${rangeVector}]`) : params.unshift(`${innerExpr}[${rangeVector}]`);
  }
  return str + params.join(", ") + ")";
}
function rangeRendererRightWithParams(model, def, innerExpr) {
  return rangeRendererWithParams(model, def, innerExpr, false);
}
function rangeRendererLeftWithParams(model, def, innerExpr) {
  return rangeRendererWithParams(model, def, innerExpr, true);
}
function renderParams(model, def, innerExpr) {
  var _a;
  return ((_a = model.params) != null ? _a : []).map((value, index) => {
    const paramDef = def.params[index];
    if ((paramDef == null ? void 0 : paramDef.type) === "string") {
      return `"${value}"`;
    }
    return value;
  });
}
function defaultAddOperationHandler(def, query) {
  const newOperation = {
    id: def.id,
    params: def.defaultParams
  };
  return {
    ...query,
    operations: [...query.operations, newOperation]
  };
}
function getPromOperationDisplayName(funcName) {
  return lodash.capitalize(funcName.replace(/_/g, " "));
}
function getRangeVectorParamDef(withRateInterval = false) {
  const options = [
    {
      label: "$__interval",
      value: "$__interval"
      // tooltip: 'Dynamic interval based on max data points, scrape and min interval',
    },
    { label: "1m", value: "1m" },
    { label: "5m", value: "5m" },
    { label: "10m", value: "10m" },
    { label: "1h", value: "1h" },
    { label: "24h", value: "24h" }
  ];
  if (withRateInterval) {
    options.unshift({
      label: "$__rate_interval",
      value: "$__rate_interval"
      // tooltip: 'Always above 4x scrape interval',
    });
  }
  const param = {
    name: "Range",
    type: "string",
    options
  };
  return param;
}
function createAggregationOperation(name, overrides = {}) {
  const operations = [
    {
      id: name,
      name: getPromOperationDisplayName(name),
      params: [
        {
          name: "By label",
          type: "string",
          restParam: true,
          optional: true
        }
      ],
      defaultParams: [],
      alternativesKey: "plain aggregations",
      category: PromVisualQueryOperationCategory.Aggregations,
      renderer: functionRendererLeft,
      paramChangedHandler: getOnLabelAddedHandler(`__${name}_by`),
      explainHandler: getAggregationExplainer(name, ""),
      addOperationHandler: defaultAddOperationHandler,
      ...overrides
    },
    {
      id: `__${name}_by`,
      name: `${getPromOperationDisplayName(name)} by`,
      params: [
        {
          name: "Label",
          type: "string",
          restParam: true,
          optional: true,
          editor: "LabelParamEditor"
        }
      ],
      defaultParams: [""],
      alternativesKey: "aggregations by",
      category: PromVisualQueryOperationCategory.Aggregations,
      renderer: getAggregationByRenderer(name),
      paramChangedHandler: getLastLabelRemovedHandler(name),
      explainHandler: getAggregationExplainer(name, "by"),
      addOperationHandler: defaultAddOperationHandler,
      hideFromList: true,
      ...overrides
    },
    {
      id: `__${name}_without`,
      name: `${getPromOperationDisplayName(name)} without`,
      params: [
        {
          name: "Label",
          type: "string",
          restParam: true,
          optional: true,
          editor: "LabelParamEditor"
        }
      ],
      defaultParams: [""],
      alternativesKey: "aggregations by",
      category: PromVisualQueryOperationCategory.Aggregations,
      renderer: getAggregationWithoutRenderer(name),
      paramChangedHandler: getLastLabelRemovedHandler(name),
      explainHandler: getAggregationExplainer(name, "without"),
      addOperationHandler: defaultAddOperationHandler,
      hideFromList: true,
      ...overrides
    }
  ];
  return operations;
}
function createAggregationOperationWithParam(name, paramsDef, overrides = {}) {
  const operations = createAggregationOperation(name, overrides);
  operations[0].params.unshift(...paramsDef.params);
  operations[1].params.unshift(...paramsDef.params);
  operations[2].params.unshift(...paramsDef.params);
  operations[0].defaultParams = paramsDef.defaultParams;
  operations[1].defaultParams = [...paramsDef.defaultParams, ""];
  operations[2].defaultParams = [...paramsDef.defaultParams, ""];
  operations[1].renderer = getAggregationByRendererWithParameter(name);
  operations[2].renderer = getAggregationByRendererWithParameter(name);
  return operations;
}
function getAggregationByRenderer(aggregation) {
  return function aggregationRenderer(model, def, innerExpr) {
    return `${aggregation} by(${model.params.join(", ")}) (${innerExpr})`;
  };
}
function getAggregationWithoutRenderer(aggregation) {
  return function aggregationRenderer(model, def, innerExpr) {
    return `${aggregation} without(${model.params.join(", ")}) (${innerExpr})`;
  };
}
function getAggregationExplainer(aggregationName, mode) {
  return function aggregationExplainer(model) {
    const labels = model.params.map((label) => `\`${label}\``).join(" and ");
    const labelWord = pluralize__default.default("label", model.params.length);
    switch (mode) {
      case "by":
        return `Calculates ${aggregationName} over dimensions while preserving ${labelWord} ${labels}.`;
      case "without":
        return `Calculates ${aggregationName} over the dimensions ${labels}. All other labels are preserved.`;
      default:
        return `Calculates ${aggregationName} over the dimensions.`;
    }
  };
}
function getAggregationByRendererWithParameter(aggregation) {
  return function aggregationRenderer(model, def, innerExpr) {
    const restParamIndex = def.params.findIndex((param) => param.restParam);
    const params = model.params.slice(0, restParamIndex);
    const restParams = model.params.slice(restParamIndex);
    return `${aggregation} by(${restParams.join(", ")}) (${params.map((param, idx) => def.params[idx].type === "string" ? `"${param}"` : param).join(", ")}, ${innerExpr})`;
  };
}
function getLastLabelRemovedHandler(changeToOperationId) {
  return function onParamChanged(index, op, def) {
    if (op.params.length < def.params.length) {
      return {
        ...op,
        id: changeToOperationId
      };
    }
    return op;
  };
}
function getOnLabelAddedHandler(changeToOperationId) {
  return function onParamChanged(index, op, def) {
    if (op.params.length === def.params.length) {
      return {
        ...op,
        id: changeToOperationId
      };
    }
    return op;
  };
}
function isConflictingSelector(newLabel, labels) {
  if (!newLabel.label || !newLabel.op || !newLabel.value) {
    return false;
  }
  if (labels.length < 2) {
    return false;
  }
  const operationIsNegative = newLabel.op.toString().startsWith("!");
  const candidates = labels.filter(
    (label) => label.label === newLabel.label && label.value === newLabel.value && label.op !== newLabel.op
  );
  const conflict = candidates.some((candidate) => {
    var _a, _b;
    if (operationIsNegative && ((_a = candidate == null ? void 0 : candidate.op) == null ? void 0 : _a.toString().startsWith("!")) === false) {
      return true;
    }
    if (operationIsNegative === false && ((_b = candidate == null ? void 0 : candidate.op) == null ? void 0 : _b.toString().startsWith("!"))) {
      return true;
    }
    return false;
  });
  return conflict;
}

"use strict";
const binaryScalarDefs = [
  {
    id: PromOperationId.Addition,
    name: "Add scalar",
    sign: "+"
  },
  {
    id: PromOperationId.Subtraction,
    name: "Subtract scalar",
    sign: "-"
  },
  {
    id: PromOperationId.MultiplyBy,
    name: "Multiply by scalar",
    sign: "*"
  },
  {
    id: PromOperationId.DivideBy,
    name: "Divide by scalar",
    sign: "/"
  },
  {
    id: PromOperationId.Modulo,
    name: "Modulo by scalar",
    sign: "%"
  },
  {
    id: PromOperationId.Exponent,
    name: "Exponent",
    sign: "^"
  },
  {
    id: PromOperationId.EqualTo,
    name: "Equal to",
    sign: "==",
    comparison: true
  },
  {
    id: PromOperationId.NotEqualTo,
    name: "Not equal to",
    sign: "!=",
    comparison: true
  },
  {
    id: PromOperationId.GreaterThan,
    name: "Greater than",
    sign: ">",
    comparison: true
  },
  {
    id: PromOperationId.LessThan,
    name: "Less than",
    sign: "<",
    comparison: true
  },
  {
    id: PromOperationId.GreaterOrEqual,
    name: "Greater or equal to",
    sign: ">=",
    comparison: true
  },
  {
    id: PromOperationId.LessOrEqual,
    name: "Less or equal to",
    sign: "<=",
    comparison: true
  }
];
const binaryScalarOperatorToOperatorName = binaryScalarDefs.reduce((acc, def) => {
  acc[def.sign] = {
    id: def.id,
    comparison: def.comparison
  };
  return acc;
}, {});
const binaryScalarOperations = binaryScalarDefs.map((opDef) => {
  const params = [{ name: "Value", type: "number" }];
  let defaultParams = [2];
  if (opDef.comparison) {
    params.push({
      name: "Bool",
      type: "boolean",
      description: "If checked comparison will return 0 or 1 for the value rather than filtering."
    });
    defaultParams = [2, false];
  }
  return {
    id: opDef.id,
    name: opDef.name,
    params,
    defaultParams,
    alternativesKey: "binary scalar operations",
    category: PromVisualQueryOperationCategory.BinaryOps,
    renderer: getSimpleBinaryRenderer(opDef.sign),
    addOperationHandler: defaultAddOperationHandler
  };
});
function getSimpleBinaryRenderer(operator) {
  return function binaryRenderer(model, def, innerExpr) {
    let param = model.params[0];
    let bool = "";
    if (model.params.length === 2) {
      bool = model.params[1] ? " bool" : "";
    }
    return `${innerExpr} ${operator}${bool} ${param}`;
  };
}

"use strict";
function getOperationDefinitions() {
  const list = [
    {
      id: PromOperationId.HistogramQuantile,
      name: "Histogram quantile",
      params: [{ name: "Quantile", type: "number", options: [0.99, 0.95, 0.9, 0.75, 0.5, 0.25] }],
      defaultParams: [0.9],
      category: PromVisualQueryOperationCategory.Functions,
      renderer: functionRendererLeft,
      addOperationHandler: defaultAddOperationHandler
    },
    createFunction({ id: PromOperationId.HistogramAvg }),
    createFunction({ id: PromOperationId.HistogramCount }),
    createFunction({ id: PromOperationId.HistogramSum }),
    {
      id: PromOperationId.HistogramFraction,
      name: "Histogram fraction",
      params: [
        { name: "Lower scalar", type: "number" },
        { name: "Upper scalar", type: "number" }
      ],
      defaultParams: [0, 0.2],
      category: PromVisualQueryOperationCategory.Functions,
      renderer: functionRendererLeft,
      addOperationHandler: defaultAddOperationHandler
    },
    createFunction({ id: PromOperationId.HistogramStddev }),
    createFunction({ id: PromOperationId.HistogramStdvar }),
    {
      id: PromOperationId.LabelReplace,
      name: "Label replace",
      params: [
        { name: "Destination label", type: "string" },
        { name: "Replacement", type: "string" },
        { name: "Source label", type: "string" },
        { name: "Regex", type: "string" }
      ],
      category: PromVisualQueryOperationCategory.Functions,
      defaultParams: ["", "$1", "", "(.*)"],
      renderer: functionRendererRight,
      addOperationHandler: defaultAddOperationHandler
    },
    {
      id: PromOperationId.Ln,
      name: "Ln",
      params: [],
      defaultParams: [],
      category: PromVisualQueryOperationCategory.Functions,
      renderer: functionRendererLeft,
      addOperationHandler: defaultAddOperationHandler
    },
    createRangeFunction(PromOperationId.Changes),
    createRangeFunction(PromOperationId.Rate, true),
    createRangeFunction(PromOperationId.Irate),
    createRangeFunction(PromOperationId.Increase, true),
    createRangeFunction(PromOperationId.Idelta),
    createRangeFunction(PromOperationId.Delta),
    createFunction({
      id: PromOperationId.DoubleExponentialSmoothing,
      params: [
        getRangeVectorParamDef(),
        { name: "Smoothing Factor", type: "number" },
        { name: "Trend Factor", type: "number" }
      ],
      defaultParams: ["$__interval", 0.5, 0.5],
      alternativesKey: "range function",
      category: PromVisualQueryOperationCategory.RangeFunctions,
      renderer: rangeRendererRightWithParams,
      addOperationHandler: addOperationWithRangeVector,
      changeTypeHandler: operationTypeChangedHandlerForRangeFunction
    }),
    createFunction({
      id: PromOperationId.HoltWinters,
      params: [
        getRangeVectorParamDef(),
        { name: "Smoothing Factor", type: "number" },
        { name: "Trend Factor", type: "number" }
      ],
      defaultParams: ["$__interval", 0.5, 0.5],
      alternativesKey: "range function",
      category: PromVisualQueryOperationCategory.RangeFunctions,
      renderer: rangeRendererRightWithParams,
      addOperationHandler: addOperationWithRangeVector,
      changeTypeHandler: operationTypeChangedHandlerForRangeFunction
    }),
    createFunction({
      id: PromOperationId.PredictLinear,
      params: [getRangeVectorParamDef(), { name: "Seconds from now", type: "number" }],
      defaultParams: ["$__interval", 60],
      alternativesKey: "range function",
      category: PromVisualQueryOperationCategory.RangeFunctions,
      renderer: rangeRendererRightWithParams,
      addOperationHandler: addOperationWithRangeVector,
      changeTypeHandler: operationTypeChangedHandlerForRangeFunction
    }),
    createFunction({
      id: PromOperationId.QuantileOverTime,
      params: [getRangeVectorParamDef(), { name: "Quantile", type: "number" }],
      defaultParams: ["$__interval", 0.5],
      alternativesKey: "overtime function",
      category: PromVisualQueryOperationCategory.RangeFunctions,
      renderer: rangeRendererLeftWithParams,
      addOperationHandler: addOperationWithRangeVector,
      changeTypeHandler: operationTypeChangedHandlerForRangeFunction
    }),
    ...binaryScalarOperations,
    {
      id: PromOperationId.NestedQuery,
      name: "Binary operation with query",
      params: [],
      defaultParams: [],
      category: PromVisualQueryOperationCategory.BinaryOps,
      renderer: (model, def, innerExpr) => innerExpr,
      addOperationHandler: addNestedQueryHandler
    },
    createFunction({ id: PromOperationId.Abs }),
    createFunction({ id: PromOperationId.Absent }),
    createFunction({
      id: PromOperationId.Acos,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({
      id: PromOperationId.Acosh,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({
      id: PromOperationId.Asin,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({
      id: PromOperationId.Asinh,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({
      id: PromOperationId.Atan,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({
      id: PromOperationId.Atanh,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({ id: PromOperationId.Ceil }),
    createFunction({
      id: PromOperationId.Clamp,
      name: "Clamp",
      params: [
        { name: "Minimum Scalar", type: "number" },
        { name: "Maximum Scalar", type: "number" }
      ],
      defaultParams: [1, 1]
    }),
    createFunction({
      id: PromOperationId.ClampMax,
      params: [{ name: "Maximum Scalar", type: "number" }],
      defaultParams: [1]
    }),
    createFunction({
      id: PromOperationId.ClampMin,
      params: [{ name: "Minimum Scalar", type: "number" }],
      defaultParams: [1]
    }),
    createFunction({
      id: PromOperationId.Cos,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({
      id: PromOperationId.Cosh,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({
      id: PromOperationId.DayOfMonth,
      category: PromVisualQueryOperationCategory.Time
    }),
    createFunction({
      id: PromOperationId.DayOfWeek,
      category: PromVisualQueryOperationCategory.Time
    }),
    createFunction({
      id: PromOperationId.DayOfYear,
      category: PromVisualQueryOperationCategory.Time
    }),
    createFunction({
      id: PromOperationId.DaysInMonth,
      category: PromVisualQueryOperationCategory.Time
    }),
    createFunction({ id: PromOperationId.Deg }),
    createRangeFunction(PromOperationId.Deriv),
    //
    createFunction({ id: PromOperationId.Exp }),
    createFunction({ id: PromOperationId.Floor }),
    createFunction({ id: PromOperationId.Hour }),
    createFunction({
      id: PromOperationId.LabelJoin,
      params: [
        {
          name: "Destination Label",
          type: "string"
        },
        {
          name: "Separator",
          type: "string"
        },
        {
          name: "Source Label",
          type: "string",
          restParam: true,
          optional: true
        }
      ],
      defaultParams: ["", ",", ""],
      renderer: labelJoinRenderer,
      explainHandler: labelJoinExplainHandler,
      addOperationHandler: labelJoinAddOperationHandler
    }),
    createFunction({ id: PromOperationId.Log10 }),
    createFunction({ id: PromOperationId.Log2 }),
    createFunction({ id: PromOperationId.Minute }),
    createFunction({ id: PromOperationId.Month }),
    createFunction({
      id: PromOperationId.Pi,
      renderer: (model) => `${model.id}()`
    }),
    createFunction({ id: PromOperationId.Rad }),
    createRangeFunction(PromOperationId.Resets),
    createFunction({
      id: PromOperationId.Round,
      category: PromVisualQueryOperationCategory.Functions,
      params: [{ name: "To Nearest", type: "number" }],
      defaultParams: [1]
    }),
    createFunction({ id: PromOperationId.Scalar }),
    createFunction({ id: PromOperationId.Sgn }),
    createFunction({ id: PromOperationId.Sin, category: PromVisualQueryOperationCategory.Trigonometric }),
    createFunction({
      id: PromOperationId.Sinh,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({ id: PromOperationId.Sort }),
    createFunction({ id: PromOperationId.SortDesc }),
    createFunction({ id: PromOperationId.Sqrt }),
    createFunction({ id: PromOperationId.Stddev }),
    createFunction({
      id: PromOperationId.Tan,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({
      id: PromOperationId.Tanh,
      category: PromVisualQueryOperationCategory.Trigonometric
    }),
    createFunction({
      id: PromOperationId.Time,
      renderer: (model) => `${model.id}()`
    }),
    createFunction({ id: PromOperationId.Timestamp }),
    createFunction({
      id: PromOperationId.Vector,
      params: [{ name: "Value", type: "number" }],
      defaultParams: [1],
      renderer: (model) => `${model.id}(${model.params[0]})`
    }),
    createFunction({ id: PromOperationId.Year })
  ];
  return list;
}
function createFunction(definition) {
  var _a, _b, _c, _d, _e, _f;
  return {
    ...definition,
    id: definition.id,
    name: (_a = definition.name) != null ? _a : getPromOperationDisplayName(definition.id),
    params: (_b = definition.params) != null ? _b : [],
    defaultParams: (_c = definition.defaultParams) != null ? _c : [],
    category: (_d = definition.category) != null ? _d : PromVisualQueryOperationCategory.Functions,
    renderer: (_e = definition.renderer) != null ? _e : definition.params ? functionRendererRight : functionRendererLeft,
    addOperationHandler: (_f = definition.addOperationHandler) != null ? _f : defaultAddOperationHandler
  };
}
function createRangeFunction(name, withRateInterval = false) {
  return {
    id: name,
    name: getPromOperationDisplayName(name),
    params: [getRangeVectorParamDef(withRateInterval)],
    defaultParams: [withRateInterval ? "$__rate_interval" : "$__interval"],
    alternativesKey: "range function",
    category: PromVisualQueryOperationCategory.RangeFunctions,
    renderer: operationWithRangeVectorRenderer$1,
    addOperationHandler: addOperationWithRangeVector,
    changeTypeHandler: operationTypeChangedHandlerForRangeFunction
  };
}
function operationTypeChangedHandlerForRangeFunction(operation, newDef) {
  if (operation.params[0] === "$__rate_interval" && newDef.defaultParams[0] !== "$__rate_interval") {
    operation.params = newDef.defaultParams;
  } else if (operation.params[0] === "$__interval" && newDef.defaultParams[0] !== "$__interval") {
    operation.params = newDef.defaultParams;
  }
  return operation;
}
function operationWithRangeVectorRenderer$1(model, def, innerExpr) {
  var _a, _b;
  let rangeVector = (_b = ((_a = model.params) != null ? _a : [])[0]) != null ? _b : "5m";
  return `${def.id}(${innerExpr}[${rangeVector}])`;
}
function addOperationWithRangeVector(def, query, modeller) {
  const newOperation = {
    id: def.id,
    params: def.defaultParams
  };
  if (query.operations.length > 0) {
    const firstOp = modeller.getOperationDef(query.operations[0].id);
    if (firstOp.addOperationHandler === addOperationWithRangeVector) {
      return {
        ...query,
        operations: [newOperation, ...query.operations.slice(1)]
      };
    }
  }
  return {
    ...query,
    operations: [newOperation, ...query.operations]
  };
}
function addNestedQueryHandler(def, query) {
  var _a;
  return {
    ...query,
    binaryQueries: [
      ...(_a = query.binaryQueries) != null ? _a : [],
      {
        operator: "/",
        query
      }
    ]
  };
}
function labelJoinRenderer(model, def, innerExpr) {
  var _a, _b;
  const paramZero = (_a = model.params[0]) != null ? _a : "";
  const paramOne = (_b = model.params[1]) != null ? _b : "";
  const separator = `"${paramOne}"`;
  return `${model.id}(${innerExpr}, "${paramZero}", ${separator}, "${model.params.slice(2).join(separator)}")`;
}
function labelJoinExplainHandler(op, def) {
  var _a;
  let explainMessage = (_a = def == null ? void 0 : def.documentation) != null ? _a : "no docs";
  if (typeof op.params[1] !== "string") {
    explainMessage += " \u{1F6A8}\u{1F6A8}\u{1F6A8} The `separator` must be a string.";
  }
  return explainMessage;
}
function labelJoinAddOperationHandler(def, query) {
  const newOperation = {
    id: def.id,
    params: def.defaultParams
  };
  return {
    ...query,
    operations: [...query.operations, newOperation]
  };
}

"use strict";
function getAggregationOperations() {
  return [
    ...createAggregationOperation(PromOperationId.Sum),
    ...createAggregationOperation(PromOperationId.Avg),
    ...createAggregationOperation(PromOperationId.Min),
    ...createAggregationOperation(PromOperationId.Max),
    ...createAggregationOperation(PromOperationId.Count),
    ...createAggregationOperation(PromOperationId.Group),
    ...createAggregationOperationWithParam(PromOperationId.TopK, {
      params: [{ name: "K-value", type: "number" }],
      defaultParams: [5]
    }),
    ...createAggregationOperationWithParam(PromOperationId.BottomK, {
      params: [{ name: "K-value", type: "number" }],
      defaultParams: [5]
    }),
    ...createAggregationOperationWithParam(PromOperationId.CountValues, {
      params: [{ name: "Identifier", type: "string" }],
      defaultParams: ["count"]
    }),
    ...createAggregationOperationWithParam(PromOperationId.Quantile, {
      params: [{ name: "Value", type: "number" }],
      defaultParams: [1]
    }),
    createAggregationOverTime(PromOperationId.SumOverTime),
    createAggregationOverTime(PromOperationId.AvgOverTime),
    createAggregationOverTime(PromOperationId.MinOverTime),
    createAggregationOverTime(PromOperationId.MaxOverTime),
    createAggregationOverTime(PromOperationId.CountOverTime),
    createAggregationOverTime(PromOperationId.LastOverTime),
    createAggregationOverTime(PromOperationId.PresentOverTime),
    createAggregationOverTime(PromOperationId.AbsentOverTime),
    createAggregationOverTime(PromOperationId.StddevOverTime)
  ];
}
function createAggregationOverTime(name) {
  return {
    id: name,
    name: getPromOperationDisplayName(name),
    params: [getRangeVectorParamDef()],
    defaultParams: ["$__interval"],
    alternativesKey: "overtime function",
    category: PromVisualQueryOperationCategory.RangeFunctions,
    renderer: operationWithRangeVectorRenderer,
    addOperationHandler: addOperationWithRangeVector
  };
}
function operationWithRangeVectorRenderer(model, def, innerExpr) {
  var _a, _b;
  let rangeVector = (_b = ((_a = model.params) != null ? _a : [])[0]) != null ? _b : "$__interval";
  return `${def.id}(${innerExpr}[${rangeVector}])`;
}

"use strict";
function prometheusRegularEscape(value) {
  if (typeof value !== "string") {
    return value;
  }
  if (runtime.config.featureToggles.prometheusSpecialCharsInLabelValues) {
    if (/^\w+(=|!=|=~|!~)".*"$/.test(value)) {
      return value;
    }
    return value.replace(/\\/g, "\\\\").replace(/"/g, '\\"');
  }
  return value.replace(/\\/g, "\\\\").replace(/'/g, "\\\\'");
}
function prometheusSpecialRegexEscape(value) {
  if (typeof value !== "string") {
    return value;
  }
  if (runtime.config.featureToggles.prometheusSpecialCharsInLabelValues) {
    return value.replace(/\\/g, "\\\\\\\\").replace(/"/g, '\\\\\\"').replace(/[$^*{}\[\]\'+?.()|]/g, "\\\\$&");
  }
  return value.replace(/\\/g, "\\\\\\\\").replace(/[$^*{}\[\]+?.()|]/g, "\\\\$&");
}
const RE2_METACHARACTERS = /[*+?()|\\.\[\]{}^$]/g;
function escapePrometheusRegexp(value) {
  return value.replace(RE2_METACHARACTERS, "\\$&");
}
function escapeLabelValueInExactSelector(labelValue) {
  return labelValue.replace(/\\/g, "\\\\").replace(/\n/g, "\\n").replace(/"/g, '\\"');
}
function escapeLabelValueInRegexSelector(labelValue) {
  return escapeLabelValueInExactSelector(escapePrometheusRegexp(labelValue));
}

"use strict";
const utf8Support = (value) => {
  if (value === "") {
    return value;
  }
  const isLegacyLabel = isValidLegacyName(value);
  if (isLegacyLabel) {
    return value;
  }
  return `"${value}"`;
};
const escapeForUtf8Support = (value) => {
  const isLegacyLabel = isValidLegacyName(value);
  if (isLegacyLabel) {
    return value;
  }
  let escaped = "U__";
  for (let i = 0; i < value.length; i++) {
    const char = value[i];
    const codePoint = value.codePointAt(i);
    if (char === "_") {
      escaped += "__";
    } else if (codePoint !== void 0 && isValidLegacyRune(char, i)) {
      escaped += char;
    } else if (codePoint === void 0 || !isValidCodePoint(codePoint)) {
      escaped += "_FFFD_";
    } else {
      escaped += "_";
      escaped += codePoint.toString(16);
      escaped += "_";
    }
    if (codePoint !== void 0 && codePoint > 65535) {
      i++;
    }
  }
  return escaped;
};
const isValidLegacyName = (name) => {
  if (name.length === 0) {
    return false;
  }
  for (let i = 0; i < name.length; i++) {
    const char = name[i];
    if (!isValidLegacyRune(char, i)) {
      return false;
    }
  }
  return true;
};
const isValidLegacyRune = (char, index) => {
  const codePoint = char.codePointAt(0);
  if (codePoint === void 0) {
    return false;
  }
  return codePoint >= 97 && codePoint <= 122 || // 'a' to 'z'
  codePoint >= 65 && codePoint <= 90 || // 'A' to 'Z'
  codePoint === 95 || // '_'
  codePoint === 58 || // ':'
  codePoint >= 48 && codePoint <= 57 && index > 0;
};
const isValidCodePoint = (codePoint) => {
  return codePoint >= 0 && codePoint <= 1114111;
};
const wrapUtf8Filters = (filterStr) => {
  const resultArray = [];
  const operatorRegex = /(=~|!=|!~|=)/;
  let currentKey = "";
  let currentValue = "";
  let inQuotes = false;
  let temp = "";
  const addResult = () => {
    const operatorMatch = temp.match(operatorRegex);
    if (operatorMatch) {
      const operator = operatorMatch[0];
      [currentKey, currentValue] = temp.split(operator);
      resultArray.push(`${utf8Support(currentKey.trim())}${operator}"${currentValue.slice(1, -1)}"`);
    }
  };
  for (const char of filterStr) {
    if (char === '"' && temp[temp.length - 1] !== "\\") {
      inQuotes = !inQuotes;
      temp += char;
    } else if (char === "," && !inQuotes) {
      addResult();
      temp = "";
    } else {
      temp += char;
    }
  }
  if (temp) {
    addResult();
  }
  return resultArray.join(",");
};

"use strict";
function renderLabels(labels) {
  if (labels.length === 0) {
    return "";
  }
  let expr = "{";
  for (const filter of labels) {
    if (expr !== "{") {
      expr += ", ";
    }
    let labelValue = filter.value;
    const usingRegexOperator = filter.op === "=~" || filter.op === "!~";
    if (runtime.config.featureToggles.prometheusSpecialCharsInLabelValues && !usingRegexOperator) {
      labelValue = prometheusRegularEscape(labelValue);
    }
    expr += `${utf8Support(filter.label)}${filter.op}"${labelValue}"`;
  }
  return expr + `}`;
}
function renderLabelsWithoutBrackets(labels) {
  if (labels.length === 0) {
    return [];
  }
  const renderedLabels = [];
  for (const filter of labels) {
    let labelValue = filter.value;
    const usingRegexOperator = filter.op === "=~" || filter.op === "!~";
    if (runtime.config.featureToggles.prometheusSpecialCharsInLabelValues && !usingRegexOperator) {
      labelValue = prometheusRegularEscape(labelValue);
    }
    renderedLabels.push(`${utf8Support(filter.label)}${filter.op}"${labelValue}"`);
  }
  return renderedLabels;
}

"use strict";
function renderOperations(queryString, operations, operationsRegistry) {
  for (const operation of operations) {
    const def = operationsRegistry.get(operation.id);
    if (!def) {
      throw new Error(`Could not find operation ${operation.id} in the registry`);
    }
    queryString = def.renderer(operation, def, queryString);
  }
  return queryString;
}
function hasBinaryOp(query, operationsRegistry) {
  return query.operations.find((op) => {
    const def = operationsRegistry.get(op.id);
    return (def == null ? void 0 : def.category) === PromVisualQueryOperationCategory.BinaryOps;
  }) !== void 0;
}

"use strict";
function renderBinaryQueries(queryString, binaryQueries) {
  if (binaryQueries) {
    for (const binQuery of binaryQueries) {
      queryString = `${renderBinaryQuery(queryString, binQuery)}`;
    }
  }
  return queryString;
}
function renderBinaryQuery(leftOperand, binaryQuery) {
  let result = leftOperand + ` ${binaryQuery.operator} `;
  if (binaryQuery.vectorMatches) {
    result += `${binaryQuery.vectorMatchesType}(${binaryQuery.vectorMatches}) `;
  }
  return result + renderQuery(binaryQuery.query, true);
}
function renderQuery(query, nested, operationsRegistry) {
  var _a;
  if (!query.metric && query.labels.length === 0 && query.operations.length === 0) {
    return "";
  }
  let queryString = "";
  const labels = renderLabels(query.labels);
  if (query.metric) {
    if (isValidLegacyName(query.metric)) {
      queryString = `${query.metric}${labels}`;
    } else {
      queryString = `{"${query.metric}"${labels.length > 0 ? `, ${labels.substring(1)}` : `}`}`;
    }
  } else if (query.labels.length > 0) {
    queryString = labels;
  } else if (query.operations.length > 0) {
    queryString = "";
  }
  if (query.operations.length > 0) {
    if (operationsRegistry) {
      queryString = renderOperations(queryString, query.operations, operationsRegistry);
    } else {
      for (const operation of query.operations) {
        if (operation.id === "MultiplyBy" && operation.params && operation.params.length > 0) {
          queryString = `${queryString} * ${operation.params[0]}`;
        }
      }
    }
  }
  const hasNesting = Boolean((_a = query.binaryQueries) == null ? void 0 : _a.length);
  const hasBinaryOperation = operationsRegistry ? hasBinaryOp(query, operationsRegistry) : false;
  if (!nested && hasBinaryOperation && hasNesting) {
    queryString = `(${queryString})`;
  }
  if (hasNesting) {
    for (const binQuery of query.binaryQueries) {
      const rightOperand = renderNestedPart(binQuery.query, operationsRegistry);
      let vectorMatchingStr = "";
      if (binQuery.vectorMatches) {
        vectorMatchingStr = `${binQuery.vectorMatchesType}(${binQuery.vectorMatches}) `;
      }
      queryString = `${queryString} ${binQuery.operator} ${vectorMatchingStr}${rightOperand}`;
    }
  }
  if (nested && (hasBinaryOperation || hasNesting)) {
    queryString = `(${queryString})`;
  }
  return queryString;
}
function renderNestedPart(query, operationsRegistry) {
  var _a;
  const renderedQuery = renderQuery(query, false, operationsRegistry);
  const hasOps = query.operations.length > 0;
  const hasNestedBinary = Boolean((_a = query.binaryQueries) == null ? void 0 : _a.length);
  if (hasOps && !hasNestedBinary && !query.metric && (!query.labels || query.labels.length === 0)) {
    return renderedQuery;
  }
  if (hasOps || hasNestedBinary) {
    return `(${renderedQuery})`;
  }
  return renderedQuery;
}

"use strict";
class LokiAndPromQueryModellerBase {
  constructor(getOperations) {
    this.categories = [];
    this.operationsMapCache = null;
    this.operationsRegistry = new data.Registry(getOperations);
  }
  getOperationsMap() {
    if (!this.operationsMapCache) {
      this.operationsMapCache = /* @__PURE__ */ new Map();
      this.operationsRegistry.list().forEach((op) => {
        this.operationsMapCache.set(op.id, op);
      });
    }
    return this.operationsMapCache;
  }
  setOperationCategories(categories) {
    this.categories = categories;
  }
  getOperationsForCategory(category) {
    return this.operationsRegistry.list().filter((op) => op.category === category && !op.hideFromList);
  }
  getAlternativeOperations(key) {
    return this.operationsRegistry.list().filter((op) => op.alternativesKey && op.alternativesKey === key);
  }
  getCategories() {
    return this.categories;
  }
  getOperationDef(id) {
    return this.operationsRegistry.getIfExists(id);
  }
  renderOperations(queryString, operations) {
    return renderOperations(queryString, operations, this.getOperationsMap());
  }
  renderBinaryQueries(queryString, binaryQueries) {
    return renderBinaryQueries(queryString, binaryQueries);
  }
  renderLabels(labels) {
    return renderLabels(labels);
  }
  renderQuery(query, nested) {
    return renderQuery(query, nested, this.getOperationsMap());
  }
  hasBinaryOp(query) {
    return hasBinaryOp(query, this.getOperationsMap());
  }
}

"use strict";
class PromQueryModeller extends LokiAndPromQueryModellerBase {
  constructor() {
    super(() => {
      const allOperations = [...getOperationDefinitions(), ...getAggregationOperations()];
      for (const op of allOperations) {
        const func = FUNCTIONS.find((x) => x.insertText === op.id);
        if (func) {
          op.documentation = func.documentation;
        }
      }
      return allOperations;
    });
    this.setOperationCategories([
      PromVisualQueryOperationCategory.Aggregations,
      PromVisualQueryOperationCategory.RangeFunctions,
      PromVisualQueryOperationCategory.Functions,
      PromVisualQueryOperationCategory.BinaryOps,
      PromVisualQueryOperationCategory.Trigonometric,
      PromVisualQueryOperationCategory.Time
    ]);
  }
  getQueryPatterns() {
    return [
      {
        name: "Rate then sum",
        type: PromQueryPatternType.Rate,
        operations: [
          { id: "rate", params: ["$__rate_interval"] },
          { id: "sum", params: [] }
        ]
      },
      {
        name: "Rate then sum by(label) then avg",
        type: PromQueryPatternType.Rate,
        operations: [
          { id: "rate", params: ["$__rate_interval"] },
          { id: "__sum_by", params: [""] },
          { id: "avg", params: [] }
        ]
      },
      {
        name: "Histogram quantile on rate",
        type: PromQueryPatternType.Histogram,
        operations: [
          { id: "rate", params: ["$__rate_interval"] },
          { id: "__sum_by", params: ["le"] },
          { id: "histogram_quantile", params: [0.95] }
        ]
      },
      {
        name: "Histogram quantile on increase",
        type: PromQueryPatternType.Histogram,
        operations: [
          { id: "increase", params: ["$__rate_interval"] },
          { id: "__max_by", params: ["le"] },
          { id: "histogram_quantile", params: [0.95] }
        ]
      },
      {
        name: "Binary Query",
        type: PromQueryPatternType.Binary,
        operations: [
          { id: "rate", params: ["$__rate_interval"] },
          { id: "sum", params: [] }
        ],
        binaryQueries: [
          {
            operator: "/",
            query: {
              metric: "",
              labels: [],
              operations: [
                { id: "rate", params: ["$__rate_interval"] },
                { id: "sum", params: [] }
              ]
            }
          }
        ]
      }
    ];
  }
}

"use strict";
const promQueryModeller = new PromQueryModeller();

"use strict";
const QueryPattern = (props) => {
  const { pattern, onPatternSelect, hasNewQueryOption, hasPreviousQuery, selectedPatternName, setSelectedPatternName } = props;
  const styles = ui.useStyles2(getStyles$l);
  const lang = { grammar: promqlGrammar, name: "promql" };
  return /* @__PURE__ */ jsxRuntime.jsxs(ui.Card, { className: styles.card, children: [
    /* @__PURE__ */ jsxRuntime.jsx(ui.Card.Heading, { children: pattern.name }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.rawQueryContainer, children: /* @__PURE__ */ jsxRuntime.jsx(
      RawQuery,
      {
        "aria-label": i18n.t(
          "grafana-prometheus.querybuilder.query-pattern.aria-label-raw-query",
          "{{patternName}} raw query",
          {
            patternName: pattern.name
          }
        ),
        query: promQueryModeller.renderQuery({
          metric: "",
          labels: [],
          operations: pattern.operations,
          binaryQueries: pattern.binaryQueries
        }),
        lang,
        className: styles.rawQuery
      }
    ) }),
    /* @__PURE__ */ jsxRuntime.jsx(ui.Card.Actions, { children: selectedPatternName !== pattern.name ? /* @__PURE__ */ jsxRuntime.jsx(
      ui.Button,
      {
        size: "sm",
        "aria-label": i18n.t(
          "grafana-prometheus.querybuilder.query-pattern.aria-label-use-this-query-button",
          "use this query button"
        ),
        onClick: () => {
          if (hasPreviousQuery) {
            setSelectedPatternName(pattern.name);
          } else {
            onPatternSelect(pattern);
          }
        },
        children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.query-pattern.use-this-query", children: "Use this query" })
      }
    ) : /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.spacing, children: `If you would like to use this query, ${hasNewQueryOption ? "you can either apply this query pattern or create a new query" : "this query pattern will be applied to your current query"}.` }),
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          size: "sm",
          "aria-label": i18n.t("grafana-prometheus.querybuilder.query-pattern.aria-label-back-button", "back button"),
          fill: "outline",
          onClick: () => setSelectedPatternName(null),
          children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.query-pattern.back", children: "Back" })
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          size: "sm",
          "aria-label": i18n.t(
            "grafana-prometheus.querybuilder.query-pattern.aria-label-apply-query-starter-button",
            "apply query starter button"
          ),
          onClick: () => {
            onPatternSelect(pattern);
          },
          children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.query-pattern.apply-query", children: "Apply query" })
        }
      ),
      hasNewQueryOption && /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          size: "sm",
          "aria-label": i18n.t(
            "grafana-prometheus.querybuilder.query-pattern.aria-label-create-new-query-button",
            "create new query button"
          ),
          onClick: () => {
            onPatternSelect(pattern, true);
          },
          children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.query-pattern.create-new-query", children: "Create new query" })
        }
      )
    ] }) })
  ] });
};
const getStyles$l = (theme) => {
  return {
    card: css.css({
      width: "49.5%",
      display: "flex",
      flexDirection: "column"
    }),
    rawQueryContainer: css.css({
      flexGrow: 1
    }),
    rawQuery: css.css({
      backgroundColor: theme.colors.background.primary,
      padding: theme.spacing(1),
      marginTop: theme.spacing(1)
    }),
    spacing: css.css({
      marginBottom: theme.spacing(1)
    })
  };
};

"use strict";
const ErrorId$1 = 0;
function getLeftMostChild(cur) {
  return cur.firstChild ? getLeftMostChild(cur.firstChild) : cur;
}
function makeError(expr, node) {
  var _a;
  return {
    text: getString(expr, node),
    // TODO: this are positions in the string with the replaced variables. Means it cannot be used to show exact
    //  placement of the error for the user. We need some translation table to positions before the variable
    //  replace.
    from: node.from,
    to: node.to,
    parentType: (_a = node.parent) == null ? void 0 : _a.name
  };
}
const variableRegex = /\$(\w+)|\[\[([\s\S]+?)(?::(\w+))?\]\]|\${(\w+)(?:\.([^:^\}]+))?(?::([^\}]+))?}/g;
function replaceVariables(expr) {
  const replacedVariables = {};
  const replacedExpr = expr.replace(variableRegex, (match, var1, var2, fmt2, var3, fieldPath, fmt3) => {
    const fmt = fmt2 || fmt3;
    let variable = var1;
    let varType = "0";
    if (var2) {
      variable = var2;
      varType = "1";
    }
    if (var3) {
      variable = var3;
      varType = "2";
    }
    const replacement = `__V_${varType}__` + variable + "__V__" + (fmt ? "__F__" + fmt + "__F__" : "");
    replacedVariables[replacement] = match;
    return replacement;
  });
  return { replacedExpr, replacedVariables };
}
const varTypeFunc = [
  (v, f) => `$${v}`,
  (v, f) => `[[${v}${f ? `:${f}` : ""}]]`,
  (v, f) => `\${${v}${f ? `:${f}` : ""}}`
];
function returnVariables(expr) {
  return expr.replace(/__V_(\d)__(.+?)__V__(?:__F__(\w+)__F__)?/g, (match, type, v, f) => {
    return varTypeFunc[parseInt(type, 10)](v, f);
  });
}
function getString(expr, node) {
  if (!node) {
    return "";
  }
  return returnVariables(expr.substring(node.from, node.to));
}
function makeBinOp(opDef, expr, numberNode, hasBool) {
  const params = [parseFloat(getString(expr, numberNode))];
  if (opDef.comparison) {
    params.push(hasBool);
  }
  return {
    id: opDef.id,
    params
  };
}
function getAllByType(expr, cur, type) {
  if (cur.type.id === type) {
    return [getString(expr, cur)];
  }
  const values = [];
  let pos = 0;
  let child = cur.childAfter(pos);
  while (child) {
    values.push(...getAllByType(expr, child, type));
    pos = child.to;
    child = cur.childAfter(pos);
  }
  return values;
}
const regexifyLabelValuesQueryString = (query) => {
  const queryArray = query.split(" ");
  return queryArray.map((query2) => `${query2}.*`).join("");
};
const BUILT_IN_VARIABLES = [
  { variable: "$__interval_ms", replacement: "79_999_999_999" },
  { variable: "$__interval", replacement: "711_999_999" },
  { variable: "$__rate_interval", replacement: "7999799979997999" },
  { variable: "$__range_ms", replacement: "722_999_999" },
  { variable: "$__range_s", replacement: "79_299_999" },
  { variable: "$__range", replacement: "799_999" }
];
const variableToReplacement = BUILT_IN_VARIABLES.reduce((map, { variable, replacement }) => {
  map[variable] = replacement;
  return map;
}, {});
const replacementToVariable = BUILT_IN_VARIABLES.reduce((map, { variable, replacement }) => {
  map[replacement] = variable;
  return map;
}, {});
const builtInVariablePattern = BUILT_IN_VARIABLES.map(({ variable }) => variable.replace(/\$/g, "\\$")).join("|");
const builtInVariableRegex = new RegExp(builtInVariablePattern, "g");
const builtInReplacementPattern = BUILT_IN_VARIABLES.map(({ replacement }) => replacement).join("|");
const builtInReplacementRegex = new RegExp(builtInReplacementPattern, "g");
function replaceBuiltInVariable(expr) {
  return expr.replace(builtInVariableRegex, (match) => variableToReplacement[match]);
}
function returnBuiltInVariable(expr) {
  return expr.replace(builtInReplacementRegex, (match) => replacementToVariable[match]);
}

"use strict";
function buildVisualQueryFromString(expr) {
  expr = replaceBuiltInVariable(expr);
  const { replacedExpr, replacedVariables } = replaceVariables(expr);
  const tree = lezerPromql.parser.parse(replacedExpr);
  const node = tree.topNode;
  const visQuery = {
    metric: "",
    labels: [],
    operations: []
  };
  const context = {
    query: visQuery,
    errors: [],
    replacements: replacedVariables
  };
  try {
    handleExpression(replacedExpr, node, context);
  } catch (err) {
    console.error(err);
    if (err instanceof Error) {
      context.errors.push({
        text: err.message
      });
    }
  }
  if (isEmptyQuery(context.query)) {
    context.errors = [];
  }
  delete context.replacements;
  return context;
}
function handleExpression(expr, node, context) {
  const visQuery = context.query;
  switch (node.type.id) {
    case lezerPromql.Identifier: {
      visQuery.metric = getString(expr, node);
      break;
    }
    case lezerPromql.QuotedLabelName: {
      if (visQuery.metric === "") {
        const strLiteral = node.getChild(lezerPromql.StringLiteral);
        const quotedMetric = getString(expr, strLiteral);
        visQuery.metric = quotedMetric.slice(1, -1);
      }
      break;
    }
    case lezerPromql.QuotedLabelMatcher: {
      const quotedLabel = getLabel$1(expr, node, lezerPromql.QuotedLabelName);
      quotedLabel.label = quotedLabel.label.slice(1, -1);
      visQuery.labels.push(quotedLabel);
      const err = node.getChild(ErrorId$1);
      if (err) {
        context.errors.push(makeError(expr, err));
      }
      break;
    }
    case lezerPromql.UnquotedLabelMatcher: {
      visQuery.labels.push(getLabel$1(expr, node, lezerPromql.LabelName));
      const err = node.getChild(ErrorId$1);
      if (err) {
        context.errors.push(makeError(expr, err));
      }
      break;
    }
    case lezerPromql.FunctionCall: {
      handleFunction(expr, node, context);
      break;
    }
    case lezerPromql.AggregateExpr: {
      handleAggregation(expr, node, context);
      break;
    }
    case lezerPromql.BinaryExpr: {
      handleBinary(expr, node, context);
      break;
    }
    case ErrorId$1: {
      if (isIntervalVariableError(node)) {
        break;
      }
      context.errors.push(makeError(expr, node));
      break;
    }
    default: {
      if (node.type.id === lezerPromql.ParenExpr) {
        context.errors.push(makeError(expr, node));
      }
      let child = node.firstChild;
      while (child) {
        handleExpression(expr, child, context);
        child = child.nextSibling;
      }
    }
  }
}
function isIntervalVariableError(node) {
  var _a, _b;
  return ((_b = (_a = node.prevSibling) == null ? void 0 : _a.firstChild) == null ? void 0 : _b.type.id) === lezerPromql.VectorSelector;
}
function getLabel$1(expr, node, labelType) {
  const label = getString(expr, node.getChild(labelType));
  const op = getString(expr, node.getChild(lezerPromql.MatchOp));
  const value = getString(expr, node.getChild(lezerPromql.StringLiteral)).replace(/^["'`]|["'`]$/g, "");
  return {
    label,
    op,
    value
  };
}
const rangeFunctions = ["changes", "rate", "irate", "increase", "delta"];
function handleFunction(expr, node, context) {
  const visQuery = context.query;
  const nameNode = node.getChild(lezerPromql.FunctionIdentifier);
  const funcName = getString(expr, nameNode);
  if (funcName === "info") {
    context.errors.push({
      text: i18n.t(
        "grafana-prometheus.querybuilder.handle-function.text.query-parsing-is-ambiguous",
        "Query parsing is ambiguous."
      ),
      from: node.from,
      to: node.to
    });
  }
  const body = node.getChild(lezerPromql.FunctionCallBody);
  const params = [];
  let interval = "";
  if (rangeFunctions.includes(funcName) || funcName.endsWith("_over_time")) {
    let match = getString(expr, node).match(/\[(.+)\]/);
    if (match == null ? void 0 : match[1]) {
      interval = match[1];
      params.push(returnBuiltInVariable(match[1]));
    }
  }
  const op = { id: funcName, params };
  visQuery.operations.unshift(op);
  if (body) {
    if (getString(expr, body) === "([" + interval + "])") {
      return;
    }
    updateFunctionArgs(expr, body, context, op);
  }
}
function handleAggregation(expr, node, context) {
  const visQuery = context.query;
  const nameNode = node.getChild(lezerPromql.AggregateOp);
  let funcName = getString(expr, nameNode);
  const modifier = node.getChild(lezerPromql.AggregateModifier);
  const labels = [];
  if (modifier) {
    const byModifier = modifier.getChild(`By`);
    if (byModifier && funcName) {
      funcName = `__${funcName}_by`;
    }
    const withoutModifier = modifier.getChild(lezerPromql.Without);
    if (withoutModifier) {
      funcName = `__${funcName}_without`;
    }
    labels.push(...getAllByType(expr, modifier, lezerPromql.LabelName), ...getAllByType(expr, modifier, lezerPromql.QuotedLabelName));
  }
  const body = node.getChild(lezerPromql.FunctionCallBody);
  const op = { id: funcName, params: [] };
  visQuery.operations.unshift(op);
  updateFunctionArgs(expr, body, context, op);
  op.params.push(...labels);
}
function updateFunctionArgs(expr, node, context, op) {
  var _a;
  if (!node) {
    return;
  }
  switch (node.type.id) {
    case lezerPromql.FunctionCallBody: {
      let child = node.firstChild;
      while (child) {
        let binaryExpressionWithinFunctionArgs;
        if (child.type.id === lezerPromql.BinaryExpr) {
          binaryExpressionWithinFunctionArgs = child;
        } else {
          binaryExpressionWithinFunctionArgs = child.getChild(lezerPromql.BinaryExpr);
        }
        if (binaryExpressionWithinFunctionArgs) {
          context.errors.push({
            text: i18n.t(
              "grafana-prometheus.querybuilder.update-function-args.text.query-parsing-is-ambiguous",
              "Query parsing is ambiguous."
            ),
            from: binaryExpressionWithinFunctionArgs.from,
            to: binaryExpressionWithinFunctionArgs.to
          });
        }
        updateFunctionArgs(expr, child, context, op);
        child = child.nextSibling;
      }
      break;
    }
    case lezerPromql.NumberDurationLiteral: {
      op.params.push(parseFloat(getString(expr, node)));
      break;
    }
    case lezerPromql.StringLiteral: {
      op.params.push(getString(expr, node).replace(/"/g, ""));
      break;
    }
    case lezerPromql.VectorSelector: {
      if ((_a = context.replacements) == null ? void 0 : _a[expr.substring(node.from, node.to)]) {
        const identifierNode = node.getChild(lezerPromql.Identifier);
        const customVarName = getString(expr, identifierNode);
        op.params.push(customVarName);
        break;
      }
    }
    default: {
      handleExpression(expr, node, context);
    }
  }
}
function handleBinary(expr, node, context) {
  var _a;
  const visQuery = context.query;
  const left = node.firstChild;
  const op = getString(expr, left.nextSibling);
  const binModifier = getBinaryModifier(expr, (_a = node.getChild(lezerPromql.BoolModifier)) != null ? _a : node.getChild(lezerPromql.MatchingModifierClause));
  const right = node.lastChild;
  const opDef = binaryScalarOperatorToOperatorName[op];
  const leftNumber = left.type.id === lezerPromql.NumberDurationLiteral;
  const rightNumber = right.type.id === lezerPromql.NumberDurationLiteral;
  const rightBinary = right.type.id === lezerPromql.BinaryExpr;
  if (leftNumber) {
  } else {
    handleExpression(expr, left, context);
  }
  if (rightNumber) {
    visQuery.operations.push(makeBinOp(opDef, expr, right, !!(binModifier == null ? void 0 : binModifier.isBool)));
  } else if (rightBinary) {
    const leftMostChild = getLeftMostChild(right);
    if ((leftMostChild == null ? void 0 : leftMostChild.type.id) === lezerPromql.NumberDurationLiteral) {
      visQuery.operations.push(makeBinOp(opDef, expr, leftMostChild, !!(binModifier == null ? void 0 : binModifier.isBool)));
    }
    handleExpression(expr, right, context);
  } else {
    visQuery.binaryQueries = visQuery.binaryQueries || [];
    const binQuery = {
      operator: op,
      query: {
        metric: "",
        labels: [],
        operations: []
      }
    };
    if (binModifier == null ? void 0 : binModifier.isMatcher) {
      binQuery.vectorMatchesType = binModifier.matchType;
      binQuery.vectorMatches = binModifier.matches;
    }
    visQuery.binaryQueries.push(binQuery);
    handleExpression(expr, right, {
      query: binQuery.query,
      errors: context.errors,
      replacements: context.replacements
    });
  }
}
function getBinaryModifier(expr, node) {
  if (!node) {
    return void 0;
  }
  if (node.getChild("Bool")) {
    return { isBool: true, isMatcher: false };
  } else {
    let labels = "";
    const groupingLabels = node.getChild(lezerPromql.GroupingLabels);
    if (groupingLabels) {
      labels = getAllByType(expr, groupingLabels, lezerPromql.LabelName).join(", ");
    }
    return {
      isMatcher: true,
      isBool: false,
      matches: labels,
      matchType: node.getChild(lezerPromql.On) ? "on" : "ignoring"
    };
  }
}
function isEmptyQuery(query) {
  if (query.labels.length === 0 && query.operations.length === 0 && !query.metric) {
    return true;
  }
  return false;
}

"use strict";
const QueryPatternsModal = (props) => {
  const { isOpen, onClose, onChange, onAddQuery, query, queries, app } = props;
  const [openTabs, setOpenTabs] = React.useState([]);
  const [selectedPatternName, setSelectedPatternName] = React.useState(null);
  const styles = ui.useStyles2(getStyles$k);
  const hasNewQueryOption = !!onAddQuery;
  const hasPreviousQuery = React.useMemo(() => {
    var _a;
    const visualQuery = buildVisualQueryFromString((_a = query.expr) != null ? _a : "");
    const hasOperations = visualQuery.query.operations.length > 0, hasMetric = visualQuery.query.metric, hasLabels = visualQuery.query.labels.length > 0, hasBinaryQueries = visualQuery.query.binaryQueries ? visualQuery.query.binaryQueries.length > 0 : false;
    return hasOperations || hasMetric || hasLabels || hasBinaryQueries;
  }, [query.expr]);
  const onPatternSelect = (pattern, selectAsNewQuery = false) => {
    const visualQuery = buildVisualQueryFromString(selectAsNewQuery ? "" : query.expr);
    runtime.reportInteraction("grafana_prom_kickstart_your_query_selected", {
      app: app != null ? app : "",
      editorMode: query.editorMode,
      selectedPattern: pattern.name,
      preSelectedOperationsCount: visualQuery.query.operations.length,
      preSelectedLabelsCount: visualQuery.query.labels.length,
      createNewQuery: hasNewQueryOption && selectAsNewQuery
    });
    visualQuery.query.operations = pattern.operations;
    visualQuery.query.binaryQueries = pattern.binaryQueries;
    const renderedExpr = promQueryModeller.renderQuery(visualQuery.query);
    if (hasNewQueryOption && selectAsNewQuery) {
      onAddQuery({
        ...query,
        refId: data.getNextRefId(queries != null ? queries : [query]),
        expr: renderedExpr
      });
    } else {
      onChange({
        ...query,
        expr: renderedExpr
      });
    }
    setSelectedPatternName(null);
    onClose();
  };
  return /* @__PURE__ */ jsxRuntime.jsxs(
    ui.Modal,
    {
      "aria-label": i18n.t(
        "grafana-prometheus.querybuilder.query-patterns-modal.aria-label-kick-start-your-query-modal",
        "Kick start your query modal"
      ),
      isOpen,
      title: i18n.t(
        "grafana-prometheus.querybuilder.query-patterns-modal.title-kick-start-your-query",
        "Kick start your query"
      ),
      onDismiss: onClose,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.spacing, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.query-patterns-modal.description-kick-start-your-query", children: "Kick start your query by selecting one of these queries. You can then continue to complete your query." }) }),
        Object.values(PromQueryPatternType).map((patternType) => {
          const isOpen2 = openTabs.includes(patternType);
          return /* @__PURE__ */ jsxRuntime.jsx(
            ui.Collapse,
            {
              "aria-label": i18n.t(
                "grafana-prometheus.querybuilder.query-patterns-modal.aria-label-toggle-query-starter",
                "open and close {{patternType}} query starter card",
                { patternType }
              ),
              label: i18n.t(
                "grafana-prometheus.querybuilder.query-patterns-modal.label-toggle-query-starter",
                "{{patternType}} query starters",
                {
                  patternType: lodash.capitalize(patternType)
                }
              ),
              isOpen: isOpen2,
              collapsible: true,
              onToggle: () => {
                const action = isOpen2 ? "close" : "open";
                runtime.reportInteraction(`grafana_prom_kickstart_toggle_pattern_card`, {
                  action,
                  patternType
                });
                setOpenTabs(
                  (tabs) => (
                    // close tab if it's already open, otherwise open it
                    tabs.includes(patternType) ? tabs.filter((t2) => t2 !== patternType) : [...tabs, patternType]
                  )
                );
              },
              children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.cardsContainer, children: promQueryModeller.getQueryPatterns().filter((pattern) => pattern.type === patternType).map((pattern) => /* @__PURE__ */ jsxRuntime.jsx(
                QueryPattern,
                {
                  pattern,
                  hasNewQueryOption,
                  hasPreviousQuery,
                  onPatternSelect,
                  selectedPatternName,
                  setSelectedPatternName
                },
                pattern.name
              )) })
            },
            patternType
          );
        }),
        /* @__PURE__ */ jsxRuntime.jsx(
          ui.Button,
          {
            "aria-label": i18n.t(
              "grafana-prometheus.querybuilder.query-patterns-modal.aria-label-close-kick-start-your-query-modal",
              "close kick start your query modal"
            ),
            variant: "secondary",
            onClick: onClose,
            children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.query-patterns-modal.close", children: "Close" })
          }
        )
      ]
    }
  );
};
const getStyles$k = (theme) => {
  return {
    cardsContainer: css.css({
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap",
      justifyContent: "space-between"
    }),
    spacing: css.css({
      marginBottom: theme.spacing(1)
    })
  };
};

"use strict";
const promQueryEditorExplainKey = "PrometheusQueryEditorExplainDefault";
function getFlagValue(key, defaultValue = false) {
  const val = data.store.get(key);
  return val === void 0 ? defaultValue : Boolean(parseInt(val, 10));
}
function setFlagValue(key, value) {
  data.store.set(key, value ? "1" : "0");
}
function useFlag(key, defaultValue = false) {
  const [flag, updateFlag] = React.useState(getFlagValue(key, defaultValue));
  const setter = React.useCallback(
    (value) => {
      setFlagValue(key, value);
      updateFlag(value);
    },
    [key]
  );
  return { flag, setFlag: setter };
}

"use strict";
var QueryEditorMode = /* @__PURE__ */ ((QueryEditorMode2) => {
  QueryEditorMode2["Code"] = "code";
  QueryEditorMode2["Builder"] = "builder";
  return QueryEditorMode2;
})(QueryEditorMode || {});

"use strict";
function QueryEditorModeToggle({ mode, onChange }) {
  const editorModes = [
    {
      label: i18n.t("grafana-prometheus.querybuilder.query-editor-mode-toggle.editor-modes.label-builder", "Builder"),
      value: QueryEditorMode.Builder
    },
    {
      label: i18n.t("grafana-prometheus.querybuilder.query-editor-mode-toggle.editor-modes.label-code", "Code"),
      value: QueryEditorMode.Code
    }
  ];
  return /* @__PURE__ */ jsxRuntime.jsx("div", { "data-testid": "QueryEditorModeToggle", children: /* @__PURE__ */ jsxRuntime.jsx(ui.RadioButtonGroup, { options: editorModes, size: "sm", value: mode, onChange }) });
}

"use strict";
function QueryHeaderSwitch({ label, ...inputProps }) {
  const dashedLabel = label.replace(" ", "-");
  const switchIdRef = React.useRef(lodash.uniqueId(`switch-${dashedLabel}`));
  const styles = ui.useStyles2(getStyles$j);
  return /* @__PURE__ */ jsxRuntime.jsxs(ui.Stack, { gap: 1, children: [
    /* @__PURE__ */ jsxRuntime.jsx("label", { htmlFor: switchIdRef.current, className: styles.switchLabel, children: label }),
    /* @__PURE__ */ jsxRuntime.jsx(ui.Switch, { ...inputProps, id: switchIdRef.current })
  ] });
}
const getStyles$j = (theme) => {
  return {
    switchLabel: css.css({
      color: theme.colors.text.secondary,
      cursor: "pointer",
      fontSize: theme.typography.bodySmall.fontSize,
      "&:hover": {
        color: theme.colors.text.primary
      }
    })
  };
};

"use strict";
var PrometheusCacheLevel = /* @__PURE__ */ ((PrometheusCacheLevel2) => {
  PrometheusCacheLevel2["Low"] = "Low";
  PrometheusCacheLevel2["Medium"] = "Medium";
  PrometheusCacheLevel2["High"] = "High";
  PrometheusCacheLevel2["None"] = "None";
  return PrometheusCacheLevel2;
})(PrometheusCacheLevel || {});
var PromApplication = /* @__PURE__ */ ((PromApplication2) => {
  PromApplication2["Cortex"] = "Cortex";
  PromApplication2["Mimir"] = "Mimir";
  PromApplication2["Prometheus"] = "Prometheus";
  PromApplication2["Thanos"] = "Thanos";
  return PromApplication2;
})(PromApplication || {});
var LegendFormatMode = /* @__PURE__ */ ((LegendFormatMode2) => {
  LegendFormatMode2["Auto"] = "__auto";
  LegendFormatMode2["Verbose"] = "__verbose";
  LegendFormatMode2["Custom"] = "__custom";
  return LegendFormatMode2;
})(LegendFormatMode || {});
var PromVariableQueryType = /* @__PURE__ */ ((PromVariableQueryType2) => {
  PromVariableQueryType2[PromVariableQueryType2["LabelNames"] = 0] = "LabelNames";
  PromVariableQueryType2[PromVariableQueryType2["LabelValues"] = 1] = "LabelValues";
  PromVariableQueryType2[PromVariableQueryType2["MetricNames"] = 2] = "MetricNames";
  PromVariableQueryType2[PromVariableQueryType2["VarQueryResult"] = 3] = "VarQueryResult";
  PromVariableQueryType2[PromVariableQueryType2["SeriesQuery"] = 4] = "SeriesQuery";
  PromVariableQueryType2[PromVariableQueryType2["ClassicQuery"] = 5] = "ClassicQuery";
  return PromVariableQueryType2;
})(PromVariableQueryType || {});

"use strict";
const queryEditorModeDefaultLocalStorageKey = "PrometheusQueryEditorModeDefault";
function changeEditorMode(query, editorMode, onChange) {
  if (query.expr === "") {
    data.store.set(queryEditorModeDefaultLocalStorageKey, editorMode);
  }
  onChange({ ...query, editorMode });
}
function getDefaultEditorMode(expr, defaultEditor = QueryEditorMode.Builder) {
  if (expr != null && expr !== "") {
    return QueryEditorMode.Code;
  }
  const value = data.store.get(queryEditorModeDefaultLocalStorageKey);
  switch (value) {
    case QueryEditorMode.Builder:
    case QueryEditorMode.Code:
      return value;
    default:
      return defaultEditor;
  }
}
function getQueryWithDefaults(query, app, defaultEditor) {
  let result = query;
  if (!query.editorMode) {
    result = { ...query, editorMode: getDefaultEditorMode(query.expr, defaultEditor) };
  }
  if (!query.expr) {
    result = { ...result, expr: "", legendFormat: LegendFormatMode.Auto };
  }
  if (query.range == null && query.instant == null) {
    result = { ...result, range: true };
    if (app === data.CoreApp.Explore) {
      result.instant = true;
    }
  }
  const isBothInstantAndRange = query.instant && query.range;
  if (app === data.CoreApp.UnifiedAlerting && isBothInstantAndRange) {
    result = { ...result, instant: false, range: true };
  }
  return result;
}

"use strict";
const SUM_HINT_THRESHOLD_COUNT = 20;
function getQueryHints(query, series, datasource) {
  var _a;
  const hints = [];
  const metricsMetadata = (_a = datasource == null ? void 0 : datasource.languageProvider) == null ? void 0 : _a.retrieveMetricsMetadata();
  const oldHistogramMetric = query.trim().match(/^\w+_bucket$|^\w+_bucket{.*}$/);
  if (oldHistogramMetric) {
    const label = "Selected metric has buckets.";
    hints.push({
      type: "HISTOGRAM_QUANTILE",
      label,
      fix: {
        label: "Consider calculating aggregated quantile by adding histogram_quantile().",
        action: {
          type: "ADD_HISTOGRAM_QUANTILE",
          query
        }
      }
    });
  } else if (metricsMetadata && simpleQueryCheck(query)) {
    const queryTokens = getQueryTokens(query);
    const { nameMetric } = checkMetricType(queryTokens, "histogram", metricsMetadata, false);
    const nativeHistogramNameMetric = nameMetric;
    if (nativeHistogramNameMetric) {
      const label = "Selected metric is a native histogram.";
      hints.push(
        {
          type: "HISTOGRAM_QUANTILE",
          label,
          fix: {
            label: "Consider calculating aggregated quantile by adding histogram_quantile().",
            action: {
              type: "ADD_HISTOGRAM_QUANTILE",
              query
            }
          }
        },
        {
          type: "HISTOGRAM_AVG",
          label,
          fix: {
            label: "Consider calculating the arithmetic average of observed values by adding histogram_avg().",
            action: {
              type: "ADD_HISTOGRAM_AVG",
              query
            }
          }
        },
        {
          type: "HISTOGRAM_COUNT",
          label,
          fix: {
            label: "Consider calculating the count of observations by adding histogram_count().",
            action: {
              type: "ADD_HISTOGRAM_COUNT",
              query
            }
          }
        }
      );
    }
  }
  if (query.indexOf("rate(") === -1 && query.indexOf("increase(") === -1) {
    const nameMatch = query.match(/\b((?<!:)\w+_(total|sum|count)(?!:))\b/);
    let counterNameMetric = nameMatch ? nameMatch[1] : "";
    let certain = false;
    if (metricsMetadata) {
      const queryTokens = getQueryTokens(query);
      const metricTypeChecked = checkMetricType(queryTokens, "counter", metricsMetadata, certain);
      counterNameMetric = metricTypeChecked.nameMetric;
      certain = metricTypeChecked.certain;
    }
    if (counterNameMetric) {
      const fixableQuery = simpleQueryCheck(query);
      const verb = certain ? "is" : "looks like";
      let label = `Selected metric ${verb} a counter.`;
      let fix;
      if (fixableQuery) {
        fix = {
          label: "Consider calculating rate of counter by adding rate().",
          action: {
            type: "ADD_RATE",
            query
          }
        };
      } else {
        label = `${label} Consider calculating rate of counter by adding rate().`;
      }
      hints.push({
        type: "APPLY_RATE",
        label,
        fix
      });
    }
  }
  if (datasource && datasource.ruleMappings) {
    const expandQueryHints = getExpandRulesHints(query, datasource.ruleMappings);
    hints.push(...expandQueryHints);
  }
  if (series && series.length >= SUM_HINT_THRESHOLD_COUNT) {
    const simpleMetric = query.trim().match(/^\w+$/);
    if (simpleMetric) {
      hints.push({
        type: "ADD_SUM",
        label: "Many time series results returned.",
        fix: {
          label: "Consider aggregating with sum().",
          action: {
            type: "ADD_SUM",
            query,
            preventSubmit: true
          }
        }
      });
    }
  }
  return hints;
}
function getInitHints(datasource) {
  const hints = [];
  if (datasource.lookupsDisabled) {
    hints.push({
      label: `Labels and metrics lookup was disabled in data source settings.`,
      type: "INFO"
    });
  }
  return hints;
}
function isRuleInQuery(query, ruleName) {
  if (!query || !ruleName) {
    return false;
  }
  const getRuleRegex = new RegExp(`(?<![\\w:])${ruleName}(?=[\\[{(\\s\\)]|$)`);
  return getRuleRegex.test(query);
}
function getExpandRulesHints(query, mapping) {
  const hints = [];
  const mappingForQuery = Object.keys(mapping).reduce((acc, ruleName) => {
    if (!isRuleInQuery(query, ruleName)) {
      return acc;
    }
    if (mapping[ruleName].length > 1) {
      const { idx, expandedQuery, identifier, identifierValue } = getRecordingRuleIdentifierIdx(
        query,
        ruleName,
        mapping[ruleName]
      );
      if (idx === -1) {
        hints.push({
          type: "EXPAND_RULES_WARNING",
          label: "We found multiple recording rules that match in this query. To expand the recording rule, add an identifier label/value."
        });
        return acc;
      } else {
        return {
          ...acc,
          [ruleName]: {
            expandedQuery,
            identifier,
            identifierValue
          }
        };
      }
    } else {
      return {
        ...acc,
        [ruleName]: {
          expandedQuery: mapping[ruleName][0].query
        }
      };
    }
  }, {});
  if (lodash.size(mappingForQuery) > 0) {
    const label = "Query contains recording rules.";
    hints.push({
      type: "EXPAND_RULES",
      label,
      fix: {
        label: "Expand rules",
        action: {
          type: "EXPAND_RULES",
          query,
          options: mappingForQuery
        }
      }
    });
  }
  return hints;
}
function getRecordingRuleIdentifierIdx(queryStr, ruleName, mapping) {
  var _a, _b;
  const { query } = buildVisualQueryFromString(queryStr);
  const queryMetricLabels = getQueryLabelsForRuleName(ruleName, query);
  if (queryMetricLabels.length === 0) {
    return { idx: -1, identifier: "", identifierValue: "", expandedQuery: "" };
  }
  let uuidLabel = "";
  let uuidLabelValue = "";
  let uuidLabelIdx = -1;
  queryMetricLabels.forEach((qml) => {
    if (uuidLabelIdx === -1 && qml.label.search("uuid") !== -1) {
      uuidLabel = qml.label;
      uuidLabelValue = qml.value;
    }
  });
  mapping.forEach((mp, idx) => {
    if (mp.labels) {
      Object.entries(mp.labels).forEach(([key, value]) => {
        if (uuidLabelIdx === -1 && key === uuidLabel && value === uuidLabelValue) {
          uuidLabelIdx = idx;
        }
      });
    }
  });
  return {
    idx: uuidLabelIdx,
    identifier: uuidLabel,
    identifierValue: uuidLabelValue,
    expandedQuery: (_b = (_a = mapping[uuidLabelIdx]) == null ? void 0 : _a.query) != null ? _b : ""
  };
}
function getQueryLabelsForRuleName(metricName, query) {
  if (query.metric === metricName) {
    return query.labels;
  } else {
    if (query.binaryQueries) {
      for (let i = 0; i < query.binaryQueries.length; i++) {
        const labels = getQueryLabelsForRuleName(metricName, query.binaryQueries[i].query);
        if (labels && labels.length > 0) {
          return labels;
        }
      }
    }
    return [];
  }
}
function getQueryTokens(query) {
  return Array.from(query.matchAll(/\$?[a-zA-Z_:][a-zA-Z0-9_:]*/g)).map(([match]) => match).filter((token) => !token.startsWith("$")).flatMap((token) => token.split(":"));
}
function checkMetricType(queryTokens, metricType, metricsMetadata, certain) {
  var _a;
  const nameMetric = (_a = queryTokens.find((metricName) => {
    const metadata = metricsMetadata[metricName];
    if (metadata && metadata.type.toLowerCase() === metricType) {
      certain = true;
      return true;
    } else {
      return false;
    }
  })) != null ? _a : "";
  return { nameMetric, certain };
}
function simpleQueryCheck(query) {
  return query.trim().match(/^\w+$|^\w+{.*}$/);
}

"use strict";
function OperationExplainedBox({ title, stepNumber, markdown, children }) {
  const styles = ui.useStyles2(getStyles$i);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.box, children: [
    stepNumber !== void 0 && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.stepNumber, children: stepNumber }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.boxInner, children: [
      title && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.header, children: /* @__PURE__ */ jsxRuntime.jsx("span", { children: title }) }),
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.body, children: [
        markdown && /* @__PURE__ */ jsxRuntime.jsx("div", { dangerouslySetInnerHTML: { __html: data.renderMarkdown(markdown) } }),
        children
      ] })
    ] })
  ] });
}
const getStyles$i = (theme) => {
  return {
    box: css.css({
      background: theme.colors.background.secondary,
      padding: theme.spacing(1),
      borderRadius: theme.shape.radius.default,
      position: "relative"
    }),
    boxInner: css.css({
      marginLeft: theme.spacing(4)
    }),
    stepNumber: css.css({
      fontWeight: theme.typography.fontWeightMedium,
      background: theme.colors.secondary.main,
      width: "20px",
      height: "20px",
      borderRadius: theme.shape.radius.circle,
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      position: "absolute",
      top: "10px",
      left: "11px",
      fontSize: theme.typography.bodySmall.fontSize
    }),
    header: css.css({
      paddingBottom: theme.spacing(0.5),
      display: "flex",
      alignItems: "center",
      fontFamily: theme.typography.fontFamilyMonospace
    }),
    body: css.css({
      color: theme.colors.text.secondary,
      "p:last-child": {
        margin: 0
      },
      a: {
        color: theme.colors.text.link,
        textDecoration: "underline"
      }
    })
  };
};

"use strict";
const OperationInfoButton = React.memo(({ def, operation }) => {
  const styles = ui.useStyles2(getStyles$h);
  const [show, setShow] = React.useState(false);
  const middleware = [
    react.offset(16),
    react.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react.shift()
  ];
  const { context, refs, floatingStyles } = react.useFloating({
    open: show,
    placement: "top",
    onOpenChange: setShow,
    middleware,
    whileElementsMounted: react.autoUpdate
  });
  const click = react.useClick(context);
  const dismiss = react.useDismiss(context);
  const { getReferenceProps, getFloatingProps } = react.useInteractions([dismiss, click]);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.Button,
      {
        title: i18n.t(
          "grafana-prometheus.querybuilder.operation-info-button.title-click-to-show-description",
          "Click to show description"
        ),
        ref: refs.setReference,
        icon: "info-circle",
        size: "sm",
        variant: "secondary",
        fill: "text",
        ...getReferenceProps()
      }
    ),
    show && /* @__PURE__ */ jsxRuntime.jsx(ui.Portal, { children: /* @__PURE__ */ jsxRuntime.jsxs("div", { ref: refs.setFloating, style: floatingStyles, ...getFloatingProps(), className: styles.docBox, children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.docBoxHeader, children: [
        /* @__PURE__ */ jsxRuntime.jsx("span", { children: def.renderer(operation, def, "<expr>") }),
        /* @__PURE__ */ jsxRuntime.jsx(pluginUi.FlexItem, { grow: 1 }),
        /* @__PURE__ */ jsxRuntime.jsx(
          ui.Button,
          {
            icon: "times",
            onClick: () => setShow(false),
            fill: "text",
            variant: "secondary",
            title: i18n.t(
              "grafana-prometheus.querybuilder.operation-info-button.title-remove-operation",
              "Remove operation"
            )
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          className: styles.docBoxBody,
          dangerouslySetInnerHTML: { __html: getOperationDocs(def, operation) }
        }
      )
    ] }) })
  ] });
});
OperationInfoButton.displayName = "OperationDocs";
const getStyles$h = (theme) => {
  return {
    docBox: css.css({
      overflow: "hidden",
      background: theme.colors.background.elevated,
      border: `1px solid ${theme.colors.border.weak}`,
      boxShadow: theme.shadows.z3,
      maxWidth: "600px",
      padding: theme.spacing(1),
      borderRadius: theme.shape.radius.default,
      zIndex: theme.zIndex.tooltip
    }),
    docBoxHeader: css.css({
      fontSize: theme.typography.h5.fontSize,
      fontFamily: theme.typography.fontFamilyMonospace,
      paddingBottom: theme.spacing(1),
      display: "flex",
      alignItems: "center"
    }),
    docBoxBody: css.css({
      // The markdown paragraph has a marginBottom this removes it
      marginBottom: theme.spacing(-1),
      color: theme.colors.text.secondary
    })
  };
};
function getOperationDocs(def, op) {
  var _a;
  return data.renderMarkdown(def.explainHandler ? def.explainHandler(op, def) : (_a = def.documentation) != null ? _a : "no docs");
}

"use strict";
const OperationHeader = React.memo(
  ({ operation, def, index, onChange, onRemove, queryModeller, dragHandleProps }) => {
    var _a;
    const styles = ui.useStyles2(getStyles$g);
    const [state, setState] = React.useState({});
    const onToggleSwitcher = () => {
      if (state.isOpen) {
        setState({ ...state, isOpen: false });
      } else {
        const alternatives = queryModeller.getAlternativeOperations(def.alternativesKey).map((alt) => ({ label: alt.name, value: alt }));
        setState({ isOpen: true, alternatives });
      }
    };
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.header, children: [
      !state.isOpen && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { ...dragHandleProps, children: (_a = def.name) != null ? _a : def.id }),
        /* @__PURE__ */ jsxRuntime.jsx(pluginUi.FlexItem, { grow: 1 }),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { className: `${styles.operationHeaderButtons} operation-header-show-on-hover`, children: [
          /* @__PURE__ */ jsxRuntime.jsx(
            ui.Button,
            {
              icon: "angle-down",
              size: "sm",
              onClick: onToggleSwitcher,
              fill: "text",
              variant: "secondary",
              title: i18n.t(
                "grafana-prometheus.querybuilder.operation-header.title-click-to-view-alternative-operations",
                "Click to view alternative operations"
              )
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx(OperationInfoButton, { def, operation }),
          /* @__PURE__ */ jsxRuntime.jsx(
            ui.Button,
            {
              icon: "times",
              size: "sm",
              onClick: () => onRemove(index),
              fill: "text",
              variant: "secondary",
              title: i18n.t("grafana-prometheus.querybuilder.operation-header.title-remove-operation", "Remove operation")
            }
          )
        ] })
      ] }),
      state.isOpen && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.selectWrapper, children: /* @__PURE__ */ jsxRuntime.jsx(
        ui.Select,
        {
          autoFocus: true,
          openMenuOnFocus: true,
          placeholder: i18n.t(
            "grafana-prometheus.querybuilder.operation-header.placeholder-replace-with",
            "Replace with"
          ),
          options: state.alternatives,
          isOpen: true,
          onCloseMenu: onToggleSwitcher,
          onChange: (value) => {
            if (value.value) {
              const newDef = queryModeller.getOperationDef(value.value.id);
              const newParams = [...newDef.defaultParams];
              for (let i = 0; i < Math.min(operation.params.length, newParams.length); i++) {
                if (newDef.params[i].type === def.params[i].type) {
                  newParams[i] = operation.params[i];
                }
              }
              const changedOp = { ...operation, params: newParams, id: value.value.id };
              onChange(index, def.changeTypeHandler ? def.changeTypeHandler(changedOp, newDef) : changedOp);
            }
          }
        }
      ) })
    ] });
  }
);
OperationHeader.displayName = "OperationHeader";
const getStyles$g = (theme) => {
  return {
    header: css.css({
      borderBottom: `1px solid ${theme.colors.border.medium}`,
      padding: theme.spacing(0.5, 0.5, 0.5, 1),
      display: "flex",
      alignItems: "center"
    }),
    operationHeaderButtons: css.css({
      opacity: 1
    }),
    selectWrapper: css.css({
      paddingRight: theme.spacing(2)
    })
  };
};

"use strict";
function getOperationParamId(operationId, paramIndex) {
  return `operations.${operationId}.param.${paramIndex}`;
}

"use strict";
function LabelParamEditor({
  onChange,
  index,
  operationId,
  value,
  query,
  datasource,
  timeRange,
  queryModeller
}) {
  const [state, setState] = React.useState({});
  return /* @__PURE__ */ jsxRuntime.jsx(
    ui.Select,
    {
      inputId: getOperationParamId(operationId, index),
      autoFocus: value === "" ? true : void 0,
      openMenuOnFocus: true,
      onOpenMenu: async () => {
        setState({ isLoading: true });
        const options = await loadGroupByLabels(timeRange, query, datasource, queryModeller);
        setState({ options, isLoading: void 0 });
      },
      isLoading: state.isLoading,
      allowCustomValue: true,
      noOptionsMessage: i18n.t(
        "grafana-prometheus.querybuilder.label-param-editor.noOptionsMessage-no-labels-found",
        "No labels found"
      ),
      loadingMessage: i18n.t(
        "grafana-prometheus.querybuilder.label-param-editor.loadingMessage-loading-labels",
        "Loading labels"
      ),
      options: state.options,
      value: data.toOption(value),
      onChange: (value2) => onChange(index, value2.value)
    }
  );
}
async function loadGroupByLabels(timeRange, query, datasource, modeller) {
  let labels = query.labels;
  if (datasource.type === "prometheus") {
    labels = [{ label: "__name__", op: "=", value: query.metric }, ...query.labels];
  }
  const expr = modeller.renderLabels(labels);
  const result = await datasource.languageProvider.queryLabelKeys(timeRange, expr);
  return result.map((x) => ({
    label: x,
    value: x
  }));
}

"use strict";
const editorMap = {
  // The wrapper component will ensure the modeller is provided
  LabelParamEditor
};
function getOperationParamEditor(paramDef) {
  if (paramDef.editor) {
    if (typeof paramDef.editor === "string") {
      return editorMap[paramDef.editor] || SimpleInputParamEditor;
    }
    return paramDef.editor;
  }
  if (paramDef.options) {
    return SelectInputParamEditor;
  }
  switch (paramDef.type) {
    case "boolean":
      return BoolInputParamEditor;
    case "number":
    case "string":
    default:
      return SimpleInputParamEditor;
  }
}
function SimpleInputParamEditor(props) {
  var _a;
  return /* @__PURE__ */ jsxRuntime.jsx(
    ui.AutoSizeInput,
    {
      id: getOperationParamId(props.operationId, props.index),
      defaultValue: (_a = props.value) == null ? void 0 : _a.toString(),
      minWidth: props.paramDef.minWidth,
      placeholder: props.paramDef.placeholder,
      title: props.paramDef.description,
      maxWidth: (props.paramDef.minWidth || 20) * 3,
      onCommitChange: (evt) => {
        props.onChange(props.index, evt.currentTarget.value);
        if (props.paramDef.runQueryOnEnter && evt.type === "keydown") {
          props.onRunQuery();
        }
      }
    }
  );
}
function BoolInputParamEditor(props) {
  return /* @__PURE__ */ jsxRuntime.jsx(
    ui.Checkbox,
    {
      id: getOperationParamId(props.operationId, props.index),
      value: Boolean(props.value),
      onChange: (evt) => props.onChange(props.index, evt.currentTarget.checked)
    }
  );
}
function SelectInputParamEditor({
  paramDef,
  value,
  index,
  operationId,
  onChange
}) {
  var _a, _b;
  const styles = ui.useStyles2(getStyles$f);
  let selectOptions = paramDef.options;
  if (!((_a = selectOptions[0]) == null ? void 0 : _a.label)) {
    selectOptions = paramDef.options.map((option) => ({
      label: option.toString(),
      value: option
    }));
  }
  let valueOption = (_b = selectOptions.find((x) => x.value === value)) != null ? _b : data.toOption(value);
  if (!value && paramDef.optional) {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.optionalParam, children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.Button,
      {
        size: "sm",
        variant: "secondary",
        title: i18n.t("grafana-prometheus.querybuilder.operation-param-editor.title-add", "Add {{name}}", {
          name: paramDef.name
        }),
        icon: "plus",
        onClick: () => onChange(index, selectOptions[0].value),
        children: paramDef.name
      }
    ) });
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(ui.Stack, { gap: 0.5, direction: "row", alignItems: "center", children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.Select,
      {
        id: getOperationParamId(operationId, index),
        value: valueOption,
        options: selectOptions,
        placeholder: paramDef.placeholder,
        allowCustomValue: true,
        onChange: (value2) => onChange(index, value2.value),
        width: paramDef.minWidth || "auto"
      }
    ),
    paramDef.optional && /* @__PURE__ */ jsxRuntime.jsx(
      ui.Button,
      {
        "data-testid": `operations.${index}.remove-param`,
        size: "sm",
        fill: "text",
        icon: "times",
        variant: "secondary",
        title: i18n.t("grafana-prometheus.querybuilder.operation-param-editor.title-remove", "Remove {{name}}", {
          name: paramDef.name
        }),
        onClick: () => onChange(index, "")
      }
    )
  ] });
}
const getStyles$f = (theme) => {
  return {
    optionalParam: css.css({
      marginTop: theme.spacing(1)
    })
  };
};

"use strict";
function OperationEditor({
  operation,
  index,
  onRemove,
  onChange,
  onRunQuery,
  queryModeller,
  query,
  datasource,
  flash,
  highlight,
  timeRange
}) {
  const styles = ui.useStyles2(getStyles$e);
  const def = queryModeller.getOperationDef(operation.id);
  const shouldFlash = useFlash(flash);
  const id = React.useId();
  if (!def) {
    return /* @__PURE__ */ jsxRuntime.jsx("span", { children: /* @__PURE__ */ jsxRuntime.jsxs(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.operation-editor.not-found", values: { id: operation.id }, children: [
      "Operation ",
      "{{id}}",
      " not found"
    ] }) });
  }
  const onParamValueChanged = (paramIdx, value) => {
    const update = { ...operation, params: [...operation.params] };
    update.params[paramIdx] = value;
    callParamChangedThenOnChange(def, update, index, paramIdx, onChange);
  };
  const onAddRestParam = () => {
    const update = { ...operation, params: [...operation.params, ""] };
    callParamChangedThenOnChange(def, update, index, operation.params.length, onChange);
  };
  const onRemoveRestParam = (paramIdx) => {
    const update = {
      ...operation,
      params: [...operation.params.slice(0, paramIdx), ...operation.params.slice(paramIdx + 1)]
    };
    callParamChangedThenOnChange(def, update, index, paramIdx, onChange);
  };
  const operationElements = [];
  for (let paramIndex = 0; paramIndex < operation.params.length; paramIndex++) {
    const paramDef = def.params[Math.min(def.params.length - 1, paramIndex)];
    const Editor = getOperationParamEditor(paramDef);
    operationElements.push(
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.paramRow, children: [
        !paramDef.hideName && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.paramName, children: [
          /* @__PURE__ */ jsxRuntime.jsx("label", { htmlFor: getOperationParamId(id, paramIndex), children: paramDef.name }),
          paramDef.description && /* @__PURE__ */ jsxRuntime.jsx(ui.Tooltip, { placement: "top", content: paramDef.description, theme: "info", children: /* @__PURE__ */ jsxRuntime.jsx(ui.Icon, { name: "info-circle", size: "sm", className: styles.infoIcon }) })
        ] }),
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.paramValue, children: /* @__PURE__ */ jsxRuntime.jsxs(ui.Stack, { gap: 0.5, direction: "row", alignItems: "center", children: [
          /* @__PURE__ */ jsxRuntime.jsx(
            Editor,
            {
              paramDef,
              value: operation.params[paramIndex],
              index: paramIndex,
              operationId: operation.id,
              query,
              datasource,
              timeRange,
              onChange: onParamValueChanged,
              onRunQuery,
              queryModeller
            }
          ),
          paramDef.restParam && (operation.params.length > def.params.length || paramDef.optional) && /* @__PURE__ */ jsxRuntime.jsx(
            ui.Button,
            {
              "data-testid": `operations.${index}.remove-rest-param`,
              size: "sm",
              fill: "text",
              icon: "times",
              variant: "secondary",
              title: i18n.t("grafana-prometheus.querybuilder.operation-editor.title-remove", "Remove {{name}}", {
                name: paramDef.name
              }),
              onClick: () => onRemoveRestParam(paramIndex)
            }
          )
        ] }) })
      ] }, `${paramIndex}-1`)
    );
  }
  let restParam;
  if (def.params.length > 0) {
    const lastParamDef = def.params[def.params.length - 1];
    if (lastParamDef.restParam) {
      restParam = renderAddRestParamButton(lastParamDef, onAddRestParam, index, operation.params.length, styles);
    }
  }
  return /* @__PURE__ */ jsxRuntime.jsx(dnd.Draggable, { draggableId: `operation-${index}`, index, children: (provided) => /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      className: css.cx(styles.card, (shouldFlash || highlight) && styles.cardHighlight),
      ref: provided.innerRef,
      ...provided.draggableProps,
      "data-testid": `operations.${index}.wrapper`,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          OperationHeader,
          {
            operation,
            dragHandleProps: provided.dragHandleProps,
            def,
            index,
            onChange,
            onRemove,
            queryModeller
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.body, children: operationElements }),
        restParam,
        index < query.operations.length - 1 && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.arrow, children: [
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.arrowLine }),
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.arrowArrow })
        ] })
      ]
    }
  ) });
}
function useFlash(flash) {
  const [keepFlash, setKeepFlash] = React.useState(true);
  React.useEffect(() => {
    let t2;
    if (flash) {
      t2 = setTimeout(() => {
        setKeepFlash(false);
      }, 1e3);
    } else {
      setKeepFlash(true);
    }
    return () => clearTimeout(t2);
  }, [flash]);
  return keepFlash && flash;
}
function renderAddRestParamButton(paramDef, onAddRestParam, operationIndex, paramIndex, styles) {
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.restParam, children: /* @__PURE__ */ jsxRuntime.jsx(
    ui.Button,
    {
      size: "sm",
      icon: "plus",
      title: `Add ${paramDef.name}`.trimEnd(),
      variant: "secondary",
      onClick: onAddRestParam,
      "data-testid": `operations.${operationIndex}.add-rest-param`,
      children: paramDef.name
    }
  ) }, `${paramIndex}-2`);
}
function callParamChangedThenOnChange(def, operation, operationIndex, paramIndex, onChange) {
  if (def.paramChangedHandler) {
    onChange(operationIndex, def.paramChangedHandler(paramIndex, operation, def));
  } else {
    onChange(operationIndex, operation);
  }
}
const getStyles$e = (theme) => {
  return {
    cardWrapper: css.css({
      alignItems: "stretch"
    }),
    error: css.css({
      marginBottom: theme.spacing(1)
    }),
    card: css.css({
      background: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.medium}`,
      cursor: "grab",
      borderRadius: theme.shape.radius.default,
      marginBottom: theme.spacing(1),
      position: "relative",
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: "all 0.5s ease-in 0s"
      },
      height: "100%"
    }),
    cardError: css.css({
      boxShadow: `0px 0px 4px 0px ${theme.colors.warning.main}`,
      border: `1px solid ${theme.colors.warning.main}`
    }),
    cardHighlight: css.css({
      boxShadow: `0px 0px 4px 0px ${theme.colors.primary.border}`,
      border: `1px solid ${theme.colors.primary.border}`
    }),
    infoIcon: css.css({
      marginLeft: theme.spacing(0.5),
      color: theme.colors.text.secondary,
      ":hover": {
        color: theme.colors.text.primary
      }
    }),
    body: css.css({
      margin: theme.spacing(1, 1, 0.5, 1),
      display: "table"
    }),
    paramRow: css.css({
      label: "paramRow",
      display: "table-row",
      verticalAlign: "middle"
    }),
    paramName: css.css({
      display: "table-cell",
      padding: theme.spacing(0, 1, 0, 0),
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      verticalAlign: "middle",
      height: "32px"
    }),
    paramValue: css.css({
      label: "paramValue",
      display: "table-cell",
      verticalAlign: "middle"
    }),
    restParam: css.css({
      padding: theme.spacing(0, 1, 1, 1)
    }),
    arrow: css.css({
      position: "absolute",
      top: "0",
      right: "-18px",
      display: "flex"
    }),
    arrowLine: css.css({
      height: "2px",
      width: "8px",
      backgroundColor: theme.colors.border.strong,
      position: "relative",
      top: "14px"
    }),
    arrowArrow: css.css({
      width: 0,
      height: 0,
      borderTop: `5px solid transparent`,
      borderBottom: `5px solid transparent`,
      borderLeft: `7px solid ${theme.colors.border.strong}`,
      position: "relative",
      top: "10px"
    })
  };
};

"use strict";
function OperationList({
  query,
  datasource,
  queryModeller,
  onChange,
  onRunQuery,
  highlightedOp,
  timeRange
}) {
  const styles = ui.useStyles2(getStyles$d);
  const { operations } = query;
  const opsToHighlight = useOperationsHighlight(operations);
  const [cascaderOpen, setCascaderOpen] = React.useState(false);
  const onOperationChange = (index, update) => {
    const updatedList = [...operations];
    updatedList.splice(index, 1, update);
    onChange({ ...query, operations: updatedList });
  };
  const onRemove = (index) => {
    const updatedList = [...operations.slice(0, index), ...operations.slice(index + 1)];
    onChange({ ...query, operations: updatedList });
  };
  const addOptions = queryModeller.getCategories().map((category) => {
    return {
      value: category,
      label: category,
      items: queryModeller.getOperationsForCategory(category).map((operation) => ({
        value: operation.id,
        label: operation.name,
        isLeaf: true
      }))
    };
  });
  const onAddOperation = (value) => {
    const operationDef = queryModeller.getOperationDef(value);
    if (!operationDef) {
      return;
    }
    onChange(operationDef.addOperationHandler(operationDef, query, queryModeller));
    setCascaderOpen(false);
  };
  const onDragEnd = (result) => {
    if (!result.destination) {
      return;
    }
    const updatedList = [...operations];
    const element = updatedList[result.source.index];
    updatedList.splice(result.source.index, 1);
    updatedList.splice(result.destination.index, 0, element);
    onChange({ ...query, operations: updatedList });
  };
  const onCascaderBlur = () => {
    setCascaderOpen(false);
  };
  return /* @__PURE__ */ jsxRuntime.jsx(ui.Stack, { gap: 1, direction: "column", children: /* @__PURE__ */ jsxRuntime.jsxs(ui.Stack, { gap: 1, children: [
    operations.length > 0 && /* @__PURE__ */ jsxRuntime.jsx(dnd.DragDropContext, { onDragEnd, children: /* @__PURE__ */ jsxRuntime.jsx(dnd.Droppable, { droppableId: "sortable-field-mappings", direction: "horizontal", children: (provided) => /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.operationList, ref: provided.innerRef, ...provided.droppableProps, children: [
      operations.map((op, index) => {
        return /* @__PURE__ */ jsxRuntime.jsx(
          OperationEditor,
          {
            queryModeller,
            index,
            operation: op,
            query,
            datasource,
            onChange: onOperationChange,
            onRemove,
            onRunQuery,
            flash: opsToHighlight[index],
            highlight: highlightedOp === op,
            timeRange
          },
          op.id + JSON.stringify(op.params) + index
        );
      }),
      provided.placeholder
    ] }) }) }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.addButton, children: cascaderOpen ? /* @__PURE__ */ jsxRuntime.jsx(
      ui.Cascader,
      {
        options: addOptions,
        onSelect: onAddOperation,
        onBlur: onCascaderBlur,
        autoFocus: true,
        alwaysOpen: true,
        hideActiveLevelLabel: true,
        placeholder: i18n.t("grafana-prometheus.querybuilder.operation-list.placeholder-search", "Search")
      }
    ) : /* @__PURE__ */ jsxRuntime.jsx(
      ui.Button,
      {
        icon: "plus",
        variant: "secondary",
        onClick: () => setCascaderOpen(true),
        title: i18n.t("grafana-prometheus.querybuilder.operation-list.title-add-operation", "Add operation"),
        children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.operation-list.operations", children: "Operations" })
      }
    ) })
  ] }) });
}
function useOperationsHighlight(operations) {
  const isMounted = reactUse.useMountedState();
  const prevOperations = reactUse.usePrevious(operations);
  if (!isMounted()) {
    return operations.map(() => false);
  }
  if (!prevOperations) {
    return operations.map(() => true);
  }
  let newOps = [];
  if (prevOperations.length - 1 === operations.length && operations.every((op) => prevOperations.includes(op))) {
    return operations.map(() => false);
  }
  if (prevOperations.length + 1 === operations.length && prevOperations.every((op) => operations.includes(op))) {
    const newOp = operations.find((op) => !prevOperations.includes(op));
    newOps = operations.map((op) => {
      return op === newOp;
    });
  } else {
    newOps = operations.map((op, index) => {
      var _a;
      return !isSameOp(op.id, (_a = prevOperations[index]) == null ? void 0 : _a.id);
    });
  }
  return newOps;
}
function isSameOp(op1, op2) {
  return op1 === op2 || `__${op1}_by` === op2 || op1 === `__${op2}_by`;
}
const getStyles$d = (theme) => {
  return {
    heading: css.css({
      label: "heading",
      fontSize: 12,
      fontWeight: theme.typography.fontWeightMedium,
      marginBottom: 0
    }),
    operationList: css.css({
      label: "operationList",
      display: "flex",
      flexWrap: "wrap",
      gap: theme.spacing(2)
    }),
    addButton: css.css({
      label: "addButton",
      width: 126,
      paddingBottom: theme.spacing(1)
    })
  };
};

"use strict";
function OperationListExplained({
  query,
  queryModeller,
  stepNumber,
  lang,
  onMouseEnter,
  onMouseLeave
}) {
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: query.operations.map((op, index) => {
    var _a;
    const def = queryModeller.getOperationDef(op.id);
    if (!def) {
      return `Operation ${op.id} not found`;
    }
    const title = def.renderer(op, def, "<expr>");
    const body = def.explainHandler ? def.explainHandler(op, def) : (_a = def.documentation) != null ? _a : "no docs";
    return /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        onMouseEnter: () => onMouseEnter == null ? void 0 : onMouseEnter(op, index),
        onMouseLeave: () => onMouseLeave == null ? void 0 : onMouseLeave(op, index),
        children: /* @__PURE__ */ jsxRuntime.jsx(
          OperationExplainedBox,
          {
            stepNumber: index + stepNumber,
            title: /* @__PURE__ */ jsxRuntime.jsx(RawQuery, { query: title, lang }),
            markdown: body
          }
        )
      },
      index
    );
  }) });
}

"use strict";
function OperationsEditorRow({ children }) {
  const styles = ui.useStyles2(getStyles$c);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.root, children: /* @__PURE__ */ jsxRuntime.jsx(ui.Stack, { gap: 1, children }) });
}
const getStyles$c = (theme) => {
  return {
    root: css.css({
      padding: theme.spacing(1, 1, 0, 1),
      backgroundColor: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.default
    })
  };
};

"use strict";
const QueryBuilderHints = ({
  datasource,
  query: visualQuery,
  onChange,
  data,
  queryModeller,
  buildVisualQueryFromString
}) => {
  const [hints, setHints] = React.useState([]);
  const styles = ui.useStyles2(getStyles$b);
  React.useEffect(() => {
    const query = { expr: queryModeller.renderQuery(visualQuery), refId: "" };
    const hints2 = datasource.getQueryHints(query, (data == null ? void 0 : data.series) || []).filter((hint) => {
      var _a;
      return (_a = hint.fix) == null ? void 0 : _a.action;
    });
    setHints(hints2);
  }, [datasource, visualQuery, data, queryModeller]);
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: hints.length > 0 && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.container, children: hints.map((hint) => {
    var _a, _b, _c, _d;
    return (
      // eslint-disable-next-line @grafana/i18n/no-untranslated-strings
      /* @__PURE__ */ jsxRuntime.jsx(ui.Tooltip, { content: `${hint.label} ${(_a = hint.fix) == null ? void 0 : _a.label}`, children: /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          onClick: () => {
            var _a2;
            runtime.reportInteraction("grafana_query_builder_hints_clicked", {
              hint: hint.type,
              datasourceType: datasource.type
            });
            if ((_a2 = hint == null ? void 0 : hint.fix) == null ? void 0 : _a2.action) {
              const query = { expr: queryModeller.renderQuery(visualQuery), refId: "" };
              const newQuery = datasource.modifyQuery(query, hint.fix.action);
              const newVisualQuery = buildVisualQueryFromString(newQuery.expr);
              return onChange(newVisualQuery.query);
            }
          },
          fill: "outline",
          size: "sm",
          className: styles.hint,
          children: /* @__PURE__ */ jsxRuntime.jsxs(
            i18n.Trans,
            {
              i18nKey: "grafana-prometheus.querybuilder.query-builder-hints.hint-details",
              values: { hintDetails: ((_b = hint.fix) == null ? void 0 : _b.title) || ((_d = (_c = hint.fix) == null ? void 0 : _c.action) == null ? void 0 : _d.type.toLowerCase().replace("_", " ")) },
              children: [
                "hint: ",
                "{{hintDetails}}"
              ]
            }
          )
        }
      ) }, hint.type)
    );
  }) }) });
};
QueryBuilderHints.displayName = "QueryBuilderHints";
const getStyles$b = (theme) => {
  return {
    container: css.css({
      display: "flex",
      alignItems: "start"
    }),
    hint: css.css({
      marginRight: theme.spacing(1)
    })
  };
};

"use strict";
const getDebounceTimeInMilliseconds = (cacheLevel) => {
  switch (cacheLevel) {
    case PrometheusCacheLevel.Medium:
      return 600;
    case PrometheusCacheLevel.High:
      return 1200;
    default:
      return 350;
  }
};
const getDaysToCacheMetadata = (cacheLevel) => {
  switch (cacheLevel) {
    case PrometheusCacheLevel.Medium:
      return 7;
    case PrometheusCacheLevel.High:
      return 30;
    default:
      return 1;
  }
};
const getCacheDurationInMinutes = (cacheLevel) => {
  switch (cacheLevel) {
    case PrometheusCacheLevel.Medium:
      return 10;
    case PrometheusCacheLevel.High:
      return 60;
    default:
      return 1;
  }
};
const buildCacheHeaders = (durationInSeconds) => {
  return {
    headers: {
      "X-Grafana-Cache": `private, max-age=${durationInSeconds}`
    }
  };
};
const getDefaultCacheHeaders = (cacheLevel) => {
  if (cacheLevel !== PrometheusCacheLevel.None) {
    return buildCacheHeaders(getCacheDurationInMinutes(cacheLevel) * 60);
  }
  return;
};

"use strict";
function addLabelToQuery(query, key, value, operator = "=") {
  if (!key || !value) {
    throw new Error("Need label to add to query.");
  }
  const vectorSelectorPositions = getVectorSelectorPositions(query);
  if (!vectorSelectorPositions.length) {
    return query;
  }
  const filter = toLabelFilter(key, value, operator);
  return addFilter(query, vectorSelectorPositions, filter);
}
function getVectorSelectorPositions(query) {
  const tree = lezerPromql.parser.parse(query);
  const positions = [];
  tree.iterate({
    enter: ({ to, from, type }) => {
      if (type.id === lezerPromql.VectorSelector) {
        const visQuery = buildVisualQueryFromString(query.substring(from, to));
        positions.push({ query: visQuery.query, from, to });
        return false;
      }
    }
  });
  return positions;
}
function toLabelFilter(key, value, operator) {
  const transformedValue = value === Infinity ? "+Inf" : value.toString();
  return { label: key, op: operator, value: transformedValue };
}
function addFilter(query, vectorSelectorPositions, filter) {
  let newQuery = "";
  let prev = 0;
  for (let i = 0; i < vectorSelectorPositions.length; i++) {
    const match = vectorSelectorPositions[i];
    const isLast = i === vectorSelectorPositions.length - 1;
    const start = query.substring(prev, match.from);
    const end = isLast ? query.substring(match.to) : "";
    if (!labelExists(match.query.labels, filter)) {
      match.query.labels.push(filter);
    }
    const newLabels = renderQuery(match.query);
    newQuery += start + newLabels + end;
    prev = match.to;
  }
  return newQuery;
}
function labelExists(labels, filter) {
  return labels.find((label) => label.label === filter.label && label.value === filter.value);
}

"use strict";
const SUGGESTIONS_LIMIT = 1e4;
const PROMETHEUS_QUERY_BUILDER_MAX_RESULTS = 1e3;
const PROM_CONFIG_LABEL_WIDTH = 30;
const LIST_ITEM_SIZE = 25;
const LAST_USED_LABELS_KEY = "grafana.datasources.prometheus.browser.labels";
const DURATION_REGEX = /^$|^\d+(ms|[Mwdhmsy])$/;
const MULTIPLE_DURATION_REGEX = /(\d+)(.+)/;
const NON_NEGATIVE_INTEGER_REGEX = /^(0|[1-9]\d*)(\.\d+)?(e\+?\d+)?$/;
const EMPTY_SELECTOR = "{}";
const DEFAULT_SERIES_LIMIT = 4e4;
const MATCH_ALL_LABELS = '{__name__!=""}';
const METRIC_LABEL = "__name__";
const durationError = "Value is not valid, you can use number with time unit specifier: y, M, w, d, h, m, s";
const countError = "Value is not valid, you can use non-negative integers, including scientific notation";
const seriesLimitError = "Value is not valid, you can use only numbers or leave it empty to use default limit or set 0 to have no limit.";
const InstantQueryRefIdIndex = "-Instant";
const GET_AND_POST_METADATA_ENDPOINTS = [
  "api/v1/query",
  "api/v1/query_range",
  "api/v1/series",
  "api/v1/labels",
  "suggestions"
];
const REMOVE_SERIES_LIMIT = "none";

"use strict";
const processHistogramMetrics = (metrics) => {
  const resultSet = /* @__PURE__ */ new Set();
  const regexp = new RegExp("_bucket($|:)");
  for (let index = 0; index < metrics.length; index++) {
    const metric = metrics[index];
    const isHistogramValue = regexp.test(metric);
    if (isHistogramValue) {
      resultSet.add(metric);
    }
  }
  return [...resultSet];
};
function processLabels(labels, withName = false) {
  const valueSet = {};
  labels.forEach((label) => {
    const { __name__, ...rest } = label;
    if (withName) {
      valueSet["__name__"] = valueSet["__name__"] || /* @__PURE__ */ new Set();
      if (!valueSet["__name__"].has(__name__)) {
        valueSet["__name__"].add(__name__);
      }
    }
    Object.keys(rest).forEach((key) => {
      if (!valueSet[key]) {
        valueSet[key] = /* @__PURE__ */ new Set();
      }
      if (!valueSet[key].has(rest[key])) {
        valueSet[key].add(rest[key]);
      }
    });
  });
  const valueArray = {};
  limitSuggestions(Object.keys(valueSet)).forEach((key) => {
    valueArray[key] = limitSuggestions(Array.from(valueSet[key]));
  });
  return { values: valueArray, keys: Object.keys(valueArray) };
}
const selectorRegexp = /\{[^}]*?(\}|$)/;
const labelRegexp = /\b(\w+)(!?=~?)("[^"\n]*?")(,)?(\s*)?/g;
function parseSelector(query, cursorOffset = 1) {
  if (!query.match(selectorRegexp)) {
    if (query.match(/^[A-Za-z:][\w:]*$/)) {
      return {
        selector: `{__name__="${query}"}`,
        labelKeys: ["__name__"]
      };
    }
    throw new Error("Query must contain a selector: " + query);
  }
  const prefix = query.slice(0, cursorOffset);
  const prefixOpen = prefix.lastIndexOf("{");
  const prefixClose = prefix.lastIndexOf("}");
  if (prefixOpen === -1) {
    throw new Error("Not inside selector, missing open brace: " + prefix);
  }
  if (prefixClose > -1 && prefixClose > prefixOpen) {
    throw new Error("Not inside selector, previous selector already closed: " + prefix);
  }
  const suffix = query.slice(cursorOffset);
  const suffixCloseIndex = suffix.indexOf("}");
  const suffixClose = suffixCloseIndex + cursorOffset;
  const suffixOpenIndex = suffix.indexOf("{");
  const suffixOpen = suffixOpenIndex + cursorOffset;
  if (suffixClose === -1) {
    throw new Error("Not inside selector, missing closing brace in suffix: " + suffix);
  }
  if (suffixOpenIndex > -1 && suffixOpen < suffixClose) {
    throw new Error("Not inside selector, next selector opens before this one closed: " + suffix);
  }
  const selector = query.slice(prefixOpen, suffixClose);
  const labels = {};
  selector.replace(labelRegexp, (label, key, operator, value) => {
    const labelOffset = query.indexOf(label);
    const valueStart = labelOffset + key.length + operator.length + 1;
    const valueEnd = labelOffset + key.length + operator.length + value.length - 1;
    if (cursorOffset < valueStart || cursorOffset > valueEnd) {
      labels[key] = { value, operator };
    }
    return "";
  });
  const metricPrefix = query.slice(0, prefixOpen);
  const metricMatch = metricPrefix.match(/[A-Za-z:][\w:]*$/);
  if (metricMatch) {
    labels["__name__"] = { value: `"${metricMatch[0]}"`, operator: "=" };
  }
  const labelKeys = Object.keys(labels).sort();
  const cleanSelector = labelKeys.map((key) => `${key}${labels[key].operator}${labels[key].value}`).join(",");
  const selectorString = ["{", cleanSelector, "}"].join("");
  return { labelKeys, selector: selectorString };
}
function expandRecordingRules(query, mapping) {
  const getRuleRegex = (ruleName) => new RegExp(`(\\s|\\(|^)(${ruleName})(\\s|$|\\(|\\[|\\{)`, "ig");
  const tmpSplitParts = Object.keys(mapping).reduce(
    (prev, curr) => {
      let parts = [];
      let tmpParts = [];
      let removeIdx = [];
      prev.filter(Boolean).forEach((p, i) => {
        const doesMatch = p.match(getRuleRegex(curr));
        if (doesMatch) {
          parts = p.split(curr);
          if (parts.length === 2) {
            removeIdx.push(i);
            tmpParts.push(...[parts[0], curr, parts[1]].filter(Boolean));
          } else if (parts.length > 2) {
            removeIdx.push(i);
            parts = parts.map((p2) => p2 === "" ? curr : p2);
            tmpParts.push(...parts);
          }
        }
      });
      removeIdx.forEach((ri) => prev[ri] = "");
      prev = prev.filter(Boolean);
      prev.push(...tmpParts);
      return prev;
    },
    [query]
  );
  let labelFound = false;
  const trulyExpandedQuery = tmpSplitParts.map((tsp, i) => {
    if (labelFound) {
      labelFound = false;
      return "";
    }
    if (mapping[tsp]) {
      const { expandedQuery: recordingRule, identifierValue, identifier } = mapping[tsp];
      if (i + 1 !== tmpSplitParts.length && tmpSplitParts[i + 1].match(labelRegexp)) {
        labelFound = true;
        const regexp = new RegExp(`(,)?(\\s)?(${identifier}=\\"${identifierValue}\\")(,)?(\\s)?`, "g");
        const labels = tmpSplitParts[i + 1].replace(regexp, "");
        const invalidLabelsRegex = /(\)\{|\}\{|\]\{)/;
        return addLabelsToExpression(recordingRule + labels, invalidLabelsRegex);
      } else {
        return recordingRule;
      }
    }
    return tsp;
  });
  return trulyExpandedQuery.filter(Boolean).join("");
}
function addLabelsToExpression(expr, invalidLabelsRegexp) {
  var _a;
  const match = expr.match(invalidLabelsRegexp);
  if (!match) {
    return expr;
  }
  const indexOfRegexMatch = (_a = match.index) != null ? _a : 0;
  const exprBeforeRegexMatch = expr.slice(0, indexOfRegexMatch + 1);
  const exprAfterRegexMatch = expr.slice(indexOfRegexMatch + 1);
  const arrayOfLabelObjects = [];
  exprAfterRegexMatch.replace(labelRegexp, (label, key, operator, value, comma, space) => {
    arrayOfLabelObjects.push({ key, operator, value, comma, space });
    return "";
  });
  let result = exprBeforeRegexMatch;
  arrayOfLabelObjects.filter(Boolean).forEach((obj) => {
    const value = obj.value.slice(1, -1);
    result = addLabelToQuery(result, obj.key, value, obj.operator);
  });
  let existingLabel = arrayOfLabelObjects.reduce((prev, curr) => {
    var _a2, _b;
    prev += `${curr.key}${curr.operator}${curr.value}${(_a2 = curr.comma) != null ? _a2 : ""}${(_b = curr.space) != null ? _b : ""}`;
    return prev;
  }, "");
  existingLabel = "{" + existingLabel + "}";
  const potentialLeftOver = exprAfterRegexMatch.replace(existingLabel, "");
  return result + potentialLeftOver;
}
function fixSummariesMetadata(metadata) {
  if (!metadata) {
    return metadata;
  }
  const baseMetadata = {};
  const summaryMetadata = {};
  for (const metric in metadata) {
    const item = metadata[metric][0];
    baseMetadata[metric] = item;
    if (item.type === "histogram") {
      summaryMetadata[`${metric}_bucket`] = {
        type: "counter",
        help: `Cumulative counters for the observation buckets (${item.help})`
      };
      summaryMetadata[`${metric}_count`] = {
        type: "counter",
        help: `Count of events that have been observed for the histogram metric (${item.help})`
      };
      summaryMetadata[`${metric}_sum`] = {
        type: "counter",
        help: `Total sum of all observed values for the histogram metric (${item.help})`
      };
    }
    if (item.type === "summary") {
      summaryMetadata[`${metric}_count`] = {
        type: "counter",
        help: `Count of events that have been observed for the base metric (${item.help})`
      };
      summaryMetadata[`${metric}_sum`] = {
        type: "counter",
        help: `Total sum of all observed values for the base metric (${item.help})`
      };
    }
  }
  const syntheticMetadata = {};
  syntheticMetadata["ALERTS"] = {
    type: "gauge",
    help: "Time series showing pending and firing alerts. The sample value is set to 1 as long as the alert is in the indicated active (pending or firing) state."
  };
  return { ...baseMetadata, ...summaryMetadata, ...syntheticMetadata };
}
function roundMsToMin(milliseconds) {
  return roundSecToMin(milliseconds / 1e3);
}
function roundSecToMin(seconds) {
  return Math.floor(seconds / 60);
}
function roundSecToNextMin(seconds, secondsToRound = 1) {
  return Math.ceil(seconds / 60) - Math.ceil(seconds / 60) % secondsToRound;
}
function limitSuggestions(items) {
  return items.slice(0, SUGGESTIONS_LIMIT);
}
function addLimitInfo(items) {
  return items && items.length >= SUGGESTIONS_LIMIT ? `, limited to the first ${SUGGESTIONS_LIMIT} received items` : "";
}
const FromPromLikeMap = {
  "=": data.AbstractLabelOperator.Equal,
  "!=": data.AbstractLabelOperator.NotEqual,
  "=~": data.AbstractLabelOperator.EqualRegEx,
  "!~": data.AbstractLabelOperator.NotEqualRegEx
};
const ToPromLikeMap = lodash.invert(FromPromLikeMap);
function toPromLikeExpr(labelBasedQuery) {
  const expr = labelBasedQuery.labelMatchers.map((selector) => {
    const operator = ToPromLikeMap[selector.operator];
    if (operator) {
      return `${selector.name}${operator}"${selector.value}"`;
    } else {
      return "";
    }
  }).filter((e) => e !== "").join(", ");
  return expr ? `{${expr}}` : "";
}
function toPromLikeQuery(labelBasedQuery) {
  return {
    refId: labelBasedQuery.refId,
    expr: toPromLikeExpr(labelBasedQuery),
    range: true
  };
}
function getMaybeTokenStringContent(token) {
  if (typeof token.content === "string") {
    return token.content;
  }
  return "";
}
function extractLabelMatchers(tokens) {
  const labelMatchers = [];
  for (const token of tokens) {
    if (!(token instanceof Prism.Token)) {
      continue;
    }
    if (token.type === "context-labels") {
      let labelKey = "";
      let labelValue = "";
      let labelOperator = "";
      const contentTokens = Array.isArray(token.content) ? token.content : [token.content];
      for (let currentToken of contentTokens) {
        if (typeof currentToken === "string") {
          let currentStr;
          currentStr = currentToken;
          if (currentStr === "=" || currentStr === "!=" || currentStr === "=~" || currentStr === "!~") {
            labelOperator = currentStr;
          }
        } else if (currentToken instanceof Prism.Token) {
          switch (currentToken.type) {
            case "label-key":
              labelKey = getMaybeTokenStringContent(currentToken);
              break;
            case "label-value":
              labelValue = getMaybeTokenStringContent(currentToken);
              labelValue = labelValue.substring(1, labelValue.length - 1);
              const labelComparator = FromPromLikeMap[labelOperator];
              if (labelComparator) {
                labelMatchers.push({ name: labelKey, operator: labelComparator, value: labelValue });
              }
              break;
          }
        }
      }
    }
  }
  return labelMatchers;
}
function getRangeSnapInterval(cacheLevel, range) {
  if (cacheLevel === PrometheusCacheLevel.None) {
    return {
      start: getPrometheusTime(range.from, false).toString(),
      end: getPrometheusTime(range.to, true).toString()
    };
  }
  const startTime = getPrometheusTime(range.from, false);
  const startTimeQuantizedSeconds = data.incrRoundDn(startTime, getCacheDurationInMinutes(cacheLevel) * 60);
  const endTime = getPrometheusTime(range.to, true);
  const endTimeQuantizedSeconds = roundSecToNextMin(endTime, getCacheDurationInMinutes(cacheLevel)) * 60;
  if (startTimeQuantizedSeconds === endTimeQuantizedSeconds) {
    const endTimePlusOneStep = endTimeQuantizedSeconds + getCacheDurationInMinutes(cacheLevel) * 60;
    return { start: startTimeQuantizedSeconds.toString(), end: endTimePlusOneStep.toString() };
  }
  const start = startTimeQuantizedSeconds.toString();
  const end = endTimeQuantizedSeconds.toString();
  return { start, end };
}
function getPrometheusTime(date, roundUp) {
  if (typeof date === "string") {
    date = data.dateMath.parse(date, roundUp);
  }
  return Math.ceil(date.valueOf() / 1e3);
}
function truncateResult(array, limit) {
  if (limit === void 0) {
    limit = PROMETHEUS_QUERY_BUILDER_MAX_RESULTS;
  }
  array.length = Math.min(array.length, limit);
  return array;
}

"use strict";
function LabelFilterItem({
  item,
  defaultOp,
  onChange,
  onDelete,
  onGetLabelNames,
  onGetLabelValues,
  invalidLabel,
  invalidValue,
  getLabelValuesAutofillSuggestions,
  debounceDuration
}) {
  var _a, _b, _c, _d;
  const [state, setState] = React.useState({});
  const [labelNamesMenuOpen, setLabelNamesMenuOpen] = React.useState(false);
  const [labelValuesMenuOpen, setLabelValuesMenuOpen] = React.useState(false);
  const [allLabels, setAllLabels] = React.useState([]);
  const isMultiSelect = (operator = item.op) => {
    var _a2;
    return (_a2 = operators$2.find((op) => op.label === operator)) == null ? void 0 : _a2.isMultiValue;
  };
  const getSelectOptionsFromString = (item2) => {
    if (item2) {
      const regExp = /\(([^)]+)\)/;
      const matches = item2 == null ? void 0 : item2.match(regExp);
      if (matches && matches[0].indexOf("|") > 0) {
        return [item2];
      }
      if (item2.indexOf("|") > 0) {
        return item2.split("|");
      }
      return [item2];
    }
    return [];
  };
  const labelValueSearch = debounce__default.default(
    (query) => getLabelValuesAutofillSuggestions(query, item.label),
    debounceDuration
  );
  const labelNamesSearch = debounce__default.default((query) => {
    const results = allLabels.filter((label) => {
      return label.value.includes(query);
    });
    return truncateResult(results);
  }, debounceDuration);
  const itemValue = (_a = item == null ? void 0 : item.value) != null ? _a : "";
  return /* @__PURE__ */ jsxRuntime.jsx("div", { "data-testid": "prometheus-dimensions-filter-item", children: /* @__PURE__ */ jsxRuntime.jsxs(pluginUi.InputGroup, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.AsyncSelect,
      {
        placeholder: i18n.t("grafana-prometheus.querybuilder.label-filter-item.placeholder-select-label", "Select label"),
        "data-testid": e2eSelectors.selectors.components.QueryBuilder.labelSelect,
        inputId: "prometheus-dimensions-filter-item-key",
        width: "auto",
        value: item.label ? data.toOption(item.label) : null,
        allowCustomValue: true,
        onOpenMenu: async () => {
          setState({ isLoadingLabelNames: true });
          const labelNames = await onGetLabelNames(item);
          setAllLabels(labelNames);
          setLabelNamesMenuOpen(true);
          const truncatedLabelNames = truncateResult(labelNames);
          setState({ labelNames: truncatedLabelNames, isLoadingLabelNames: void 0 });
        },
        onCloseMenu: () => {
          setLabelNamesMenuOpen(false);
        },
        isOpen: labelNamesMenuOpen,
        isLoading: (_b = state.isLoadingLabelNames) != null ? _b : false,
        loadOptions: labelNamesSearch,
        defaultOptions: state.labelNames,
        onChange: (change) => {
          var _a2;
          if (change.label) {
            onChange({
              ...item,
              op: (_a2 = item.op) != null ? _a2 : defaultOp,
              label: change.label
              // eslint-ignore
            });
          }
        },
        invalid: invalidLabel
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.Select,
      {
        "data-testid": e2eSelectors.selectors.components.QueryBuilder.matchOperatorSelect,
        className: "query-segment-operator",
        value: data.toOption((_c = item.op) != null ? _c : defaultOp),
        options: operators$2,
        width: "auto",
        onChange: (change) => {
          if (change.value != null) {
            onChange({
              ...item,
              op: change.value,
              value: isMultiSelect(change.value) ? item.value : getSelectOptionsFromString(item == null ? void 0 : item.value)[0]
              // eslint-ignore
            });
          }
        }
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.AsyncSelect,
      {
        placeholder: i18n.t("grafana-prometheus.querybuilder.label-filter-item.placeholder-select-value", "Select value"),
        "data-testid": e2eSelectors.selectors.components.QueryBuilder.valueSelect,
        inputId: "prometheus-dimensions-filter-item-value",
        width: "auto",
        value: isMultiSelect() ? getSelectOptionsFromString(itemValue).map(data.toOption) : getSelectOptionsFromString(itemValue).map(data.toOption)[0],
        allowCustomValue: true,
        formatCreateLabel: (input) => input,
        createOptionPosition: ((_d = item.op) == null ? void 0 : _d.includes("~")) ? "first" : "last",
        onOpenMenu: async () => {
          setState({ isLoadingLabelValues: true });
          const labelValues = await onGetLabelValues(item);
          truncateResult(labelValues);
          setLabelValuesMenuOpen(true);
          setState({
            ...state,
            labelValues,
            isLoadingLabelValues: void 0
          });
        },
        onCloseMenu: () => {
          setLabelValuesMenuOpen(false);
        },
        isOpen: labelValuesMenuOpen,
        defaultOptions: state.labelValues,
        isMulti: isMultiSelect(),
        isLoading: state.isLoadingLabelValues,
        loadOptions: labelValueSearch,
        onChange: (change) => {
          var _a2, _b2;
          if (change.value) {
            onChange({
              ...item,
              value: change.value,
              op: (_a2 = item.op) != null ? _a2 : defaultOp
              // eslint-ignore
            });
          } else {
            const changes = change.map((change2) => {
              return change2.label;
            }).join("|");
            onChange({ ...item, value: changes, op: (_b2 = item.op) != null ? _b2 : defaultOp });
          }
        },
        invalid: invalidValue
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      pluginUi.AccessoryButton,
      {
        "aria-label": i18n.t("grafana-prometheus.querybuilder.label-filter-item.aria-label-remove", "Remove {{name}}", {
          name: item.label
        }),
        icon: "times",
        variant: "secondary",
        onClick: onDelete
      }
    )
  ] }) }, itemValue);
}
const operators$2 = [
  { label: "=", value: "=", isMultiValue: false },
  { label: "!=", value: "!=", isMultiValue: false },
  { label: "=~", value: "=~", isMultiValue: true },
  { label: "!~", value: "!~", isMultiValue: true }
];

"use strict";
const MISSING_LABEL_FILTER_ERROR_MESSAGE = "Select at least 1 label filter (label and value)";
function LabelFilters({
  labelsFilters,
  onChange,
  onGetLabelNames,
  onGetLabelValues,
  labelFilterRequired,
  getLabelValuesAutofillSuggestions,
  debounceDuration,
  variableEditor
}) {
  const defaultOp = "=";
  const [items, setItems] = React.useState([{ op: defaultOp }]);
  React.useEffect(() => {
    if (labelsFilters.length > 0) {
      setItems(labelsFilters);
    } else {
      setItems([{ op: defaultOp }]);
    }
  }, [labelsFilters]);
  const onLabelsChange = (newItems) => {
    setItems(newItems);
    const newLabels = newItems.filter((x) => x.label != null && x.value != null);
    if (!lodash.isEqual(newLabels, labelsFilters)) {
      onChange(newLabels);
    }
  };
  const hasLabelFilter = items.some((item) => item.label && item.value);
  const editorList = () => {
    return /* @__PURE__ */ jsxRuntime.jsx(
      pluginUi.EditorList,
      {
        items,
        onChange: onLabelsChange,
        renderItem: (item, onChangeItem, onDelete) => /* @__PURE__ */ jsxRuntime.jsx(
          LabelFilterItem,
          {
            debounceDuration,
            item,
            defaultOp,
            onChange: onChangeItem,
            onDelete,
            onGetLabelNames,
            onGetLabelValues,
            invalidLabel: labelFilterRequired && !item.label,
            invalidValue: labelFilterRequired && !item.value,
            getLabelValuesAutofillSuggestions
          }
        )
      }
    );
  };
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: variableEditor ? /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFieldRow, { children: /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      className: css.cx(
        css.css({
          display: "flex"
        })
      ),
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          ui.InlineLabel,
          {
            width: 20,
            tooltip: /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.label-filters.tooltip-label-filters", children: "Optional: used to filter the metric select for this query type." }) }),
            children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.label-filters.label-filters", children: "Label filters" })
          }
        ),
        editorList()
      ]
    }
  ) }) : /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorFieldGroup, { children: /* @__PURE__ */ jsxRuntime.jsx(
    pluginUi.EditorField,
    {
      label: i18n.t("grafana-prometheus.querybuilder.label-filters.label-label-filters", "Label filters"),
      error: MISSING_LABEL_FILTER_ERROR_MESSAGE,
      invalid: labelFilterRequired && !hasLabelFilter,
      children: editorList()
    }
  ) }) });
}

"use strict";
const metricsModaltestIds$1 = {
  metricModal: "metric-modal",
  searchMetric: "search-metric",
  searchWithMetadata: "search-with-metadata",
  selectType: "select-type",
  metricCard: "metric-card",
  useMetric: "use-metric",
  searchPage: "search-page",
  resultsPerPage: "results-per-page",
  setUseBackend: "set-use-backend",
  showAdditionalSettings: "show-additional-settings"
};

"use strict";
const DEFAULT_RESULTS_PER_PAGE = 100;
const MAXIMUM_RESULTS_PER_PAGE = 1e3;
function initialState$1(query) {
  var _a, _b, _c, _d;
  return {
    isLoading: true,
    metrics: [],
    hasMetadata: true,
    metaHaystackDictionary: {},
    metaHaystackMatches: [],
    metaHaystackOrder: [],
    nameHaystackDictionary: {},
    nameHaystackOrder: [],
    nameHaystackMatches: [],
    totalMetricCount: 0,
    filteredMetricCount: null,
    resultsPerPage: DEFAULT_RESULTS_PER_PAGE,
    pageNum: 1,
    fuzzySearchQuery: "",
    fullMetaSearch: (_a = query == null ? void 0 : query.fullMetaSearch) != null ? _a : false,
    includeNullMetadata: (_b = query == null ? void 0 : query.includeNullMetadata) != null ? _b : true,
    selectedTypes: [],
    useBackend: (_c = query == null ? void 0 : query.useBackend) != null ? _c : false,
    disableTextWrap: (_d = query == null ? void 0 : query.disableTextWrap) != null ? _d : false,
    showAdditionalSettings: false
  };
}
function getSettings(visQuery) {
  var _a, _b, _c, _d;
  return {
    useBackend: (_a = visQuery == null ? void 0 : visQuery.useBackend) != null ? _a : false,
    disableTextWrap: (_b = visQuery == null ? void 0 : visQuery.disableTextWrap) != null ? _b : false,
    fullMetaSearch: (_c = visQuery == null ? void 0 : visQuery.fullMetaSearch) != null ? _c : false,
    includeNullMetadata: (_d = visQuery.includeNullMetadata) != null ? _d : false
  };
}
const stateSlice$1 = toolkit.createSlice({
  name: "metrics-modal-state",
  initialState: initialState$1(),
  reducers: {
    filterMetricsBackend: (state, action) => {
      state.metrics = action.payload.metrics;
      state.filteredMetricCount = action.payload.filteredMetricCount;
      state.isLoading = action.payload.isLoading;
    },
    buildMetrics: (state, action) => {
      state.isLoading = action.payload.isLoading;
      state.metrics = action.payload.metrics;
      state.hasMetadata = action.payload.hasMetadata;
      state.metaHaystackDictionary = action.payload.metaHaystackDictionary;
      state.nameHaystackDictionary = action.payload.nameHaystackDictionary;
      state.totalMetricCount = action.payload.totalMetricCount;
      state.filteredMetricCount = action.payload.filteredMetricCount;
    },
    setIsLoading: (state, action) => {
      state.isLoading = action.payload;
    },
    setFilteredMetricCount: (state, action) => {
      state.filteredMetricCount = action.payload;
    },
    setResultsPerPage: (state, action) => {
      state.resultsPerPage = action.payload;
    },
    setPageNum: (state, action) => {
      state.pageNum = action.payload;
    },
    setFuzzySearchQuery: (state, action) => {
      state.fuzzySearchQuery = action.payload;
      state.pageNum = 1;
    },
    setNameHaystack: (state, action) => {
      state.nameHaystackOrder = action.payload[0];
      state.nameHaystackMatches = action.payload[1];
    },
    setMetaHaystack: (state, action) => {
      state.metaHaystackOrder = action.payload[0];
      state.metaHaystackMatches = action.payload[1];
    },
    setFullMetaSearch: (state, action) => {
      state.fullMetaSearch = action.payload;
      state.pageNum = 1;
    },
    setIncludeNullMetadata: (state, action) => {
      state.includeNullMetadata = action.payload;
      state.pageNum = 1;
    },
    setSelectedTypes: (state, action) => {
      state.selectedTypes = action.payload;
      state.pageNum = 1;
    },
    setUseBackend: (state, action) => {
      state.useBackend = action.payload;
      state.fullMetaSearch = false;
      state.pageNum = 1;
    },
    setDisableTextWrap: (state) => {
      state.disableTextWrap = !state.disableTextWrap;
    },
    showAdditionalSettings: (state) => {
      state.showAdditionalSettings = !state.showAdditionalSettings;
    }
  }
});
const {
  setIsLoading: setIsLoading$1,
  buildMetrics: buildMetrics$1,
  filterMetricsBackend: filterMetricsBackend$1,
  setResultsPerPage: setResultsPerPage$1,
  setPageNum: setPageNum$1,
  setFuzzySearchQuery: setFuzzySearchQuery$1,
  setNameHaystack: setNameHaystack$1,
  setMetaHaystack: setMetaHaystack$1,
  setFullMetaSearch: setFullMetaSearch$1,
  setIncludeNullMetadata: setIncludeNullMetadata$1,
  setSelectedTypes: setSelectedTypes$1,
  setUseBackend: setUseBackend$1,
  setDisableTextWrap: setDisableTextWrap$1,
  showAdditionalSettings: showAdditionalSettings$1,
  setFilteredMetricCount: setFilteredMetricCount$1
} = stateSlice$1.actions;

"use strict";
async function setMetrics(datasource, query, initialMetrics) {
  var _a, _b;
  let hasMetadata = true;
  const metadata = datasource.languageProvider.retrieveMetricsMetadata();
  if (metadata && Object.keys(metadata).length === 0) {
    hasMetadata = false;
  }
  let nameHaystackDictionaryData = {};
  let metaHaystackDictionaryData = {};
  let metricsData;
  metricsData = initialMetrics == null ? void 0 : initialMetrics.map((m) => {
    const metricData = buildMetricData(m, datasource);
    const metaDataString = `${m}\xA6${metricData.description}`;
    nameHaystackDictionaryData[m] = metricData;
    metaHaystackDictionaryData[metaDataString] = metricData;
    return metricData;
  });
  return {
    isLoading: false,
    hasMetadata,
    metrics: metricsData != null ? metricsData : [],
    metaHaystackDictionary: metaHaystackDictionaryData,
    nameHaystackDictionary: nameHaystackDictionaryData,
    totalMetricCount: (_a = metricsData == null ? void 0 : metricsData.length) != null ? _a : 0,
    filteredMetricCount: (_b = metricsData == null ? void 0 : metricsData.length) != null ? _b : 0
  };
}
function buildMetricData(metric, datasource) {
  let type = getMetadataType(metric, datasource.languageProvider.retrieveMetricsMetadata());
  const description = getMetadataHelp(metric, datasource.languageProvider.retrieveMetricsMetadata());
  ["histogram", "summary"].forEach((t) => {
    if ((description == null ? void 0 : description.toLowerCase().includes(t)) && type !== t) {
      type += ` (${t})`;
    }
  });
  const oldHistogramMatch = metric.match(/^\w+_bucket$|^\w+_bucket{.*}$/);
  if (type === "histogram" && !oldHistogramMatch) {
    type = "native histogram";
  }
  const metricData = {
    value: metric,
    type,
    description
  };
  return metricData;
}
function getMetadataHelp(metric, metadata) {
  var _a;
  return (_a = metadata[metric]) == null ? void 0 : _a.help;
}
function getMetadataType(metric, metadata) {
  var _a;
  return (_a = metadata[metric]) == null ? void 0 : _a.type;
}
function displayedMetrics(state, dispatch) {
  const filteredSorted = filterMetrics(state);
  if (!state.isLoading && state.filteredMetricCount !== filteredSorted.length) {
    dispatch(setFilteredMetricCount$1(filteredSorted.length));
  }
  return sliceMetrics(filteredSorted, state.pageNum, state.resultsPerPage);
}
function filterMetrics(state) {
  let filteredMetrics = state.metrics;
  if (state.fuzzySearchQuery && !state.useBackend) {
    if (state.fullMetaSearch) {
      filteredMetrics = state.metaHaystackOrder.map((needle) => state.metaHaystackDictionary[needle]);
    } else {
      filteredMetrics = state.nameHaystackOrder.map((needle) => state.nameHaystackDictionary[needle]);
    }
  }
  if (state.selectedTypes.length > 0) {
    filteredMetrics = filteredMetrics.filter((m, idx) => {
      const matchesSelectedType = state.selectedTypes.some((t) => {
        if (m.type && t.value) {
          return m.type.includes(t.value);
        }
        if (!m.type && t.value === "no type") {
          return true;
        }
        return false;
      });
      return matchesSelectedType;
    });
  }
  if (!state.includeNullMetadata) {
    filteredMetrics = filteredMetrics.filter((m) => {
      return m.type !== void 0 && m.description !== void 0;
    });
  }
  return filteredMetrics;
}
function calculatePageList(state) {
  if (!state.metrics.length) {
    return [];
  }
  const calcResultsPerPage = state.resultsPerPage === 0 ? 1 : state.resultsPerPage;
  const pages = Math.floor(filterMetrics(state).length / calcResultsPerPage) + 1;
  return [...Array(pages).keys()].map((i) => i + 1);
}
function sliceMetrics(metrics, pageNum, resultsPerPage) {
  const calcResultsPerPage = resultsPerPage === 0 ? 1 : resultsPerPage;
  const start = pageNum === 1 ? 0 : (pageNum - 1) * calcResultsPerPage;
  const end = start + calcResultsPerPage;
  return metrics.slice(start, end);
}
const calculateResultsPerPage = (results, defaultResults, max) => {
  if (results < 1) {
    return 1;
  }
  if (results > max) {
    return max;
  }
  return results != null ? results : defaultResults;
};
async function getBackendSearchMetrics(metricText, labels, datasource) {
  const queryString = regexifyLabelValuesQueryString(metricText);
  const labelsParams = labels.map((label) => {
    return `,${label.label}="${label.value}"`;
  });
  const params = `label_values({__name__=~".*${queryString}"${labels ? labelsParams.join() : ""}},__name__)`;
  const results = datasource.metricFindQuery(params);
  return await results.then((results2) => {
    return results2.map((result) => buildMetricData(result.text, datasource));
  });
}
function tracking(event, state, metric, query) {
  switch (event) {
    case "grafana_prom_metric_encycopedia_tracking":
      runtime.reportInteraction(event, {
        metric,
        hasMetadata: state == null ? void 0 : state.hasMetadata,
        totalMetricCount: state == null ? void 0 : state.totalMetricCount,
        fuzzySearchQuery: state == null ? void 0 : state.fuzzySearchQuery,
        fullMetaSearch: state == null ? void 0 : state.fullMetaSearch,
        selectedTypes: state == null ? void 0 : state.selectedTypes,
        useRegexSearch: state == null ? void 0 : state.useBackend,
        includeResultsWithoutMetadata: state == null ? void 0 : state.includeNullMetadata
      });
    case "grafana_prom_metric_encycopedia_disable_text_wrap_interaction":
      runtime.reportInteraction(event, {
        disableTextWrap: state == null ? void 0 : state.disableTextWrap
      });
    case "grafana_prometheus_metric_encyclopedia_open":
      runtime.reportInteraction(event, {
        query
      });
  }
}
const promTypes = [
  {
    value: "counter",
    description: "A cumulative metric that represents a single monotonically increasing counter whose value can only increase or be reset to zero on restart."
  },
  {
    value: "gauge",
    description: "A metric that represents a single numerical value that can arbitrarily go up and down."
  },
  {
    value: "histogram",
    description: "A histogram samples observations (usually things like request durations or response sizes) and counts them in configurable buckets."
  },
  {
    value: "native histogram",
    description: "Native histograms are different from classic Prometheus histograms in a number of ways: Native histogram bucket boundaries are calculated by a formula that depends on the scale (resolution) of the native histogram, and are not user defined."
  },
  {
    value: "summary",
    description: "A summary samples observations (usually things like request durations and response sizes) and can calculate configurable quantiles over a sliding time window."
  },
  {
    value: "unknown",
    description: "These metrics have been given the type unknown in the metadata."
  },
  {
    value: "no type",
    description: "These metrics have no defined type in the metadata."
  }
];
const placeholders = {
  browse: "Search metrics by name",
  metadataSearchSwitch: "Include description in search",
  type: "Filter by type",
  includeNullMetadata: "Include results with no metadata",
  setUseBackend: "Enable regex search"
};

"use strict";
function AdditionalSettings(props) {
  const { state, onChangeFullMetaSearch, onChangeIncludeNullMetadata, onChangeDisableTextWrap, onChangeUseBackend } = props;
  const theme = ui.useTheme2();
  const styles = getStyles$a(theme);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.selectItem, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Switch,
        {
          "data-testid": metricsModaltestIds$1.searchWithMetadata,
          value: state.fullMetaSearch,
          disabled: state.useBackend || !state.hasMetadata,
          onChange: () => onChangeFullMetaSearch()
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.selectItemLabel, children: placeholders.metadataSearchSwitch })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.selectItem, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Switch,
        {
          value: state.includeNullMetadata,
          disabled: !state.hasMetadata,
          onChange: () => onChangeIncludeNullMetadata()
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.selectItemLabel, children: placeholders.includeNullMetadata })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.selectItem, children: [
      /* @__PURE__ */ jsxRuntime.jsx(ui.Switch, { value: state.disableTextWrap, onChange: () => onChangeDisableTextWrap() }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.selectItemLabel, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.additional-settings.disable-text-wrap", children: "Disable text wrap" }) })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.selectItem, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Switch,
        {
          "data-testid": metricsModaltestIds$1.setUseBackend,
          value: state.useBackend,
          onChange: () => onChangeUseBackend()
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.selectItemLabel, children: [
        placeholders.setUseBackend,
        "\xA0"
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Tooltip,
        {
          content: i18n.t(
            "grafana-prometheus.querybuilder.additional-settings.content-filter-metric-names-regex-search-using",
            "Filter metric names by regex search, using an additional call on the Prometheus API."
          ),
          placement: "bottom-end",
          children: /* @__PURE__ */ jsxRuntime.jsx(ui.Icon, { name: "info-circle", size: "xs", className: styles.settingsIcon })
        }
      )
    ] })
  ] });
}
function getStyles$a(theme) {
  return {
    settingsIcon: css.css({
      color: theme.colors.text.secondary
    }),
    selectItem: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "center",
      padding: "4px 0"
    }),
    selectItemLabel: css.css({
      margin: `0 0 0 ${theme.spacing(1)}`,
      alignSelf: "center",
      color: theme.colors.text.secondary,
      fontSize: "12px"
    })
  };
}

"use strict";
function FeedbackLink({ feedbackUrl }) {
  const styles = ui.useStyles2(getStyles$9);
  return /* @__PURE__ */ jsxRuntime.jsx(ui.Stack, { children: /* @__PURE__ */ jsxRuntime.jsxs(
    "a",
    {
      href: feedbackUrl,
      className: styles.link,
      title: i18n.t(
        "grafana-prometheus.querybuilder.feedback-link.title-give-feedback",
        "The metrics explorer is new, please let us know how we can improve it"
      ),
      target: "_blank",
      rel: "noreferrer noopener",
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(ui.Icon, { name: "comment-alt-message" }),
        " ",
        /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.feedback-link.give-feedback", children: "Give feedback" })
      ]
    }
  ) });
}
function getStyles$9(theme) {
  return {
    link: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize,
      ":hover": {
        color: theme.colors.text.link
      },
      margin: `-25px 0 30px 0`
    })
  };
}

"use strict";
function docsTip(url) {
  const docsUrl = "https://grafana.com/docs/grafana/latest/datasources/prometheus/configure-prometheus-data-source/";
  return /* @__PURE__ */ jsxRuntime.jsx(ui.TextLink, { href: url ? url : docsUrl, external: true, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.docs-tip.visit-docs-for-more-details-here", children: "Visit docs for more details here." }) });
}
const validateInput = (input, pattern, errorMessage) => {
  const defaultErrorMessage = "Value is not valid";
  const inputTooLongErrorMessage = "Input is too long";
  const validationTimeoutErrorMessage = "Validation timeout - input too complex";
  const invalidValidationPatternErrorMessage = "Invalid validation pattern";
  const MAX_INPUT_LENGTH = 1e3;
  if (!input) {
    return true;
  }
  if (input.length > MAX_INPUT_LENGTH) {
    return /* @__PURE__ */ jsxRuntime.jsx(ui.FieldValidationMessage, { children: inputTooLongErrorMessage });
  }
  try {
    let regex = typeof pattern === "string" ? new RegExp(pattern) : pattern;
    if (typeof pattern === "string" && !pattern.startsWith("^") && !pattern.endsWith("$")) {
      regex = new RegExp(`^${pattern}$`);
    }
    const timeout = 100;
    const startTime = Date.now();
    const isValid = regex.test(input);
    if (Date.now() - startTime > timeout) {
      return /* @__PURE__ */ jsxRuntime.jsx(ui.FieldValidationMessage, { children: validationTimeoutErrorMessage });
    }
    if (!isValid) {
      return /* @__PURE__ */ jsxRuntime.jsx(ui.FieldValidationMessage, { children: errorMessage || defaultErrorMessage });
    }
    return true;
  } catch (error) {
    return /* @__PURE__ */ jsxRuntime.jsx(ui.FieldValidationMessage, { children: invalidValidationPatternErrorMessage });
  }
};
function overhaulStyles(theme) {
  return {
    additionalSettings: css.css({
      marginBottom: "25px"
    }),
    secondaryGrey: css.css({
      color: theme.colors.secondary.text,
      opacity: "65%"
    }),
    inlineError: css.css({
      margin: "0px 0px 4px 245px"
    }),
    switchField: css.css({
      alignItems: "center"
    }),
    sectionHeaderPadding: css.css({
      paddingTop: "32px"
    }),
    sectionBottomPadding: css.css({
      paddingBottom: "28px"
    }),
    subsectionText: css.css({
      fontSize: "12px"
    }),
    hrBottomSpace: css.css({
      marginBottom: "56px"
    }),
    hrTopSpace: css.css({
      marginTop: "50px"
    }),
    textUnderline: css.css({
      textDecoration: "underline"
    }),
    versionMargin: css.css({
      marginBottom: "12px"
    }),
    advancedHTTPSettingsMargin: css.css({
      margin: "24px 0 8px 0"
    }),
    advancedSettings: css.css({
      paddingTop: "32px"
    }),
    alertingTop: css.css({
      marginTop: "40px !important"
    }),
    overhaulPageHeading: css.css({
      fontWeight: 400
    }),
    container: css.css({
      maxwidth: 578
    })
  };
}

"use strict";
function ResultsTable(props) {
  const { metrics, onChange, onClose, query, state, disableTextWrap } = props;
  const theme = ui.useTheme2();
  const styles = getStyles$8(theme, disableTextWrap);
  function selectMetric(metric) {
    if (metric.value) {
      onChange({ ...query, metric: metric.value });
      tracking("grafana_prom_metric_encycopedia_tracking", state, metric.value);
      onClose();
    }
  }
  function metaRows(metric) {
    var _a, _b, _c, _d;
    if (state.fullMetaSearch && metric) {
      return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsx("td", { children: displayType((_a = metric.type) != null ? _a : "") }),
        /* @__PURE__ */ jsxRuntime.jsx("td", { children: /* @__PURE__ */ jsxRuntime.jsx(
          Highlighter__default.default,
          {
            textToHighlight: (_b = metric.description) != null ? _b : "",
            searchWords: state.metaHaystackMatches,
            autoEscape: true,
            highlightClassName: styles.matchHighLight
          }
        ) })
      ] });
    } else {
      return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsx("td", { children: displayType((_c = metric.type) != null ? _c : "") }),
        /* @__PURE__ */ jsxRuntime.jsx("td", { children: (_d = metric.description) != null ? _d : "" })
      ] });
    }
  }
  function addHelpIcon(fullType, descriptiveType, link) {
    return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      fullType,
      /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.tooltipSpace, children: /* @__PURE__ */ jsxRuntime.jsx(
        ui.Tooltip,
        {
          content: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
            /* @__PURE__ */ jsxRuntime.jsxs(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.results-table.content-descriptive-type", children: [
              "When creating a ",
              { descriptiveType },
              ", Prometheus exposes multiple series with the type counter.",
              " "
            ] }),
            docsTip(link)
          ] }),
          placement: "bottom-start",
          interactive: true,
          children: /* @__PURE__ */ jsxRuntime.jsx(ui.Icon, { name: "info-circle", size: "xs" })
        }
      ) })
    ] });
  }
  function displayType(type) {
    if (!type) {
      return "";
    }
    if (type.includes("(summary)")) {
      return addHelpIcon(type, "summary", "https://prometheus.io/docs/concepts/metric_types/#summary");
    }
    if (type.includes("(histogram)")) {
      return addHelpIcon(type, "histogram", "https://prometheus.io/docs/concepts/metric_types/#histogram");
    }
    return type;
  }
  function noMetricsMessages() {
    let message;
    if (!state.fuzzySearchQuery) {
      message = "There are no metrics found in the data source.";
    }
    if (query.labels.length > 0) {
      message = "There are no metrics found. Try to expand your label filters.";
    }
    if (state.fuzzySearchQuery || state.selectedTypes.length > 0) {
      message = "There are no metrics found. Try to expand your search and filters.";
    }
    return /* @__PURE__ */ jsxRuntime.jsx("tr", { className: styles.noResults, children: /* @__PURE__ */ jsxRuntime.jsx("td", { colSpan: 3, children: message }) });
  }
  function textHighlight(state2) {
    if (state2.useBackend) {
      return [state2.fuzzySearchQuery];
    } else if (state2.fullMetaSearch) {
      return state2.metaHaystackMatches;
    } else {
      return state2.nameHaystackMatches;
    }
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("table", { className: styles.table, children: [
    /* @__PURE__ */ jsxRuntime.jsx("thead", { className: styles.stickyHeader, children: /* @__PURE__ */ jsxRuntime.jsxs("tr", { children: [
      /* @__PURE__ */ jsxRuntime.jsx("th", { className: `${styles.nameWidth} ${styles.tableHeaderPadding}`, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.results-table.name", children: "Name" }) }),
      state.hasMetadata && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsx("th", { className: `${styles.typeWidth} ${styles.tableHeaderPadding}`, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.results-table.type", children: "Type" }) }),
        /* @__PURE__ */ jsxRuntime.jsx("th", { className: `${styles.descriptionWidth} ${styles.tableHeaderPadding}`, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.results-table.description", children: "Description" }) })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx("th", { className: styles.selectButtonWidth, children: " " })
    ] }) }),
    /* @__PURE__ */ jsxRuntime.jsx("tbody", { children: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      metrics.length > 0 && metrics.map((metric, idx) => {
        var _a, _b;
        return /* @__PURE__ */ jsxRuntime.jsxs("tr", { className: styles.row, children: [
          /* @__PURE__ */ jsxRuntime.jsx("td", { className: styles.nameOverflow, children: /* @__PURE__ */ jsxRuntime.jsx(
            Highlighter__default.default,
            {
              textToHighlight: (_b = metric == null ? void 0 : metric.value) != null ? _b : "",
              searchWords: textHighlight(state),
              autoEscape: true,
              highlightClassName: styles.matchHighLight
            }
          ) }),
          state.hasMetadata && metaRows(metric),
          /* @__PURE__ */ jsxRuntime.jsx("td", { children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.Button,
            {
              size: "md",
              variant: "secondary",
              onClick: () => selectMetric(metric),
              className: styles.centerButton,
              children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.results-table.select", children: "Select" })
            }
          ) })
        ] }, (_a = metric == null ? void 0 : metric.value) != null ? _a : idx);
      }),
      metrics.length === 0 && !state.isLoading && noMetricsMessages()
    ] }) })
  ] });
}
const getStyles$8 = (theme, disableTextWrap) => {
  return {
    table: css.css({
      tableLayout: disableTextWrap ? void 0 : "fixed",
      borderRadius: theme.shape.radius.default,
      width: "100%",
      whiteSpace: disableTextWrap ? "nowrap" : "normal",
      td: {
        padding: theme.spacing(1)
      },
      "td,th": {
        minWidth: theme.spacing(3),
        borderBottom: `1px solid ${theme.colors.border.weak}`
      }
    }),
    row: css.css({
      label: "row",
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      "&:last-child": {
        borderBottom: 0
      }
    }),
    tableHeaderPadding: css.css({
      padding: "8px"
    }),
    matchHighLight: css.css({
      background: "inherit",
      color: theme.components.textHighlight.text,
      backgroundColor: theme.components.textHighlight.background
    }),
    nameWidth: css.css({
      width: disableTextWrap ? void 0 : "37.5%"
    }),
    nameOverflow: css.css({
      overflowWrap: disableTextWrap ? void 0 : "anywhere"
    }),
    typeWidth: css.css({
      width: disableTextWrap ? void 0 : "15%"
    }),
    descriptionWidth: css.css({
      width: disableTextWrap ? void 0 : "35%"
    }),
    selectButtonWidth: css.css({
      width: disableTextWrap ? void 0 : "12.5%"
    }),
    stickyHeader: css.css({
      position: "sticky",
      top: 0,
      backgroundColor: theme.colors.background.primary
    }),
    noResults: css.css({
      textAlign: "center",
      color: theme.colors.text.secondary
    }),
    tooltipSpace: css.css({
      marginLeft: "4px"
    }),
    centerButton: css.css({
      display: "block",
      margin: "auto",
      border: "none"
    })
  };
};

"use strict";
const getStyles$7 = (theme, disableTextWrap) => {
  return {
    modal: css.css({
      width: "85vw",
      [theme.breakpoints.down("md")]: {
        width: "100%"
      },
      [theme.breakpoints.up("xl")]: {
        width: "60%"
      }
    }),
    inputWrapper: css.css({
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap"
    }),
    inputItemFirst: css.css({
      flexBasis: "40%",
      paddingRight: "16px",
      [theme.breakpoints.down("md")]: {
        paddingRight: "0px",
        paddingBottom: "16px"
      }
    }),
    inputItem: css.css({
      flexGrow: 1,
      flexBasis: "20%",
      [theme.breakpoints.down("md")]: {
        minWidth: "100%"
      }
    }),
    selectWrapper: css.css({
      marginBottom: theme.spacing(1)
    }),
    resultsAmount: css.css({
      color: theme.colors.text.secondary,
      fontSize: "0.85rem",
      padding: "0 0 4px 0"
    }),
    resultsData: css.css({
      margin: `4px 0 ${theme.spacing(2)} 0`
    }),
    resultsDataCount: css.css({
      margin: 0
    }),
    resultsDataFiltered: css.css({
      color: theme.colors.text.secondary,
      textAlign: "center",
      border: "solid 1px rgba(204, 204, 220, 0.25)",
      padding: "7px"
    }),
    resultsDataFilteredText: css.css({
      display: "inline",
      verticalAlign: "text-top"
    }),
    results: css.css({
      height: "calc(80vh - 310px)",
      overflowY: "scroll"
    }),
    resultsFooter: css.css({
      marginTop: "24px",
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap",
      justifyContent: "space-between",
      alignItems: "center",
      position: "sticky"
    }),
    currentlySelected: css.css({
      color: "grey",
      opacity: "75%",
      fontSize: "0.75rem"
    }),
    loadingSpinner: css.css({
      visibility: "hidden"
    }),
    visible: css.css({
      visibility: "visible"
    }),
    settingsBtn: css.css({
      float: "right"
    }),
    noBorder: css.css({
      border: "none"
    }),
    resultsPerPageLabel: css.css({
      color: theme.colors.text.secondary,
      opacity: "75%",
      paddingTop: "5px",
      fontSize: "0.85rem",
      marginRight: "8px"
    }),
    resultsPerPageWrapper: css.css({
      display: "flex"
    })
  };
};

"use strict";
const uf = new uFuzzy__default.default({
  intraMode: 1,
  intraIns: 1,
  intraSub: 1,
  intraTrn: 1,
  intraDel: 1
});
function fuzzySearch(haystack, query, dispatcher) {
  const [idxs, info, order] = uf.search(haystack, query, 0, 1e5);
  let haystackOrder = [];
  let matchesSet = /* @__PURE__ */ new Set();
  if (idxs && order) {
    const mark = (part, matched) => {
      if (matched) {
        matchesSet.add(part);
      }
    };
    for (let i = 0; i < order.length; i++) {
      let infoIdx = order[i];
      uFuzzy__default.default.highlight(haystack[info.idx[infoIdx]], info.ranges[infoIdx], mark);
      haystackOrder.push(haystack[info.idx[infoIdx]]);
    }
    dispatcher([haystackOrder, [...matchesSet]]);
  } else if (!query) {
    dispatcher([[], []]);
  }
}
const debouncedFuzzySearch = lodash.debounce(fuzzySearch, 300);

"use strict";
const MetricsModal = (props) => {
  var _a;
  const { datasource, isOpen, onClose, onChange, query, initialMetrics, timeRange } = props;
  const [state, dispatch] = React.useReducer(stateSlice$1.reducer, initialState$1(query));
  const theme = ui.useTheme2();
  const styles = getStyles$7(theme, state.disableTextWrap);
  const updateMetricsMetadata = React.useCallback(async () => {
    dispatch(setIsLoading(true));
    const metrics = typeof initialMetrics === "function" ? await initialMetrics() : initialMetrics;
    const data = await setMetrics(datasource, query, metrics);
    dispatch(
      buildMetrics({
        isLoading: false,
        hasMetadata: data.hasMetadata,
        metrics: data.metrics,
        metaHaystackDictionary: data.metaHaystackDictionary,
        nameHaystackDictionary: data.nameHaystackDictionary,
        totalMetricCount: data.metrics.length,
        filteredMetricCount: data.metrics.length
      })
    );
  }, [query, datasource, initialMetrics]);
  React.useEffect(() => {
    updateMetricsMetadata();
  }, [updateMetricsMetadata]);
  const typeOptions = promTypes.map((t2) => {
    return {
      value: t2.value,
      label: t2.value,
      description: t2.description
    };
  });
  const debouncedBackendSearch = React.useMemo(
    () => debounce__default.default(async (metricText) => {
      dispatch(setIsLoading(true));
      const queryString = regexifyLabelValuesQueryString(metricText);
      const filterArray = query.labels ? formatPrometheusLabelFilters(query.labels) : [];
      const match = `{__name__=~".*${queryString}"${filterArray ? filterArray.join("") : ""}}`;
      const results = await datasource.languageProvider.queryLabelValues(timeRange, METRIC_LABEL, match);
      const resultsOptions = results.map((result) => ({
        value: result
      }));
      dispatch(
        filterMetricsBackend({
          metrics: resultsOptions,
          filteredMetricCount: resultsOptions.length,
          isLoading: false
        })
      );
    }, getDebounceTimeInMilliseconds(datasource.cacheLevel)),
    [datasource.cacheLevel, datasource.languageProvider, query.labels, timeRange]
  );
  function fuzzyNameDispatch(haystackData) {
    dispatch(setNameHaystack(haystackData));
  }
  function fuzzyMetaDispatch(haystackData) {
    dispatch(setMetaHaystack(haystackData));
  }
  function searchCallback(query2, fullMetaSearchVal) {
    if (state.useBackend && query2 === "") {
      updateMetricsMetadata();
    } else if (state.useBackend) {
      debouncedBackendSearch(query2);
    } else {
      if (fullMetaSearchVal) {
        debouncedFuzzySearch(Object.keys(state.metaHaystackDictionary), query2, fuzzyMetaDispatch);
      } else {
        debouncedFuzzySearch(Object.keys(state.nameHaystackDictionary), query2, fuzzyNameDispatch);
      }
    }
  }
  const additionalSettings = /* @__PURE__ */ jsxRuntime.jsx(
    AdditionalSettings,
    {
      state,
      onChangeFullMetaSearch: () => {
        const newVal = !state.fullMetaSearch;
        dispatch(setFullMetaSearch(newVal));
        onChange({ ...query, fullMetaSearch: newVal });
        searchCallback(state.fuzzySearchQuery, newVal);
      },
      onChangeIncludeNullMetadata: () => {
        dispatch(setIncludeNullMetadata(!state.includeNullMetadata));
        onChange({ ...query, includeNullMetadata: !state.includeNullMetadata });
      },
      onChangeDisableTextWrap: () => {
        dispatch(setDisableTextWrap());
        onChange({ ...query, disableTextWrap: !state.disableTextWrap });
        tracking("grafana_prom_metric_encycopedia_disable_text_wrap_interaction", state, "");
      },
      onChangeUseBackend: () => {
        const newVal = !state.useBackend;
        dispatch(setUseBackend(newVal));
        onChange({ ...query, useBackend: newVal });
        if (newVal === false) {
          updateMetricsMetadata();
        } else {
          if (state.fuzzySearchQuery !== "") {
            debouncedBackendSearch(state.fuzzySearchQuery);
          }
        }
      }
    }
  );
  return /* @__PURE__ */ jsxRuntime.jsxs(
    ui.Modal,
    {
      "data-testid": metricsModaltestIds.metricModal,
      isOpen,
      title: i18n.t("grafana-prometheus.querybuilder.metrics-modal.title-metrics-explorer", "Metrics explorer"),
      onDismiss: onClose,
      "aria-label": i18n.t("grafana-prometheus.querybuilder.metrics-modal.aria-label-browse-metrics", "Browse metrics"),
      className: styles.modal,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(FeedbackLink, { feedbackUrl: "https://forms.gle/DEMAJHoAMpe3e54CA" }),
        /* @__PURE__ */ jsxRuntime.jsxs(
          "div",
          {
            className: styles.inputWrapper,
            "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.builder.metricsExplorer,
            children: [
              /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.inputItem, styles.inputItemFirst), children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.Input,
                {
                  autoFocus: true,
                  "data-testid": metricsModaltestIds.searchMetric,
                  placeholder: placeholders.browse,
                  value: state.fuzzySearchQuery,
                  onInput: (e) => {
                    var _a2;
                    const value = (_a2 = e.currentTarget.value) != null ? _a2 : "";
                    dispatch(setFuzzySearchQuery(value));
                    searchCallback(value, state.fullMetaSearch);
                  }
                }
              ) }),
              state.hasMetadata && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.inputItem, children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.MultiSelect,
                {
                  "data-testid": metricsModaltestIds.selectType,
                  inputId: "my-select",
                  options: typeOptions,
                  value: state.selectedTypes,
                  placeholder: placeholders.type,
                  onChange: (v) => dispatch(setSelectedTypes(v))
                }
              ) }),
              /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(ui.Spinner, { className: `${styles.loadingSpinner} ${state.isLoading ? styles.visible : ""}` }) }),
              /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.inputItem, children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.Toggletip,
                {
                  "aria-label": i18n.t(
                    "grafana-prometheus.querybuilder.metrics-modal.aria-label-additional-settings",
                    "Additional settings"
                  ),
                  content: additionalSettings,
                  placement: "bottom-end",
                  closeButton: false,
                  children: /* @__PURE__ */ jsxRuntime.jsxs(ui.ButtonGroup, { className: styles.settingsBtn, children: [
                    /* @__PURE__ */ jsxRuntime.jsx(
                      ui.Button,
                      {
                        variant: "secondary",
                        size: "md",
                        onClick: () => dispatch(showAdditionalSettings()),
                        "data-testid": metricsModaltestIds.showAdditionalSettings,
                        className: styles.noBorder,
                        children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.metrics-modal.additional-settings", children: "Additional Settings" })
                      }
                    ),
                    /* @__PURE__ */ jsxRuntime.jsx(
                      ui.Button,
                      {
                        className: styles.noBorder,
                        variant: "secondary",
                        icon: state.showAdditionalSettings ? "angle-up" : "angle-down"
                      }
                    )
                  ] })
                }
              ) })
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.resultsData, children: [
          query.metric && /* @__PURE__ */ jsxRuntime.jsx("i", { className: styles.currentlySelected, children: /* @__PURE__ */ jsxRuntime.jsxs(
            i18n.Trans,
            {
              i18nKey: "grafana-prometheus.querybuilder.metrics-modal.currently-selected",
              values: { selected: query.metric },
              children: [
                "Currently selected: ",
                "{{selected}}"
              ]
            }
          ) }),
          query.labels.length > 0 && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.resultsDataFiltered, children: [
            /* @__PURE__ */ jsxRuntime.jsx(ui.Icon, { name: "info-circle", size: "sm" }),
            /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.resultsDataFilteredText, children: [
              "\xA0",
              /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.metrics-modal.metrics-pre-filtered", children: "These metrics have been pre-filtered by labels chosen in the label filters." })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.results, children: state.metrics && /* @__PURE__ */ jsxRuntime.jsx(
          ResultsTable,
          {
            metrics: displayedMetrics(state, dispatch),
            onChange,
            onClose,
            query,
            state,
            disableTextWrap: state.disableTextWrap
          }
        ) }),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.resultsFooter, children: [
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.resultsAmount, children: /* @__PURE__ */ jsxRuntime.jsxs(
            i18n.Trans,
            {
              i18nKey: "grafana-prometheus.querybuilder.metrics-modal.results-amount",
              values: { num: state.filteredMetricCount },
              count: state.totalMetricCount,
              children: [
                "Showing ",
                "{{num}}",
                " of ",
                "{{count}}",
                " results"
              ]
            }
          ) }),
          /* @__PURE__ */ jsxRuntime.jsx(
            ui.Pagination,
            {
              currentPage: (_a = state.pageNum) != null ? _a : 1,
              numberOfPages: calculatePageList(state).length,
              onNavigate: (val) => {
                const page = val != null ? val : 1;
                dispatch(setPageNum(page));
              }
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.resultsPerPageWrapper, children: [
            /* @__PURE__ */ jsxRuntime.jsx("p", { className: styles.resultsPerPageLabel, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.metrics-modal.results-per-page", children: "Results per page" }) }),
            /* @__PURE__ */ jsxRuntime.jsx(
              ui.Input,
              {
                "data-testid": metricsModaltestIds.resultsPerPage,
                value: calculateResultsPerPage(state.resultsPerPage, DEFAULT_RESULTS_PER_PAGE, MAXIMUM_RESULTS_PER_PAGE),
                placeholder: i18n.t(
                  "grafana-prometheus.querybuilder.metrics-modal.placeholder-results-per-page",
                  "results per page"
                ),
                width: 10,
                title: "The maximum results per page is " + MAXIMUM_RESULTS_PER_PAGE,
                type: "number",
                onInput: (e) => {
                  const value = +e.currentTarget.value;
                  if (isNaN(value) || value >= MAXIMUM_RESULTS_PER_PAGE) {
                    return;
                  }
                  dispatch(setResultsPerPage(value));
                }
              }
            )
          ] })
        ] })
      ]
    }
  );
};
const metricsModaltestIds = {
  metricModal: "metric-modal",
  searchMetric: "search-metric",
  searchWithMetadata: "search-with-metadata",
  selectType: "select-type",
  metricCard: "metric-card",
  useMetric: "use-metric",
  searchPage: "search-page",
  resultsPerPage: "results-per-page",
  setUseBackend: "set-use-backend",
  showAdditionalSettings: "show-additional-settings"
};
const {
  setIsLoading,
  buildMetrics,
  filterMetricsBackend,
  setResultsPerPage,
  setPageNum,
  setFuzzySearchQuery,
  setNameHaystack,
  setMetaHaystack,
  setFullMetaSearch,
  setIncludeNullMetadata,
  setSelectedTypes,
  setUseBackend,
  setDisableTextWrap,
  showAdditionalSettings,
  setFilteredMetricCount
} = stateSlice$1.actions;

"use strict";
function MetricCombobox({
  datasource,
  query,
  onChange,
  onGetMetrics,
  labelsFilters,
  variableEditor,
  timeRange
}) {
  const [metricsModalOpen, setMetricsModalOpen] = React.useState(false);
  const getMetricLabels = React.useCallback(
    async (query2) => {
      const match = formatKeyValueStrings(query2, labelsFilters);
      const results = await datasource.languageProvider.queryLabelValues(timeRange, METRIC_LABEL, match);
      const resultsOptions = results.map((result) => {
        return {
          label: result,
          value: result
        };
      });
      return resultsOptions;
    },
    [datasource.languageProvider, labelsFilters, timeRange]
  );
  const onComboboxChange = React.useCallback(
    (opt) => {
      var _a;
      onChange({ ...query, metric: (_a = opt == null ? void 0 : opt.value) != null ? _a : "" });
    },
    [onChange, query]
  );
  const loadOptions = React.useCallback(
    async (input) => {
      const metrics = input.length ? await getMetricLabels(input) : await onGetMetrics();
      return metrics.map((option) => {
        var _a;
        return {
          label: (_a = option.label) != null ? _a : option.value,
          value: option.value
        };
      });
    },
    [getMetricLabels, onGetMetrics]
  );
  const loadMetricsExplorerMetrics = React.useCallback(async () => {
    const allMetrics = await onGetMetrics();
    const metrics = [];
    for (const metric of allMetrics) {
      if (metric.value) {
        metrics.push(metric.value);
      }
    }
    return metrics;
  }, [onGetMetrics]);
  const asyncSelect = () => {
    return /* @__PURE__ */ jsxRuntime.jsxs(pluginUi.InputGroup, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Combobox,
        {
          placeholder: i18n.t(
            "grafana-prometheus.querybuilder.metric-combobox.async-select.placeholder-select-metric",
            "Select metric"
          ),
          width: "auto",
          minWidth: 25,
          options: loadOptions,
          value: query.metric,
          onChange: onComboboxChange,
          createCustomValue: true,
          "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.builder.metricSelect
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          tooltip: i18n.t(
            "grafana-prometheus.querybuilder.metric-combobox.async-select.tooltip-open-metrics-explorer",
            "Open metrics explorer"
          ),
          "aria-label": i18n.t(
            "grafana-prometheus.querybuilder.metric-combobox.async-select.aria-label-open-metrics-explorer",
            "Open metrics explorer"
          ),
          variant: "secondary",
          icon: "book-open",
          onClick: () => {
            tracking("grafana_prometheus_metric_encyclopedia_open", null, "", query);
            setMetricsModalOpen(true);
          }
        }
      )
    ] });
  };
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    !datasource.lookupsDisabled && metricsModalOpen && /* @__PURE__ */ jsxRuntime.jsx(
      MetricsModal,
      {
        datasource,
        isOpen: metricsModalOpen,
        onClose: () => setMetricsModalOpen(false),
        query,
        onChange,
        initialMetrics: loadMetricsExplorerMetrics,
        timeRange
      }
    ),
    variableEditor ? /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFieldRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.querybuilder.metric-combobox.label-metric", "Metric"),
        labelWidth: 20,
        tooltip: /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.metric-combobox.tooltip-metric", children: "Optional: returns a list of label values for the label name in the specified metric." }) }),
        children: asyncSelect()
      }
    ) }) : /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorFieldGroup, { children: /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorField, { label: i18n.t("grafana-prometheus.querybuilder.metric-combobox.label-metric", "Metric"), children: asyncSelect() }) })
  ] });
}
const formatPrometheusLabelFiltersToString = (queryString, labelsFilters) => {
  const filterArray = labelsFilters ? formatPrometheusLabelFilters(labelsFilters) : [];
  return `{__name__=~".*${queryString}"${filterArray ? filterArray.join("") : ""}}`;
};
const formatPrometheusLabelFilters = (labelsFilters) => {
  return labelsFilters.map((label) => {
    return `,${label.label}="${label.value}"`;
  });
};
const formatKeyValueStrings = (query, labelsFilters) => {
  const queryString = regexifyLabelValuesQueryString(query);
  return formatPrometheusLabelFiltersToString(queryString, labelsFilters);
};

"use strict";
function MetricsLabelsSection({
  datasource,
  query,
  onChange,
  onBlur,
  variableEditor,
  timeRange
}) {
  const onChangeLabels = (labels) => {
    onChange({ ...query, labels });
  };
  const withTemplateVariableOptions = React.useCallback(
    async (optionsPromise) => {
      const variables = datasource.getVariables();
      const options = await optionsPromise;
      return [
        ...variables.map((value) => ({ label: value, value })),
        ...options.map((option) => ({
          label: option.value,
          value: option.value,
          title: option.description
        }))
      ];
    },
    [datasource]
  );
  const onGetLabelNames = async (forLabel) => {
    if (!query.metric) {
      await datasource.languageProvider.queryLabelKeys(timeRange);
      return datasource.languageProvider.retrieveLabelKeys().map((k) => ({ value: k }));
    }
    const labelsToConsider = query.labels.filter((x) => x !== forLabel);
    labelsToConsider.push({ label: "__name__", op: "=", value: query.metric });
    const expr = promQueryModeller.renderLabels(labelsToConsider);
    let labelsIndex = await datasource.languageProvider.queryLabelKeys(timeRange, expr);
    return labelsIndex.filter((labelName) => !labelsToConsider.find((filter) => filter.label === labelName)).map((k) => ({ value: k }));
  };
  const getLabelValuesAutocompleteSuggestions = async (queryString, labelName) => {
    const forLabel = {
      label: labelName != null ? labelName : "__name__",
      op: "=~",
      value: regexifyLabelValuesQueryString(`.*${queryString}`)
    };
    const labelsToConsider = query.labels.filter((x) => x.label !== forLabel.label);
    labelsToConsider.push(forLabel);
    if (query.metric) {
      labelsToConsider.push({ label: "__name__", op: "=", value: query.metric });
    }
    const interpolatedLabelsToConsider = labelsToConsider.map((labelObject) => ({
      ...labelObject,
      label: datasource.interpolateString(labelObject.label),
      value: datasource.interpolateString(labelObject.value)
    }));
    const expr = promQueryModeller.renderLabels(interpolatedLabelsToConsider);
    const values = await datasource.languageProvider.queryLabelValues(timeRange, forLabel.label, expr);
    return truncateResult(values).map(toSelectableValue);
  };
  const onGetLabelValues = async (forLabel) => {
    if (!forLabel.label) {
      return [];
    }
    if (!query.metric) {
      return (await datasource.languageProvider.queryLabelValues(timeRange, forLabel.label)).map((v) => ({ value: v }));
    }
    const labelsToConsider = query.labels.filter((x) => x !== forLabel);
    labelsToConsider.push({ label: "__name__", op: "=", value: query.metric });
    const interpolatedLabelsToConsider = labelsToConsider.map((labelObject) => ({
      ...labelObject,
      label: datasource.interpolateString(labelObject.label),
      value: datasource.interpolateString(labelObject.value)
    }));
    const expr = promQueryModeller.renderLabels(interpolatedLabelsToConsider);
    return (await datasource.languageProvider.queryLabelValues(timeRange, forLabel.label, expr)).map(toSelectableValue);
  };
  const onGetMetrics = React.useCallback(() => {
    return withTemplateVariableOptions(getMetrics(datasource, query, timeRange));
  }, [datasource, query, timeRange, withTemplateVariableOptions]);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      MetricCombobox,
      {
        query,
        onChange,
        onGetMetrics,
        datasource,
        labelsFilters: query.labels,
        metricLookupDisabled: datasource.lookupsDisabled,
        onBlur: onBlur ? onBlur : () => {
        },
        variableEditor,
        timeRange
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      LabelFilters,
      {
        debounceDuration: getDebounceTimeInMilliseconds(datasource.cacheLevel),
        getLabelValuesAutofillSuggestions: getLabelValuesAutocompleteSuggestions,
        labelsFilters: query.labels,
        onChange: onChangeLabels,
        onGetLabelNames: (forLabel) => withTemplateVariableOptions(onGetLabelNames(forLabel)),
        onGetLabelValues: (forLabel) => withTemplateVariableOptions(onGetLabelValues(forLabel)),
        variableEditor
      }
    )
  ] });
}
async function getMetrics(datasource, query, timeRange) {
  var _a;
  const metadata = datasource.languageProvider.retrieveMetricsMetadata();
  if (Object.keys(metadata).length === 0) {
    await datasource.languageProvider.queryMetricsMetadata();
  }
  let metrics;
  const expr = promQueryModeller.renderLabels(query.labels);
  metrics = (_a = await datasource.languageProvider.queryLabelValues(timeRange, "__name__", expr === "" ? void 0 : expr)) != null ? _a : [];
  return metrics.map((m) => ({
    value: m,
    description: getMetadataString(m, datasource.languageProvider.retrieveMetricsMetadata())
  }));
}
function getMetadataString(metric, metadata) {
  if (!metadata[metric]) {
    return;
  }
  const { type, help } = metadata[metric];
  return `${type.toUpperCase()}: ${help}`;
}
function toSelectableValue(lv) {
  return {
    label: lv,
    value: lv
  };
}

"use strict";
const EXPLAIN_LABEL_FILTER_CONTENT = "Fetch all series matching metric name and label filters.";
const PromQueryBuilderExplained = React.memo(({ query }) => {
  const visQuery = buildVisualQueryFromString(query || "").query;
  const lang = { grammar: promqlGrammar, name: "promql" };
  return /* @__PURE__ */ jsxRuntime.jsxs(ui.Stack, { gap: 0.5, direction: "column", children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      OperationExplainedBox,
      {
        stepNumber: 1,
        title: /* @__PURE__ */ jsxRuntime.jsx(RawQuery, { query: `${promQueryModeller.renderQuery(visQuery)}`, lang }),
        children: EXPLAIN_LABEL_FILTER_CONTENT
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      OperationListExplained,
      {
        stepNumber: 2,
        queryModeller: promQueryModeller,
        query: visQuery,
        lang
      }
    )
  ] });
});
PromQueryBuilderExplained.displayName = "PromQueryBuilderExplained";

"use strict";
const QueryBuilderContent = React.memo((props) => {
  var _a, _b;
  const { datasource, query, onChange, onRunQuery, data: data$1, showExplain } = props;
  const [highlightedOp, setHighlightedOp] = React.useState();
  const lang = { grammar: promqlGrammar, name: "promql" };
  const initHints = getInitHints(datasource);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
      MetricsLabelsSection,
      {
        query,
        onChange,
        datasource,
        timeRange: (_a = data$1 == null ? void 0 : data$1.timeRange) != null ? _a : data.getDefaultTimeRange()
      }
    ) }),
    initHints.length ? /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.css({
          flexBasis: "100%"
        }),
        children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "text-warning", children: [
          initHints[0].label,
          " ",
          initHints[0].fix ? /* @__PURE__ */ jsxRuntime.jsx("button", { type: "button", className: "text-warning", children: initHints[0].fix.label }) : null
        ] })
      }
    ) : null,
    showExplain && /* @__PURE__ */ jsxRuntime.jsx(
      OperationExplainedBox,
      {
        stepNumber: 1,
        title: /* @__PURE__ */ jsxRuntime.jsx(RawQuery, { query: `${promQueryModeller.renderQuery(query)}`, lang }),
        children: EXPLAIN_LABEL_FILTER_CONTENT
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsxs(OperationsEditorRow, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        OperationList,
        {
          queryModeller: promQueryModeller,
          datasource,
          query,
          onChange,
          onRunQuery,
          highlightedOp,
          timeRange: (_b = data$1 == null ? void 0 : data$1.timeRange) != null ? _b : data.getDefaultTimeRange()
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("div", { "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.builder.hints, children: /* @__PURE__ */ jsxRuntime.jsx(
        QueryBuilderHints,
        {
          datasource,
          query,
          onChange,
          data: data$1,
          queryModeller: promQueryModeller,
          buildVisualQueryFromString
        }
      ) })
    ] }),
    showExplain && /* @__PURE__ */ jsxRuntime.jsx(
      OperationListExplained,
      {
        lang,
        query,
        stepNumber: 2,
        queryModeller: promQueryModeller,
        onMouseEnter: (op) => setHighlightedOp(op),
        onMouseLeave: () => setHighlightedOp(void 0)
      }
    )
  ] });
});
QueryBuilderContent.displayName = "QueryBuilderContent";

"use strict";
const NestedQuery = React.memo((props) => {
  const { nestedQuery, index, datasource, onChange, onRemove, onRunQuery, showExplain } = props;
  const styles = ui.useStyles2(getStyles$6);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.card, children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.header, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.name, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.nested-query.operator", children: "Operator" }) }),
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Select,
        {
          width: "auto",
          options: operators$1,
          value: data.toOption(nestedQuery.operator),
          onChange: (value) => {
            onChange(index, {
              ...nestedQuery,
              operator: value.value
            });
          }
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.name, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.nested-query.vector-matches", children: "Vector matches" }) }),
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.vectorMatchWrapper, children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          ui.Select,
          {
            width: "auto",
            value: nestedQuery.vectorMatchesType || "on",
            allowCustomValue: true,
            options: [
              { value: "on", label: i18n.t("grafana-prometheus.querybuilder.nested-query.label.on", "On") },
              {
                value: "ignoring",
                label: i18n.t("grafana-prometheus.querybuilder.nested-query.label.ignoring", "Ignoring")
              }
            ],
            onChange: (val) => {
              onChange(index, {
                ...nestedQuery,
                vectorMatchesType: val.value
              });
            }
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx(
          ui.AutoSizeInput,
          {
            className: styles.vectorMatchInput,
            minWidth: 20,
            defaultValue: nestedQuery.vectorMatches,
            onCommitChange: (evt) => {
              onChange(index, {
                ...nestedQuery,
                vectorMatches: evt.currentTarget.value,
                vectorMatchesType: nestedQuery.vectorMatchesType || "on"
              });
            }
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx(pluginUi.FlexItem, { grow: 1 }),
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.IconButton,
        {
          name: "times",
          size: "sm",
          onClick: () => onRemove(index),
          tooltip: i18n.t("grafana-prometheus.querybuilder.nested-query.tooltip-remove-match", "Remove match")
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.body, children: /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorRows, { children: /* @__PURE__ */ jsxRuntime.jsx(
      QueryBuilderContent,
      {
        showExplain,
        query: nestedQuery.query,
        datasource,
        onRunQuery,
        onChange: (update) => {
          onChange(index, { ...nestedQuery, query: update });
        }
      }
    ) }) })
  ] });
});
const operators$1 = binaryScalarDefs.map((def) => ({ label: def.sign, value: def.sign }));
NestedQuery.displayName = "NestedQuery";
const getStyles$6 = (theme) => {
  return {
    card: css.css({
      label: "card",
      display: "flex",
      flexDirection: "column",
      gap: theme.spacing(0.5)
    }),
    header: css.css({
      label: "header",
      padding: theme.spacing(0.5, 0.5, 0.5, 1),
      gap: theme.spacing(1),
      display: "flex",
      alignItems: "center"
    }),
    name: css.css({
      label: "name",
      whiteSpace: "nowrap"
    }),
    body: css.css({
      label: "body",
      paddingLeft: theme.spacing(2)
    }),
    vectorMatchInput: css.css({
      label: "vectorMatchInput",
      marginLeft: -1
    }),
    vectorMatchWrapper: css.css({
      label: "vectorMatchWrapper",
      display: "flex"
    })
  };
};

"use strict";
function NestedQueryList(props) {
  var _a;
  const { query, datasource, onChange, onRunQuery, showExplain } = props;
  const nestedQueries = (_a = query.binaryQueries) != null ? _a : [];
  const onNestedQueryUpdate = (index, update) => {
    const updatedList = [...nestedQueries];
    updatedList.splice(index, 1, update);
    onChange({ ...query, binaryQueries: updatedList });
  };
  const onRemove = (index) => {
    const updatedList = [...nestedQueries.slice(0, index), ...nestedQueries.slice(index + 1)];
    onChange({ ...query, binaryQueries: updatedList });
  };
  return /* @__PURE__ */ jsxRuntime.jsx(ui.Stack, { direction: "column", gap: 1, children: nestedQueries.map((nestedQuery, index) => /* @__PURE__ */ jsxRuntime.jsx(
    NestedQuery,
    {
      nestedQuery,
      index,
      onChange: onNestedQueryUpdate,
      datasource,
      onRemove,
      onRunQuery,
      showExplain
    },
    index.toString()
  )) });
}

"use strict";
const BaseQueryBuilder = React.memo((props) => {
  const { query, datasource, onChange, onRunQuery, showExplain } = props;
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(QueryBuilderContent, { ...props }),
    query.binaryQueries && query.binaryQueries.length > 0 && /* @__PURE__ */ jsxRuntime.jsx(
      NestedQueryList,
      {
        query,
        datasource,
        onChange,
        onRunQuery,
        showExplain
      }
    )
  ] });
});
BaseQueryBuilder.displayName = "BaseQueryBuilder";

"use strict";
const PromQueryBuilder = React.memo((props) => {
  return /* @__PURE__ */ jsxRuntime.jsx(BaseQueryBuilder, { ...props });
});
PromQueryBuilder.displayName = "PromQueryBuilder";

"use strict";
function QueryPreview({ query }) {
  if (!query) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorRow, { children: /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorFieldGroup, { children: /* @__PURE__ */ jsxRuntime.jsx(RawQuery, { query, lang: { grammar: promqlGrammar, name: "promql" } }) }) });
}

"use strict";
function PromQueryBuilderContainer(props) {
  const { query, onChange, onRunQuery, datasource, data, showExplain } = props;
  const [state, dispatch] = React.useReducer(stateSlice.reducer, { expr: query.expr });
  React.useEffect(() => {
    var _a, _b, _c, _d;
    dispatch(exprChanged(query.expr));
    dispatch(
      setMetricsModalSettings({
        useBackend: (_a = query.useBackend) != null ? _a : false,
        disableTextWrap: (_b = query.disableTextWrap) != null ? _b : false,
        fullMetaSearch: (_c = query.fullMetaSearch) != null ? _c : false,
        includeNullMetadata: (_d = query.includeNullMetadata) != null ? _d : true
      })
    );
  }, [query]);
  React.useEffect(() => {
    datasource.languageProvider.start(data == null ? void 0 : data.timeRange);
  }, [data == null ? void 0 : data.timeRange, datasource.languageProvider]);
  const onVisQueryChange = (visQuery) => {
    const expr = promQueryModeller.renderQuery(visQuery);
    dispatch(visualQueryChange({ visQuery, expr }));
    const metricsModalSettings = getSettings(visQuery);
    onChange({ ...props.query, expr, ...metricsModalSettings });
  };
  if (!state.visQuery) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      PromQueryBuilder,
      {
        query: state.visQuery,
        datasource,
        onChange: onVisQueryChange,
        onRunQuery,
        data,
        showExplain
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(QueryPreview, { query: query.expr })
  ] });
}
const initialState = {
  expr: ""
};
const stateSlice = toolkit.createSlice({
  name: "prom-builder-container",
  initialState,
  reducers: {
    visualQueryChange: (state, action) => {
      state.expr = action.payload.expr;
      state.visQuery = action.payload.visQuery;
    },
    exprChanged: (state, action) => {
      var _a;
      if (!state.visQuery || state.expr !== action.payload) {
        state.expr = action.payload;
        const parseResult = buildVisualQueryFromString((_a = action.payload) != null ? _a : "");
        state.visQuery = parseResult.query;
      }
    },
    setMetricsModalSettings: (state, action) => {
      if (state.visQuery) {
        state.visQuery.useBackend = action.payload.useBackend;
        state.visQuery.disableTextWrap = action.payload.disableTextWrap;
        state.visQuery.fullMetaSearch = action.payload.fullMetaSearch;
        state.visQuery.includeNullMetadata = action.payload.includeNullMetadata;
      }
    }
  }
});
const { visualQueryChange, exprChanged, setMetricsModalSettings } = stateSlice.actions;

"use strict";
function PromExemplarField({ datasource, onChange, query, ...rest }) {
  const [error, setError] = React.useState(null);
  const styles = ui.useStyles2(getStyles$5);
  const prevError = reactUse.usePrevious(error);
  React.useEffect(() => {
    if (!datasource.exemplarsAvailable) {
      setError("Exemplars for this query are not available");
      onChange(false);
    } else if (query.instant && !query.range) {
      setError("Exemplars are not available for instant queries");
      onChange(false);
    } else {
      setError(null);
      if (prevError && !error) {
        onChange(true);
      }
    }
  }, [datasource.exemplarsAvailable, query.instant, query.range, onChange, prevError, error]);
  const iconButtonStyles = css.cx(
    {
      [styles.activeIcon]: !!query.exemplar
    },
    styles.eyeIcon
  );
  return /* @__PURE__ */ jsxRuntime.jsx(ui.InlineLabel, { width: "auto", "data-testid": rest["data-testid"], children: /* @__PURE__ */ jsxRuntime.jsx(ui.Tooltip, { content: error != null ? error : "", children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.iconWrapper, children: [
    /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.prom-exemplar-field.exemplars", children: "Exemplars" }),
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.IconButton,
      {
        name: "eye",
        tooltip: !!query.exemplar ? i18n.t(
          "grafana-prometheus.components.prom-exemplar-field.tooltip-disable-query",
          "Disable query with exemplars"
        ) : i18n.t(
          "grafana-prometheus.components.prom-exemplar-field.tooltip-enable-query",
          "Enable query with exemplars"
        ),
        disabled: !!error,
        className: iconButtonStyles,
        onClick: () => {
          onChange(!query.exemplar);
        }
      }
    )
  ] }) }) });
}
function getStyles$5(theme) {
  return {
    eyeIcon: css.css({
      marginLeft: theme.spacing(2)
    }),
    activeIcon: css.css({
      color: theme.colors.primary.main
    }),
    iconWrapper: css.css({
      display: "flex",
      alignItems: "center"
    })
  };
}

"use strict";
const PromExploreExtraField = React.memo(({ query, datasource, onChange, onRunQuery }) => {
  var _a;
  const rangeOptions = getQueryTypeOptions(true);
  const prevQuery = reactUse.usePrevious(query);
  const styles = ui.useStyles2(getStyles$4);
  const onExemplarChange = React.useCallback(
    (exemplar) => {
      if (!lodash.isEqual(query, prevQuery) || exemplar !== query.exemplar) {
        onChange({ ...query, exemplar });
      }
    },
    [prevQuery, query, onChange]
  );
  function onChangeQueryStep(interval) {
    onChange({ ...query, interval });
  }
  function onStepChange(e) {
    if (e.currentTarget.value !== query.interval) {
      onChangeQueryStep(e.currentTarget.value);
    }
  }
  function onReturnKeyDown(e) {
    if (e.key === "Enter" && e.shiftKey) {
      onRunQuery();
    }
  }
  const onQueryTypeChange = getQueryTypeChangeHandler(query, onChange);
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      "aria-label": i18n.t(
        "grafana-prometheus.components.prom-explore-extra-field.aria-label-prometheus-extra-field",
        "Prometheus extra field"
      ),
      className: "gf-form-inline",
      "data-testid": promExploreExtraFieldTestIds.extraFieldEditor,
      children: [
        /* @__PURE__ */ jsxRuntime.jsxs(
          "div",
          {
            "data-testid": promExploreExtraFieldTestIds.queryTypeField,
            className: css.cx(
              "gf-form",
              styles.queryTypeField,
              css.css({
                flexWrap: "nowrap"
              })
            ),
            "aria-label": i18n.t(
              "grafana-prometheus.components.prom-explore-extra-field.aria-label-query-type-field",
              "Query type field"
            ),
            children: [
              /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFormLabel, { width: "auto", children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.prom-explore-extra-field.query-type", children: "Query type" }) }),
              /* @__PURE__ */ jsxRuntime.jsx(
                ui.RadioButtonGroup,
                {
                  options: rangeOptions,
                  value: query.range && query.instant ? "both" : query.instant ? "instant" : "range",
                  onChange: onQueryTypeChange
                }
              )
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsxs(
          "div",
          {
            "data-testid": promExploreExtraFieldTestIds.stepField,
            className: css.cx(
              "gf-form",
              css.css({
                flexWrap: "nowrap"
              })
            ),
            "aria-label": i18n.t("grafana-prometheus.components.prom-explore-extra-field.aria-label-step-field", "Step field"),
            children: [
              /* @__PURE__ */ jsxRuntime.jsx(
                ui.InlineFormLabel,
                {
                  width: 6,
                  tooltip: i18n.t(
                    "grafana-prometheus.components.prom-explore-extra-field.tooltip-units-builtin-variables-example-interval-rateinterval",
                    "Time units and built-in variables can be used here, for example: {{example1}}, {{example2}}, {{example3}}, {{example4}}, {{example5}}, {{example6}}, {{example7}} (Default if no unit is specified: {{default}})",
                    {
                      example1: "$__interval",
                      example2: "$__rate_interval",
                      example3: "5s",
                      example4: "1m",
                      example5: "3h",
                      example6: "1d",
                      example7: "1y",
                      default: "s"
                    }
                  ),
                  children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.prom-explore-extra-field.min-step", children: "Min step" })
                }
              ),
              /* @__PURE__ */ jsxRuntime.jsx(
                "input",
                {
                  type: "text",
                  className: "gf-form-input width-4",
                  placeholder: "auto",
                  onChange: onStepChange,
                  onKeyDown: onReturnKeyDown,
                  value: (_a = query.interval) != null ? _a : ""
                }
              )
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx(PromExemplarField, { onChange: onExemplarChange, datasource, query })
      ]
    }
  );
});
PromExploreExtraField.displayName = "PromExploreExtraField";
function getQueryTypeOptions(includeBoth) {
  const rangeOptions = [
    {
      value: "range",
      label: i18n.t("grafana-prometheus.components.get-query-type-options.range-options.label.range", "Range"),
      description: i18n.t(
        "grafana-prometheus.components.get-query-type-options.range-options.description.query-range",
        "Run query over a range of time"
      )
    },
    {
      value: "instant",
      label: i18n.t("grafana-prometheus.components.get-query-type-options.range-options.label.instant", "Instant"),
      description: 'Run query against a single point in time. For this query, the "To" time is used'
    }
  ];
  if (includeBoth) {
    rangeOptions.push({
      value: "both",
      label: i18n.t("grafana-prometheus.components.get-query-type-options.label.both", "Both"),
      description: i18n.t(
        "grafana-prometheus.components.get-query-type-options.description.instant-query-range",
        "Run an Instant query and a Range query"
      )
    });
  }
  return rangeOptions;
}
function getQueryTypeChangeHandler(query, onChange) {
  return (queryType) => {
    if (queryType === "instant") {
      onChange({ ...query, instant: true, range: false, exemplar: false });
    } else if (queryType === "range") {
      onChange({ ...query, instant: false, range: true });
    } else {
      onChange({ ...query, instant: true, range: true });
    }
  };
}
const promExploreExtraFieldTestIds = {
  extraFieldEditor: "prom-editor-extra-field",
  stepField: "prom-editor-extra-field-step",
  queryTypeField: "prom-editor-extra-field-query-type"
};
const getStyles$4 = (theme) => ({
  queryTypeField: css.css({
    marginRight: theme.spacing(0.5)
  })
});

"use strict";
function QueryOptionGroup({ title, children, collapsedInfo }) {
  const [isOpen, toggleOpen] = reactUse.useToggle(false);
  const styles = ui.useStyles2(getStyles$3);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.wrapper, children: /* @__PURE__ */ jsxRuntime.jsx(
    ui.Collapse,
    {
      className: styles.collapse,
      collapsible: true,
      isOpen,
      onToggle: toggleOpen,
      label: /* @__PURE__ */ jsxRuntime.jsxs(ui.Stack, { gap: 0, children: [
        /* @__PURE__ */ jsxRuntime.jsx("h6", { className: styles.title, children: title }),
        !isOpen && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.description, children: collapsedInfo.map((x, i) => /* @__PURE__ */ jsxRuntime.jsx("span", { children: x }, i)) })
      ] }),
      children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.body, children })
    }
  ) });
}
const getStyles$3 = (theme) => {
  return {
    collapse: css.css({
      backgroundColor: "unset",
      border: "unset",
      marginBottom: 0,
      ["> button"]: {
        padding: theme.spacing(0, 1)
      }
    }),
    wrapper: css.css({
      width: "100%",
      display: "flex",
      justifyContent: "space-between",
      alignItems: "baseline"
    }),
    title: css.css({
      flexGrow: 1,
      overflow: "hidden",
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      margin: 0
    }),
    description: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.bodySmall.fontWeight,
      paddingLeft: theme.spacing(2),
      gap: theme.spacing(2),
      display: "flex"
    }),
    body: css.css({
      display: "flex",
      gap: theme.spacing(2),
      flexWrap: "wrap"
    }),
    tooltip: css.css({
      marginRight: theme.spacing(0.25)
    })
  };
};

"use strict";
const getLegendModeOptions = () => [
  {
    label: i18n.t("grafana-prometheus.prom-query-legend-editor.get-legend-mode-options.label-auto", "Auto"),
    value: LegendFormatMode.Auto,
    description: i18n.t(
      "grafana-prometheus.prom-query-legend-editor.get-legend-mode-options.description-auto",
      "Only includes unique labels"
    )
  },
  {
    label: i18n.t("grafana-prometheus.prom-query-legend-editor.get-legend-mode-options.label-verbose", "Verbose"),
    value: LegendFormatMode.Verbose,
    description: i18n.t(
      "grafana-prometheus.prom-query-legend-editor.get-legend-mode-options.description-verbose",
      "All label names and values"
    )
  },
  {
    label: i18n.t("grafana-prometheus.prom-query-legend-editor.get-legend-mode-options.label-custom", "Custom"),
    value: LegendFormatMode.Custom,
    description: i18n.t(
      "grafana-prometheus.prom-query-legend-editor.get-legend-mode-options.description-custom",
      "Provide a naming template"
    )
  }
];
const PromQueryLegendEditor = React__namespace.memo(
  ({ legendFormat, onChange, onRunQuery }) => {
    const mode = getLegendMode(legendFormat);
    const inputRef = React.useRef(null);
    const legendModeOptions = getLegendModeOptions();
    const onLegendFormatChanged = (evt) => {
      let newFormat = evt.currentTarget.value;
      if (newFormat.length === 0) {
        newFormat = LegendFormatMode.Auto;
      }
      if (newFormat !== legendFormat) {
        onChange(newFormat);
        onRunQuery();
      }
    };
    const onLegendModeChanged = (value) => {
      switch (value.value) {
        case LegendFormatMode.Auto:
          onChange(LegendFormatMode.Auto);
          break;
        case LegendFormatMode.Custom:
          onChange("{{label_name}}");
          setTimeout(() => {
            var _a, _b;
            (_a = inputRef.current) == null ? void 0 : _a.focus();
            (_b = inputRef.current) == null ? void 0 : _b.setSelectionRange(2, 12, "forward");
          }, 10);
          break;
        case LegendFormatMode.Verbose:
          onChange("");
          break;
      }
      onRunQuery();
    };
    return /* @__PURE__ */ jsxRuntime.jsx(
      pluginUi.EditorField,
      {
        label: i18n.t("grafana-prometheus.querybuilder.prom-query-legend-editor.label-legend", "Legend"),
        tooltip: i18n.t(
          "grafana-prometheus.querybuilder.prom-query-legend-editor.tooltip-legend",
          "Series name override or template. Ex. {{templateExample}} will be replaced with label value for {{labelName}}.",
          { templateExample: "{{hostname}}", labelName: "hostname" }
        ),
        "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.legend,
        children: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          mode === LegendFormatMode.Custom && /* @__PURE__ */ jsxRuntime.jsx(
            ui.AutoSizeInput,
            {
              id: "legendFormat",
              minWidth: 22,
              placeholder: "auto",
              defaultValue: legendFormat,
              onCommitChange: onLegendFormatChanged,
              ref: inputRef
            }
          ),
          mode !== LegendFormatMode.Custom && /* @__PURE__ */ jsxRuntime.jsx(
            ui.Select,
            {
              inputId: "legend.mode",
              isSearchable: false,
              placeholder: i18n.t(
                "grafana-prometheus.querybuilder.prom-query-legend-editor.placeholder-select-legend-mode",
                "Select legend mode"
              ),
              options: legendModeOptions,
              width: 22,
              onChange: onLegendModeChanged,
              value: legendModeOptions.find((x) => x.value === mode)
            }
          )
        ] })
      }
    );
  }
);
PromQueryLegendEditor.displayName = "PromQueryLegendEditor";
function getLegendMode(legendFormat) {
  if (legendFormat === LegendFormatMode.Auto) {
    return LegendFormatMode.Auto;
  }
  if (legendFormat == null || legendFormat === "") {
    return LegendFormatMode.Verbose;
  }
  return LegendFormatMode.Custom;
}
function getLegendModeLabel(legendFormat) {
  var _a;
  const legendModeOptions = getLegendModeOptions();
  const mode = getLegendMode(legendFormat);
  if (mode !== LegendFormatMode.Custom) {
    return (_a = legendModeOptions.find((x) => x.value === mode)) == null ? void 0 : _a.label;
  }
  return legendFormat;
}

"use strict";
const INTERVAL_FACTOR_OPTIONS = lodash.map([1, 2, 3, 4, 5, 10], (value) => ({
  value,
  label: "1/" + value
}));
const PromQueryBuilderOptions = React__namespace.memo(
  ({ query, app, onChange, onRunQuery }) => {
    const FORMAT_OPTIONS = [
      {
        label: i18n.t(
          "grafana-prometheus.querybuilder.prom-query-builder-options.format-options.label-time-series",
          "Time series"
        ),
        value: "time_series"
      },
      {
        label: i18n.t("grafana-prometheus.querybuilder.prom-query-builder-options.format-options.label-table", "Table"),
        value: "table"
      },
      {
        label: i18n.t("grafana-prometheus.querybuilder.prom-query-builder-options.format-options.label-heatmap", "Heatmap"),
        value: "heatmap"
      }
    ];
    const onChangeFormat = (value) => {
      onChange({ ...query, format: value.value });
      onRunQuery();
    };
    const onChangeStep = (evt) => {
      onChange({ ...query, interval: evt.currentTarget.value.trim() });
      onRunQuery();
    };
    const queryTypeOptions = getQueryTypeOptions(
      app === data.CoreApp.Explore || app === data.CoreApp.Correlations || app === data.CoreApp.PanelEditor
    );
    const onQueryTypeChange = getQueryTypeChangeHandler(query, onChange);
    const onExemplarChange = (event) => {
      const isEnabled = event.currentTarget.checked;
      onChange({ ...query, exemplar: isEnabled });
      onRunQuery();
    };
    const onIntervalFactorChange = (value) => {
      onChange({ ...query, intervalFactor: value.value });
      onRunQuery();
    };
    const formatOption = FORMAT_OPTIONS.find((option) => option.value === query.format) || FORMAT_OPTIONS[0];
    const queryTypeValue = getQueryTypeValue(query);
    const queryTypeLabel = queryTypeOptions.find((x) => x.value === queryTypeValue).label;
    return /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorRow, { children: /* @__PURE__ */ jsxRuntime.jsx("div", { "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.options, children: /* @__PURE__ */ jsxRuntime.jsxs(
      QueryOptionGroup,
      {
        title: i18n.t("grafana-prometheus.querybuilder.prom-query-builder-options.title-options", "Options"),
        collapsedInfo: getCollapsedInfo(query, formatOption.label, queryTypeLabel, app),
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(
            PromQueryLegendEditor,
            {
              legendFormat: query.legendFormat,
              onChange: (legendFormat) => onChange({ ...query, legendFormat }),
              onRunQuery
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx(
            pluginUi.EditorField,
            {
              label: i18n.t("grafana-prometheus.querybuilder.prom-query-builder-options.label-min-step", "Min step"),
              tooltip: /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsxs(
                i18n.Trans,
                {
                  i18nKey: "grafana-prometheus.querybuilder.prom-query-builder-options.tooltip-min-step",
                  values: {
                    interval: "$__interval",
                    rateInterval: "$__rate_interval"
                  },
                  children: [
                    "An additional lower limit for the step parameter of the Prometheus query and for the",
                    " ",
                    /* @__PURE__ */ jsxRuntime.jsx("code", { children: "{{interval}}" }),
                    " and ",
                    /* @__PURE__ */ jsxRuntime.jsx("code", { children: "{{rateInterval}}" }),
                    " variables."
                  ]
                }
              ) }),
              children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.AutoSizeInput,
                {
                  type: "text",
                  "aria-label": i18n.t(
                    "grafana-prometheus.querybuilder.prom-query-builder-options.aria-label-lower-limit-parameter",
                    "Set lower limit for the step parameter"
                  ),
                  placeholder: i18n.t("grafana-prometheus.querybuilder.prom-query-builder-options.placeholder-auto", "auto"),
                  minWidth: 10,
                  onCommitChange: onChangeStep,
                  defaultValue: query.interval,
                  "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.step
                }
              )
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorField, { label: i18n.t("grafana-prometheus.querybuilder.prom-query-builder-options.label-format", "Format"), children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.Select,
            {
              "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.format,
              value: formatOption,
              allowCustomValue: true,
              onChange: onChangeFormat,
              options: FORMAT_OPTIONS
            }
          ) }),
          /* @__PURE__ */ jsxRuntime.jsx(
            pluginUi.EditorField,
            {
              label: i18n.t("grafana-prometheus.querybuilder.prom-query-builder-options.label-type", "Type"),
              "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.type,
              children: /* @__PURE__ */ jsxRuntime.jsx(ui.RadioButtonGroup, { options: queryTypeOptions, value: queryTypeValue, onChange: onQueryTypeChange })
            }
          ),
          shouldShowExemplarSwitch(query, app) && /* @__PURE__ */ jsxRuntime.jsx(
            pluginUi.EditorField,
            {
              label: i18n.t("grafana-prometheus.querybuilder.prom-query-builder-options.label-exemplars", "Exemplars"),
              children: /* @__PURE__ */ jsxRuntime.jsx(
                pluginUi.EditorSwitch,
                {
                  value: query.exemplar || false,
                  onChange: onExemplarChange,
                  "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.exemplars
                }
              )
            }
          ),
          query.intervalFactor && query.intervalFactor > 1 && /* @__PURE__ */ jsxRuntime.jsx(
            pluginUi.EditorField,
            {
              label: i18n.t("grafana-prometheus.querybuilder.prom-query-builder-options.label-resolution", "Resolution"),
              children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.Select,
                {
                  "aria-label": i18n.t(
                    "grafana-prometheus.querybuilder.prom-query-builder-options.aria-label-select-resolution",
                    "Select resolution"
                  ),
                  isSearchable: false,
                  options: INTERVAL_FACTOR_OPTIONS,
                  onChange: onIntervalFactorChange,
                  value: INTERVAL_FACTOR_OPTIONS.find((option) => option.value === query.intervalFactor)
                }
              )
            }
          )
        ]
      }
    ) }) });
  }
);
function shouldShowExemplarSwitch(query, app) {
  if (app === data.CoreApp.UnifiedAlerting || !query.range) {
    return false;
  }
  return true;
}
function getQueryTypeValue(query) {
  return query.range && query.instant ? "both" : query.instant ? "instant" : "range";
}
function getCollapsedInfo(query, formatOption, queryType, app) {
  var _a;
  const items = [];
  items.push(
    i18n.t("grafana-prometheus.querybuilder.get-collapsed-info.legend", "Legend: {{value}}", {
      value: getLegendModeLabel(query.legendFormat)
    })
  );
  items.push(
    i18n.t("grafana-prometheus.querybuilder.get-collapsed-info.format", "Format: {{value}}", { value: formatOption })
  );
  items.push(
    i18n.t("grafana-prometheus.querybuilder.get-collapsed-info.step", "Step: {{value}}", { value: (_a = query.interval) != null ? _a : "auto" })
  );
  items.push(i18n.t("grafana-prometheus.querybuilder.get-collapsed-info.type", "Type: {{value}}", { value: queryType }));
  if (shouldShowExemplarSwitch(query, app)) {
    items.push(
      i18n.t("grafana-prometheus.querybuilder.get-collapsed-info.exemplars", "Exemplars: {{value}}", {
        value: query.exemplar ? "true" : "false"
      })
    );
  }
  return items;
}
PromQueryBuilderOptions.displayName = "PromQueryBuilderOptions";

"use strict";
function isCancelablePromiseRejection(promise) {
  return typeof promise === "object" && promise !== null && "isCanceled" in promise;
}
const makePromiseCancelable = (promise) => {
  let hasCanceled_ = false;
  const wrappedPromise = new Promise((resolve, reject) => {
    const canceledPromiseRejection = { isCanceled: true };
    promise.then((val) => hasCanceled_ ? reject(canceledPromiseRejection) : resolve(val));
    promise.catch((error) => hasCanceled_ ? reject(canceledPromiseRejection) : reject(error));
  });
  return {
    promise: wrappedPromise,
    cancel() {
      hasCanceled_ = true;
    }
  };
};

"use strict";
function buildSelector(selectedMetric, selectedLabelValues) {
  if (selectedMetric === "" && Object.keys(selectedLabelValues).length === 0) {
    return "{}";
  }
  const selectorParts = [];
  for (const [key, values] of Object.entries(selectedLabelValues)) {
    if (values.length === 0) {
      continue;
    }
    if (values.length > 1) {
      selectorParts.push(`${utf8Support(key)}=~"${values.map(escapeLabelValueInRegexSelector).join("|")}"`);
    } else {
      selectorParts.push(`${utf8Support(key)}="${escapeLabelValueInExactSelector(values[0])}"`);
    }
  }
  if (selectedMetric === "") {
    return `{${selectorParts.join(",")}}`;
  }
  if (isValidLegacyName(selectedMetric)) {
    return `${selectedMetric}{${selectorParts.join(",")}}`;
  }
  selectorParts.unshift(utf8Support(selectedMetric));
  return `{${selectorParts.join(",")}}`;
}

"use strict";
const useMetricsLabelsValues = (timeRange, languageProvider) => {
  const timeRangeRef = React.useRef(timeRange);
  const lastSeriesLimitRef = React.useRef(languageProvider.datasource.seriesLimit);
  const isInitializedRef = React.useRef(false);
  const [seriesLimit, setSeriesLimit] = React.useState(languageProvider.datasource.seriesLimit);
  const [err, setErr] = React.useState("");
  const [status, setStatus] = React.useState("Ready");
  const [validationStatus, setValidationStatus] = React.useState("");
  const [metrics, setMetrics] = React.useState([]);
  const [selectedMetric, setSelectedMetric] = React.useState("");
  const [labelKeys, setLabelKeys] = React.useState([]);
  const [selectedLabelKeys, setSelectedLabelKeys] = React.useState([]);
  const [lastSelectedLabelKey, setLastSelectedLabelKey] = React.useState("");
  const [labelValues, setLabelValues] = React.useState({});
  const [selectedLabelValues, setSelectedLabelValues] = React.useState({});
  const effectiveLimit = React.useMemo(() => seriesLimit, [seriesLimit]);
  React.useEffect(() => {
    if (timeRange.to.diff(timeRangeRef.current.to, "second") >= 5 && timeRange.from.diff(timeRangeRef.current.from, "second") >= 5) {
      timeRangeRef.current = timeRange;
    }
  }, [timeRange]);
  const handleError = React.useCallback((e, msg) => {
    if (e instanceof Error) {
      setErr(`${msg}: ${e.message}`);
    } else {
      setErr(`${msg}: Unknown error`);
    }
    setStatus("");
  }, []);
  const getMetricDetails = React.useCallback(
    (metricName) => {
      const meta = languageProvider.retrieveMetricsMetadata();
      return meta && meta[metricName] ? `(${meta[metricName].type}) ${meta[metricName].help}` : void 0;
    },
    [languageProvider]
  );
  const buildSafeSelector = React.useCallback((metric, labelValues2) => {
    const selector = buildSelector(metric, labelValues2);
    return selector === EMPTY_SELECTOR ? void 0 : selector;
  }, []);
  const loadSelectedLabelsFromStorage = React.useCallback(
    (availableLabelKeys) => {
      try {
        const labelKeysInLocalStorageAsString = localStorage.getItem(LAST_USED_LABELS_KEY) || "[]";
        const labelKeysInLocalStorage = JSON.parse(labelKeysInLocalStorageAsString);
        return labelKeysInLocalStorage.filter((slk) => availableLabelKeys.includes(slk));
      } catch (e) {
        handleError(e, "Failed to load saved label keys");
        return [];
      }
    },
    [handleError]
  );
  const fetchMetrics = React.useCallback(
    async (safeSelector) => {
      try {
        const fetchedMetrics = await languageProvider.queryLabelValues(
          timeRangeRef.current,
          METRIC_LABEL,
          safeSelector,
          effectiveLimit
        );
        return fetchedMetrics.map((m) => ({
          name: m,
          details: getMetricDetails(m)
        }));
      } catch (e) {
        handleError(e, "Error fetching metrics");
        return [];
      }
    },
    [getMetricDetails, handleError, languageProvider, effectiveLimit]
  );
  const fetchLabelKeys = React.useCallback(
    async (safeSelector) => {
      var _a;
      try {
        return (_a = await languageProvider.queryLabelKeys(timeRangeRef.current, safeSelector || void 0, effectiveLimit)) != null ? _a : [];
      } catch (e) {
        handleError(e, "Error fetching labels");
        return [];
      }
    },
    [handleError, languageProvider, effectiveLimit]
  );
  const fetchLabelValues = React.useCallback(
    async (labelKeys2, safeSelector) => {
      const transformedLabelValues = {};
      const newSelectedLabelValues = {};
      for (const lk of labelKeys2) {
        try {
          const values = await languageProvider.queryLabelValues(
            timeRangeRef.current,
            lk,
            safeSelector,
            effectiveLimit
          );
          transformedLabelValues[lk] = values;
          if (selectedLabelValues[lk]) {
            newSelectedLabelValues[lk] = [...selectedLabelValues[lk]];
          }
          setErr("");
        } catch (e) {
          handleError(e, "Error fetching label values");
        }
      }
      return [transformedLabelValues, newSelectedLabelValues];
    },
    [handleError, languageProvider, selectedLabelValues, effectiveLimit]
  );
  const initialize = React.useCallback(
    async (metric, labelValues2) => {
      const selector = buildSelector(metric, labelValues2);
      const safeSelector = selector === EMPTY_SELECTOR ? void 0 : selector;
      const transformedMetrics = await fetchMetrics(safeSelector);
      const transformedLabelKeys = await fetchLabelKeys(safeSelector);
      const labelKeysInLocalStorage = loadSelectedLabelsFromStorage(transformedLabelKeys);
      const [transformedLabelValues] = await fetchLabelValues(labelKeysInLocalStorage, safeSelector);
      setMetrics(transformedMetrics);
      setLabelKeys(transformedLabelKeys);
      setSelectedLabelKeys(labelKeysInLocalStorage);
      setLabelValues(transformedLabelValues);
    },
    [fetchLabelKeys, fetchLabelValues, fetchMetrics, loadSelectedLabelsFromStorage]
  );
  React.useEffect(() => {
    initialize(selectedMetric, selectedLabelValues);
    isInitializedRef.current = true;
  }, []);
  reactUse.useDebounce(
    () => {
      if (isInitializedRef.current && lastSeriesLimitRef.current !== seriesLimit) {
        initialize(selectedMetric, selectedLabelValues);
        lastSeriesLimitRef.current = seriesLimit;
      }
    },
    300,
    [seriesLimit]
  );
  const handleSelectedMetricChange = async (metricName) => {
    const newSelectedMetric = selectedMetric !== metricName ? metricName : "";
    const selector = buildSafeSelector(newSelectedMetric, selectedLabelValues);
    try {
      const fetchedMetrics = await fetchMetrics(selector);
      const fetchedLabelKeys = await fetchLabelKeys(selector);
      const newSelectedLabelKeys = selectedLabelKeys.filter((slk) => fetchedLabelKeys.includes(slk));
      const [transformedLabelValues, newSelectedLabelValues] = await fetchLabelValues(
        newSelectedLabelKeys,
        newSelectedMetric === "" ? void 0 : selector
      );
      setMetrics(fetchedMetrics);
      setSelectedMetric(newSelectedMetric);
      setLabelKeys(fetchedLabelKeys);
      setSelectedLabelKeys(newSelectedLabelKeys);
      setLabelValues(transformedLabelValues);
      setSelectedLabelValues(newSelectedLabelValues);
    } catch (e) {
      handleError(e, "Error fetching labels");
    }
  };
  const handleSelectedLabelKeyChange = async (labelKey) => {
    const newSelectedLabelKeys = [...selectedLabelKeys];
    const lkIdx = newSelectedLabelKeys.indexOf(labelKey);
    const newLabelValues = { ...labelValues };
    const newSelectedLabelValues = { ...selectedLabelValues };
    if (lkIdx === -1) {
      newSelectedLabelKeys.push(labelKey);
      const safeSelector = buildSafeSelector(selectedMetric, selectedLabelValues);
      const [values] = await fetchLabelValues([labelKey], safeSelector);
      newLabelValues[labelKey] = values[labelKey];
    } else {
      newSelectedLabelKeys.splice(lkIdx, 1);
      delete newLabelValues[labelKey];
      delete newSelectedLabelValues[labelKey];
    }
    localStorage.setItem(LAST_USED_LABELS_KEY, JSON.stringify(newSelectedLabelKeys));
    setSelectedLabelKeys(newSelectedLabelKeys);
    setLabelValues(newLabelValues);
    setSelectedLabelValues(newSelectedLabelValues);
  };
  const handleSelectedLabelValueChange = async (labelKey, labelValue, isSelected) => {
    var _a;
    const newSelectedLabelValues = { ...selectedLabelValues };
    let newLastSelectedLabelKey = lastSelectedLabelKey;
    if (labelKey !== lastSelectedLabelKey) {
      newLastSelectedLabelKey = labelKey;
    }
    if (isSelected) {
      if (!newSelectedLabelValues[labelKey]) {
        newSelectedLabelValues[labelKey] = [];
      }
      newSelectedLabelValues[labelKey].push(labelValue);
    } else {
      newSelectedLabelValues[labelKey].splice(newSelectedLabelValues[labelKey].indexOf(labelValue), 1);
      if (newSelectedLabelValues[labelKey].length === 0) {
        delete newSelectedLabelValues[labelKey];
      }
    }
    let safeSelector = buildSafeSelector(selectedMetric, newSelectedLabelValues);
    let newLabelValues = {};
    if (selectedLabelKeys.length !== 0) {
      for (const lk of selectedLabelKeys) {
        try {
          const fetchedLabelValues = await languageProvider.queryLabelValues(
            timeRange,
            lk,
            safeSelector,
            effectiveLimit
          );
          if (newLastSelectedLabelKey === lk) {
            newLabelValues[lk] = Array.from(/* @__PURE__ */ new Set([...labelValues[lk], ...fetchedLabelValues]));
          } else {
            newLabelValues[lk] = fetchedLabelValues;
            newSelectedLabelValues[lk] = ((_a = newSelectedLabelValues[lk]) != null ? _a : []).filter(
              (item) => fetchedLabelValues.includes(item)
            );
          }
          setErr("");
        } catch (e) {
          handleError(e, "Error fetching label values");
        }
      }
    }
    safeSelector = buildSafeSelector(selectedMetric, newSelectedLabelValues);
    const newMetrics = await fetchMetrics(safeSelector);
    let newLabelKeys = [];
    if (!safeSelector) {
      newLabelKeys = await fetchLabelKeys(void 0);
    } else {
      const labelKeysSelector = `{${METRIC_LABEL}=~"${newMetrics.map((m) => m.name).join("|")}"}`;
      newLabelKeys = await fetchLabelKeys(labelKeysSelector);
    }
    const newSelectedLabelKeys = loadSelectedLabelsFromStorage(newLabelKeys);
    setMetrics(newMetrics);
    setLabelKeys(newLabelKeys);
    setSelectedLabelKeys(newSelectedLabelKeys);
    setLastSelectedLabelKey(newLastSelectedLabelKey);
    setLabelValues(newLabelValues);
    setSelectedLabelValues(newSelectedLabelValues);
  };
  const handleValidation = async () => {
    const selector = buildSelector(selectedMetric, selectedLabelValues);
    setValidationStatus(`Validating selector ${selector}`);
    setErr("");
    try {
      const results = await languageProvider.queryLabelKeys(timeRangeRef.current, selector, effectiveLimit);
      setValidationStatus(`Selector is valid (${Object.keys(results).length} labels found)`);
    } catch (e) {
      handleError(e, "Validation failed");
      setValidationStatus("");
    }
  };
  const handleClear = () => {
    localStorage.setItem(LAST_USED_LABELS_KEY, "[]");
    setSelectedMetric("");
    setSelectedLabelKeys([]);
    setSelectedLabelValues({});
    setErr("");
    setStatus("Ready");
    setValidationStatus("");
    initialize("", {});
  };
  return {
    err,
    setErr,
    status,
    setStatus,
    seriesLimit,
    setSeriesLimit,
    validationStatus,
    metrics,
    labelKeys,
    labelValues,
    selectedMetric,
    selectedLabelKeys,
    selectedLabelValues,
    handleSelectedMetricChange,
    handleSelectedLabelKeyChange,
    handleSelectedLabelValueChange,
    handleValidation,
    handleClear,
    // Helper functions - not part of the public API
    buildSafeSelector,
    loadSelectedLabelsFromStorage,
    fetchMetrics,
    fetchLabelKeys,
    fetchLabelValues
  };
};

"use strict";
const MetricsBrowserContext = React.createContext(void 0);
function MetricsBrowserProvider({
  children,
  timeRange,
  languageProvider,
  onChange
}) {
  const {
    err,
    setErr,
    status,
    setStatus,
    seriesLimit,
    setSeriesLimit,
    validationStatus,
    metrics,
    labelKeys,
    labelValues,
    selectedMetric,
    selectedLabelKeys,
    selectedLabelValues,
    handleSelectedMetricChange,
    handleSelectedLabelKeyChange,
    handleSelectedLabelValueChange,
    handleValidation,
    handleClear
  } = useMetricsLabelsValues(timeRange, languageProvider);
  const getSelector = React.useCallback(
    () => buildSelector(selectedMetric, selectedLabelValues),
    [selectedLabelValues, selectedMetric]
  );
  const value = React.useMemo(
    () => ({
      err,
      setErr,
      status,
      setStatus,
      seriesLimit,
      setSeriesLimit,
      validationStatus,
      onChange,
      getSelector,
      metrics,
      labelKeys,
      labelValues,
      selectedMetric,
      selectedLabelKeys,
      selectedLabelValues,
      onMetricClick: handleSelectedMetricChange,
      onLabelKeyClick: handleSelectedLabelKeyChange,
      onLabelValueClick: handleSelectedLabelValueChange,
      onValidationClick: handleValidation,
      onClearClick: handleClear
    }),
    [
      err,
      setErr,
      status,
      setStatus,
      seriesLimit,
      setSeriesLimit,
      validationStatus,
      onChange,
      metrics,
      getSelector,
      labelKeys,
      labelValues,
      selectedMetric,
      selectedLabelKeys,
      selectedLabelValues,
      handleSelectedLabelKeyChange,
      handleSelectedLabelValueChange,
      handleSelectedMetricChange,
      handleValidation,
      handleClear
    ]
  );
  return /* @__PURE__ */ jsxRuntime.jsx(MetricsBrowserContext.Provider, { value, children });
}
function useMetricsBrowser() {
  const context = React.useContext(MetricsBrowserContext);
  if (context === void 0) {
    throw new Error("useMetricsBrowser must be used within a MetricsBrowserProvider");
  }
  return context;
}

"use strict";
const getStylesMetricsBrowser = (theme) => ({
  wrapper: css.css({
    backgroundColor: theme.colors.background.secondary,
    padding: theme.spacing(1),
    width: "100%"
  })
});
const getStylesMetricSelector = (theme) => ({
  section: css.css({
    "& + &": {
      margin: `${theme.spacing(2)} 0`
    },
    position: "relative"
  }),
  valueListWrapper: css.css({
    borderLeft: `1px solid ${theme.colors.border.medium}`,
    margin: `${theme.spacing(1)} 0`,
    padding: `${theme.spacing(1)} 0 ${theme.spacing(1)} ${theme.spacing(1)}`
  }),
  valueList: css.css({
    marginRight: theme.spacing(1),
    resize: "horizontal"
  })
});
const getStylesLabelSelector = (theme) => ({
  section: css.css({
    "& + &": {
      margin: `${theme.spacing(2)} 0`
    },
    position: "relative"
  }),
  list: css.css({
    marginTop: theme.spacing(1),
    display: "flex",
    flexWrap: "wrap",
    maxHeight: "200px",
    overflow: "auto",
    alignContent: "flex-start"
  })
});
const getStylesValueSelector = (theme) => ({
  section: css.css({
    "& + &": {
      margin: `${theme.spacing(2)} 0`
    },
    position: "relative"
  }),
  valueListArea: css.css({
    display: "flex",
    flexWrap: "wrap",
    marginTop: theme.spacing(1)
  }),
  valueTitle: css.css({
    marginLeft: `-${theme.spacing(0.5)}`,
    marginBottom: theme.spacing(1)
  }),
  valueListWrapper: css.css({
    borderLeft: `1px solid ${theme.colors.border.medium}`,
    margin: `${theme.spacing(1)} 0`,
    padding: `${theme.spacing(1)} 0 ${theme.spacing(1)} ${theme.spacing(1)}`
  }),
  valueList: css.css({
    marginRight: theme.spacing(1),
    resize: "horizontal"
  })
});
const getStylesSelectorActions = (theme) => ({
  section: css.css({
    "& + &": {
      margin: `${theme.spacing(2)} 0`
    },
    position: "relative"
  }),
  selector: css.css({
    fontFamily: theme.typography.fontFamilyMonospace,
    marginBottom: theme.spacing(1)
  }),
  status: css.css({
    padding: theme.spacing(0.5),
    color: theme.colors.text.secondary,
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    width: "100%",
    right: 0,
    textAlign: "right",
    opacity: 0,
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      transition: "opacity 100ms linear"
    }
  }),
  statusShowing: css.css({
    opacity: 1
  }),
  error: css.css({
    color: theme.colors.error.main
  }),
  validationStatus: css.css({
    padding: theme.spacing(0.5),
    marginBottom: theme.spacing(1),
    color: theme.colors.text.maxContrast,
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis"
  })
});

"use strict";
function LabelSelector() {
  const styles = ui.useStyles2(getStylesLabelSelector);
  const [labelSearchTerm, setLabelSearchTerm] = React.useState("");
  const { labelKeys, selectedLabelKeys, onLabelKeyClick } = useMetricsBrowser();
  const filteredLabelKeys = React.useMemo(() => {
    return labelKeys.filter(
      (lk) => lk !== METRIC_LABEL && (selectedLabelKeys.includes(lk) || lk.includes(labelSearchTerm))
    );
  }, [labelKeys, labelSearchTerm, selectedLabelKeys]);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.Label,
      {
        description: i18n.t(
          "grafana-prometheus.components.label-selector.description-select-labels",
          "Once label values are selected, only possible label combinations are shown."
        ),
        children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.label-selector.select-labels-to-search-in", children: "2. Select labels to search in" })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.Input,
      {
        onChange: (e) => setLabelSearchTerm(e.currentTarget.value),
        "aria-label": i18n.t(
          "grafana-prometheus.components.label-selector.aria-label-filter-expression-for-label",
          "Filter expression for label"
        ),
        value: labelSearchTerm,
        "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.labelNamesFilter
      }
    ) }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.list, style: { height: 120 }, children: filteredLabelKeys.map((label) => /* @__PURE__ */ jsxRuntime.jsx(
      ui.BrowserLabel,
      {
        name: label,
        loading: false,
        active: selectedLabelKeys.includes(label),
        hidden: false,
        facets: void 0,
        onClick: (name) => {
          setLabelSearchTerm("");
          onLabelKeyClick(name);
        },
        searchTerm: labelSearchTerm
      },
      label
    )) })
  ] });
}

"use strict";
function MetricSelector() {
  const styles = ui.useStyles2(getStylesMetricSelector);
  const [metricSearchTerm, setMetricSearchTerm] = React.useState("");
  const { metrics, selectedMetric, seriesLimit, setSeriesLimit, onMetricClick } = useMetricsBrowser();
  const filteredMetrics = React.useMemo(() => {
    return metrics.filter((m) => m.name === selectedMetric || m.name.includes(metricSearchTerm));
  }, [metrics, selectedMetric, metricSearchTerm]);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.Label,
      {
        description: i18n.t(
          "grafana-prometheus.components.metric-selector.label-select-metric",
          "Once a metric is selected only possible labels are shown. Labels are limited by the series limit below."
        ),
        children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.metric-selector.select-a-metric", children: "1. Select a metric" })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.Input,
      {
        onChange: (e) => setMetricSearchTerm(e.currentTarget.value),
        "aria-label": i18n.t(
          "grafana-prometheus.components.metric-selector.aria-label-filter-expression-for-metric",
          "Filter expression for metric"
        ),
        value: metricSearchTerm,
        "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.selectMetric
      }
    ) }),
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.Label,
      {
        description: i18n.t(
          "grafana-prometheus.components.metric-selector.description-series-limit",
          "The limit applies to all metrics, labels, and values. Leave the field empty to use the default limit. Set to 0 to disable the limit and fetch everything \u2014 this may cause performance issues."
        ),
        children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.metric-selector.series-limit", children: "Series limit" })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.Input,
      {
        onChange: (e) => setSeriesLimit(parseInt(e.currentTarget.value.trim(), 10)),
        "aria-label": i18n.t(
          "grafana-prometheus.components.metric-selector.aria-label-limit-results-from-series-endpoint",
          "Limit results from series endpoint"
        ),
        value: seriesLimit,
        "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.seriesLimit
      }
    ) }),
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        role: "list",
        className: styles.valueListWrapper,
        "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.metricList,
        children: /* @__PURE__ */ jsxRuntime.jsx(
          reactWindow.FixedSizeList,
          {
            height: Math.min(450, filteredMetrics.length * LIST_ITEM_SIZE),
            itemCount: filteredMetrics.length,
            itemSize: LIST_ITEM_SIZE,
            itemKey: (i) => filteredMetrics[i].name,
            width: 300,
            className: styles.valueList,
            children: ({ index, style }) => {
              const metric = filteredMetrics[index];
              return /* @__PURE__ */ jsxRuntime.jsx("div", { style, children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.BrowserLabel,
                {
                  name: metric.name,
                  value: metric.name,
                  title: metric.details,
                  active: metric.name === selectedMetric,
                  onClick: (name, value) => {
                    setMetricSearchTerm("");
                    onMetricClick(name);
                  },
                  searchTerm: metricSearchTerm
                }
              ) });
            }
          }
        )
      }
    )
  ] }) });
}

"use strict";
function SelectorActions() {
  const styles = ui.useStyles2(getStylesSelectorActions);
  const { validationStatus, onValidationClick, getSelector, onChange, status, err, onClearClick } = useMetricsBrowser();
  const selector = getSelector();
  const onClickRunQuery = () => {
    onChange(selector);
  };
  const onClickRunRateQuery = () => {
    const query = `rate(${selector}[$__rate_interval])`;
    onChange(query);
  };
  const empty = React.useMemo(() => selector === EMPTY_SELECTOR, [selector]);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsxRuntime.jsx(ui.Label, { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.selector-actions.resulting-selector", children: "4. Resulting selector" }) }),
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        "aria-label": i18n.t("grafana-prometheus.components.selector-actions.aria-label-selector", "selector"),
        className: styles.selector,
        children: selector
      }
    ),
    validationStatus && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.validationStatus, children: validationStatus }),
    /* @__PURE__ */ jsxRuntime.jsxs(ui.Stack, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.useQuery,
          "aria-label": i18n.t(
            "grafana-prometheus.components.selector-actions.aria-label-use-selector-for-query-button",
            "Use selector for query button"
          ),
          disabled: empty,
          onClick: onClickRunQuery,
          children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.selector-actions.use-query", children: "Use query" })
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.useAsRateQuery,
          "aria-label": i18n.t(
            "grafana-prometheus.components.selector-actions.aria-label-use-selector-as-metrics-button",
            "Use selector as metrics button"
          ),
          variant: "secondary",
          disabled: empty,
          onClick: onClickRunRateQuery,
          children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.selector-actions.use-as-rate-query", children: "Use as rate query" })
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.validateSelector,
          "aria-label": i18n.t(
            "grafana-prometheus.components.selector-actions.aria-label-validate-submit-button",
            "Validate submit button"
          ),
          variant: "secondary",
          disabled: empty,
          onClick: onValidationClick,
          children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.selector-actions.validate-selector", children: "Validate selector" })
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.clear,
          "aria-label": i18n.t(
            "grafana-prometheus.components.selector-actions.aria-label-selector-clear-button",
            "Selector clear button"
          ),
          variant: "secondary",
          onClick: onClearClick,
          children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.selector-actions.clear", children: "Clear" })
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.status, (status || err) && styles.statusShowing), children: /* @__PURE__ */ jsxRuntime.jsx("span", { className: err ? styles.error : "", children: err || status }) })
    ] })
  ] });
}

"use strict";
function ValueSelector() {
  const styles = ui.useStyles2(getStylesValueSelector);
  const [valueSearchTerm, setValueSearchTerm] = React.useState("");
  const { labelValues, selectedLabelValues, onLabelValueClick, onLabelKeyClick } = useMetricsBrowser();
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.Label,
      {
        description: i18n.t(
          "grafana-prometheus.components.value-selector.description-search-field-values-across-selected-labels",
          "Use the search field to find values across selected labels."
        ),
        children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.value-selector.select-multiple-values-for-your-labels", children: "3. Select (multiple) values for your labels" })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.Input,
      {
        onChange: (e) => setValueSearchTerm(e.currentTarget.value),
        "aria-label": i18n.t(
          "grafana-prometheus.components.value-selector.aria-label-filter-expression-for-label-values",
          "Filter expression for label values"
        ),
        value: valueSearchTerm,
        "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.labelValuesFilter
      }
    ) }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.valueListArea, children: Object.entries(labelValues).map(([lk, lv]) => {
      if (!lk || !lv) {
        console.error("label values are empty:", { lk, lv });
        return null;
      }
      return /* @__PURE__ */ jsxRuntime.jsxs(
        "div",
        {
          role: "list",
          "aria-label": i18n.t(
            "grafana-prometheus.components.value-selector.aria-label-values-for",
            "Values for {{labelKey}}",
            {
              labelKey: lk
            }
          ),
          className: styles.valueListWrapper,
          children: [
            /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.valueTitle, children: /* @__PURE__ */ jsxRuntime.jsx(
              ui.BrowserLabel,
              {
                name: lk,
                loading: false,
                active: true,
                hidden: false,
                facets: lv.length,
                onClick: onLabelKeyClick
              }
            ) }),
            /* @__PURE__ */ jsxRuntime.jsx(
              reactWindow.FixedSizeList,
              {
                height: Math.min(200, LIST_ITEM_SIZE * (lv.length || 0)),
                itemCount: lv.length || 0,
                itemSize: 28,
                itemKey: (i) => lv[i],
                width: 200,
                className: styles.valueList,
                children: ({ index, style }) => {
                  var _a;
                  const value = lv[index];
                  const isSelected = (_a = selectedLabelValues[lk]) == null ? void 0 : _a.includes(value);
                  return /* @__PURE__ */ jsxRuntime.jsx("div", { style, children: /* @__PURE__ */ jsxRuntime.jsx(
                    ui.BrowserLabel,
                    {
                      name: value,
                      value,
                      active: isSelected,
                      onClick: (name) => onLabelValueClick(lk, name, !isSelected),
                      searchTerm: valueSearchTerm
                    }
                  ) });
                }
              }
            )
          ]
        },
        lk
      );
    }) })
  ] });
}

"use strict";
const MetricsBrowser = () => {
  const styles = ui.useStyles2(getStylesMetricsBrowser);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsxRuntime.jsxs(ui.Stack, { gap: 3, children: [
      /* @__PURE__ */ jsxRuntime.jsx(MetricSelector, {}),
      /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntime.jsx(LabelSelector, {}),
        /* @__PURE__ */ jsxRuntime.jsx(ValueSelector, {})
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(SelectorActions, {})
  ] });
};

"use strict";
function makeStorageService() {
  const strings = /* @__PURE__ */ new Map();
  strings.set("expandSuggestionDocs", true.toString());
  return {
    // we do not implement the on* handlers
    onDidChangeValue: (data) => void 0,
    onDidChangeTarget: (data) => void 0,
    onWillSaveState: (data) => void 0,
    get: (key, scope, fallbackValue) => {
      var _a;
      return (_a = strings.get(key)) != null ? _a : fallbackValue;
    },
    getBoolean: (key, scope, fallbackValue) => {
      const val = strings.get(key);
      if (val !== void 0) {
        return val === "true";
      } else {
        return fallbackValue;
      }
    },
    getNumber: (key, scope, fallbackValue) => {
      const val = strings.get(key);
      if (val !== void 0) {
        return parseInt(val, 10);
      } else {
        return fallbackValue;
      }
    },
    store: (key, value, scope, target) => {
      if (value === null || value === void 0) {
        strings.delete(key);
      } else {
        strings.set(key, value.toString());
      }
    },
    remove: (key, scope) => {
      strings.delete(key);
    },
    keys: (scope, target) => {
      return Array.from(strings.keys());
    },
    logStorage: () => {
      console.log("logStorage: not implemented");
    },
    migrate: () => {
      return Promise.resolve(void 0);
    },
    isNew: (scope) => {
      return true;
    },
    flush: (reason) => {
      return Promise.resolve(void 0);
    }
  };
}
let overrideServices = null;
function getOverrideServices() {
  if (overrideServices === null) {
    overrideServices = {
      storageService: makeStorageService()
    };
  }
  return overrideServices;
}

"use strict";
const CODE_MODE_SUGGESTIONS_INCOMPLETE_EVENT = "codeModeSuggestionsIncomplete";
function isSuggestionsIncompleteEvent(e) {
  return e.type === CODE_MODE_SUGGESTIONS_INCOMPLETE_EVENT && "detail" in e && typeof e.detail === "object" && e.detail !== null && "limit" in e.detail && "datasourceUid" in e.detail;
}
class DataProvider {
  constructor(params) {
    this.languageProvider = params.languageProvider;
    this.historyProvider = params.historyProvider;
    this.inputInRange = "";
    this.metricNamesSuggestionLimit = this.languageProvider.datasource.metricNamesAutocompleteSuggestionLimit;
    this.suggestionsIncomplete = false;
    this.getSeriesLabels = this.languageProvider.queryLabelKeys.bind(this.languageProvider);
    this.getSeriesValues = this.languageProvider.queryLabelValues.bind(this.languageProvider);
    this.getAllLabelNames = this.languageProvider.retrieveLabelKeys.bind(this.languageProvider);
    this.getLabelValues = this.languageProvider.queryLabelValues.bind(this.languageProvider);
  }
  getHistory() {
    return this.historyProvider.map((h) => h.query.expr).filter(Boolean);
  }
  getAllMetricNames() {
    return this.languageProvider.retrieveMetrics();
  }
  metricNamesToMetrics(metricNames) {
    const metricsMetadata = this.languageProvider.retrieveMetricsMetadata();
    const result = metricNames.map((m) => {
      var _a, _b;
      const metaItem = metricsMetadata == null ? void 0 : metricsMetadata[m];
      return {
        name: m,
        help: (_a = metaItem == null ? void 0 : metaItem.help) != null ? _a : "",
        type: (_b = metaItem == null ? void 0 : metaItem.type) != null ? _b : "",
        isUtf8: !isValidLegacyName(m)
      };
    });
    return result;
  }
  enableAutocompleteSuggestionsUpdate() {
    this.suggestionsIncomplete = true;
    dispatchEvent(
      new CustomEvent(CODE_MODE_SUGGESTIONS_INCOMPLETE_EVENT, {
        detail: { limit: this.metricNamesSuggestionLimit, datasourceUid: this.languageProvider.datasource.uid }
      })
    );
  }
  setInputInRange(textInput) {
    this.inputInRange = textInput;
  }
  get monacoSettings() {
    return {
      /**
       * Enable autocomplete suggestions update on every input change.
       *
       * @remarks
       * If fuzzy search is used in `getCompletions` to trim down results to improve performance,
       * we need to instruct Monaco to update the completions on every input change, so that the
       * completions reflect the current input.
       */
      enableAutocompleteSuggestionsUpdate: this.enableAutocompleteSuggestionsUpdate.bind(this),
      inputInRange: this.inputInRange,
      setInputInRange: this.setInputInRange.bind(this),
      suggestionsIncomplete: this.suggestionsIncomplete
    };
  }
}

"use strict";
class NeverCaseError extends Error {
  constructor(value) {
    super("should never happen");
  }
}

"use strict";
const InsertAsSnippet = 4;
const metricNamesSearch = {
  // see https://github.com/leeoniya/uFuzzy?tab=readme-ov-file#how-it-works for details
  multiInsert: new uFuzzy__default.default({ intraMode: 0 }),
  singleError: new uFuzzy__default.default({ intraMode: 1 })
};
const snippetMarker = "${1:}";
function filterMetricNames({ metricNames, inputText, limit }) {
  if (!(inputText == null ? void 0 : inputText.trim())) {
    return metricNames.slice(0, limit);
  }
  const terms = metricNamesSearch.multiInsert.split(inputText);
  const isComplexSearch = terms.length > 4;
  const fuzzyResults = isComplexSearch ? metricNamesSearch.multiInsert.filter(metricNames, inputText) : metricNamesSearch.singleError.filter(metricNames, inputText);
  return fuzzyResults ? fuzzyResults.slice(0, limit).map((idx) => metricNames[idx]) : [];
}
function getAllMetricNamesCompletions(dataProvider) {
  let metricNames = dataProvider.getAllMetricNames();
  if (runtime.config.featureToggles.prometheusCodeModeMetricNamesSearch && metricNames.length > dataProvider.metricNamesSuggestionLimit) {
    const { monacoSettings } = dataProvider;
    monacoSettings.enableAutocompleteSuggestionsUpdate();
    if (monacoSettings.inputInRange) {
      metricNames = filterMetricNames({
        metricNames,
        inputText: monacoSettings.inputInRange,
        limit: dataProvider.metricNamesSuggestionLimit
      });
    } else {
      metricNames = metricNames.slice(0, dataProvider.metricNamesSuggestionLimit);
    }
  }
  return dataProvider.metricNamesToMetrics(metricNames).map((metric) => ({
    type: "METRIC_NAME",
    label: metric.name,
    detail: `${metric.name} : ${metric.type}`,
    documentation: metric.help,
    ...metric.isUtf8 ? {
      insertText: `{"${metric.name}"${snippetMarker}}`,
      insertTextRules: InsertAsSnippet
    } : {
      insertText: metric.name
    }
  }));
}
const FUNCTION_COMPLETIONS = FUNCTIONS.map((f) => {
  var _a;
  return {
    type: "FUNCTION",
    label: f.label,
    insertText: (_a = f.insertText) != null ? _a : "",
    // i don't know what to do when this is nullish. it should not be.
    detail: f.detail,
    documentation: f.documentation
  };
});
async function getAllFunctionsAndMetricNamesCompletions(dataProvider) {
  const metricNames = getAllMetricNamesCompletions(dataProvider);
  return [...FUNCTION_COMPLETIONS, ...metricNames];
}
const DURATION_COMPLETIONS = [
  "$__interval",
  "$__range",
  "$__rate_interval",
  "1m",
  "5m",
  "10m",
  "30m",
  "1h",
  "1d"
].map((text) => ({
  type: "DURATION",
  label: text,
  insertText: text
}));
function getAllHistoryCompletions(dataProvider) {
  const allHistory = dataProvider.getHistory();
  return allHistory.slice(0, 10).map((expr) => ({
    type: "HISTORY",
    label: expr,
    insertText: expr
  }));
}
function makeSelector(metricName, labels) {
  const allLabels = [...labels];
  if (metricName !== void 0) {
    allLabels.push({ name: "__name__", value: metricName, op: "=" });
  }
  const allLabelTexts = allLabels.map(
    (label) => `${label.name}${label.op}"${escapeLabelValueInExactSelector(label.value)}"`
  );
  return `{${allLabelTexts.join(",")}}`;
}
async function getLabelNames(metric, otherLabels, dataProvider, timeRange) {
  if (metric === void 0 && otherLabels.length === 0) {
    return Promise.resolve(dataProvider.getAllLabelNames());
  } else {
    const selector = makeSelector(metric, otherLabels);
    const labelNames = await dataProvider.getSeriesLabels(timeRange, selector);
    otherLabels.push({ name: "__name__", value: "", op: "!=" });
    const usedLabelNames = new Set(otherLabels.map((l) => l.name));
    return labelNames.filter((l) => !usedLabelNames.has(l));
  }
}
async function getLabelNamesForCompletions(metric, suffix, triggerOnInsert, otherLabels, dataProvider, timeRange) {
  const labelNames = await getLabelNames(metric, otherLabels, dataProvider, timeRange);
  return labelNames.map((text) => {
    const isUtf8 = !isValidLegacyName(text);
    return {
      type: "LABEL_NAME",
      label: text,
      ...isUtf8 ? {
        insertText: `"${text}"${suffix}`,
        insertTextRules: InsertAsSnippet
      } : {
        insertText: `${text}${suffix}`
      },
      triggerOnInsert
    };
  });
}
async function getLabelNamesForSelectorCompletions(metric, otherLabels, dataProvider, timeRange) {
  return getLabelNamesForCompletions(metric, "=", true, otherLabels, dataProvider, timeRange);
}
async function getLabelNamesForByCompletions(metric, otherLabels, dataProvider, timeRange) {
  return getLabelNamesForCompletions(metric, "", false, otherLabels, dataProvider, timeRange);
}
async function getLabelValues(metric, labelName, otherLabels, dataProvider, timeRange) {
  if (metric === void 0 && otherLabels.length === 0) {
    return dataProvider.getLabelValues(timeRange, labelName);
  } else {
    const selector = makeSelector(metric, otherLabels);
    return await dataProvider.getSeriesValues(timeRange, labelName, selector);
  }
}
async function getLabelValuesForMetricCompletions(metric, labelName, betweenQuotes, otherLabels, dataProvider, timeRange) {
  const values = await getLabelValues(metric, labelName, otherLabels, dataProvider, timeRange);
  return values.map((text) => ({
    type: "LABEL_VALUE",
    label: text,
    insertText: formatLabelValueForCompletion(text, betweenQuotes)
  }));
}
function formatLabelValueForCompletion(value, betweenQuotes) {
  const text = runtime.config.featureToggles.prometheusSpecialCharsInLabelValues ? prometheusRegularEscape(value) : value;
  return betweenQuotes ? text : `"${text}"`;
}
function getCompletions(situation, dataProvider, timeRange) {
  switch (situation.type) {
    case "IN_DURATION":
      return Promise.resolve(DURATION_COMPLETIONS);
    case "IN_FUNCTION":
      return getAllFunctionsAndMetricNamesCompletions(dataProvider);
    case "AT_ROOT": {
      return getAllFunctionsAndMetricNamesCompletions(dataProvider);
    }
    case "EMPTY": {
      const metricNames = getAllMetricNamesCompletions(dataProvider);
      const historyCompletions = getAllHistoryCompletions(dataProvider);
      return Promise.resolve([...historyCompletions, ...FUNCTION_COMPLETIONS, ...metricNames]);
    }
    case "IN_LABEL_SELECTOR_NO_LABEL_NAME":
      return getLabelNamesForSelectorCompletions(situation.metricName, situation.otherLabels, dataProvider, timeRange);
    case "IN_GROUPING":
      return getLabelNamesForByCompletions(situation.metricName, situation.otherLabels, dataProvider, timeRange);
    case "IN_LABEL_SELECTOR_WITH_LABEL_NAME":
      return getLabelValuesForMetricCompletions(
        situation.metricName,
        situation.labelName,
        situation.betweenQuotes,
        situation.otherLabels,
        dataProvider,
        timeRange
      );
    default:
      throw new NeverCaseError(situation);
  }
}

"use strict";
function move(node, direction) {
  switch (direction) {
    case "parent":
      return node.parent;
    case "firstChild":
      return node.firstChild;
    case "lastChild":
      return node.lastChild;
    case "nextSibling":
      return node.nextSibling;
    default:
      throw new NeverCaseError(direction);
  }
}
function walk(node, path) {
  let current = node;
  for (const [direction, expectedType] of path) {
    current = move(current, direction);
    if (current === null) {
      return null;
    }
    if (current.type.id !== expectedType) {
      return null;
    }
  }
  return current;
}
function getNodeText(node, text, utf8) {
  const nodeFrom = utf8 ? node.from + 1 : node.from;
  const nodeTo = utf8 ? node.to - 1 : node.to;
  return text.slice(nodeFrom, nodeTo);
}
function parsePromQLStringLiteral(text) {
  const inside = text.slice(1, text.length - 1);
  if (text.startsWith('"') && text.endsWith('"')) {
    return inside.replace(/\\"/, '"');
  }
  if (text.startsWith("'") && text.endsWith("'")) {
    return inside.replace(/\\'/, "'");
  }
  if (text.startsWith("`") && text.endsWith("`")) {
    return inside;
  }
  throw new Error("FIXME: invalid string literal");
}
function isPathMatch(resolverPath, cursorPath) {
  return resolverPath.every((item, index) => item === cursorPath[index]);
}
const ERROR_NODE_NAME = 0;
const RESOLVERS = [
  {
    path: [lezerPromql.LabelMatchers, lezerPromql.VectorSelector],
    fun: resolveLabelKeysWithEquals
  },
  {
    path: [lezerPromql.StringLiteral, lezerPromql.QuotedLabelName, lezerPromql.LabelMatchers, lezerPromql.VectorSelector],
    fun: resolveUtf8LabelKeysWithEquals
  },
  {
    path: [lezerPromql.PromQL],
    fun: resolveTopLevel
  },
  {
    path: [lezerPromql.FunctionCallBody],
    fun: resolveInFunction
  },
  {
    path: [lezerPromql.StringLiteral, lezerPromql.UnquotedLabelMatcher],
    fun: resolveLabelMatcher
  },
  {
    path: [lezerPromql.StringLiteral, lezerPromql.QuotedLabelMatcher],
    fun: resolveQuotedLabelMatcher
  },
  {
    path: [ERROR_NODE_NAME, lezerPromql.BinaryExpr, lezerPromql.PromQL],
    fun: resolveTopLevel
  },
  {
    path: [ERROR_NODE_NAME, lezerPromql.UnquotedLabelMatcher],
    fun: resolveLabelMatcher
  },
  {
    path: [ERROR_NODE_NAME, lezerPromql.QuotedLabelMatcher],
    fun: resolveQuotedLabelMatcher
  },
  {
    path: [ERROR_NODE_NAME, lezerPromql.NumberDurationLiteralInDurationContext, lezerPromql.MatrixSelector],
    fun: resolveDurations
  },
  {
    path: [lezerPromql.GroupingLabels],
    fun: resolveLabelsForGrouping
  }
];
const LABEL_OP_MAP = /* @__PURE__ */ new Map([
  [lezerPromql.EqlSingle, "="],
  [lezerPromql.EqlRegex, "=~"],
  [lezerPromql.Neq, "!="],
  [lezerPromql.NeqRegex, "!~"]
]);
function getLabelOp(opNode) {
  var _a;
  const opChild = opNode.firstChild;
  if (opChild === null) {
    return null;
  }
  return (_a = LABEL_OP_MAP.get(opChild.type.id)) != null ? _a : null;
}
function getLabel(labelMatcherNode, text) {
  var _a;
  const allowedMatchers = /* @__PURE__ */ new Set([lezerPromql.UnquotedLabelMatcher, lezerPromql.QuotedLabelMatcher]);
  if (!allowedMatchers.has(labelMatcherNode.type.id)) {
    return null;
  }
  const nameNode = (_a = walk(labelMatcherNode, [["firstChild", lezerPromql.LabelName]])) != null ? _a : walk(labelMatcherNode, [["firstChild", lezerPromql.QuotedLabelName]]);
  if (nameNode === null) {
    return null;
  }
  const opNode = walk(nameNode, [["nextSibling", lezerPromql.MatchOp]]);
  if (opNode === null) {
    return null;
  }
  const op = getLabelOp(opNode);
  if (op === null) {
    return null;
  }
  const valueNode = walk(labelMatcherNode, [["lastChild", lezerPromql.StringLiteral]]);
  if (valueNode === null) {
    return null;
  }
  const name = getNodeText(nameNode, text);
  const value = parsePromQLStringLiteral(getNodeText(valueNode, text));
  return { name, value, op };
}
function getLabels(labelMatchersNode, text) {
  if (labelMatchersNode.type.id !== lezerPromql.LabelMatchers) {
    return [];
  }
  const matchers = [lezerPromql.UnquotedLabelMatcher, lezerPromql.QuotedLabelMatcher];
  return matchers.reduce((acc, matcher) => {
    labelMatchersNode.getChildren(matcher).forEach((ln) => {
      const label = getLabel(ln, text);
      if (notEmpty(label)) {
        acc.push(label);
      }
    });
    return acc;
  }, []);
}
function getNodeChildren(node) {
  let child = node.firstChild;
  const children = [];
  while (child !== null) {
    children.push(child);
    child = child.nextSibling;
  }
  return children;
}
function getNodeInSubtree(node, typeId) {
  if (node.type.id === typeId) {
    return node;
  }
  const children = getNodeChildren(node);
  for (const child of children) {
    const n = getNodeInSubtree(child, typeId);
    if (n !== null) {
      return n;
    }
  }
  return null;
}
function resolveLabelsForGrouping(node, text, pos) {
  var _a, _b;
  const aggrExpNode = walk(node, [
    ["parent", lezerPromql.AggregateModifier],
    ["parent", lezerPromql.AggregateExpr]
  ]);
  if (aggrExpNode === null) {
    return null;
  }
  const bodyNode = aggrExpNode.getChild(lezerPromql.FunctionCallBody);
  if (bodyNode === null) {
    return null;
  }
  const metricIdNode = (_a = getNodeInSubtree(bodyNode, lezerPromql.Identifier)) != null ? _a : getNodeInSubtree(bodyNode, lezerPromql.StringLiteral);
  if (!metricIdNode) {
    return null;
  }
  if (metricIdNode.type.id === lezerPromql.StringLiteral && ((_b = metricIdNode.parent) == null ? void 0 : _b.type.id) !== lezerPromql.QuotedLabelName) {
    return null;
  }
  const metricName = getNodeText(metricIdNode, text, metricIdNode.type.id === lezerPromql.StringLiteral);
  return {
    type: "IN_GROUPING",
    metricName,
    otherLabels: []
  };
}
function resolveLabelMatcher(node, text, pos) {
  const inStringNode = !node.type.isError;
  const parent = walk(node, [["parent", lezerPromql.UnquotedLabelMatcher]]);
  if (parent === null) {
    return null;
  }
  const labelNameNode = walk(parent, [["firstChild", lezerPromql.LabelName]]);
  if (labelNameNode === null) {
    return null;
  }
  const labelName = getNodeText(labelNameNode, text);
  const labelMatchersNode = walk(parent, [["parent", lezerPromql.LabelMatchers]]);
  if (labelMatchersNode === null) {
    return null;
  }
  const allLabels = getLabels(labelMatchersNode, text);
  const otherLabels = allLabels.filter((label) => label.name !== labelName);
  const metricName = getMetricName(labelMatchersNode, text);
  return {
    type: "IN_LABEL_SELECTOR_WITH_LABEL_NAME",
    labelName,
    betweenQuotes: inStringNode,
    otherLabels,
    ...metricName ? { metricName } : {}
  };
}
function resolveQuotedLabelMatcher(node, text, pos) {
  const inStringNode = !node.type.isError;
  const parent = walk(node, [["parent", lezerPromql.QuotedLabelMatcher]]);
  if (parent === null) {
    return null;
  }
  const labelNameNode = walk(parent, [["firstChild", lezerPromql.QuotedLabelName]]);
  if (labelNameNode === null) {
    return null;
  }
  const labelName = getNodeText(labelNameNode, text);
  const labelMatchersNode = walk(parent, [["parent", lezerPromql.LabelMatchers]]);
  if (labelMatchersNode === null) {
    return null;
  }
  const allLabels = getLabels(labelMatchersNode, text);
  const otherLabels = allLabels.filter((label) => label.name !== labelName);
  const metricName = getMetricName(parent.parent, text);
  return {
    type: "IN_LABEL_SELECTOR_WITH_LABEL_NAME",
    labelName,
    betweenQuotes: inStringNode,
    otherLabels,
    ...metricName ? { metricName } : {}
  };
}
function resolveTopLevel(node, text, pos) {
  return {
    type: "AT_ROOT"
  };
}
function resolveInFunction(node, text, pos) {
  return {
    type: "IN_FUNCTION"
  };
}
function resolveDurations(node, text, pos) {
  return {
    type: "IN_DURATION"
  };
}
function resolveLabelKeysWithEquals(node, text, pos) {
  let child = walk(node, [["firstChild", lezerPromql.UnquotedLabelMatcher]]);
  if (child !== null) {
    const textToCheck = text.slice(child.to, pos);
    if (!textToCheck.includes(",")) {
      return null;
    }
  }
  child = walk(node, [["firstChild", lezerPromql.QuotedLabelName]]);
  if (child !== null) {
    const textToCheck = text.slice(child.to, pos);
    if (!textToCheck.includes(",")) {
      return null;
    }
  }
  const otherLabels = getLabels(node, text);
  const metricName = getMetricName(node, text);
  return {
    type: "IN_LABEL_SELECTOR_NO_LABEL_NAME",
    otherLabels,
    betweenQuotes: false,
    ...metricName ? { metricName } : {}
  };
}
function resolveUtf8LabelKeysWithEquals(node, text, pos) {
  var _a;
  const otherLabels = getLabels(node, text);
  const metricName = ((_a = node.parent) == null ? void 0 : _a.parent) ? getMetricName(node.parent.parent, text) : null;
  return {
    type: "IN_LABEL_SELECTOR_NO_LABEL_NAME",
    otherLabels,
    betweenQuotes: true,
    ...metricName ? { metricName } : {}
  };
}
function getMetricName(node, text) {
  const legacyMetricNameNode = walk(node, [
    ["parent", lezerPromql.VectorSelector],
    ["firstChild", lezerPromql.Identifier]
  ]);
  if (legacyMetricNameNode) {
    return getNodeText(legacyMetricNameNode, text);
  }
  const utf8MetricNameNode = walk(node, [
    ["parent", lezerPromql.VectorSelector],
    ["firstChild", lezerPromql.LabelMatchers],
    ["firstChild", lezerPromql.QuotedLabelName],
    ["firstChild", lezerPromql.StringLiteral]
  ]);
  if (utf8MetricNameNode) {
    return getNodeText(utf8MetricNameNode, text, true);
  }
  return null;
}
function getErrorNode(tree, pos) {
  const cur = tree.cursorAt(pos);
  while (true) {
    if (cur.from === pos && cur.to === pos) {
      const { node } = cur;
      if (node.type.isError) {
        return node;
      }
    }
    if (!cur.next()) {
      break;
    }
  }
  return null;
}
function getSituation(text, pos) {
  if (text === "") {
    return {
      type: "EMPTY"
    };
  }
  const tree = lezerPromql.parser.parse(text);
  const maybeErrorNode = getErrorNode(tree, pos);
  const cur = maybeErrorNode != null ? maybeErrorNode.cursor() : tree.cursorAt(pos);
  const currentNode = cur.node;
  const ids = [cur.type.id];
  while (cur.parent()) {
    ids.push(cur.type.id);
  }
  for (let resolver of RESOLVERS) {
    if (isPathMatch(resolver.path, ids)) {
      return resolver.fun(currentNode, text, pos);
    }
  }
  return null;
}
function notEmpty(value) {
  return value !== null && value !== void 0;
}

"use strict";
function getSuggestOptions() {
  return {
    // monaco-editor sometimes provides suggestions automatically, i am not
    // sure based on what, seems to be by analyzing the words already
    // written.
    // to try it out:
    // - enter `go_goroutines{job~`
    // - have the cursor at the end of the string
    // - press ctrl-enter
    // - you will get two suggestions
    // those were not provided by grafana, they are offered automatically.
    // i want to remove those. the only way i found is:
    // - every suggestion-item has a `kind` attribute,
    //   that controls the icon to the left of the suggestion.
    // - items auto-generated by monaco have `kind` set to `text`.
    // - we make sure grafana-provided suggestions do not have `kind` set to `text`.
    // - and then we tell monaco not to show suggestions of kind `text`
    showWords: false
  };
}
function getMonacoCompletionItemKind(type, monaco) {
  switch (type) {
    case "DURATION":
      return monaco.languages.CompletionItemKind.Unit;
    case "FUNCTION":
      return monaco.languages.CompletionItemKind.Variable;
    case "HISTORY":
      return monaco.languages.CompletionItemKind.Snippet;
    case "LABEL_NAME":
      return monaco.languages.CompletionItemKind.Enum;
    case "LABEL_VALUE":
      return monaco.languages.CompletionItemKind.EnumMember;
    case "METRIC_NAME":
      return monaco.languages.CompletionItemKind.Constructor;
    default:
      throw new NeverCaseError(type);
  }
}
function getCompletionProvider(monaco, dataProvider, timeRange) {
  const provideCompletionItems = (model, position) => {
    var _a;
    const word = model.getWordAtPosition(position);
    const range = word != null ? monaco.Range.lift({
      startLineNumber: position.lineNumber,
      endLineNumber: position.lineNumber,
      startColumn: word.startColumn,
      endColumn: word.endColumn
    }) : monaco.Range.fromPositions(position);
    const positionClone = {
      column: position.column,
      lineNumber: position.lineNumber
    };
    dataProvider.monacoSettings.setInputInRange(model.getValueInRange(range));
    if (window.getSelection) {
      const selectedText = (_a = window.getSelection()) == null ? void 0 : _a.toString();
      if (selectedText && selectedText.length > 0) {
        positionClone.column = positionClone.column - selectedText.length;
      }
    }
    const offset = model.getOffsetAt(positionClone);
    const situation = getSituation(model.getValue(), offset);
    const completionsPromise = situation != null ? getCompletions(situation, dataProvider, timeRange) : Promise.resolve([]);
    return completionsPromise.then((items) => {
      const maxIndexDigits = items.length.toString().length;
      const suggestions = items.map((item, index) => ({
        kind: getMonacoCompletionItemKind(item.type, monaco),
        label: item.label,
        insertText: item.insertText,
        insertTextRules: item.insertTextRules,
        detail: item.detail,
        documentation: item.documentation,
        sortText: index.toString().padStart(maxIndexDigits, "0"),
        // to force the order we have
        range,
        command: item.triggerOnInsert ? {
          id: "editor.action.triggerSuggest",
          title: ""
        } : void 0
      }));
      return { suggestions, incomplete: dataProvider.monacoSettings.suggestionsIncomplete };
    });
  };
  return {
    triggerCharacters: ["{", ",", "[", "(", "=", "~", " ", '"'],
    provideCompletionItems
  };
}

"use strict";
const ErrorId = 0;
const warningTypes = {
  SubqueryExpr: "This subquery may return only one data point, preventing rate/increase/delta calculations. Use a range at least twice the step size (e.g., [2x:x])."
};
var NodeType = /* @__PURE__ */ ((NodeType2) => {
  NodeType2["SubqueryExpr"] = "SubqueryExpr";
  NodeType2["Duration"] = "NumberDurationLiteralInDurationContext";
  return NodeType2;
})(NodeType || {});
function validateQuery(query, interpolatedQuery, queryLines, parser) {
  if (!query) {
    return { errors: [], warnings: [] };
  }
  const { errors: interpolatedErrors, warnings: interpolatedWarnings } = parseQuery(interpolatedQuery, parser);
  if (!interpolatedErrors.length && !interpolatedWarnings.length) {
    return { errors: [], warnings: [] };
  }
  let parseErrors = interpolatedErrors;
  let parseWarnings = interpolatedWarnings;
  if (query !== interpolatedQuery) {
    const { errors: queryErrors, warnings: queryWarnings } = parseQuery(query, parser);
    parseErrors = interpolatedErrors.flatMap(
      (interpolatedError) => queryErrors.filter((queryError) => interpolatedError.text === queryError.text) || interpolatedError
    );
    parseWarnings = interpolatedWarnings.flatMap(
      (interpolatedWarning) => queryWarnings.filter((queryWarning) => interpolatedWarning.node.from === queryWarning.node.from) || interpolatedWarning
    );
  }
  const errorBoundaries = parseErrors.map((parseError) => findIssueBoundary(query, queryLines, parseError, "error")).filter(isValidIssueBoundary);
  const warningBoundaries = parseWarnings.map((parseWarning) => findIssueBoundary(query, queryLines, parseWarning, "warning")).filter(isValidIssueBoundary);
  return {
    errors: errorBoundaries,
    warnings: warningBoundaries
  };
}
function parseQuery(query, parser) {
  const parseErrors = [];
  const parseWarnings = [];
  const tree = parser.parse(query);
  tree.iterate({
    enter: (nodeRef) => {
      if (nodeRef.type.id === ErrorId) {
        const node = nodeRef.node;
        parseErrors.push({ node, text: query.substring(node.from, node.to) });
      }
      if (nodeRef.type.name === "SubqueryExpr" /* SubqueryExpr */) {
        const node = nodeRef.node;
        const durations = [];
        const children = node.getChildren("NumberDurationLiteralInDurationContext" /* Duration */);
        for (const child of children) {
          durations.push(query.substring(child.from, child.to));
        }
        if (durations.length === 2 && durations[0] === durations[1]) {
          parseWarnings.push({ node, text: query.substring(node.from, node.to) });
        }
      }
    }
  });
  return { errors: parseErrors, warnings: parseWarnings };
}
function findIssueBoundary(query, queryLines, parseError, issueType) {
  if (queryLines.length === 1) {
    const isEmptyString = parseError.node.from === parseError.node.to;
    const errorNode = isEmptyString && parseError.node.parent ? parseError.node.parent : parseError.node;
    let issue;
    if (issueType === "error") {
      issue = isEmptyString ? query.substring(errorNode.from, errorNode.to) : parseError.text;
    } else {
      issue = warningTypes[parseError.node.type.name];
    }
    return {
      startLineNumber: 1,
      startColumn: errorNode.from + 1,
      endLineNumber: 1,
      endColumn: errorNode.to + 1,
      issue
    };
  }
  let startPos = 0, endPos = 0;
  for (let line = 0; line < queryLines.length; line++) {
    endPos = startPos + queryLines[line].length;
    if (parseError.node.from > endPos) {
      startPos += queryLines[line].length + 1;
      continue;
    }
    return {
      startLineNumber: line + 1,
      startColumn: parseError.node.from - startPos + 1,
      endLineNumber: line + 1,
      endColumn: parseError.node.to - startPos + 1,
      issue: issueType === "error" ? parseError.text : warningTypes[parseError.node.type.name]
    };
  }
  return null;
}
function isValidIssueBoundary(boundary) {
  return boundary !== null;
}
const placeHolderScopedVars = {
  __interval: { text: "1s", value: "1s" },
  __rate_interval: { text: "1s", value: "1s" },
  __auto: { text: "1s", value: "1s" },
  __interval_ms: { text: "1000", value: 1e3 },
  __range_ms: { text: "1000", value: 1e3 },
  __range_s: { text: "1", value: 1 },
  __range: { text: "1s", value: "1s" }
};

"use strict";
const languageConfiguration = {
  // the default separators except `@$`
  wordPattern: /(-?\d*\.\d\w*)|([^`~!#%^&*()\-=+\[{\]}\\|;:'",.<>\/?\s]+)/g,
  // Not possible to make comments in PromQL syntax
  comments: {
    lineComment: "#"
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  autoClosingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" },
    { open: "<", close: ">" }
  ],
  folding: {}
};
const aggregations = [
  "sum",
  "min",
  "max",
  "avg",
  "group",
  "stddev",
  "stdvar",
  "count",
  "count_values",
  "bottomk",
  "topk",
  "quantile"
];
const functions = [
  "abs",
  "absent",
  "ceil",
  "changes",
  "clamp_max",
  "clamp_min",
  "day_of_month",
  "day_of_week",
  "days_in_month",
  "delta",
  "deriv",
  "double_exponential_smoothing",
  "exp",
  "floor",
  "histogram_quantile",
  "histogram_avg",
  "histogram_count",
  "histogram_sum",
  "histogram_fraction",
  "histogram_stddev",
  "histogram_stdvar",
  // Renamed as DoubleExponentialSmoothing with Prometheus v3.x
  // https://github.com/prometheus/prometheus/pull/14930
  "holt_winters",
  "hour",
  "idelta",
  "increase",
  "info",
  "irate",
  "label_join",
  "label_replace",
  "ln",
  "log2",
  "log10",
  "minute",
  "month",
  "predict_linear",
  "rate",
  "resets",
  "round",
  "scalar",
  "sort",
  "sort_desc",
  "sqrt",
  "time",
  "timestamp",
  "vector",
  "year"
];
const aggregationsOverTime = [];
for (let _i = 0, aggregations_1 = aggregations; _i < aggregations_1.length; _i++) {
  let agg = aggregations_1[_i];
  aggregationsOverTime.push(agg + "_over_time");
}
const vectorMatching = ["on", "ignoring", "group_right", "group_left", "by", "without"];
const vectorMatchingRegex = "(" + vectorMatching.reduce(function(prev, curr) {
  return prev + "|" + curr;
}) + ")";
const operators = ["+", "-", "*", "/", "%", "^", "==", "!=", ">", "<", ">=", "<=", "and", "or", "unless"];
const offsetModifier = ["offset"];
const keywords = aggregations.concat(functions).concat(aggregationsOverTime).concat(vectorMatching).concat(offsetModifier);
const language = {
  ignoreCase: false,
  defaultToken: "",
  tokenPostfix: ".promql",
  keywords,
  operators,
  vectorMatching: vectorMatchingRegex,
  // we include these common regular expressions
  symbols: /[=><!~?:&|+\-*\/^%]+/,
  escapes: /\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,
  digits: /\d+(_+\d+)*/,
  octaldigits: /[0-7]+(_+[0-7]+)*/,
  binarydigits: /[0-1]+(_+[0-1]+)*/,
  hexdigits: /[[0-9a-fA-F]+(_+[0-9a-fA-F]+)*/,
  integersuffix: /(ll|LL|u|U|l|L)?(ll|LL|u|U|l|L)?/,
  floatsuffix: /[fFlL]?/,
  // The main tokenizer for our languages
  tokenizer: {
    root: [
      // 'by', 'without' and vector matching
      [/@vectorMatching\s*(?=\()/, "type", "@clauses"],
      // labels
      [/[a-z_]\w*(?=\s*(=|!=|=~|!~))/, "tag"],
      // comments
      [/(^#.*$)/, "comment"],
      // all keywords have the same color
      [
        /[a-zA-Z_]\w*/,
        {
          cases: {
            "@keywords": "type",
            "@default": "identifier"
          }
        }
      ],
      // strings
      [/"([^"\\]|\\.)*$/, "string.invalid"],
      [/'([^'\\]|\\.)*$/, "string.invalid"],
      [/"/, "string", "@string_double"],
      [/'/, "string", "@string_single"],
      [/`/, "string", "@string_backtick"],
      // whitespace
      { include: "@whitespace" },
      // delimiters and operators
      [/[{}()\[\]]/, "@brackets"],
      [/[<>](?!@symbols)/, "@brackets"],
      [
        /@symbols/,
        {
          cases: {
            "@operators": "delimiter",
            "@default": ""
          }
        }
      ],
      // numbers
      [/\d+[smhdwy]/, "number"],
      [/\d*\d+[eE]([\-+]?\d+)?(@floatsuffix)/, "number.float"],
      [/\d*\.\d+([eE][\-+]?\d+)?(@floatsuffix)/, "number.float"],
      [/0[xX][0-9a-fA-F']*[0-9a-fA-F](@integersuffix)/, "number.hex"],
      [/0[0-7']*[0-7](@integersuffix)/, "number.octal"],
      [/0[bB][0-1']*[0-1](@integersuffix)/, "number.binary"],
      [/\d[\d']*\d(@integersuffix)/, "number"],
      [/\d(@integersuffix)/, "number"]
    ],
    string_double: [
      [/[^\\"]+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/"/, "string", "@pop"]
    ],
    string_single: [
      [/[^\\']+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/'/, "string", "@pop"]
    ],
    string_backtick: [
      [/[^\\`$]+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/`/, "string", "@pop"]
    ],
    clauses: [
      [/[^(,)]/, "tag"],
      [/\)/, "identifier", "@pop"]
    ],
    whitespace: [[/[ \t\r\n]+/, "white"]]
  }
};

"use strict";
const options = {
  codeLens: false,
  contextmenu: false,
  // we need `fixedOverflowWidgets` because otherwise in grafana-dashboards
  // the popup is clipped by the panel-visualizations.
  fixedOverflowWidgets: true,
  folding: false,
  fontSize: 14,
  lineDecorationsWidth: 8,
  // used as "padding-left"
  lineNumbers: "off",
  minimap: { enabled: false },
  overviewRulerBorder: false,
  overviewRulerLanes: 0,
  padding: {
    // these numbers were picked so that visually this matches the previous version
    // of the query-editor the best
    top: 4,
    bottom: 5
  },
  renderLineHighlight: "none",
  scrollbar: {
    vertical: "hidden",
    verticalScrollbarSize: 8,
    // used as "padding-right"
    horizontal: "hidden",
    horizontalScrollbarSize: 0,
    alwaysConsumeMouseWheel: false
  },
  scrollBeyondLastLine: false,
  suggest: getSuggestOptions(),
  suggestFontSize: 12,
  wordWrap: "on"
};
const EDITOR_HEIGHT_OFFSET = 2;
const PROMQL_LANG_ID = monacoPromql.promLanguageDefinition.id;
let PROMQL_SETUP_STARTED = false;
function ensurePromQL(monaco) {
  if (PROMQL_SETUP_STARTED === false) {
    PROMQL_SETUP_STARTED = true;
    const { aliases, extensions, mimetypes } = monacoPromql.promLanguageDefinition;
    monaco.languages.register({ id: PROMQL_LANG_ID, aliases, extensions, mimetypes });
    monaco.languages.setMonarchTokensProvider(PROMQL_LANG_ID, language);
    monaco.languages.setLanguageConfiguration(PROMQL_LANG_ID, languageConfiguration);
  }
}
const getStyles$2 = (theme, placeholder) => {
  return {
    container: css.css({
      borderRadius: theme.shape.radius.default,
      border: `1px solid ${theme.components.input.borderColor}`,
      display: "flex",
      flexDirection: "row",
      justifyContent: "start",
      alignItems: "center",
      height: "100%",
      overflow: "hidden"
    }),
    placeholder: css.css({
      "::after": {
        content: `'${placeholder}'`,
        fontFamily: theme.typography.fontFamilyMonospace,
        opacity: 0.6
      }
    })
  };
};
const MonacoQueryField = (props) => {
  const id = uuid.v4();
  const overrideServicesRef = React.useRef(getOverrideServices());
  const containerRef = React.useRef(null);
  const { languageProvider, history, onBlur, onRunQuery, initialValue, placeholder, datasource, timeRange } = props;
  const lpRef = reactUse.useLatest(languageProvider);
  const historyRef = reactUse.useLatest(history);
  const onRunQueryRef = reactUse.useLatest(onRunQuery);
  const onBlurRef = reactUse.useLatest(onBlur);
  const autocompleteDisposeFun = React.useRef(null);
  const theme = ui.useTheme2();
  const styles = getStyles$2(theme, placeholder);
  React.useEffect(() => {
    return () => {
      var _a;
      (_a = autocompleteDisposeFun.current) == null ? void 0 : _a.call(autocompleteDisposeFun);
    };
  }, []);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      "data-testid": e2eSelectors.selectors.components.QueryField.container,
      className: styles.container,
      ref: containerRef,
      children: /* @__PURE__ */ jsxRuntime.jsx(
        ui.ReactMonacoEditor,
        {
          saveViewState: true,
          overrideServices: overrideServicesRef.current,
          options,
          language: "promql",
          value: initialValue,
          beforeMount: (monaco) => {
            ensurePromQL(monaco);
          },
          onMount: (editor, monaco) => {
            const isEditorFocused = editor.createContextKey("isEditorFocused" + id, false);
            editor.onDidBlurEditorWidget(() => {
              isEditorFocused.set(false);
              onBlurRef.current(editor.getValue());
            });
            editor.onDidFocusEditorText(() => {
              isEditorFocused.set(true);
            });
            const dataProvider = new DataProvider({
              historyProvider: historyRef.current,
              languageProvider: lpRef.current
            });
            const completionProvider = getCompletionProvider(monaco, dataProvider, timeRange);
            const filteringCompletionProvider = {
              ...completionProvider,
              provideCompletionItems: (model, position, context, token) => {
                var _a;
                if (((_a = editor.getModel()) == null ? void 0 : _a.id) !== model.id) {
                  return { suggestions: [] };
                }
                return completionProvider.provideCompletionItems(model, position, context, token);
              }
            };
            const { dispose } = monaco.languages.registerCompletionItemProvider(
              PROMQL_LANG_ID,
              filteringCompletionProvider
            );
            autocompleteDisposeFun.current = dispose;
            const updateElementHeight = () => {
              const containerDiv = containerRef.current;
              if (containerDiv !== null) {
                const pixelHeight = editor.getContentHeight();
                containerDiv.style.height = `${pixelHeight + EDITOR_HEIGHT_OFFSET}px`;
                containerDiv.style.width = "100%";
                const pixelWidth = containerDiv.clientWidth;
                editor.layout({ width: pixelWidth, height: pixelHeight });
              }
            };
            editor.onDidContentSizeChange(updateElementHeight);
            updateElementHeight();
            editor.addCommand(
              monaco.KeyMod.Shift | monaco.KeyCode.Enter,
              () => {
                onRunQueryRef.current(editor.getValue());
              },
              "isEditorFocused" + id
            );
            monaco.editor.addKeybindingRule({
              keybinding: monaco.KeyMod.CtrlCmd | monaco.KeyCode.KeyF,
              command: null
            });
            editor.addCommand(monaco.KeyMod.CtrlCmd | monaco.KeyCode.KeyK, function() {
              global.dispatchEvent(new KeyboardEvent("keydown", { key: "k", metaKey: true }));
            });
            if (placeholder) {
              const placeholderDecorators = [
                {
                  range: new monaco.Range(1, 1, 1, 1),
                  options: {
                    className: styles.placeholder,
                    isWholeLine: true
                  }
                }
              ];
              let decorators = [];
              const checkDecorators = () => {
                const model = editor.getModel();
                if (!model) {
                  return;
                }
                const newDecorators = model.getValueLength() === 0 ? placeholderDecorators : [];
                decorators = model.deltaDecorations(decorators, newDecorators);
              };
              checkDecorators();
              editor.onDidChangeModelContent(checkDecorators);
              editor.onDidChangeModelContent((e) => {
                const model = editor.getModel();
                if (!model) {
                  return;
                }
                const query = model.getValue();
                const { errors, warnings } = validateQuery(
                  query,
                  datasource.interpolateString(query, placeHolderScopedVars),
                  model.getLinesContent(),
                  lezerPromql.parser
                );
                const errorMarkers = errors.map(({ issue, ...boundary }) => {
                  return {
                    message: `${issue ? `Error parsing "${issue}"` : "Parse error"}. The query appears to be incorrect and could fail to be executed.`,
                    severity: monaco.MarkerSeverity.Error,
                    ...boundary
                  };
                });
                const warningMarkers = warnings.map(({ issue, ...boundary }) => {
                  return {
                    message: `Warning: ${issue}`,
                    severity: monaco.MarkerSeverity.Warning,
                    ...boundary
                  };
                });
                monaco.editor.setModelMarkers(model, "owner", [...errorMarkers, ...warningMarkers]);
              });
            }
          }
        }
      )
    }
  );
};

"use strict";
const MonacoQueryFieldLazy = (props) => {
  return /* @__PURE__ */ jsxRuntime.jsx(React.Suspense, { fallback: null, children: /* @__PURE__ */ jsxRuntime.jsx(MonacoQueryField, { ...props }) });
};

"use strict";
const MonacoQueryFieldWrapper = (props) => {
  const lastRunValueRef = React.useRef(null);
  const { onRunQuery, onChange, ...rest } = props;
  const handleRunQuery = (value) => {
    lastRunValueRef.current = value;
    onChange(value);
    onRunQuery();
  };
  const handleBlur = (value) => {
    onChange(value);
  };
  return /* @__PURE__ */ jsxRuntime.jsx(MonacoQueryFieldLazy, { onRunQuery: handleRunQuery, onBlur: handleBlur, ...rest });
};

"use strict";
function getChooserText(metricsLookupDisabled, hasSyntax, hasMetrics) {
  if (metricsLookupDisabled) {
    return "(Disabled)";
  }
  if (!hasSyntax) {
    return "Loading metrics...";
  }
  if (!hasMetrics) {
    return "(No metrics found)";
  }
  return "Metrics browser";
}
function useMetricsState(datasource, languageProvider, syntaxLoaded) {
  return React.useMemo(() => {
    const hasMetrics = languageProvider.retrieveMetrics().length > 0;
    const chooserText = getChooserText(datasource.lookupsDisabled, syntaxLoaded, hasMetrics);
    const buttonDisabled = !(syntaxLoaded && hasMetrics);
    return {
      hasMetrics,
      chooserText,
      buttonDisabled
    };
  }, [languageProvider, datasource.lookupsDisabled, syntaxLoaded]);
}

"use strict";
function usePromQueryFieldEffects(languageProvider, range, series, refreshMetrics, refreshHint) {
  const lastRangeRef = React.useRef(null);
  const languageProviderInitRef = React.useRef(null);
  React.useEffect(() => {
    if (languageProvider) {
      refreshMetrics(languageProviderInitRef);
    }
    refreshHint();
    return () => {
      if (languageProviderInitRef.current) {
        languageProviderInitRef.current.cancel();
        languageProviderInitRef.current = null;
      }
    };
  }, []);
  React.useEffect(() => {
    if (!range) {
      return;
    }
    const currentFrom = roundMsToMin(range.from.valueOf());
    const currentTo = roundMsToMin(range.to.valueOf());
    if (!lastRangeRef.current) {
      lastRangeRef.current = { from: range.from, to: range.to };
    }
    const lastFrom = roundMsToMin(lastRangeRef.current.from.valueOf());
    const lastTo = roundMsToMin(lastRangeRef.current.to.valueOf());
    if (currentFrom !== lastFrom || currentTo !== lastTo) {
      lastRangeRef.current = { from: range.from, to: range.to };
      refreshMetrics(languageProviderInitRef);
    }
  }, [range, refreshMetrics]);
  React.useEffect(() => {
    refreshHint();
  }, [series, refreshHint]);
  return languageProviderInitRef;
}

"use strict";
const PromQueryField = (props) => {
  var _a;
  const {
    app,
    datasource,
    datasource: { languageProvider },
    query,
    ExtraFieldElement,
    history = [],
    data: data$1,
    range,
    onChange,
    onRunQuery
  } = props;
  const theme = ui.useTheme2();
  const [syntaxLoaded, setSyntaxLoaded] = React.useState(false);
  const [hint, setHint] = React.useState(null);
  const [labelBrowserVisible, setLabelBrowserVisible] = React.useState(false);
  const updateLanguage = React.useCallback(() => {
    if (languageProvider.retrieveMetrics()) {
      setSyntaxLoaded(true);
    }
  }, [languageProvider]);
  const refreshMetrics = React.useCallback(
    async (languageProviderInitRef) => {
      if (languageProviderInitRef.current) {
        languageProviderInitRef.current.cancel();
      }
      if (!languageProvider || !range) {
        return;
      }
      try {
        const initialization = makePromiseCancelable(languageProvider.start(range));
        languageProviderInitRef.current = initialization;
        const remainingTasks = await initialization.promise;
        if (Array.isArray(remainingTasks) && remainingTasks.length > 0) {
          await Promise.all(remainingTasks);
        }
        updateLanguage();
      } catch (err) {
        if (isCancelablePromiseRejection(err) && err.isCanceled) {
        } else {
          throw err;
        }
      } finally {
        languageProviderInitRef.current = null;
      }
    },
    [languageProvider, range, updateLanguage]
  );
  const refreshHint = React.useCallback(() => {
    var _a2, _b;
    const initHints = getInitHints(datasource);
    const initHint = (_a2 = initHints[0]) != null ? _a2 : null;
    if (!((_b = data$1 == null ? void 0 : data$1.series) == null ? void 0 : _b.length)) {
      setHint(initHint);
      return;
    }
    const result = data.isDataFrame(data$1.series[0]) ? data$1.series.map(data.toLegacyResponseData) : data$1.series;
    const queryHints = datasource.getQueryHints(query, result);
    let queryHint = queryHints.length > 0 ? queryHints[0] : null;
    setHint(queryHint != null ? queryHint : initHint);
  }, [data$1, datasource, query]);
  const onChangeQuery = (value, override) => {
    if (!onChange) {
      return;
    }
    const nextQuery = { ...query, expr: value };
    onChange(nextQuery);
    if (override && onRunQuery) {
      onRunQuery();
    }
  };
  const onChangeLabelBrowser = (selector) => {
    onChangeQuery(selector, true);
    setLabelBrowserVisible(false);
  };
  const onClickChooserButton = () => {
    setLabelBrowserVisible(!labelBrowserVisible);
    runtime.reportInteraction("user_grafana_prometheus_metrics_browser_clicked", {
      editorMode: labelBrowserVisible ? "metricViewClosed" : "metricViewOpen",
      app: app != null ? app : ""
    });
  };
  const onClickHintFix = () => {
    var _a2;
    if ((_a2 = hint == null ? void 0 : hint.fix) == null ? void 0 : _a2.action) {
      onChange(datasource.modifyQuery(query, hint.fix.action));
    }
    onRunQuery();
  };
  usePromQueryFieldEffects(languageProvider, range, data$1 == null ? void 0 : data$1.series, refreshMetrics, refreshHint);
  const { chooserText, buttonDisabled } = useMetricsState(datasource, languageProvider, syntaxLoaded);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsxs(
      "div",
      {
        className: "gf-form-inline gf-form-inline--xs-view-flex-column flex-grow-1",
        "data-testid": props["data-testid"],
        children: [
          /* @__PURE__ */ jsxRuntime.jsxs(
            "button",
            {
              className: "gf-form-label query-keyword pointer",
              onClick: onClickChooserButton,
              disabled: buttonDisabled,
              type: "button",
              "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.openButton,
              children: [
                chooserText,
                /* @__PURE__ */ jsxRuntime.jsx(ui.Icon, { name: labelBrowserVisible ? "angle-down" : "angle-right" })
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: "flex-grow-1 min-width-15", children: /* @__PURE__ */ jsxRuntime.jsx(
            MonacoQueryFieldWrapper,
            {
              languageProvider,
              history,
              onChange: onChangeQuery,
              onRunQuery,
              initialValue: (_a = query.expr) != null ? _a : "",
              placeholder: i18n.t(
                "grafana-prometheus.components.prom-query-field.placeholder-enter-a-prom-ql-query",
                "Enter a PromQL query\u2026"
              ),
              datasource,
              timeRange: range != null ? range : data.getDefaultTimeRange()
            }
          ) })
        ]
      }
    ),
    labelBrowserVisible && /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
      MetricsBrowserProvider,
      {
        timeRange: range != null ? range : data.getDefaultTimeRange(),
        languageProvider,
        onChange: onChangeLabelBrowser,
        children: /* @__PURE__ */ jsxRuntime.jsx(MetricsBrowser, {})
      }
    ) }),
    ExtraFieldElement,
    hint ? /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.css({
          flexBasis: "100%"
        }),
        children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "text-warning", children: [
          hint.label,
          " ",
          hint.fix ? /* @__PURE__ */ jsxRuntime.jsx(
            "button",
            {
              type: "button",
              className: css.cx(ui.clearButtonStyles(theme), "text-link", "muted"),
              onClick: onClickHintFix,
              children: hint.fix.label
            }
          ) : null
        ] })
      }
    ) : null
  ] });
};

"use strict";
function PromQueryCodeEditor(props) {
  const { query, datasource, range, onRunQuery, onChange, data, app, showExplain } = props;
  const styles = ui.useStyles2(getStyles$1);
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.queryField,
      className: styles.wrapper,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          PromQueryField,
          {
            datasource,
            query,
            range,
            onRunQuery,
            onChange,
            history: [],
            data,
            app
          }
        ),
        showExplain && /* @__PURE__ */ jsxRuntime.jsx(PromQueryBuilderExplained, { query: query.expr })
      ]
    }
  );
}
const getStyles$1 = (theme) => {
  return {
    // This wrapper styling can be removed after the old PromQueryEditor is removed.
    // This is removing margin bottom on the old legacy inline form styles
    wrapper: css.css({
      ".gf-form": {
        marginBottom: 0
      }
    })
  };
};

"use strict";
function PromQueryCodeEditorAutocompleteInfo(props) {
  const [autocompleteLimit, setAutocompleteLimit] = React.useState("n");
  const [autocompleteLimitExceeded, setAutocompleteLimitExceeded] = React.useState(false);
  const handleSuggestionsIncompleteEvent = React.useCallback(
    (e) => {
      if (!isSuggestionsIncompleteEvent(e)) {
        return;
      }
      if (e.detail.datasourceUid === props.datasourceUid) {
        setAutocompleteLimitExceeded(true);
        setAutocompleteLimit(e.detail.limit.toString());
      }
    },
    [props.datasourceUid]
  );
  React.useEffect(() => {
    window.addEventListener(CODE_MODE_SUGGESTIONS_INCOMPLETE_EVENT, handleSuggestionsIncompleteEvent);
    return () => {
      window.removeEventListener(CODE_MODE_SUGGESTIONS_INCOMPLETE_EVENT, handleSuggestionsIncompleteEvent);
    };
  }, [handleSuggestionsIncompleteEvent]);
  const showCodeModeAutocompleteDisclaimer = () => {
    return Boolean(runtime.config.featureToggles.prometheusCodeModeMetricNamesSearch) && props.editorMode === QueryEditorMode.Code && autocompleteLimitExceeded;
  };
  if (!showCodeModeAutocompleteDisclaimer()) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.code.metricsCountInfo, children: /* @__PURE__ */ jsxRuntime.jsxs(ui.Stack, { direction: "row", gap: 1, children: [
    /* @__PURE__ */ jsxRuntime.jsx(ui.Text, { color: "secondary", element: "p", italic: true, children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.prom-query-code-editor-autocomplete-info.autocomplete-suggestions-limited", children: "Autocomplete suggestions limited" }) }),
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.IconButton,
      {
        name: "info-circle",
        tooltip: i18n.t(
          "grafana-prometheus.querybuilder.prom-query-code-editor-autocomplete-info.tooltip-autocomplete-suggestions-limited",
          "The number of metric names exceeds the autocomplete limit. Only the {{autocompleteLimit}}-most relevant metrics are displayed. You can adjust the threshold in the data source settings.",
          { autocompleteLimit }
        )
      }
    )
  ] }) });
}

"use strict";
const PromQueryEditorSelector = React.memo((props) => {
  const {
    onChange,
    onRunQuery,
    data: data$1,
    app,
    onAddQuery,
    datasource: { defaultEditor },
    queries
  } = props;
  const [parseModalOpen, setParseModalOpen] = React.useState(false);
  const [queryPatternsModalOpen, setQueryPatternsModalOpen] = React.useState(false);
  const [dataIsStale, setDataIsStale] = React.useState(false);
  const { flag: explain, setFlag: setExplain } = useFlag(promQueryEditorExplainKey);
  const query = getQueryWithDefaults(props.query, app, defaultEditor);
  const editorMode = query.editorMode;
  const onEditorModeChange = React.useCallback(
    (newMetricEditorMode) => {
      var _a;
      runtime.reportInteraction("user_grafana_prometheus_editor_mode_clicked", {
        newEditor: newMetricEditorMode,
        previousEditor: (_a = query.editorMode) != null ? _a : "",
        newQuery: !query.expr,
        app: app != null ? app : ""
      });
      if (newMetricEditorMode === QueryEditorMode.Builder) {
        const result = buildVisualQueryFromString(query.expr || "");
        if (result.errors.length) {
          setParseModalOpen(true);
          return;
        }
      }
      changeEditorMode(query, newMetricEditorMode, onChange);
    },
    [onChange, query, app]
  );
  React.useEffect(() => {
    setDataIsStale(false);
  }, [data$1]);
  const onChangeInternal = (query2) => {
    if (!lodash.isEqual(query2, props.query)) {
      setDataIsStale(true);
    }
    onChange(query2);
  };
  const onShowExplainChange = (e) => {
    setExplain(e.currentTarget.checked);
  };
  const handleOpenQueryPatternsModal = React.useCallback(() => {
    runtime.reportInteraction("grafana_prometheus_open_kickstart_clicked", {
      app: app != null ? app : ""
    });
    setQueryPatternsModalOpen(true);
  }, [app]);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.ConfirmModal,
      {
        isOpen: parseModalOpen,
        title: i18n.t(
          "grafana-prometheus.querybuilder.prom-query-editor-selector.title-parsing-error-switch-builder",
          "Parsing error: Switch to the builder mode?"
        ),
        body: i18n.t(
          "grafana-prometheus.querybuilder.prom-query-editor-selector.body-syntax-error",
          "There is a syntax error, or the query structure cannot be visualized when switching to the builder mode. Parts of the query may be lost."
        ),
        confirmText: i18n.t("grafana-prometheus.querybuilder.prom-query-editor-selector.confirmText-continue", "Continue"),
        onConfirm: () => {
          changeEditorMode(query, QueryEditorMode.Builder, onChange);
          setParseModalOpen(false);
        },
        onDismiss: () => setParseModalOpen(false)
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      QueryPatternsModal,
      {
        isOpen: queryPatternsModalOpen,
        onClose: () => setQueryPatternsModalOpen(false),
        query,
        queries,
        app,
        onChange,
        onAddQuery
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsxs(pluginUi.EditorHeader, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          "data-testid": e2eSelectors.selectors.components.QueryBuilder.queryPatterns,
          variant: "secondary",
          size: "sm",
          onClick: handleOpenQueryPatternsModal,
          children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.prom-query-editor-selector.kick-start-your-query", children: "Kick start your query" })
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("div", { "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.explain, children: /* @__PURE__ */ jsxRuntime.jsx(
        QueryHeaderSwitch,
        {
          label: i18n.t("grafana-prometheus.querybuilder.prom-query-editor-selector.label-explain", "Explain"),
          value: explain,
          onChange: onShowExplainChange
        }
      ) }),
      /* @__PURE__ */ jsxRuntime.jsx(pluginUi.FlexItem, { grow: 1 }),
      app !== data.CoreApp.Explore && app !== data.CoreApp.Correlations && /* @__PURE__ */ jsxRuntime.jsx(
        ui.Button,
        {
          variant: dataIsStale ? "primary" : "secondary",
          size: "sm",
          onClick: onRunQuery,
          icon: (data$1 == null ? void 0 : data$1.state) === data.LoadingState.Loading ? "spinner" : void 0,
          disabled: (data$1 == null ? void 0 : data$1.state) === data.LoadingState.Loading,
          children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.querybuilder.prom-query-editor-selector.run-queries", children: "Run queries" })
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(PromQueryCodeEditorAutocompleteInfo, { datasourceUid: props.datasource.uid, editorMode }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.queryEditor.editorToggle, children: /* @__PURE__ */ jsxRuntime.jsx(QueryEditorModeToggle, { mode: editorMode, onChange: onEditorModeChange }) })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(ui.Space, { v: 0.5 }),
    /* @__PURE__ */ jsxRuntime.jsxs(pluginUi.EditorRows, { children: [
      editorMode === QueryEditorMode.Code && /* @__PURE__ */ jsxRuntime.jsx(PromQueryCodeEditor, { ...props, query, showExplain: explain, onChange: onChangeInternal }),
      editorMode === QueryEditorMode.Builder && /* @__PURE__ */ jsxRuntime.jsx(
        PromQueryBuilderContainer,
        {
          query,
          datasource: props.datasource,
          onChange: onChangeInternal,
          onRunQuery: props.onRunQuery,
          data: data$1,
          showExplain: explain
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(PromQueryBuilderOptions, { query, app: props.app, onChange, onRunQuery })
    ] })
  ] });
});
PromQueryEditorSelector.displayName = "PromQueryEditorSelector";

"use strict";
function PromQueryEditorForAlerting(props) {
  const { datasource, query, range, data, onChange, onRunQuery } = props;
  return /* @__PURE__ */ jsxRuntime.jsx(
    PromQueryField,
    {
      datasource,
      query,
      onRunQuery,
      onChange,
      history: [],
      range,
      data,
      "data-testid": alertingTestIds.editor
    }
  );
}
const alertingTestIds = {
  editor: "prom-editor-cloud-alerting"
};

"use strict";
function PromQueryEditorByAppBase(props) {
  const { app } = props;
  switch (app) {
    case data.CoreApp.CloudAlerting:
      return /* @__PURE__ */ jsxRuntime.jsx(PromQueryEditorForAlerting, { ...props });
    default:
      return /* @__PURE__ */ jsxRuntime.jsx(PromQueryEditorSelector, { ...props });
  }
}
const PromQueryEditorByApp = React.memo(PromQueryEditorByAppBase);

"use strict";
const PLACEHOLDER_TITLE = "{{alertname}}";
const PLACEHOLDER_TEXT = "{{instance}}";
const PLACEHOLDER_TAGS = "label1,label2";
const AnnotationQueryEditor = React.memo(function AnnotationQueryEditor2(props) {
  var _a, _b, _c, _d, _e;
  const { annotation, onAnnotationChange, onChange, onRunQuery, query } = props;
  if (!annotation || !onAnnotationChange) {
    return /* @__PURE__ */ jsxRuntime.jsx("h3", { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.annotation-query-editor.annotation-data-load-error", children: "Annotation data load error!" }) });
  }
  const handleMinStepChange = (value) => {
    onChange({ ...query, interval: value });
  };
  const handleTitleChange = (value) => {
    onAnnotationChange({
      ...annotation,
      titleFormat: value
    });
  };
  const handleTagsChange = (value) => {
    onAnnotationChange({
      ...annotation,
      tagKeys: value
    });
  };
  const handleTextChange = (value) => {
    onAnnotationChange({
      ...annotation,
      textFormat: value
    });
  };
  const handleUseValueForTimeChange = (checked) => {
    onAnnotationChange({
      ...annotation,
      useValueForTime: checked
    });
  };
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsxs(pluginUi.EditorRows, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(PromQueryCodeEditor, { ...props, query, showExplain: false, onRunQuery, onChange }),
      /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
        pluginUi.EditorField,
        {
          label: i18n.t("grafana-prometheus.components.annotation-query-editor.label-min-step", "Min step"),
          tooltip: /* @__PURE__ */ jsxRuntime.jsxs(
            i18n.Trans,
            {
              i18nKey: "grafana-prometheus.components.annotation-query-editor.tooltip-min-step",
              values: { intervalVar: "$__interval", rateIntervalVar: "$__rate_interval" },
              children: [
                "An additional lower limit for the step parameter of the Prometheus query and for the",
                " ",
                /* @__PURE__ */ jsxRuntime.jsx("code", { children: "{{intervalVar}}" }),
                " and ",
                /* @__PURE__ */ jsxRuntime.jsx("code", { children: "{{rateIntervalVar}}" }),
                " variables."
              ]
            }
          ),
          children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.AutoSizeInput,
            {
              type: "text",
              "aria-label": i18n.t(
                "grafana-prometheus.components.annotation-query-editor.aria-label-lower-limit-parameter",
                "Set lower limit for the step parameter"
              ),
              placeholder: i18n.t("grafana-prometheus.components.annotation-query-editor.placeholder-auto", "auto"),
              minWidth: 10,
              value: (_a = query.interval) != null ? _a : "",
              onChange: (e) => handleMinStepChange(e.currentTarget.value),
              id: e2eSelectors.selectors.components.DataSource.Prometheus.annotations.minStep,
              "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.annotations.minStep
            }
          )
        }
      ) })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(ui.Space, { v: 0.5 }),
    /* @__PURE__ */ jsxRuntime.jsxs(pluginUi.EditorRow, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        pluginUi.EditorField,
        {
          label: i18n.t("grafana-prometheus.components.annotation-query-editor.label-title", "Title"),
          tooltip: i18n.t(
            "grafana-prometheus.components.annotation-query-editor.tooltip-either-pattern-example-instance-replaced-label",
            "Use either the name or a pattern. For example, {{labelTemplate}} is replaced with label value for the label {{labelName}}.",
            { labelName: "instance", labelTemplate: "{{instance}}" }
          ),
          children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.Input,
            {
              type: "text",
              placeholder: PLACEHOLDER_TITLE,
              value: (_b = annotation.titleFormat) != null ? _b : "",
              onChange: (event) => handleTitleChange(event.currentTarget.value),
              "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.annotations.title
            }
          )
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(pluginUi.EditorField, { label: i18n.t("grafana-prometheus.components.annotation-query-editor.label-tags", "Tags"), children: /* @__PURE__ */ jsxRuntime.jsx(
        ui.Input,
        {
          type: "text",
          placeholder: PLACEHOLDER_TAGS,
          value: (_c = annotation.tagKeys) != null ? _c : "",
          onChange: (event) => handleTagsChange(event.currentTarget.value),
          "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.annotations.tags
        }
      ) }),
      /* @__PURE__ */ jsxRuntime.jsx(
        pluginUi.EditorField,
        {
          label: i18n.t("grafana-prometheus.components.annotation-query-editor.label-text", "Text"),
          tooltip: i18n.t(
            "grafana-prometheus.components.annotation-query-editor.tooltip-either-pattern-example-instance-replaced-label",
            "Use either the name or a pattern. For example, {{labelTemplate}} is replaced with label value for the label {{labelName}}.",
            { labelName: "instance", labelTemplate: "{{instance}}" }
          ),
          children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.Input,
            {
              type: "text",
              placeholder: PLACEHOLDER_TEXT,
              value: (_d = annotation.textFormat) != null ? _d : "",
              onChange: (event) => handleTextChange(event.currentTarget.value),
              "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.annotations.text
            }
          )
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        pluginUi.EditorField,
        {
          label: i18n.t(
            "grafana-prometheus.components.annotation-query-editor.label-series-value-as-timestamp",
            "Series value as timestamp"
          ),
          tooltip: i18n.t(
            "grafana-prometheus.components.annotation-query-editor.tooltip-timestamp-milliseconds-series-value-seconds-multiply",
            "The unit of timestamp is milliseconds. If the unit of the series value is seconds, multiply its range vector by 1000."
          ),
          children: /* @__PURE__ */ jsxRuntime.jsx(
            pluginUi.EditorSwitch,
            {
              value: (_e = annotation.useValueForTime) != null ? _e : false,
              onChange: (event) => handleUseValueForTimeChange(event.currentTarget.checked),
              "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.annotations.seriesValueAsTimestamp
            }
          )
        }
      )
    ] })
  ] });
});

"use strict";
const CHEAT_SHEET_ITEMS = [
  {
    title: "Request Rate",
    expression: "rate(http_request_total[5m])",
    label: "Given an HTTP request counter, this query calculates the per-second average request rate over the last 5 minutes."
  },
  {
    title: "95th Percentile of Request Latencies",
    expression: "histogram_quantile(0.95, sum(rate(prometheus_http_request_duration_seconds_bucket[5m])) by (le))",
    label: "Calculates the 95th percentile of HTTP request rate over 5 minute windows."
  },
  {
    title: "Alerts Firing",
    expression: 'sort_desc(sum(sum_over_time(ALERTS{alertstate="firing"}[24h])) by (alertname))',
    label: "Sums up the alerts that have been firing over the last 24 hours."
  },
  {
    title: "Step",
    label: "Defines the graph resolution using a duration format (15s, 1m, 3h, ...). Small steps create high-resolution graphs but can be slow over larger time ranges. Using a longer step lowers the resolution and smooths the graph by producing fewer datapoints. If no step is given the resolution is calculated automatically."
  }
];
const PromCheatSheet = (props) => {
  const styles = ui.useStyles2(getStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntime.jsx("h2", { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.prom-cheat-sheet.prom-ql-cheat-sheet", children: "PromQL Cheat Sheet" }) }),
    CHEAT_SHEET_ITEMS.map((item, index) => /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.cheatSheetItem, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.cheatSheetItemTitle, children: item.title }),
      item.expression ? /* @__PURE__ */ jsxRuntime.jsx(
        "button",
        {
          type: "button",
          className: styles.cheatSheetExample,
          onClick: (e) => props.onClickExample({ refId: "A", expr: item.expression }),
          children: /* @__PURE__ */ jsxRuntime.jsx("code", { children: item.expression })
        }
      ) : null,
      item.label
    ] }, index))
  ] });
};
const getStyles = (theme) => ({
  cheatSheetItem: css.css({
    margin: theme.spacing(3, 0)
  }),
  cheatSheetItemTitle: css.css({
    fontSize: theme.typography.h3.fontSize
  }),
  cheatSheetExample: css.css({
    margin: theme.spacing(0.5, 0),
    // element is interactive, clear button styles
    textAlign: "left",
    border: "none",
    background: "transparent",
    display: "block"
  })
});

"use strict";
const PrometheusLabelNamesRegex = /^label_names\(\)\s*$/;
const PrometheusLabelValuesRegex = /^label_values\((?:(.+),\s*)?(.+)\)\s*$/;
const PrometheusMetricNamesRegex = /^metrics\((.+)\)\s*$/;
const PrometheusQueryResultRegex = /^query_result\((.+)\)\s*$/;
const PrometheusLabelNamesRegexWithMatch = /^label_names\((.+)\)\s*$/;
function migrateVariableQueryToEditor(rawQuery) {
  if (typeof rawQuery !== "string") {
    return rawQuery;
  }
  const queryBase = {
    refId: "PrometheusDatasource-VariableQuery",
    qryType: PromVariableQueryType.LabelNames
  };
  const labelNamesMatchQuery = rawQuery.match(PrometheusLabelNamesRegexWithMatch);
  if (labelNamesMatchQuery) {
    return {
      ...queryBase,
      qryType: PromVariableQueryType.LabelNames,
      match: labelNamesMatchQuery[1]
    };
  }
  const labelNames = rawQuery.match(PrometheusLabelNamesRegex);
  if (labelNames) {
    return {
      ...queryBase,
      qryType: PromVariableQueryType.LabelNames
    };
  }
  const labelValuesCheck = rawQuery.match(/^label_values\(/);
  if (labelValuesCheck) {
    const labelValues = rawQuery.match(PrometheusLabelValuesRegex);
    const label = labelValues ? labelValues[2] : "";
    const metric = labelValues ? labelValues[1] : "";
    if (metric) {
      const visQuery = buildVisualQueryFromString(metric);
      return {
        ...queryBase,
        qryType: PromVariableQueryType.LabelValues,
        label,
        metric: visQuery.query.metric,
        labelFilters: visQuery.query.labels
      };
    } else {
      return {
        ...queryBase,
        qryType: PromVariableQueryType.LabelValues,
        label
      };
    }
  }
  const metricNamesCheck = rawQuery.match(/^metrics\(/);
  if (metricNamesCheck) {
    const metricNames = rawQuery.match(PrometheusMetricNamesRegex);
    const metric = metricNames ? metricNames[1] : "";
    return {
      ...queryBase,
      qryType: PromVariableQueryType.MetricNames,
      metric
    };
  }
  const queryResultCheck = rawQuery.match(/^query_result\(/);
  if (queryResultCheck) {
    const queryResult = rawQuery.match(PrometheusQueryResultRegex);
    const varQuery = queryResult ? queryResult[1] : "";
    return {
      ...queryBase,
      qryType: PromVariableQueryType.VarQueryResult,
      varQuery
    };
  }
  if (!labelNames && !labelValuesCheck && !metricNamesCheck && !queryResultCheck) {
    return {
      ...queryBase,
      qryType: PromVariableQueryType.SeriesQuery,
      seriesQuery: rawQuery
    };
  }
  return queryBase;
}
function migrateVariableEditorBackToVariableSupport(QueryVariable) {
  var _a, _b, _c, _d;
  switch (QueryVariable.qryType) {
    case PromVariableQueryType.LabelNames:
      if (QueryVariable.match) {
        return `label_names(${QueryVariable.match})`;
      }
      return "label_names()";
    case PromVariableQueryType.LabelValues:
      if (QueryVariable.metric || QueryVariable.labelFilters && QueryVariable.labelFilters.length !== 0) {
        const visualQueryQuery = {
          metric: (_a = QueryVariable.metric) != null ? _a : "",
          labels: (_b = QueryVariable.labelFilters) != null ? _b : [],
          operations: []
        };
        const metric = promQueryModeller.renderQuery(visualQueryQuery);
        return `label_values(${metric},${QueryVariable.label})`;
      } else {
        return `label_values(${QueryVariable.label})`;
      }
    case PromVariableQueryType.MetricNames:
      return `metrics(${QueryVariable.metric})`;
    case PromVariableQueryType.VarQueryResult:
      const varQuery = removeLineBreaks(QueryVariable.varQuery);
      return `query_result(${varQuery})`;
    case PromVariableQueryType.SeriesQuery:
      return (_c = QueryVariable.seriesQuery) != null ? _c : "";
    case PromVariableQueryType.ClassicQuery:
      return (_d = QueryVariable.classicQuery) != null ? _d : "";
  }
  return "";
}
function removeLineBreaks(input) {
  return input ? input.replace(/[\r\n]+/gm, "") : "";
}

"use strict";
const variableOptions = [
  { label: "Label names", value: PromVariableQueryType.LabelNames },
  { label: "Label values", value: PromVariableQueryType.LabelValues },
  { label: "Metrics", value: PromVariableQueryType.MetricNames },
  { label: "Query result", value: PromVariableQueryType.VarQueryResult },
  { label: "Series query", value: PromVariableQueryType.SeriesQuery },
  { label: "Classic query", value: PromVariableQueryType.ClassicQuery }
];
const refId = "PrometheusVariableQueryEditor-VariableQuery";
const PromVariableQueryEditor = ({ onChange, query, datasource, range }) => {
  const [qryType, setQryType] = React.useState(void 0);
  const [label, setLabel] = React.useState("");
  const [labelNamesMatch, setLabelNamesMatch] = React.useState("");
  const [metric, setMetric] = React.useState("");
  const [varQuery, setVarQuery] = React.useState("");
  const [seriesQuery, setSeriesQuery] = React.useState("");
  const [classicQuery, setClassicQuery] = React.useState("");
  const [truncatedLabelOptions, setTruncatedLabelOptions] = React.useState([]);
  const [allLabelOptions, setAllLabelOptions] = React.useState([]);
  function setLabels(names, variables) {
    setAllLabelOptions([...variables, ...names]);
    const truncatedNames = truncateResult(names);
    setTruncatedLabelOptions([...variables, ...truncatedNames]);
  }
  const [labelFilters, setLabelFilters] = React.useState([]);
  React.useEffect(() => {
    datasource.languageProvider.start(range);
  }, []);
  React.useEffect(() => {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    if (!query) {
      return;
    }
    if (query.qryType === PromVariableQueryType.ClassicQuery) {
      setQryType(query.qryType);
      setClassicQuery((_a = query.query) != null ? _a : "");
    } else {
      const variableQuery = variableMigration(query);
      setLabelNamesMatch((_b = variableQuery.match) != null ? _b : "");
      setQryType(variableQuery.qryType);
      setLabel((_c = variableQuery.label) != null ? _c : "");
      setMetric((_d = variableQuery.metric) != null ? _d : "");
      setLabelFilters((_e = variableQuery.labelFilters) != null ? _e : []);
      setVarQuery((_f = variableQuery.varQuery) != null ? _f : "");
      setSeriesQuery((_g = variableQuery.seriesQuery) != null ? _g : "");
      setClassicQuery((_h = variableQuery.classicQuery) != null ? _h : "");
    }
  }, [query]);
  React.useEffect(() => {
    if (qryType !== PromVariableQueryType.LabelValues) {
      return;
    }
    const variables = datasource.getVariables().map((variable) => ({ label: variable, value: variable }));
    let timeRange = range;
    if (!timeRange) {
      timeRange = data.getDefaultTimeRange();
    }
    if (!metric) {
      datasource.getTagKeys({ timeRange, filters: [] }).then((labelNames) => {
        const names = labelNames.map(({ text }) => ({ label: text, value: text }));
        setLabels(names, variables);
      });
    } else {
      const labelToConsider = [{ label: "__name__", op: "=", value: metric }];
      const expr = promQueryModeller.renderLabels(labelToConsider);
      datasource.languageProvider.queryLabelKeys(timeRange, expr).then((labelNames) => {
        const names = labelNames.map((value) => ({ label: value, value }));
        setLabels(names, variables);
      });
    }
  }, [datasource, qryType, metric, range]);
  const onChangeWithVariableString = (updateVar, updLabelFilters) => {
    const queryVar = {
      qryType,
      label,
      metric,
      match: labelNamesMatch,
      varQuery,
      seriesQuery,
      classicQuery,
      refId: "PrometheusVariableQueryEditor-VariableQuery"
    };
    let updateLabelFilters = updLabelFilters ? { labelFilters: updLabelFilters } : { labelFilters };
    const updatedVar = { ...queryVar, ...updateVar, ...updateLabelFilters };
    const queryString = migrateVariableEditorBackToVariableSupport(updatedVar);
    onChange({
      query: queryString,
      qryType: updatedVar.qryType,
      refId
    });
  };
  const onQueryTypeChange = (newType) => {
    var _a;
    setQryType(newType.value);
    if (newType.value !== PromVariableQueryType.SeriesQuery) {
      onChangeWithVariableString({ qryType: (_a = newType.value) != null ? _a : 0 });
    }
  };
  const onLabelChange = (newLabel) => {
    const newLabelvalue = newLabel && newLabel.value ? newLabel.value : "";
    setLabel(newLabelvalue);
    if (qryType === PromVariableQueryType.LabelValues && newLabelvalue) {
      onChangeWithVariableString({ label: newLabelvalue });
    }
  };
  const metricsLabelsChange = (update) => {
    var _a;
    setMetric(update.metric);
    setLabelFilters(update.labels);
    const updMetric = update.metric;
    const updLabelFilters = (_a = update.labels) != null ? _a : [];
    if (qryType === PromVariableQueryType.LabelValues && label && (updMetric || updLabelFilters)) {
      onChangeWithVariableString({ qryType, metric: updMetric }, updLabelFilters);
    }
  };
  const onLabelNamesMatchChange = (regex) => {
    if (qryType === PromVariableQueryType.LabelNames) {
      onChangeWithVariableString({ qryType, match: regex });
    }
  };
  const onMetricChange = (value) => {
    if (qryType === PromVariableQueryType.MetricNames && value) {
      onChangeWithVariableString({ metric: value });
    }
  };
  const onVarQueryChange = (e) => {
    setVarQuery(e.currentTarget.value);
  };
  const onSeriesQueryChange = (e) => {
    setSeriesQuery(e.currentTarget.value);
  };
  const onClassicQueryChange = (e) => {
    setClassicQuery(e.currentTarget.value);
  };
  const promVisualQuery = React.useCallback(() => {
    return { metric, labels: labelFilters, operations: [] };
  }, [metric, labelFilters]);
  const labelNamesSearch = debounce__default.default((query2) => {
    const results = allLabelOptions.filter((label2) => {
      var _a;
      return (_a = label2.value) == null ? void 0 : _a.includes(query2);
    });
    return truncateResult(results);
  }, 300);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFieldRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.components.prom-variable-query-editor.label-query-type", "Query type"),
        labelWidth: 20,
        tooltip: /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.prom-variable-query-editor.tooltip-query-type", children: "The Prometheus data source plugin provides the following query types for template variables." }) }),
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Select,
          {
            placeholder: i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.placeholder-select-query-type",
              "Select query type"
            ),
            "aria-label": i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.aria-label-query-type",
              "Query type"
            ),
            onChange: onQueryTypeChange,
            value: qryType,
            options: variableOptions,
            width: 25,
            "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.variableQueryEditor.queryType
          }
        )
      }
    ) }),
    qryType === PromVariableQueryType.LabelValues && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFieldRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
        ui.InlineField,
        {
          label: i18n.t("grafana-prometheus.components.prom-variable-query-editor.label-label", "Label"),
          labelWidth: 20,
          required: true,
          "aria-labelledby": "label-select",
          tooltip: /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.prom-variable-query-editor.tooltip-label", children: "Returns a list of label values for the label name in all metrics unless the metric is specified." }) }),
          children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.AsyncSelect,
            {
              onChange: onLabelChange,
              value: label ? data.toOption(label) : null,
              defaultOptions: truncatedLabelOptions,
              width: 25,
              allowCustomValue: true,
              isClearable: true,
              loadOptions: labelNamesSearch,
              "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.variableQueryEditor.labelValues.labelSelect
            }
          )
        }
      ) }),
      /* @__PURE__ */ jsxRuntime.jsx(
        MetricsLabelsSection,
        {
          query: promVisualQuery(),
          datasource,
          onChange: metricsLabelsChange,
          variableEditor: true,
          timeRange: range != null ? range : data.getDefaultTimeRange()
        }
      )
    ] }),
    qryType === PromVariableQueryType.LabelNames && /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFieldRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.components.prom-variable-query-editor.label-metric-regex", "Metric regex"),
        labelWidth: 20,
        "aria-labelledby": "Metric regex",
        tooltip: /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.prom-variable-query-editor.tooltip-metric-regex", children: "Returns a list of label names, optionally filtering by specified metric regex." }) }),
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Input,
          {
            type: "text",
            "aria-label": i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.aria-label-metric-regex",
              "Metric regex"
            ),
            placeholder: i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.placeholder-metric-regex",
              "Metric regex"
            ),
            value: labelNamesMatch,
            onBlur: (event) => {
              setLabelNamesMatch(event.currentTarget.value);
              onLabelNamesMatchChange(event.currentTarget.value);
            },
            onChange: (e) => {
              setLabelNamesMatch(e.currentTarget.value);
            },
            width: 25,
            "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.variableQueryEditor.labelnames.metricRegex
          }
        )
      }
    ) }),
    qryType === PromVariableQueryType.MetricNames && /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFieldRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.components.prom-variable-query-editor.label-metric-regex", "Metric regex"),
        labelWidth: 20,
        "aria-labelledby": "Metric selector",
        tooltip: /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.components.prom-variable-query-editor.returns-metrics-matching-specified-metric-regex", children: "Returns a list of metrics matching the specified metric regex." }) }),
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Input,
          {
            type: "text",
            "aria-label": i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.aria-label-metric-selector",
              "Metric selector"
            ),
            placeholder: i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.placeholder-metric-regex",
              "Metric regex"
            ),
            value: metric,
            onChange: (e) => {
              setMetric(e.currentTarget.value);
            },
            onBlur: (e) => {
              setMetric(e.currentTarget.value);
              onMetricChange(e.currentTarget.value);
            },
            width: 25,
            "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.variableQueryEditor.metricNames.metricRegex
          }
        )
      }
    ) }),
    qryType === PromVariableQueryType.VarQueryResult && /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFieldRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.components.prom-variable-query-editor.label-query", "Query"),
        labelWidth: 20,
        tooltip: /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsxs(
          i18n.Trans,
          {
            i18nKey: "grafana-prometheus.components.prom-variable-query-editor.tooltip-query",
            values: { exampleQuery: "sum(go_goroutines)" },
            children: [
              "Returns a list of Prometheus query results for the query. This can include Prometheus functions, i.e.",
              "{{exampleQuery}}",
              "."
            ]
          }
        ) }),
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.TextArea,
          {
            type: "text",
            "aria-label": i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.aria-label-prometheus-query",
              "Prometheus Query"
            ),
            placeholder: i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.placeholder-prometheus-query",
              "Prometheus Query"
            ),
            value: varQuery,
            onChange: onVarQueryChange,
            onBlur: () => {
              if (qryType === PromVariableQueryType.VarQueryResult && varQuery) {
                onChangeWithVariableString({ qryType });
              }
            },
            cols: 100,
            "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.variableQueryEditor.varQueryResult
          }
        )
      }
    ) }),
    qryType === PromVariableQueryType.SeriesQuery && /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFieldRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.components.prom-variable-query-editor.label-series-query", "Series Query"),
        labelWidth: 20,
        tooltip: /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsxs(
          i18n.Trans,
          {
            i18nKey: "grafana-prometheus.components.prom-variable-query-editor.tooltip-series-query",
            values: {
              example1: 'go_goroutines{instance="localhost:9090"}',
              example2: "go_goroutines",
              example3: '{instance="localhost:9090"}'
            },
            children: [
              "Enter a metric with labels, only a metric or only labels, i.e.",
              "{{example1}}",
              ", ",
              "{{example2}}",
              ", or ",
              "{{example3}}",
              ". Returns a list of time series associated with the entered data."
            ]
          }
        ) }),
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Input,
          {
            type: "text",
            "aria-label": i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.aria-label-series-query",
              "Series Query"
            ),
            placeholder: i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.placeholder-series-query",
              "Series Query"
            ),
            value: seriesQuery,
            onChange: onSeriesQueryChange,
            onBlur: () => {
              if (qryType === PromVariableQueryType.SeriesQuery && seriesQuery) {
                onChangeWithVariableString({ qryType });
              }
            },
            width: 100,
            "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.variableQueryEditor.seriesQuery
          }
        )
      }
    ) }),
    qryType === PromVariableQueryType.ClassicQuery && /* @__PURE__ */ jsxRuntime.jsx(ui.InlineFieldRow, { children: /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.components.prom-variable-query-editor.label-classic-query", "Classic Query"),
        labelWidth: 20,
        tooltip: /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsxs(
          i18n.Trans,
          {
            i18nKey: "grafana-prometheus.components.prom-variable-query-editor.tooltip-classic-query",
            values: {
              exampleQuery: "label_values(metric, label)"
            },
            children: [
              "The original implementation of the Prometheus variable query editor. Enter a string with the correct query type and parameters as described in these docs. For example, ",
              "{{exampleQuery}}",
              "."
            ]
          }
        ) }),
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Input,
          {
            type: "text",
            "aria-label": i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.aria-label-classic-query",
              "Classic Query"
            ),
            placeholder: i18n.t(
              "grafana-prometheus.components.prom-variable-query-editor.placeholder-classic-query",
              "Classic Query"
            ),
            value: classicQuery,
            onChange: onClassicQueryChange,
            onBlur: () => {
              if (qryType === PromVariableQueryType.ClassicQuery && classicQuery) {
                onChangeWithVariableString({ qryType });
              }
            },
            width: 100,
            "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.variableQueryEditor.classicQuery
          }
        )
      }
    ) })
  ] });
};
function variableMigration(query) {
  if (typeof query === "string") {
    return migrateVariableQueryToEditor(query);
  } else if (query.query) {
    return migrateVariableQueryToEditor(query.query);
  } else {
    return query;
  }
}

"use strict";
function AlertingSettingsOverhaul({
  options,
  onOptionsChange
}) {
  var _a, _b;
  const theme = ui.useTheme2();
  const styles = overhaulStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsx(
    pluginUi.ConfigSubSection,
    {
      title: i18n.t("grafana-prometheus.configuration.alerting-settings-overhaul.title-alerting", "Alerting"),
      className: css.cx(styles.container, styles.alertingTop),
      children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-group", children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.InlineField,
          {
            labelWidth: 30,
            label: i18n.t(
              "grafana-prometheus.configuration.alerting-settings-overhaul.label-manage-alerts-via-alerting-ui",
              "Manage alerts via Alerting UI"
            ),
            disabled: options.readOnly,
            tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
              /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.alerting-settings-overhaul.tooltip-manage-alerts-via-alerting-ui", children: "Manage alert rules for this data source. To manage other alerting resources, add an Alertmanager data source." }),
              " ",
              docsTip()
            ] }),
            interactive: true,
            className: styles.switchField,
            children: /* @__PURE__ */ jsxRuntime.jsx(
              ui.Switch,
              {
                value: (_a = options.jsonData.manageAlerts) != null ? _a : runtime.config.defaultDatasourceManageAlertsUiToggle,
                onChange: (event) => onOptionsChange({
                  ...options,
                  jsonData: { ...options.jsonData, manageAlerts: event.currentTarget.checked }
                }),
                id: e2eSelectors.selectors.components.DataSource.Prometheus.configPage.manageAlerts
              }
            )
          }
        ) }) }),
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.InlineField,
          {
            labelWidth: 30,
            label: i18n.t(
              "grafana-prometheus.configuration.alerting-settings-overhaul.label-allow-as-recording-rules-target",
              "Allow as recording rules target"
            ),
            disabled: options.readOnly,
            tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
              /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.alerting-settings-overhaul.tooltip-allow-as-recording-rules-target", children: "Allow this data source to be selected as a target for writing recording rules." }),
              " ",
              docsTip()
            ] }),
            interactive: true,
            className: styles.switchField,
            children: /* @__PURE__ */ jsxRuntime.jsx(
              ui.Switch,
              {
                value: (_b = options.jsonData.allowAsRecordingRulesTarget) != null ? _b : runtime.config.defaultAllowRecordingRulesTargetAlertsUiToggle,
                onChange: (event) => onOptionsChange({
                  ...options,
                  jsonData: { ...options.jsonData, allowAsRecordingRulesTarget: event.currentTarget.checked }
                }),
                id: e2eSelectors.selectors.components.DataSource.Prometheus.configPage.allowAsRecordingRulesTarget
              }
            )
          }
        ) }) })
      ] })
    }
  );
}

"use strict";
const DataSourceHttpSettingsOverhaul = (props) => {
  const { options, onOptionsChange, secureSocksDSProxyEnabled } = props;
  const newAuthProps = pluginUi.convertLegacyAuthProps({
    config: options,
    onChange: onOptionsChange
  });
  const theme = ui.useTheme2();
  const styles = overhaulStyles(theme);
  function returnSelectedMethod() {
    return newAuthProps.selectedMethod;
  }
  let urlTooltip;
  switch (options.access) {
    case "direct":
      urlTooltip = /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsxs(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.data-source-http-settings-overhaul.tooltip-browser-access-mode", children: [
          "Your access method is ",
          /* @__PURE__ */ jsxRuntime.jsx("em", { children: "Browser" }),
          ", this means the URL needs to be accessible from the browser."
        ] }),
        docsTip()
      ] });
      break;
    case "proxy":
      urlTooltip = /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsxs(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.data-source-http-settings-overhaul.tooltip-server-access-mode", children: [
          "Your access method is ",
          /* @__PURE__ */ jsxRuntime.jsx("em", { children: "Server" }),
          ", this means the URL needs to be accessible from the grafana backend/server."
        ] }),
        docsTip()
      ] });
      break;
    default:
      urlTooltip = /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsxs(
          i18n.Trans,
          {
            i18nKey: "grafana-prometheus.configuration.data-source-http-settings-overhaul.tooltip-http-url",
            values: { exampleURL: "http://your_server:8080" },
            children: [
              "Specify a complete HTTP URL (for example ",
              "{{exampleURL}}",
              ")"
            ]
          }
        ),
        docsTip()
      ] });
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      pluginUi.ConnectionSettings,
      {
        urlPlaceholder: "http://localhost:9090",
        config: options,
        onChange: onOptionsChange,
        urlLabel: "Prometheus server URL",
        urlTooltip
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("hr", { className: `${styles.hrTopSpace} ${styles.hrBottomSpace}` }),
    /* @__PURE__ */ jsxRuntime.jsx(
      pluginUi.Auth,
      {
        ...newAuthProps,
        onAuthMethodSelect: (method) => {
          onOptionsChange({
            ...options,
            basicAuth: method === pluginUi.AuthMethod.BasicAuth,
            withCredentials: method === pluginUi.AuthMethod.CrossSiteCredentials,
            jsonData: {
              ...options.jsonData,
              oauthPassThru: method === pluginUi.AuthMethod.OAuthForward
            }
          });
        },
        selectedMethod: returnSelectedMethod()
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.sectionBottomPadding }),
    secureSocksDSProxyEnabled && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(ui.SecureSocksProxySettings, { options, onOptionsChange }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.sectionBottomPadding })
    ] })
  ] });
};

"use strict";
const defaultPrometheusQueryOverlapWindow = "10m";
const getFieldIdentity = (field) => {
  var _a;
  return `${field.type}|${field.name}|${JSON.stringify((_a = field.labels) != null ? _a : "")}`;
};
class QueryCache {
  constructor(options) {
    this.applyInterpolation = (str, scopedVars) => str;
    this.cache = /* @__PURE__ */ new Map();
    const unverifiedOverlap = options.overlapString;
    if (data.isValidDuration(unverifiedOverlap)) {
      const duration = data.parseDuration(unverifiedOverlap);
      this.overlapWindowMs = data.durationToMilliseconds(duration);
    } else {
      const duration = data.parseDuration(defaultPrometheusQueryOverlapWindow);
      this.overlapWindowMs = data.durationToMilliseconds(duration);
    }
    this.getTargetSignature = options.getTargetSignature;
    if (options.applyInterpolation) {
      this.applyInterpolation = options.applyInterpolation;
    }
  }
  // can be used to change full range request to partial, split into multiple requests
  requestInfo(request) {
    var _a, _b, _c;
    const newFrom = request.range.from.valueOf();
    const newTo = request.range.to.valueOf();
    const shouldCache = ((_b = (_a = request.rangeRaw) == null ? void 0 : _a.to) == null ? void 0 : _b.toString()) === "now";
    let doPartialQuery = shouldCache;
    let prevTo = void 0;
    const reqTargetSignatures = /* @__PURE__ */ new Map();
    request.targets.forEach((target) => {
      let targetIdentity = `${request.dashboardUID}|${request.panelId}|${target.refId}`;
      let targetSignature = this.getTargetSignature(request, target);
      reqTargetSignatures.set(targetIdentity, targetSignature);
    });
    for (const [targetIdentity, targetSignature] of reqTargetSignatures) {
      let cached = this.cache.get(targetIdentity);
      let cachedSig = cached == null ? void 0 : cached.signature;
      if (cachedSig !== targetSignature) {
        doPartialQuery = false;
      } else {
        prevTo = (_c = cached == null ? void 0 : cached.prevTo) != null ? _c : Infinity;
        doPartialQuery = newTo > prevTo && newFrom <= prevTo;
      }
      if (!doPartialQuery) {
        break;
      }
    }
    if (doPartialQuery && prevTo) {
      let newFromPartial = Math.max(prevTo - this.overlapWindowMs, newFrom);
      const newToDate = data.dateTime(newTo);
      const newFromPartialDate = data.dateTime(data.incrRoundDn(newFromPartial, request.intervalMs));
      request = {
        ...request,
        range: {
          ...request.range,
          from: newFromPartialDate,
          to: newToDate
        }
      };
    } else {
      reqTargetSignatures.forEach((targSig, targIdent) => {
        this.cache.delete(targIdent);
      });
    }
    return {
      requests: [request],
      targetSignatures: reqTargetSignatures,
      shouldCache
    };
  }
  // should amend existing cache with new frames and return full response
  procFrames(request, requestInfo, respFrames) {
    if (requestInfo == null ? void 0 : requestInfo.shouldCache) {
      const newFrom = request.range.from.valueOf();
      const newTo = request.range.to.valueOf();
      const respByTarget = /* @__PURE__ */ new Map();
      respFrames.forEach((frame) => {
        let targetIdent = `${request.dashboardUID}|${request.panelId}|${frame.refId}`;
        let frames = respByTarget.get(targetIdent);
        if (!frames) {
          frames = [];
          respByTarget.set(targetIdent, frames);
        }
        frames.push(frame);
      });
      let outFrames = [];
      respByTarget.forEach((respFrames2, targetIdentity) => {
        var _a, _b;
        let cachedFrames = (_b = targetIdentity ? (_a = this.cache.get(targetIdentity)) == null ? void 0 : _a.frames : null) != null ? _b : [];
        respFrames2.forEach((respFrame) => {
          if (respFrame.length === 0 || respFrame.fields.length === 0) {
            return;
          }
          let respFrameIdentity = getFieldIdentity(respFrame.fields[1]);
          let cachedFrame = cachedFrames.find((cached) => getFieldIdentity(cached.fields[1]) === respFrameIdentity);
          if (!cachedFrame) {
            cachedFrames.push(respFrame);
          } else {
            let prevTable = cachedFrame.fields.map((field) => field.values);
            let nextTable = respFrame.fields.map((field) => field.values);
            let amendedTable = data.amendTable(prevTable, nextTable);
            if (amendedTable) {
              for (let i = 0; i < amendedTable.length; i++) {
                cachedFrame.fields[i].values = amendedTable[i];
                if (cachedFrame.fields[i].config.displayNameFromDS !== respFrame.fields[i].config.displayNameFromDS) {
                  cachedFrame.fields[i].config.displayNameFromDS = respFrame.fields[i].config.displayNameFromDS;
                }
              }
              cachedFrame.length = cachedFrame.fields[0].values.length;
            }
          }
        });
        let nonEmptyCachedFrames = [];
        cachedFrames.forEach((frame) => {
          let table = frame.fields.map((field) => field.values);
          const dataPointStep = findDatapointStep(request, respFrames2, this.applyInterpolation);
          let trimmed = data.trimTable(table, newFrom - dataPointStep, newTo);
          if (trimmed[0].length > 0) {
            for (let i = 0; i < trimmed.length; i++) {
              frame.fields[i].values = trimmed[i];
            }
            nonEmptyCachedFrames.push(frame);
          }
        });
        this.cache.set(targetIdentity, {
          signature: requestInfo.targetSignatures.get(targetIdentity),
          frames: nonEmptyCachedFrames,
          prevTo: newTo
        });
        outFrames.push(...nonEmptyCachedFrames);
      });
      respFrames = outFrames.map((frame) => ({
        ...frame,
        fields: frame.fields.map((field) => ({
          ...field,
          config: {
            ...field.config
            // prevents mutatative exemplars links (re)enrichment
          },
          values: field.values.slice()
        }))
      }));
    }
    return respFrames;
  }
}
function findDatapointStep(request, respFrames, applyInterpolation) {
  var _a;
  if (((_a = request.targets[0].datasource) == null ? void 0 : _a.type) !== "prometheus") {
    return 0;
  }
  const target = request.targets.find((t) => t.refId === respFrames[0].refId);
  let dataPointStep = request.intervalMs;
  if (target == null ? void 0 : target.interval) {
    const minStepMs = data.rangeUtil.intervalToMs(applyInterpolation(target.interval));
    if (minStepMs > request.intervalMs) {
      dataPointStep = minStepMs;
    }
  }
  return dataPointStep;
}

"use strict";
function ExemplarSetting({ value, onChange, onDelete, disabled }) {
  const [isInternalLink, setIsInternalLink] = React.useState(Boolean(value.datasourceUid));
  const theme = ui.useTheme2();
  const styles = overhaulStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-group", children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.configuration.exemplar-setting.label-internal-link", "Internal link"),
        labelWidth: PROM_CONFIG_LABEL_WIDTH,
        disabled,
        tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.exemplar-setting.tooltip-internal-link", children: "Enable this option if you have an internal link. When enabled, this reveals the data source selector. Select the backend tracing data store for your exemplar data." }),
          " ",
          docsTip()
        ] }),
        interactive: true,
        className: styles.switchField,
        children: /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Switch,
          {
            value: isInternalLink,
            "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.internalLinkSwitch,
            onChange: (ev) => setIsInternalLink(ev.currentTarget.checked)
          }
        ) })
      }
    ),
    isInternalLink ? /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.configuration.exemplar-setting.label-data-source", "Data source"),
        labelWidth: PROM_CONFIG_LABEL_WIDTH,
        tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.exemplar-setting.tooltip-data-source", children: "The data source the exemplar is going to navigate to." }),
          " ",
          docsTip()
        ] }),
        disabled,
        interactive: true,
        children: /* @__PURE__ */ jsxRuntime.jsx(
          runtime.DataSourcePicker,
          {
            filter: runtime.config.featureToggles.azureMonitorPrometheusExemplars ? void 0 : (ds) => ds.type !== "grafana-azure-monitor-datasource",
            tracing: true,
            current: value.datasourceUid,
            noDefault: true,
            width: 40,
            onChange: (ds) => onChange({
              ...value,
              datasourceUid: ds.uid,
              url: void 0
            })
          }
        )
      }
    ) : /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.configuration.exemplar-setting.label-url", "URL"),
        labelWidth: PROM_CONFIG_LABEL_WIDTH,
        tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.exemplar-setting.tooltip-url", children: "The URL of the trace backend the user would go to see its trace" }),
          " ",
          docsTip()
        ] }),
        disabled,
        interactive: true,
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Input,
          {
            placeholder: i18n.t(
              "grafana-prometheus.configuration.exemplar-setting.placeholder-httpsexamplecomvalueraw",
              "https://example.com/${__value.raw}"
            ),
            spellCheck: false,
            width: 40,
            value: value.url,
            onChange: (event) => onChange({
              ...value,
              datasourceUid: void 0,
              url: event.currentTarget.value
            })
          }
        )
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.configuration.exemplar-setting.label-url-label", "URL Label"),
        labelWidth: PROM_CONFIG_LABEL_WIDTH,
        tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.exemplar-setting.tooltip-url-label", children: "Use to override the button label on the exemplar traceID field." }),
          " ",
          docsTip()
        ] }),
        disabled,
        interactive: true,
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Input,
          {
            placeholder: i18n.t(
              "grafana-prometheus.configuration.exemplar-setting.placeholder-go-to-examplecom",
              "Go to example.com"
            ),
            spellCheck: false,
            width: 40,
            value: value.urlDisplayLabel,
            onChange: (event) => onChange({
              ...value,
              urlDisplayLabel: event.currentTarget.value
            })
          }
        )
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t("grafana-prometheus.configuration.exemplar-setting.label-label-name", "Label name"),
        labelWidth: PROM_CONFIG_LABEL_WIDTH,
        tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.exemplar-setting.tooltip-label-name", children: "The name of the field in the labels object that should be used to get the traceID." }),
          " ",
          docsTip()
        ] }),
        disabled,
        interactive: true,
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Input,
          {
            placeholder: i18n.t("grafana-prometheus.configuration.exemplar-setting.placeholder-trace-id", "traceID"),
            spellCheck: false,
            width: 40,
            value: value.name,
            onChange: (event) => onChange({
              ...value,
              name: event.currentTarget.value
            })
          }
        )
      }
    ),
    !disabled && /* @__PURE__ */ jsxRuntime.jsx(
      ui.InlineField,
      {
        label: i18n.t(
          "grafana-prometheus.configuration.exemplar-setting.label-remove-exemplar-link",
          "Remove exemplar link"
        ),
        labelWidth: PROM_CONFIG_LABEL_WIDTH,
        disabled,
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ui.Button,
          {
            variant: "destructive",
            title: i18n.t(
              "grafana-prometheus.configuration.exemplar-setting.title-remove-exemplar-link",
              "Remove exemplar link"
            ),
            icon: "times",
            onClick: (event) => {
              event.preventDefault();
              onDelete();
            }
          }
        )
      }
    )
  ] });
}

"use strict";
function ExemplarsSettings({ options, onChange, disabled }) {
  const theme = ui.useTheme2();
  const styles = overhaulStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.sectionBottomPadding, children: /* @__PURE__ */ jsxRuntime.jsxs(
    pluginUi.ConfigSubSection,
    {
      title: i18n.t("grafana-prometheus.configuration.exemplars-settings.title-exemplars", "Exemplars"),
      className: styles.container,
      children: [
        options && options.map((option, index) => {
          return /* @__PURE__ */ jsxRuntime.jsx(
            ExemplarSetting,
            {
              value: option,
              onChange: (newField) => {
                const newOptions = [...options];
                newOptions.splice(index, 1, newField);
                onChange(newOptions);
              },
              onDelete: () => {
                const newOptions = [...options];
                newOptions.splice(index, 1);
                onChange(newOptions);
              },
              disabled
            },
            index
          );
        }),
        !disabled && /* @__PURE__ */ jsxRuntime.jsx(
          ui.Button,
          {
            variant: "secondary",
            "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.exemplarsAddButton,
            className: css.css({
              marginBottom: "10px"
            }),
            icon: "plus",
            onClick: (event) => {
              event.preventDefault();
              const newOptions = [...options || [], { name: "traceID" }];
              onChange(newOptions);
            },
            children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.exemplars-settings.add", children: "Add" })
          }
        ),
        disabled && !options && /* @__PURE__ */ jsxRuntime.jsx("i", { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.exemplars-settings.no-exemplars-configurations", children: "No exemplars configurations" }) })
      ]
    }
  ) });
}

"use strict";
const PromFlavorVersions = {
  Prometheus: [
    { value: void 0, label: "Please select" },
    { value: "2.0.0", label: "< 2.14.x" },
    { value: "2.14.0", label: "2.14.x" },
    { value: "2.15.0", label: "2.15.x" },
    { value: "2.16.0", label: "2.16.x" },
    { value: "2.17.0", label: "2.17.x" },
    { value: "2.18.0", label: "2.18.x" },
    { value: "2.19.0", label: "2.19.x" },
    { value: "2.20.0", label: "2.20.x" },
    { value: "2.21.0", label: "2.21.x" },
    { value: "2.22.0", label: "2.22.x" },
    { value: "2.23.0", label: "2.23.x" },
    { value: "2.24.0", label: "2.24.x" },
    { value: "2.25.0", label: "2.25.x" },
    { value: "2.26.0", label: "2.26.x" },
    { value: "2.27.0", label: "2.27.x" },
    { value: "2.28.0", label: "2.28.x" },
    { value: "2.29.0", label: "2.29.x" },
    { value: "2.30.0", label: "2.30.x" },
    { value: "2.31.0", label: "2.31.x" },
    { value: "2.32.0", label: "2.32.x" },
    { value: "2.33.0", label: "2.33.x" },
    { value: "2.34.0", label: "2.34.x" },
    { value: "2.35.0", label: "2.35.x" },
    { value: "2.36.0", label: "2.36.x" },
    { value: "2.37.0", label: "2.37.x" },
    { value: "2.38.0", label: "2.38.x" },
    { value: "2.39.0", label: "2.39.x" },
    { value: "2.40.0", label: "2.40.x" },
    { value: "2.41.0", label: "2.41.x" },
    { value: "2.42.0", label: "2.42.x" },
    { value: "2.43.0", label: "2.43.x" },
    { value: "2.44.0", label: "2.44.x" },
    { value: "2.45.0", label: "2.45.x" },
    { value: "2.46.0", label: "2.46.x" },
    { value: "2.47.0", label: "2.47.x" },
    { value: "2.48.0", label: "2.48.x" },
    { value: "2.49.0", label: "2.49.x" },
    { value: "2.50.0", label: "2.50.x" },
    // This value will be returned for future versions of prometheus until we add new entries to this object
    { value: "2.50.1", label: "> 2.50.x" }
  ],
  Mimir: [
    { value: void 0, label: "Please select" },
    { value: "2.0.0", label: "2.0.x" },
    { value: "2.1.0", label: "2.1.x" },
    { value: "2.2.0", label: "2.2.x" },
    { value: "2.3.0", label: "2.3.x" },
    { value: "2.4.0", label: "2.4.x" },
    { value: "2.5.0", label: "2.5.x" },
    { value: "2.6.0", label: "2.6.x" },
    { value: "2.7.0", label: "2.7.x" },
    { value: "2.8.0", label: "2.8.x" },
    { value: "2.9.0", label: "2.9.x" },
    { value: "2.9.1", label: "> 2.9.x" }
  ],
  Thanos: [
    { value: void 0, label: "Please select" },
    { value: "0.0.0", label: "< 0.16.x" },
    { value: "0.16.0", label: "0.16.x" },
    { value: "0.17.0", label: "0.17.x" },
    { value: "0.18.0", label: "0.18.x" },
    { value: "0.19.0", label: "0.19.x" },
    { value: "0.20.0", label: "0.20.x" },
    { value: "0.21.0", label: "0.21.x" },
    { value: "0.22.0", label: "0.22.x" },
    { value: "0.23.0", label: "0.23.x" },
    { value: "0.24.0", label: "0.24.x" },
    { value: "0.25.0", label: "0.25.x" },
    { value: "0.26.0", label: "0.26.x" },
    { value: "0.27.0", label: "0.27.x" },
    { value: "0.28.0", label: "0.28.x" },
    { value: "0.29.0", label: "0.29.x" },
    { value: "0.30.0", label: "0.30.x" },
    { value: "0.31.0", label: "0.31.x" },
    { value: "0.31.1", label: "> 0.31.x" }
  ],
  Cortex: [
    { value: void 0, label: "Please select" },
    { value: "0.0.0", label: "< 1.0.0" },
    { value: "1.0.0", label: "1.0.0" },
    { value: "1.1.0", label: "1.1.x" },
    { value: "1.2.0", label: "1.2.x" },
    { value: "1.3.0", label: "1.3.x" },
    { value: "1.4.0", label: "1.4.x" },
    { value: "1.5.0", label: "1.5.x" },
    { value: "1.6.0", label: "1.6.x" },
    { value: "1.7.0", label: "1.7.x" },
    { value: "1.8.0", label: "1.8.x" },
    { value: "1.9.0", label: "1.9.x" },
    { value: "1.10.0", label: "1.10.x" },
    { value: "1.11.0", label: "1.11.x" },
    { value: "1.13.0", label: "1.13.x" },
    { value: "1.14.0", label: "> 1.13.x" }
  ]
};

"use strict";
const httpOptions = [
  { value: "POST", label: "POST" },
  { value: "GET", label: "GET" }
];
const cacheValueOptions = [
  { value: PrometheusCacheLevel.Low, label: "Low" },
  { value: PrometheusCacheLevel.Medium, label: "Medium" },
  { value: PrometheusCacheLevel.High, label: "High" },
  { value: PrometheusCacheLevel.None, label: "None" }
];
const prometheusFlavorSelectItems = [
  { value: PromApplication.Prometheus, label: PromApplication.Prometheus },
  { value: PromApplication.Cortex, label: PromApplication.Cortex },
  { value: PromApplication.Mimir, label: PromApplication.Mimir },
  { value: PromApplication.Thanos, label: PromApplication.Thanos }
];
const getOptionsWithDefaults = (options) => {
  if (options.jsonData.httpMethod) {
    return options;
  }
  return { ...options, jsonData: { ...options.jsonData, httpMethod: "POST" } };
};
const PromSettings = (props) => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  const theme = ui.useTheme2();
  const styles = overhaulStyles(theme);
  const { onOptionsChange } = props;
  const editorOptions = [
    {
      value: QueryEditorMode.Builder,
      label: i18n.t("grafana-prometheus.configuration.prom-settings.editor-options.label-builder", "Builder")
    },
    {
      value: QueryEditorMode.Code,
      label: i18n.t("grafana-prometheus.configuration.prom-settings.editor-options.label-code", "Code")
    }
  ];
  const optionsWithDefaults = getOptionsWithDefaults(props.options);
  const [validDuration, updateValidDuration] = React.useState({
    timeInterval: "",
    queryTimeout: "",
    incrementalQueryOverlapWindow: ""
  });
  const [validCount, updateValidCount] = React.useState({
    codeModeMetricNamesSuggestionLimit: ""
  });
  const [seriesLimit, setSeriesLimit] = React.useState(
    ((_a = optionsWithDefaults.jsonData.seriesLimit) == null ? void 0 : _a.toString()) || `${DEFAULT_SERIES_LIMIT}`
  );
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      pluginUi.ConfigSubSection,
      {
        title: i18n.t("grafana-prometheus.configuration.prom-settings.title-interval-behaviour", "Interval behaviour"),
        className: styles.container,
        children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-group", children: [
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.InlineField,
            {
              label: i18n.t("grafana-prometheus.configuration.prom-settings.label-scrape-interval", "Scrape interval"),
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsxs(
                  i18n.Trans,
                  {
                    i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-scrape-interval",
                    values: { default: "15s" },
                    children: [
                      "This interval is how frequently Prometheus scrapes targets. Set this to the typical scrape and evaluation interval configured in your Prometheus config file. If you set this to a greater value than your Prometheus config file interval, Grafana will evaluate the data according to this interval and you will see less data points. Defaults to ",
                      "{{default}}",
                      "."
                    ]
                  }
                ),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsx(
                  ui.Input,
                  {
                    className: "width-20",
                    value: optionsWithDefaults.jsonData.timeInterval,
                    spellCheck: false,
                    placeholder: "15s",
                    onChange: onChangeHandler("timeInterval", optionsWithDefaults, onOptionsChange),
                    onBlur: (e) => updateValidDuration({
                      ...validDuration,
                      timeInterval: e.currentTarget.value
                    }),
                    "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.scrapeInterval
                  }
                ),
                validateInput(validDuration.timeInterval, DURATION_REGEX, durationError)
              ] })
            }
          ) }) }),
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.InlineField,
            {
              label: i18n.t("grafana-prometheus.configuration.prom-settings.label-query-timeout", "Query timeout"),
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-query-timeout", children: "Set the Prometheus query timeout." }),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsx(
                  ui.Input,
                  {
                    className: "width-20",
                    value: optionsWithDefaults.jsonData.queryTimeout,
                    onChange: onChangeHandler("queryTimeout", optionsWithDefaults, onOptionsChange),
                    spellCheck: false,
                    placeholder: "60s",
                    onBlur: (e) => updateValidDuration({
                      ...validDuration,
                      queryTimeout: e.currentTarget.value
                    }),
                    "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.queryTimeout
                  }
                ),
                validateInput(validDuration.queryTimeout, DURATION_REGEX, durationError)
              ] })
            }
          ) }) })
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      pluginUi.ConfigSubSection,
      {
        title: i18n.t("grafana-prometheus.configuration.prom-settings.title-query-editor", "Query editor"),
        className: styles.container,
        children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-group", children: [
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.InlineField,
            {
              label: i18n.t("grafana-prometheus.configuration.prom-settings.label-default-editor", "Default editor"),
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-default-editor", children: "Set default editor option for all users of this data source." }),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.Select,
                {
                  "aria-label": i18n.t(
                    "grafana-prometheus.configuration.prom-settings.aria-label-default-editor",
                    "Default Editor (Code or Builder)"
                  ),
                  options: editorOptions,
                  value: (_b = editorOptions.find((o) => o.value === optionsWithDefaults.jsonData.defaultEditor)) != null ? _b : editorOptions.find((o) => o.value === QueryEditorMode.Builder),
                  onChange: onChangeHandler("defaultEditor", optionsWithDefaults, onOptionsChange),
                  width: 40,
                  "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.defaultEditor
                }
              )
            }
          ) }),
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.InlineField,
            {
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              label: i18n.t(
                "grafana-prometheus.configuration.prom-settings.label-disable-metrics-lookup",
                "Disable metrics lookup"
              ),
              tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsxs(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-disable-metrics-lookup", children: [
                  "Checking this option will disable the metrics chooser and metric/label support in the query field's autocomplete. This helps if you have performance issues with bigger Prometheus instances.",
                  " "
                ] }),
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              className: styles.switchField,
              children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.Switch,
                {
                  value: (_c = optionsWithDefaults.jsonData.disableMetricsLookup) != null ? _c : false,
                  onChange: data.onUpdateDatasourceJsonDataOptionChecked(props, "disableMetricsLookup"),
                  id: e2eSelectors.selectors.components.DataSource.Prometheus.configPage.disableMetricLookup
                }
              )
            }
          ) })
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsxs(
      pluginUi.ConfigSubSection,
      {
        title: i18n.t("grafana-prometheus.configuration.prom-settings.title-performance", "Performance"),
        className: styles.container,
        children: [
          !optionsWithDefaults.jsonData.prometheusType && !optionsWithDefaults.jsonData.prometheusVersion && optionsWithDefaults.readOnly && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.versionMargin, children: /* @__PURE__ */ jsxRuntime.jsxs(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.more-info", children: [
            "For more information on configuring prometheus type and version in data sources, see the",
            " ",
            /* @__PURE__ */ jsxRuntime.jsx(ui.TextLink, { external: true, href: "https://grafana.com/docs/grafana/latest/administration/provisioning/", children: "provisioning documentation" }),
            "."
          ] }) }),
          /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-group", children: [
            /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
              ui.InlineField,
              {
                label: i18n.t("grafana-prometheus.configuration.prom-settings.label-prometheus-type", "Prometheus type"),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                  /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-prometheus-type", children: "Set this to the type of your prometheus database, e.g. Prometheus, Cortex, Mimir or Thanos. Changing this field will save your current settings. Certain types of Prometheus supports or does not support various APIs. For example, some types support regex matching for label queries to improve performance. Some types have an API for metadata. If you set this incorrectly you may experience odd behavior when querying metrics and labels. Please check your Prometheus documentation to ensure you enter the correct type." }),
                  " ",
                  docsTip()
                ] }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsxRuntime.jsx(
                  ui.Select,
                  {
                    "aria-label": i18n.t(
                      "grafana-prometheus.configuration.prom-settings.aria-label-prometheus-type",
                      "Prometheus type"
                    ),
                    options: prometheusFlavorSelectItems,
                    value: prometheusFlavorSelectItems.find(
                      (o) => o.value === optionsWithDefaults.jsonData.prometheusType
                    ),
                    onChange: onChangeHandler("prometheusType", optionsWithDefaults, onOptionsChange),
                    width: 40,
                    "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.prometheusType
                  }
                )
              }
            ) }) }),
            /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: optionsWithDefaults.jsonData.prometheusType && /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
              ui.InlineField,
              {
                label: i18n.t(
                  "grafana-prometheus.configuration.prom-settings.label-prom-type-version",
                  "{{promType}} version",
                  {
                    promType: optionsWithDefaults.jsonData.prometheusType
                  }
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                  /* @__PURE__ */ jsxRuntime.jsxs(
                    i18n.Trans,
                    {
                      i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-prom-type-version",
                      values: { promType: optionsWithDefaults.jsonData.prometheusType },
                      children: [
                        "Use this to set the version of your ",
                        "{{promType}}",
                        " instance if it is not automatically configured."
                      ]
                    }
                  ),
                  " ",
                  docsTip()
                ] }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsxRuntime.jsx(
                  ui.Select,
                  {
                    "aria-label": i18n.t(
                      "grafana-prometheus.configuration.prom-settings.aria-label-prom-type-type",
                      "{{promType}} type",
                      {
                        promType: optionsWithDefaults.jsonData.prometheusType
                      }
                    ),
                    options: PromFlavorVersions[optionsWithDefaults.jsonData.prometheusType],
                    value: (_d = PromFlavorVersions[optionsWithDefaults.jsonData.prometheusType]) == null ? void 0 : _d.find(
                      (o) => o.value === optionsWithDefaults.jsonData.prometheusVersion
                    ),
                    onChange: onChangeHandler("prometheusVersion", optionsWithDefaults, onOptionsChange),
                    width: 40,
                    "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.prometheusVersion
                  }
                )
              }
            ) }) }),
            /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form max-width-30", children: /* @__PURE__ */ jsxRuntime.jsx(
              ui.InlineField,
              {
                label: i18n.t("grafana-prometheus.configuration.prom-settings.label-cache-level", "Cache level"),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-cache-level", children: "Sets the browser caching level for editor queries. Higher cache settings are recommended for high cardinality data sources." }) }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsxRuntime.jsx(
                  ui.Select,
                  {
                    width: 40,
                    onChange: onChangeHandler("cacheLevel", optionsWithDefaults, onOptionsChange),
                    options: cacheValueOptions,
                    value: (_e = cacheValueOptions.find((o) => o.value === optionsWithDefaults.jsonData.cacheLevel)) != null ? _e : PrometheusCacheLevel.Low,
                    "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.cacheLevel
                  }
                )
              }
            ) }) }),
            runtime.config.featureToggles.prometheusCodeModeMetricNamesSearch && /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
              ui.InlineField,
              {
                label: i18n.t(
                  "grafana-prometheus.configuration.prom-settings.label-metric-names-suggestion-limit",
                  "Metric names suggestion limit"
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-metric-names-suggestion-limit", children: "The maximum number of metric names that may appear as autocomplete suggestions in the query editor's Code mode." }) }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                  /* @__PURE__ */ jsxRuntime.jsx(
                    ui.Input,
                    {
                      className: "width-20",
                      value: optionsWithDefaults.jsonData.codeModeMetricNamesSuggestionLimit,
                      onChange: onChangeHandler(
                        "codeModeMetricNamesSuggestionLimit",
                        optionsWithDefaults,
                        onOptionsChange
                      ),
                      spellCheck: false,
                      placeholder: SUGGESTIONS_LIMIT.toString(),
                      onBlur: (e) => updateValidCount({
                        ...validCount,
                        codeModeMetricNamesSuggestionLimit: e.currentTarget.value
                      }),
                      "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.codeModeMetricNamesSuggestionLimit
                    }
                  ),
                  validateInput(
                    validCount.codeModeMetricNamesSuggestionLimit,
                    NON_NEGATIVE_INTEGER_REGEX,
                    countError
                  )
                ] })
              }
            ) }) }),
            /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form max-width-30", children: /* @__PURE__ */ jsxRuntime.jsx(
              ui.InlineField,
              {
                label: i18n.t(
                  "grafana-prometheus.configuration.prom-settings.label-incremental-querying-beta",
                  "Incremental querying (beta)"
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-incremental-querying-beta", children: "This feature will change the default behavior of relative queries to always request fresh data from the prometheus instance, instead query results will be cached, and only new records are requested. Turn this on to decrease database and network load." }) }),
                interactive: true,
                className: styles.switchField,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsxRuntime.jsx(
                  ui.Switch,
                  {
                    value: (_f = optionsWithDefaults.jsonData.incrementalQuerying) != null ? _f : false,
                    onChange: data.onUpdateDatasourceJsonDataOptionChecked(props, "incrementalQuerying"),
                    id: e2eSelectors.selectors.components.DataSource.Prometheus.configPage.incrementalQuerying
                  }
                )
              }
            ) }) }),
            /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: optionsWithDefaults.jsonData.incrementalQuerying && /* @__PURE__ */ jsxRuntime.jsx(
              ui.InlineField,
              {
                label: i18n.t(
                  "grafana-prometheus.configuration.prom-settings.label-query-overlap-window",
                  "Query overlap window"
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsxs(
                  i18n.Trans,
                  {
                    i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-query-overlap-window",
                    values: {
                      example1: "10m",
                      example2: "120s",
                      example3: "0s",
                      default: "10m"
                    },
                    children: [
                      "Set a duration like ",
                      "{{example1}}",
                      " or ",
                      "{{example2}}",
                      " or ",
                      "{{example3}}",
                      ". Default of",
                      " ",
                      "{{default}}",
                      ". This duration will be added to the duration of each incremental request."
                    ]
                  }
                ) }),
                interactive: true,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                  /* @__PURE__ */ jsxRuntime.jsx(
                    ui.Input,
                    {
                      onBlur: (e) => updateValidDuration({
                        ...validDuration,
                        incrementalQueryOverlapWindow: e.currentTarget.value
                      }),
                      className: "width-20",
                      value: (_g = optionsWithDefaults.jsonData.incrementalQueryOverlapWindow) != null ? _g : defaultPrometheusQueryOverlapWindow,
                      onChange: onChangeHandler("incrementalQueryOverlapWindow", optionsWithDefaults, onOptionsChange),
                      spellCheck: false,
                      "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.queryOverlapWindow
                    }
                  ),
                  validateInput(validDuration.incrementalQueryOverlapWindow, MULTIPLE_DURATION_REGEX, durationError)
                ] })
              }
            ) }),
            /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form max-width-30", children: /* @__PURE__ */ jsxRuntime.jsx(
              ui.InlineField,
              {
                label: i18n.t(
                  "grafana-prometheus.configuration.prom-settings.label-disable-recording-rules-beta",
                  "Disable recording rules (beta)"
                ),
                labelWidth: PROM_CONFIG_LABEL_WIDTH,
                tooltip: /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-disable-recording-rules-beta", children: "This feature will disable recording rules. Turn this on to improve dashboard performance" }) }),
                interactive: true,
                className: styles.switchField,
                disabled: optionsWithDefaults.readOnly,
                children: /* @__PURE__ */ jsxRuntime.jsx(
                  ui.Switch,
                  {
                    value: (_h = optionsWithDefaults.jsonData.disableRecordingRules) != null ? _h : false,
                    onChange: data.onUpdateDatasourceJsonDataOptionChecked(props, "disableRecordingRules"),
                    id: e2eSelectors.selectors.components.DataSource.Prometheus.configPage.disableRecordingRules
                  }
                )
              }
            ) }) })
          ] })
        ]
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      pluginUi.ConfigSubSection,
      {
        title: i18n.t("grafana-prometheus.configuration.prom-settings.title-other", "Other"),
        className: styles.container,
        children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-group", children: [
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form max-width-30", children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.InlineField,
            {
              label: i18n.t(
                "grafana-prometheus.configuration.prom-settings.label-custom-query-parameters",
                "Custom query parameters"
              ),
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsxs(
                  i18n.Trans,
                  {
                    i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-custom-query-parameters",
                    values: {
                      example1: "timeout",
                      example2: "partial_response",
                      example3: "dedup",
                      example4: "max_source_resolution",
                      concatenationChar: "\u2018&\u2019"
                    },
                    children: [
                      "Add custom parameters to the Prometheus query URL. For example ",
                      "{{example1}}",
                      ", ",
                      "{{example2}}",
                      ",",
                      " ",
                      "{{example3}}",
                      ", or",
                      "{{example4}}",
                      ". Multiple parameters should be concatenated together with",
                      " ",
                      "{{concatenationChar}}",
                      "."
                    ]
                  }
                ),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.Input,
                {
                  className: "width-20",
                  value: optionsWithDefaults.jsonData.customQueryParameters,
                  onChange: onChangeHandler("customQueryParameters", optionsWithDefaults, onOptionsChange),
                  spellCheck: false,
                  placeholder: i18n.t(
                    "grafana-prometheus.configuration.prom-settings.placeholder-example-maxsourceresolutionmtimeout",
                    "Example: {{example}}",
                    { example: "max_source_resolution=5m&timeout=10" }
                  ),
                  "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.customQueryParameters
                }
              )
            }
          ) }) }),
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsxRuntime.jsx(
            ui.InlineField,
            {
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-http-method", children: "You can use either POST or GET HTTP method to query your Prometheus data source. POST is the recommended method as it allows bigger queries. Change this to GET if you have a Prometheus version older than 2.1 or if POST requests are restricted in your network." }),
                " ",
                docsTip()
              ] }),
              interactive: true,
              label: i18n.t("grafana-prometheus.configuration.prom-settings.label-http-method", "HTTP method"),
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.Select,
                {
                  width: 40,
                  "aria-label": i18n.t(
                    "grafana-prometheus.configuration.prom-settings.aria-label-select-http-method",
                    "Select HTTP method"
                  ),
                  options: httpOptions,
                  value: httpOptions.find((o) => o.value === optionsWithDefaults.jsonData.httpMethod),
                  onChange: onChangeHandler("httpMethod", optionsWithDefaults, onOptionsChange),
                  "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.httpMethod
                }
              )
            }
          ) }) }),
          /* @__PURE__ */ jsxRuntime.jsx(
            ui.InlineField,
            {
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              label: i18n.t("grafana-prometheus.configuration.prom-settings.label-series-limit", "Series limit"),
              tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-series-limit", children: "The limit applies to all resources (metrics, labels, and values) for both endpoints (series and labels). Leave the field empty to use the default limit (40000). Set to 0 to disable the limit and fetch everything \u2014 this may cause performance issues. Default limit is 40000." }),
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              children: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsx(
                  ui.Input,
                  {
                    className: "width-20",
                    value: seriesLimit,
                    spellCheck: false,
                    placeholder: "40000",
                    onChange: (event) => {
                      setSeriesLimit(event.currentTarget.value);
                      onOptionsChange({
                        ...optionsWithDefaults,
                        jsonData: {
                          ...optionsWithDefaults.jsonData,
                          seriesLimit: parseInt(event.currentTarget.value, 10)
                        }
                      });
                    },
                    onBlur: (e) => validateInput(e.currentTarget.value, NON_NEGATIVE_INTEGER_REGEX, seriesLimitError),
                    "data-testid": e2eSelectors.selectors.components.DataSource.Prometheus.configPage.seriesLimit
                  }
                ),
                validateInput(seriesLimit, NON_NEGATIVE_INTEGER_REGEX, seriesLimitError)
              ] })
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx(
            ui.InlineField,
            {
              labelWidth: PROM_CONFIG_LABEL_WIDTH,
              label: i18n.t("grafana-prometheus.configuration.prom-settings.label-use-series-endpoint", "Use series endpoint"),
              tooltip: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
                /* @__PURE__ */ jsxRuntime.jsxs(
                  i18n.Trans,
                  {
                    i18nKey: "grafana-prometheus.configuration.prom-settings.tooltip-use-series-endpoint",
                    values: { exampleParameter: "match[]" },
                    children: [
                      "Checking this option will favor the series endpoint with ",
                      "{{exampleParameter}}",
                      " parameter over the label values endpoint with ",
                      "{{exampleParameter}}",
                      " parameter. While the label values endpoint is considered more performant, some users may prefer the series because it has a POST method while the label values endpoint only has a GET method."
                    ]
                  }
                ),
                " ",
                docsTip()
              ] }),
              interactive: true,
              disabled: optionsWithDefaults.readOnly,
              className: styles.switchField,
              children: /* @__PURE__ */ jsxRuntime.jsx(
                ui.Switch,
                {
                  value: (_i = optionsWithDefaults.jsonData.seriesEndpoint) != null ? _i : false,
                  onChange: data.onUpdateDatasourceJsonDataOptionChecked(props, "seriesEndpoint")
                }
              )
            }
          )
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      ExemplarsSettings,
      {
        options: optionsWithDefaults.jsonData.exemplarTraceIdDestinations,
        onChange: (exemplarOptions) => data.updateDatasourcePluginJsonDataOption(
          { onOptionsChange, options: optionsWithDefaults },
          "exemplarTraceIdDestinations",
          exemplarOptions
        ),
        disabled: optionsWithDefaults.readOnly
      }
    )
  ] });
};
const getValueFromEventItem = (eventItem) => {
  if (!eventItem) {
    return "";
  }
  if ("currentTarget" in eventItem) {
    return eventItem.currentTarget.value;
  }
  return eventItem.value;
};
const onChangeHandler = (key, options, onOptionsChange) => (eventItem) => {
  onOptionsChange({
    ...options,
    jsonData: {
      ...options.jsonData,
      [key]: getValueFromEventItem(eventItem)
    }
  });
};

"use strict";
const ConfigEditor = (props) => {
  const { options, onOptionsChange } = props;
  const theme = ui.useTheme2();
  const styles = overhaulStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    options.access === "direct" && /* @__PURE__ */ jsxRuntime.jsx(ui.Alert, { title: i18n.t("grafana-prometheus.configuration.config-editor.title-error", "Error"), severity: "error", children: /* @__PURE__ */ jsxRuntime.jsx(i18n.Trans, { i18nKey: "grafana-prometheus.configuration.config-editor.browser-access-mode-error", children: "Browser access mode in the Prometheus data source is no longer available. Switch to server access mode." }) }),
    /* @__PURE__ */ jsxRuntime.jsx(
      pluginUi.DataSourceDescription,
      {
        dataSourceName: "Prometheus",
        docsLink: "https://grafana.com/docs/grafana/latest/datasources/prometheus/configure-prometheus-data-source/"
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("hr", { className: `${styles.hrTopSpace} ${styles.hrBottomSpace}` }),
    /* @__PURE__ */ jsxRuntime.jsx(
      DataSourceHttpSettingsOverhaul,
      {
        options,
        onOptionsChange,
        secureSocksDSProxyEnabled: runtime.config.secureSocksDSProxyEnabled
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("hr", {}),
    /* @__PURE__ */ jsxRuntime.jsxs(
      pluginUi.ConfigSection,
      {
        className: styles.advancedSettings,
        title: i18n.t("grafana-prometheus.configuration.config-editor.title-advanced-settings", "Advanced settings"),
        description: i18n.t(
          "grafana-prometheus.configuration.config-editor.description-advanced-settings",
          "Additional settings are optional settings that can be configured for more control over your data source."
        ),
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(
            pluginUi.AdvancedHttpSettings,
            {
              className: styles.advancedHTTPSettingsMargin,
              config: options,
              onChange: onOptionsChange
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx(AlertingSettingsOverhaul, { options, onOptionsChange }),
          /* @__PURE__ */ jsxRuntime.jsx(PromSettings, { options, onOptionsChange })
        ]
      }
    )
  ] });
};

"use strict";
const ANNOTATION_QUERY_STEP_DEFAULT = "60s";
const PrometheusAnnotationSupport = (ds) => {
  return {
    QueryEditor: AnnotationQueryEditor,
    prepareAnnotation(json) {
      if (!json.target) {
        json.target = {
          expr: "",
          refId: "Anno"
        };
      }
      json.target = {
        ...json.target,
        refId: json.target.refId || json.refId || "Anno",
        expr: json.target.expr || json.expr || "",
        interval: json.target.interval || json.step || ""
      };
      delete json.expr;
      delete json.step;
      return json;
    },
    processEvents(anno, frames) {
      var _a, _b;
      if (!frames.length) {
        return new rxjs.Observable();
      }
      const { tagKeys = "", titleFormat = "", textFormat = "" } = anno;
      const input = ((_a = frames[0].meta) == null ? void 0 : _a.executedQueryString) || "";
      const regex = /Step:\s*([\d\w]+)/;
      const match = input.match(regex);
      const stepValue = match ? match[1] : null;
      const step = data.rangeUtil.intervalToSeconds(stepValue || ANNOTATION_QUERY_STEP_DEFAULT) * 1e3;
      const tagKeysArray = tagKeys.split(",");
      const eventList = [];
      for (const frame of frames) {
        if (frame.fields.length === 0) {
          continue;
        }
        const timeField = frame.fields[0];
        const valueField = frame.fields[1];
        const labels = (valueField == null ? void 0 : valueField.labels) || {};
        const tags = Object.keys(labels).filter((label) => tagKeysArray.includes(label)).map((label) => labels[label]);
        const timeValueTuple = [];
        let idx = 0;
        valueField.values.forEach((value) => {
          let timeStampValue;
          let valueValue;
          const time = timeField.values[idx];
          if (anno.useValueForTime) {
            timeStampValue = Math.floor(parseFloat(value));
            valueValue = 1;
          } else {
            timeStampValue = Math.floor(parseFloat(time));
            valueValue = parseFloat(value);
          }
          idx++;
          timeValueTuple.push([timeStampValue, valueValue]);
        });
        const activeValues = timeValueTuple.filter((value) => value[1] > 0);
        const activeValuesTimestamps = activeValues.map((value) => value[0]);
        let latestEvent = null;
        for (const timestamp of activeValuesTimestamps) {
          if (latestEvent && ((_b = latestEvent.timeEnd) != null ? _b : 0) + step >= timestamp) {
            latestEvent.timeEnd = timestamp;
            continue;
          }
          if (latestEvent) {
            eventList.push(latestEvent);
          }
          latestEvent = {
            time: timestamp,
            timeEnd: timestamp,
            annotation: anno,
            title: data.renderLegendFormat(titleFormat, labels),
            tags,
            text: data.renderLegendFormat(textFormat, labels)
          };
        }
        if (latestEvent) {
          latestEvent.timeEnd = activeValuesTimestamps[activeValuesTimestamps.length - 1];
          eventList.push(latestEvent);
        }
      }
      return rxjs.of(eventList);
    }
  };
};

"use strict";
class BaseResourceClient {
  constructor(request, datasource) {
    this.request = request;
    this.datasource = datasource;
    /**
     * Fetches all time series that match a specific label matcher using **series** endpoint.
     *
     * @param {TimeRange} timeRange - Time range to use for the query
     * @param {string} match - Label matcher to filter time series
     * @param {string} limit - Maximum number of series to return
     */
    this.querySeries = async (timeRange, match, limit) => {
      const effectiveMatch = !match || match === EMPTY_SELECTOR ? MATCH_ALL_LABELS : match;
      const timeParams = this.datasource.getTimeRangeParams(timeRange);
      const searchParams = { ...timeParams, "match[]": effectiveMatch, limit };
      return await this.requestSeries("/api/v1/series", searchParams, getDefaultCacheHeaders(this.datasource.cacheLevel));
    };
    this.seriesLimit = this.datasource.seriesLimit;
  }
  getEffectiveLimit(limit) {
    return limit || this.seriesLimit;
  }
  async requestLabels(url, params, options) {
    const response = await this.request(url, params, options);
    return Array.isArray(response) ? response : [];
  }
  async requestSeries(url, params, options) {
    const response = await this.request(url, params, options);
    return Array.isArray(response) ? response : [];
  }
}
class LabelsApiClient extends BaseResourceClient {
  constructor() {
    super(...arguments);
    this._cache = new ResourceClientsCache(this.datasource.cacheLevel);
    this.histogramMetrics = [];
    this.metrics = [];
    this.labelKeys = [];
    this.cachedLabelValues = {};
    this.start = async (timeRange) => {
      await this.queryMetrics(timeRange);
      this.labelKeys = await this.queryLabelKeys(timeRange);
    };
    this.queryMetrics = async (timeRange) => {
      this.metrics = await this.queryLabelValues(timeRange, METRIC_LABEL);
      this.histogramMetrics = processHistogramMetrics(this.metrics);
      this._cache.setLabelValues(timeRange, void 0, DEFAULT_SERIES_LIMIT, this.metrics);
      return { metrics: this.metrics, histogramMetrics: this.histogramMetrics };
    };
    /**
     * Fetches all available label keys from Prometheus using labels endpoint.
     * Uses the labels endpoint with optional match parameter for filtering.
     *
     * @param {TimeRange} timeRange - Time range to use for the query
     * @param {string} match - Optional label matcher to filter results
     * @param {string} limit - Maximum number of results to return
     * @returns {Promise<string[]>} Array of label keys sorted alphabetically
     */
    this.queryLabelKeys = async (timeRange, match, limit) => {
      let url = "/api/v1/labels";
      const timeParams = getRangeSnapInterval(this.datasource.cacheLevel, timeRange);
      const effectiveLimit = this.getEffectiveLimit(limit);
      const searchParams = { limit: effectiveLimit, ...timeParams, ...match ? { "match[]": match } : {} };
      const effectiveMatch = match != null ? match : "";
      const maybeCachedKeys = this._cache.getLabelKeys(timeRange, effectiveMatch, effectiveLimit);
      if (maybeCachedKeys) {
        return maybeCachedKeys;
      }
      const res = await this.requestLabels(url, searchParams, getDefaultCacheHeaders(this.datasource.cacheLevel));
      if (Array.isArray(res)) {
        this.labelKeys = res.slice().sort();
        this._cache.setLabelKeys(timeRange, effectiveMatch, effectiveLimit, this.labelKeys);
        return this.labelKeys.slice();
      }
      return [];
    };
    /**
     * Fetches all values for a specific label key from Prometheus using labels values endpoint.
     *
     * @param {TimeRange} timeRange - Time range to use for the query
     * @param {string} labelKey - The label key to fetch values for
     * @param {string} match - Optional label matcher to filter results
     * @param {string} limit - Maximum number of results to return
     * @returns {Promise<string[]>} Array of label values
     */
    this.queryLabelValues = async (timeRange, labelKey, match, limit) => {
      const timeParams = this.datasource.getAdjustedInterval(timeRange);
      const effectiveLimit = this.getEffectiveLimit(limit);
      const searchParams = { limit: effectiveLimit, ...timeParams, ...match ? { "match[]": match } : {} };
      const interpolatedName = this.datasource.interpolateString(labelKey);
      const interpolatedAndEscapedName = escapeForUtf8Support(removeQuotesIfExist(interpolatedName));
      const effectiveMatch = `${match != null ? match : ""}-${interpolatedAndEscapedName}`;
      const maybeCachedValues = this._cache.getLabelValues(timeRange, effectiveMatch, effectiveLimit);
      if (maybeCachedValues) {
        return maybeCachedValues;
      }
      const url = `/api/v1/label/${interpolatedAndEscapedName}/values`;
      const value = await this.requestLabels(url, searchParams, getDefaultCacheHeaders(this.datasource.cacheLevel));
      this._cache.setLabelValues(timeRange, effectiveMatch, effectiveLimit, value != null ? value : []);
      return value != null ? value : [];
    };
  }
}
class SeriesApiClient extends BaseResourceClient {
  constructor() {
    super(...arguments);
    this._cache = new ResourceClientsCache(this.datasource.cacheLevel);
    this.histogramMetrics = [];
    this.metrics = [];
    this.labelKeys = [];
    this.cachedLabelValues = {};
    this.start = async (timeRange) => {
      await this.queryMetrics(timeRange);
    };
    this.queryMetrics = async (timeRange) => {
      const series = await this.querySeries(timeRange, void 0, DEFAULT_SERIES_LIMIT);
      const { metrics, labelKeys } = processSeries(series, METRIC_LABEL);
      this.metrics = metrics;
      this.histogramMetrics = processHistogramMetrics(this.metrics);
      this.labelKeys = labelKeys;
      this._cache.setLabelValues(timeRange, void 0, DEFAULT_SERIES_LIMIT, metrics);
      this._cache.setLabelKeys(timeRange, void 0, DEFAULT_SERIES_LIMIT, labelKeys);
      return { metrics: this.metrics, histogramMetrics: this.histogramMetrics };
    };
    this.queryLabelKeys = async (timeRange, match, limit) => {
      const effectiveLimit = this.getEffectiveLimit(limit);
      const effectiveMatch = !match || match === EMPTY_SELECTOR ? void 0 : match;
      const maybeCachedKeys = this._cache.getLabelKeys(timeRange, effectiveMatch, effectiveLimit);
      if (maybeCachedKeys) {
        return maybeCachedKeys;
      }
      const series = await this.querySeries(timeRange, effectiveMatch, effectiveLimit);
      const { labelKeys } = processSeries(series);
      this._cache.setLabelKeys(timeRange, effectiveMatch, effectiveLimit, labelKeys);
      return labelKeys;
    };
    this.queryLabelValues = async (timeRange, labelKey, match, limit) => {
      let effectiveMatch = "";
      if (!match || match === EMPTY_SELECTOR) {
        effectiveMatch = `{${utf8Support(removeQuotesIfExist(labelKey))}!=""}`;
      } else {
        const {
          query: { metric, labels }
        } = buildVisualQueryFromString(match);
        labels.push({
          label: removeQuotesIfExist(labelKey),
          op: "!=",
          value: ""
        });
        const metricFilter = metric ? `__name__="${metric}",` : "";
        const labelFilters = labels.map((lf) => `${utf8Support(lf.label)}${lf.op}"${lf.value}"`).join(",");
        effectiveMatch = `{${metricFilter}${labelFilters}}`;
      }
      const effectiveLimit = this.getEffectiveLimit(limit);
      const maybeCachedValues = this._cache.getLabelValues(timeRange, effectiveMatch, effectiveLimit);
      if (maybeCachedValues) {
        return maybeCachedValues;
      }
      const series = await this.querySeries(timeRange, effectiveMatch, effectiveLimit);
      const { labelValues } = processSeries(series, removeQuotesIfExist(labelKey));
      this._cache.setLabelValues(timeRange, effectiveMatch, effectiveLimit, labelValues);
      return labelValues;
    };
  }
}
class ResourceClientsCache {
  constructor(cacheLevel = PrometheusCacheLevel.High) {
    this.cacheLevel = cacheLevel;
    this.MAX_CACHE_ENTRIES = 1e3;
    // Maximum number of cache entries
    this.MAX_CACHE_SIZE_BYTES = 50 * 1024 * 1024;
    // 50MB max cache size
    this._cache = {};
    this._accessTimestamps = {};
  }
  setLabelKeys(timeRange, match, limit, keys) {
    if (keys.length === 0) {
      return;
    }
    this.cleanCacheIfNeeded();
    const cacheKey = this.getCacheKey(timeRange, match, limit, "key");
    this._cache[cacheKey] = keys.slice().sort();
    this._accessTimestamps[cacheKey] = Date.now();
  }
  getLabelKeys(timeRange, match, limit) {
    const cacheKey = this.getCacheKey(timeRange, match, limit, "key");
    const result = this._cache[cacheKey];
    if (result) {
      this._accessTimestamps[cacheKey] = Date.now();
    }
    return result;
  }
  setLabelValues(timeRange, match, limit, values) {
    if (values.length === 0) {
      return;
    }
    this.cleanCacheIfNeeded();
    const cacheKey = this.getCacheKey(timeRange, match, limit, "value");
    this._cache[cacheKey] = values.slice().sort();
    this._accessTimestamps[cacheKey] = Date.now();
  }
  getLabelValues(timeRange, match, limit) {
    const cacheKey = this.getCacheKey(timeRange, match, limit, "value");
    const result = this._cache[cacheKey];
    if (result) {
      this._accessTimestamps[cacheKey] = Date.now();
    }
    return result;
  }
  getCacheKey(timeRange, match, limit, type) {
    const snappedTimeRange = getRangeSnapInterval(this.cacheLevel, timeRange);
    return [snappedTimeRange.start, snappedTimeRange.end, limit, match, type].join("|");
  }
  cleanCacheIfNeeded() {
    const currentEntries = Object.keys(this._cache).length;
    if (currentEntries >= this.MAX_CACHE_ENTRIES) {
      const entriesToRemove = Math.max(1, Math.floor(currentEntries - this.MAX_CACHE_ENTRIES + 1));
      this.removeOldestEntries(entriesToRemove);
    }
    const currentSize = this.getCacheSizeInBytes();
    if (currentSize > this.MAX_CACHE_SIZE_BYTES) {
      const entriesToRemove = Math.max(1, Math.floor(Object.keys(this._cache).length * 0.2));
      this.removeOldestEntries(entriesToRemove);
    }
  }
  getCacheSizeInBytes() {
    let size = 0;
    for (const key in this._cache) {
      size += key.length * 2;
      const value = this._cache[key];
      for (const item of value) {
        size += item.length * 2;
      }
    }
    return size;
  }
  removeOldestEntries(count) {
    const entries = Object.entries(this._accessTimestamps).sort(
      ([, timestamp1], [, timestamp2]) => timestamp1 - timestamp2
    );
    const entriesToRemove = entries.slice(0, count);
    for (const [key] of entriesToRemove) {
      delete this._cache[key];
      delete this._accessTimestamps[key];
    }
  }
}
function processSeries(series, findValuesForKey) {
  const metrics = /* @__PURE__ */ new Set();
  const labelKeys = /* @__PURE__ */ new Set();
  const labelValues = /* @__PURE__ */ new Set();
  series.forEach((item) => {
    if (METRIC_LABEL in item) {
      metrics.add(item.__name__);
    }
    Object.keys(item).forEach((key) => {
      if (key !== METRIC_LABEL) {
        labelKeys.add(key);
      }
      if (findValuesForKey && key === findValuesForKey) {
        labelValues.add(item[key]);
      }
    });
  });
  return {
    metrics: Array.from(metrics).sort(),
    labelKeys: Array.from(labelKeys).sort(),
    labelValues: Array.from(labelValues).sort()
  };
}

"use strict";
const DEFAULT_KEYS = ["job", "instance"];
const API_V1 = {
  METADATA: "/api/v1/metadata",
  SERIES: "/api/v1/series",
  LABELS: "/api/v1/labels",
  LABELS_VALUES: (labelKey) => `/api/v1/label/${labelKey}/values`
};
class PromQlLanguageProvider extends data.LanguageProvider {
  constructor(datasource, initialValues) {
    super();
    this.labelKeys = [];
    this.request = async (url, params = {}, options) => {
      try {
        const res = await this.datasource.metadataRequest(url, params, options);
        return res.data.data;
      } catch (error) {
        if (!isCancelledError(error)) {
          console.error(error);
        }
      }
      return void 0;
    };
    /**
     * Overridden by PrometheusLanguageProvider
     */
    this.start = async (timeRange = data.getDefaultTimeRange()) => {
      if (this.datasource.lookupsDisabled) {
        return [];
      }
      this.metrics = await this.fetchLabelValues(timeRange, "__name__") || [];
      this.histogramMetrics = processHistogramMetrics(this.metrics).sort();
      return Promise.all([this.loadMetricsMetadata(), this.fetchLabels(timeRange)]);
    };
    this.fetchLabelValues = async (range, key, limit) => {
      const params = { ...this.datasource.getAdjustedInterval(range), ...limit ? { limit } : {} };
      const interpolatedName = this.datasource.interpolateString(key);
      const interpolatedAndEscapedName = escapeForUtf8Support(removeQuotesIfExist(interpolatedName));
      const value = await this.request(
        API_V1.LABELS_VALUES(interpolatedAndEscapedName),
        params,
        getDefaultCacheHeaders(this.datasource.cacheLevel)
      );
      return value != null ? value : [];
    };
    /**
     * Fetches all label keys
     */
    this.fetchLabels = async (timeRange, queries, limit) => {
      let url = API_V1.LABELS;
      const timeParams = this.datasource.getAdjustedInterval(timeRange);
      this.labelFetchTs = Date.now().valueOf();
      const searchParams = new URLSearchParams({ ...timeParams, ...limit ? { limit } : {} });
      queries == null ? void 0 : queries.forEach((q) => {
        const visualQuery = buildVisualQueryFromString(q.expr);
        if (visualQuery.query.metric !== "") {
          const isUtf8Metric = !isValidLegacyName(visualQuery.query.metric);
          searchParams.append("match[]", isUtf8Metric ? `{"${visualQuery.query.metric}"}` : visualQuery.query.metric);
          if (visualQuery.query.binaryQueries) {
            visualQuery.query.binaryQueries.forEach((bq) => {
              searchParams.append("match[]", isUtf8Metric ? `{"${bq.query.metric}"}` : bq.query.metric);
            });
          }
        }
      });
      if (this.datasource.httpMethod === "GET") {
        url += `?${searchParams.toString()}`;
      }
      const res = await this.request(url, searchParams, getDefaultCacheHeaders(this.datasource.cacheLevel));
      if (Array.isArray(res)) {
        this.labelKeys = res.slice().sort();
        return [...this.labelKeys];
      }
      return [];
    };
    /**
     * Gets series values
     * Function to replace old getSeries calls in a way that will provide faster endpoints
     * for new prometheus instances, while maintaining backward compatability
     */
    this.getSeriesValues = async (timeRange, labelName, selector) => {
      var _a;
      if (!this.datasource.hasLabelsMatchAPISupport()) {
        const data = await this.getSeries(timeRange, selector);
        return (_a = data[removeQuotesIfExist(labelName)]) != null ? _a : [];
      }
      return await this.fetchSeriesValuesWithMatch(timeRange, labelName, selector);
    };
    /**
     * Fetches all values for a label, with optional match[]
     */
    this.fetchSeriesValuesWithMatch = async (timeRange, name, match, requestId, withLimit) => {
      const interpolatedName = name ? this.datasource.interpolateString(name) : null;
      const interpolatedMatch = match ? this.datasource.interpolateString(match) : null;
      const range = this.datasource.getAdjustedInterval(timeRange);
      const urlParams = {
        ...range,
        ...interpolatedMatch && { "match[]": interpolatedMatch },
        ...withLimit ? { limit: withLimit } : {}
      };
      let requestOptions = {
        ...getDefaultCacheHeaders(this.datasource.cacheLevel),
        ...requestId && { requestId }
      };
      if (!Object.keys(requestOptions).length) {
        requestOptions = void 0;
      }
      const interpolatedAndEscapedName = escapeForUtf8Support(removeQuotesIfExist(interpolatedName != null ? interpolatedName : ""));
      const value = await this.request(API_V1.LABELS_VALUES(interpolatedAndEscapedName), urlParams, requestOptions);
      return value != null ? value : [];
    };
    /**
     * Gets series labels
     * Function to replace old getSeries calls in a way that will provide faster endpoints for new prometheus instances,
     * while maintaining backward compatability. The old API call got the labels and the values in a single query,
     * but with the new query we need two calls, one to get the labels, and another to get the values.
     */
    this.getSeriesLabels = async (timeRange, selector, otherLabels) => {
      let possibleLabelNames, data;
      if (!this.datasource.hasLabelsMatchAPISupport()) {
        data = await this.getSeries(timeRange, selector);
        possibleLabelNames = Object.keys(data);
      } else {
        otherLabels.push({ name: "__name__", value: "", op: "!=" });
        data = await this.fetchSeriesLabelsMatch(timeRange, selector);
        possibleLabelNames = Object.keys(data);
      }
      const usedLabelNames = new Set(otherLabels.map((l) => l.name));
      return possibleLabelNames.filter((l) => !usedLabelNames.has(l));
    };
    /**
     * Fetch labels using the best endpoint that datasource supports.
     * This is cached by its args but also by the global timeRange currently selected as they can change over requested time.
     */
    this.fetchLabelsWithMatch = async (timeRange, name, withName, withLimit) => {
      if (this.datasource.hasLabelsMatchAPISupport()) {
        return this.fetchSeriesLabelsMatch(timeRange, name, withLimit);
      } else {
        return this.fetchSeriesLabels(timeRange, name, withName, REMOVE_SERIES_LIMIT);
      }
    };
    /**
     * Fetch labels for a series using /series endpoint. This is cached by its args but also by the global timeRange currently selected as
     * they can change over requested time.
     */
    this.fetchSeriesLabels = async (timeRange, name, withName, withLimit) => {
      const interpolatedName = this.datasource.interpolateString(name);
      const range = this.datasource.getAdjustedInterval(timeRange);
      let urlParams = {
        ...range,
        "match[]": interpolatedName,
        ...withLimit !== "none" ? { limit: withLimit != null ? withLimit : DEFAULT_SERIES_LIMIT } : {}
      };
      const data = await this.request(API_V1.SERIES, urlParams, getDefaultCacheHeaders(this.datasource.cacheLevel));
      const { values } = processLabels(data, withName);
      return values;
    };
    /**
     * Fetch labels for a series using /labels endpoint.  This is cached by its args but also by the global timeRange currently selected as
     * they can change over requested time.
     */
    this.fetchSeriesLabelsMatch = async (timeRange, name, withLimit) => {
      const interpolatedName = this.datasource.interpolateString(name);
      const range = this.datasource.getAdjustedInterval(timeRange);
      const urlParams = {
        ...range,
        "match[]": interpolatedName,
        ...withLimit ? { limit: withLimit } : {}
      };
      const data = await this.request(
        API_V1.LABELS,
        urlParams,
        getDefaultCacheHeaders(this.datasource.cacheLevel)
      );
      return data.reduce((ac, a) => ({ ...ac, [a]: "" }), {});
    };
    /**
     * Fetch series for a selector. Use this for raw results. Use fetchSeriesLabels() to get labels.
     */
    this.fetchSeries = async (timeRange, match) => {
      const range = this.datasource.getTimeRangeParams(timeRange);
      const params = { ...range, "match[]": match };
      return await this.request(API_V1.SERIES, params, getDefaultCacheHeaders(this.datasource.cacheLevel));
    };
    /**
     * Fetch this only one as we assume this won't change over time. This is cached differently from fetchSeriesLabels
     * because we can cache more aggressively here and also we do not want to invalidate this cache the same way as in
     * fetchSeriesLabels.
     */
    this.fetchDefaultSeries = lodash.once(async (timeRange) => {
      const values = await Promise.all(DEFAULT_KEYS.map((key) => this.fetchLabelValues(timeRange, key)));
      return DEFAULT_KEYS.reduce((acc, key, i) => ({ ...acc, [key]: values[i] }), {});
    });
    /**
     * Fetch labels or values for a label based on the queries, scopes, filters and time range
     */
    this.fetchSuggestions = async (timeRange, queries, scopes, adhocFilters, labelName, limit, requestId) => {
      var _a;
      if (!timeRange) {
        timeRange = data.getDefaultTimeRange();
      }
      const url = "/suggestions";
      const timeParams = this.datasource.getAdjustedInterval(timeRange);
      const value = await this.request(
        url,
        {
          labelName,
          queries: queries == null ? void 0 : queries.map(
            (q) => this.datasource.interpolateString(q.expr, {
              ...this.datasource.getIntervalVars(),
              ...this.datasource.getRangeScopedVars(timeRange)
            })
          ),
          scopes: scopes == null ? void 0 : scopes.reduce((acc, scope) => {
            acc.push(...scope.spec.filters);
            return acc;
          }, []),
          adhocFilters: adhocFilters == null ? void 0 : adhocFilters.map((filter) => ({
            key: filter.key,
            operator: data.scopeFilterOperatorMap[filter.operator],
            value: filter.value,
            values: filter.values
          })),
          limit,
          ...timeParams
        },
        {
          ...requestId && { requestId },
          headers: {
            ...(_a = getDefaultCacheHeaders(this.datasource.cacheLevel)) == null ? void 0 : _a.headers,
            "Content-Type": "application/json"
          },
          method: "POST"
        }
      );
      return value != null ? value : [];
    };
    this.datasource = datasource;
    this.histogramMetrics = [];
    this.metrics = [];
    Object.assign(this, initialValues);
  }
  async loadMetricsMetadata() {
    const secondsInDay = 86400;
    const headers = buildCacheHeaders(getDaysToCacheMetadata(this.datasource.cacheLevel) * secondsInDay);
    this.metricsMetadata = fixSummariesMetadata(
      await this.request(
        API_V1.METADATA,
        {},
        {
          showErrorAlert: false,
          ...headers
        }
      )
    );
  }
  getLabelKeys() {
    return this.labelKeys;
  }
  async getSeries(timeRange, selector, withName) {
    if (this.datasource.lookupsDisabled) {
      return {};
    }
    try {
      if (selector === EMPTY_SELECTOR) {
        return await this.fetchDefaultSeries(timeRange);
      } else {
        return await this.fetchSeriesLabels(timeRange, selector, withName, REMOVE_SERIES_LIMIT);
      }
    } catch (error) {
      console.error(error);
      return {};
    }
  }
  async getLabelValues(range, key) {
    return await this.fetchLabelValues(range, key);
  }
}
class PrometheusLanguageProvider extends PromQlLanguageProvider {
  constructor(datasource) {
    super(datasource);
    /**
     * Same start logic but it uses resource clients. Backward compatibility it calls _backwardCompatibleStart.
     * Some places still relies on deprecated fields. Until we replace them we need _backwardCompatibleStart method
     */
    this.start = async (timeRange = data.getDefaultTimeRange()) => {
      if (this.datasource.lookupsDisabled) {
        return [];
      }
      await Promise.all([this.resourceClient.start(timeRange), this.queryMetricsMetadata(this.datasource.seriesLimit)]);
      return this._backwardCompatibleStart();
    };
    /**
     * This private method exists to make sure the old class will be functional until we remove it.
     * When we remove old class (PromQlLanguageProvider) we should remove this method too.
     */
    this._backwardCompatibleStart = async () => {
      this.metricsMetadata = this.retrieveMetricsMetadata();
      this.metrics = this.retrieveMetrics();
      this.histogramMetrics = this.retrieveHistogramMetrics();
      this.labelKeys = this.retrieveLabelKeys();
      return [];
    };
    /**
     * Fetches metadata for metrics from Prometheus.
     * Sets cache headers based on the configured metadata cache duration.
     *
     * @returns {Promise<PromMetricsMetadata>} Promise that resolves when metadata has been fetched
     */
    this._queryMetadata = async (limit) => {
      const secondsInDay = 86400;
      const headers = buildCacheHeaders(getDaysToCacheMetadata(this.datasource.cacheLevel) * secondsInDay);
      const metadata = await this.request(
        API_V1.METADATA,
        { limit: limit != null ? limit : this.datasource.seriesLimit },
        {
          showErrorAlert: false,
          ...headers
        }
      );
      return fixSummariesMetadata(metadata);
    };
    /**
     * Retrieves the cached Prometheus metrics metadata.
     * This metadata includes type information (counter, gauge, etc.) and help text for metrics.
     *
     * @returns {PromMetricsMetadata} Cached metadata or empty object if not yet fetched
     */
    this.retrieveMetricsMetadata = () => {
      var _a;
      return (_a = this._metricsMetadata) != null ? _a : {};
    };
    /**
     * Retrieves the list of histogram metrics from the current resource client.
     * Histogram metrics are identified by the '_bucket' suffix and are used for percentile calculations.
     *
     * @returns {string[]} Array of histogram metric names
     */
    this.retrieveHistogramMetrics = () => {
      var _a;
      return (_a = this.resourceClient) == null ? void 0 : _a.histogramMetrics;
    };
    /**
     * Retrieves the complete list of available metrics from the current resource client.
     * This includes all metric names regardless of their type (counter, gauge, histogram).
     *
     * @returns {string[]} Array of all metric names
     */
    this.retrieveMetrics = () => {
      var _a;
      return (_a = this.resourceClient) == null ? void 0 : _a.metrics;
    };
    /**
     * Retrieves the list of available label keys from the current resource client.
     * Label keys are the names of labels that can be used to filter and group metrics.
     *
     * @returns {string[]} Array of label key names
     */
    this.retrieveLabelKeys = () => {
      var _a;
      return (_a = this.resourceClient) == null ? void 0 : _a.labelKeys;
    };
    /**
     * Fetches fresh metrics metadata from Prometheus and updates the cache.
     * This includes querying for metric types, help text, and unit information.
     * If the fetch fails, the cache is set to an empty object to prevent stale data.
     *
     * @returns {Promise<PromMetricsMetadata>} Promise that resolves to the fetched metadata
     */
    this.queryMetricsMetadata = async (limit) => {
      var _a;
      try {
        this._metricsMetadata = (_a = await this._queryMetadata(limit)) != null ? _a : {};
      } catch (error) {
        this._metricsMetadata = {};
      }
      return this._metricsMetadata;
    };
    /**
     * Fetches all available label keys that match the specified criteria.
     *
     * This method queries Prometheus for label keys within the specified time range.
     * The results can be filtered using the match parameter and limited in size.
     * Uses either the labels API (Prometheus v2.6+) or series API based on version.
     *
     * @param {TimeRange} timeRange - Time range to search for label keys
     * @param {string} [match] - Optional PromQL selector to filter label keys (e.g., '{job="grafana"}')
     * @param {string} [limit] - Optional maximum number of label keys to return
     * @returns {Promise<string[]>} Array of matching label key names, sorted alphabetically
     */
    this.queryLabelKeys = async (timeRange, match, limit) => {
      const interpolatedMatch = match ? this.datasource.interpolateString(match) : match;
      return await this.resourceClient.queryLabelKeys(timeRange, interpolatedMatch, limit);
    };
    /**
     * Fetches all values for a specific label key that match the specified criteria.
     *
     * This method queries Prometheus for label values within the specified time range.
     * Results can be filtered using the match parameter to find values in specific contexts.
     * Supports both modern (labels API) and legacy (series API) Prometheus versions.
     *
     * The method automatically handles UTF-8 encoded label keys by properly escaping them
     * before making API requests. This means you can safely pass label keys containing
     * special characters like dots, colons, or Unicode characters (e.g., 'http.status:code',
     * 'μs', 'response.time').
     *
     * @param {TimeRange} timeRange - Time range to search for label values
     * @param {string} labelKey - The label key to fetch values for (e.g., 'job', 'instance', 'http.status:code')
     * @param {string} [match] - Optional PromQL selector to filter values (e.g., '{job="grafana"}')
     * @param {string} [limit] - Optional maximum number of values to return
     * @returns {Promise<string[]>} Array of matching label values, sorted alphabetically
     * @example
     * // Fetch all values for the 'job' label
     * const values = await queryLabelValues(timeRange, 'job');
     * // Fetch 'instance' values only for jobs matching 'grafana'
     * const instances = await queryLabelValues(timeRange, 'instance', '{job="grafana"}');
     * // Fetch values for a label key with special characters
     * const statusCodes = await queryLabelValues(timeRange, 'http.status:code');
     */
    this.queryLabelValues = async (timeRange, labelKey, match, limit) => {
      const interpolatedMatch = match ? this.datasource.interpolateString(match) : match;
      return await this.resourceClient.queryLabelValues(
        timeRange,
        this.datasource.interpolateString(labelKey),
        interpolatedMatch,
        limit
      );
    };
  }
  /**
   * Lazily initializes and returns the appropriate resource client based on Prometheus version.
   *
   * The client selection logic:
   * - For Prometheus v2.6+ with labels API: Uses LabelsApiClient for efficient label-based queries
   * - For older versions: Falls back to SeriesApiClient for backward compatibility
   *
   * The client instance is cached after first initialization to avoid repeated creation.
   *
   * @returns {ResourceApiClient} An instance of either LabelsApiClient or SeriesApiClient
   */
  get resourceClient() {
    if (!this._resourceClient) {
      this._resourceClient = this.datasource.hasLabelsMatchAPISupport() ? new LabelsApiClient(this.request, this.datasource) : new SeriesApiClient(this.request, this.datasource);
    }
    return this._resourceClient;
  }
}
const importFromAbstractQuery = (labelBasedQuery) => {
  return toPromLikeQuery(labelBasedQuery);
};
const exportToAbstractQuery = (query) => {
  const promQuery = query.expr;
  if (!promQuery || promQuery.length === 0) {
    return { refId: query.refId, labelMatchers: [] };
  }
  const tokens = Prism__default.default.tokenize(promQuery, promqlGrammar);
  const labelMatchers = extractLabelMatchers(tokens);
  const nameLabelValue = getNameLabelValue(promQuery, tokens);
  if (nameLabelValue && nameLabelValue.length > 0) {
    labelMatchers.push({
      name: "__name__",
      operator: data.AbstractLabelOperator.Equal,
      value: nameLabelValue
    });
  }
  return {
    refId: query.refId,
    labelMatchers
  };
};
function isCancelledError(error) {
  return typeof error === "object" && error !== null && "cancelled" in error && error.cancelled === true;
}
function removeQuotesIfExist(input) {
  var _a;
  const match = input.match(/^"(.*)"$/);
  return (_a = match == null ? void 0 : match[1]) != null ? _a : input;
}
function getNameLabelValue(promQuery, tokens) {
  let nameLabelValue = "";
  for (const token of tokens) {
    if (typeof token === "string") {
      nameLabelValue = token;
      break;
    }
  }
  return nameLabelValue;
}
const populateMatchParamsFromQueries = (queries) => {
  if (!queries) {
    return [];
  }
  const metrics = (queries != null ? queries : []).reduce((params, query) => {
    const visualQuery = buildVisualQueryFromString(query.expr);
    if (visualQuery.query.metric !== "") {
      params.push(visualQuery.query.metric);
    }
    if (visualQuery.query.binaryQueries) {
      visualQuery.query.binaryQueries.forEach((bq) => {
        if (bq.query.metric !== "") {
          params.push(bq.query.metric);
        }
      });
    }
    return params;
  }, []);
  return metrics.length === 0 ? [] : [`__name__=~"${metrics.join("|")}"`];
};

"use strict";
const INFINITY_SAMPLE_REGEX = /^[+-]?inf(?:inity)?$/i;
const isTableResult = (dataFrame, options) => {
  var _a, _b, _c, _d;
  if (options.app === data.CoreApp.Explore && (((_b = (_a = dataFrame.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.resultType) === "vector" || ((_d = (_c = dataFrame.meta) == null ? void 0 : _c.custom) == null ? void 0 : _d.resultType) === "scalar")) {
    return true;
  }
  const target = options.targets.find((target2) => target2.refId === dataFrame.refId);
  return (target == null ? void 0 : target.format) === "table";
};
const isCumulativeHeatmapResult = (dataFrame, options) => {
  var _a;
  if (((_a = dataFrame.meta) == null ? void 0 : _a.type) === data.DataFrameType.HeatmapCells) {
    return false;
  }
  const target = options.targets.find((target2) => target2.refId === dataFrame.refId);
  return (target == null ? void 0 : target.format) === "heatmap";
};
function transformV2(response, request, options) {
  response.data.forEach((f) => {
    const target = request.targets.find((t) => t.refId === f.refId);
    if (target && target.legendFormat === "__auto") {
      f.fields.forEach((field) => {
        var _a, _b;
        if (((_a = field.labels) == null ? void 0 : _a.__name__) && ((_b = field.labels) == null ? void 0 : _b.__name__) === field.name) {
          const fieldCopy = { ...field, name: data.TIME_SERIES_VALUE_FIELD_NAME };
          field.config.displayNameFromDS = data.getFieldDisplayName(fieldCopy, f, response.data);
        }
      });
    }
  });
  const [tableFrames, framesWithoutTable] = lodash.partition(response.data, (df) => isTableResult(df, request));
  const processedTableFrames = transformDFToTable(tableFrames);
  const [exemplarFrames, framesWithoutTableAndExemplars] = lodash.partition(
    framesWithoutTable,
    (df) => {
      var _a, _b;
      return ((_b = (_a = df.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.resultType) === "exemplar";
    }
  );
  const { exemplarTraceIdDestinations: destinations } = options;
  const processedExemplarFrames = exemplarFrames.map((dataFrame) => {
    var _a;
    if (destinations == null ? void 0 : destinations.length) {
      for (const exemplarTraceIdDestination of destinations) {
        const traceIDField = dataFrame.fields.find((field) => field.name === exemplarTraceIdDestination.name);
        if (traceIDField) {
          const links = getDataLinks(exemplarTraceIdDestination);
          traceIDField.config.links = ((_a = traceIDField.config.links) == null ? void 0 : _a.length) ? [...traceIDField.config.links, ...links] : links;
        }
      }
    }
    return { ...dataFrame, meta: { ...dataFrame.meta, dataTopic: data.DataTopic.Annotations } };
  });
  const [heatmapResults, framesWithoutTableHeatmapsAndExemplars] = lodash.partition(
    framesWithoutTableAndExemplars,
    (df) => isCumulativeHeatmapResult(df, request)
  );
  heatmapResults.forEach((df) => {
    var _a;
    if (df.name == null) {
      let f = df.fields.find((f2) => f2.type === data.FieldType.number);
      if (f) {
        let le = (_a = f.labels) == null ? void 0 : _a.le;
        if (le) {
          df.name = le;
          f.config.displayNameFromDS = le;
        }
      }
    }
  });
  const heatmapResultsGroupedByQuery = lodash.groupBy(heatmapResults, (h) => h.refId);
  let processedHeatmapResultsGroupedByQuery = [];
  for (const query in heatmapResultsGroupedByQuery) {
    const heatmapResultsGroup = heatmapResultsGroupedByQuery[query];
    const heatmapResultsGroupedByValues = lodash.groupBy(heatmapResultsGroup, (dataFrame) => {
      var _a;
      const values = dataFrame.fields.find((field) => field.type === data.FieldType.number);
      if ((values == null ? void 0 : values.labels) && HISTOGRAM_QUANTILE_LABEL_NAME in values.labels) {
        const { le, ...notLE } = values == null ? void 0 : values.labels;
        return Object.values(notLE).join();
      }
      return Object.values((_a = values == null ? void 0 : values.labels) != null ? _a : []).join();
    });
    lodash.forOwn(heatmapResultsGroupedByValues, (dataFrames, key) => {
      const sortedHeatmap = dataFrames.sort(sortSeriesByLabel);
      processedHeatmapResultsGroupedByQuery.push(mergeHeatmapFrames(transformToHistogramOverTime(sortedHeatmap)));
    });
  }
  const otherFrames = framesWithoutTableHeatmapsAndExemplars.map((dataFrame) => {
    const df = {
      ...dataFrame,
      meta: {
        ...dataFrame.meta,
        preferredVisualisationType: "graph"
      }
    };
    return df;
  });
  const flattenedProcessedHeatmapFrames = lodash.flatten(processedHeatmapResultsGroupedByQuery);
  return {
    ...response,
    data: [...otherFrames, ...processedTableFrames, ...flattenedProcessedHeatmapFrames, ...processedExemplarFrames]
  };
}
const HISTOGRAM_QUANTILE_LABEL_NAME = "le";
function transformDFToTable(dfs) {
  if (dfs.length === 0 || dfs.length === 1 && dfs[0].length === 0) {
    return dfs;
  }
  const dataFramesByRefId = lodash.groupBy(dfs, "refId");
  const refIds = Object.keys(dataFramesByRefId);
  const frames = refIds.map((refId) => {
    const valueText = getValueText(refIds.length, refId);
    const valueField = getValueField({ data: [], valueName: valueText });
    const timeField = getTimeField([]);
    const labelFields = [];
    dataFramesByRefId[refId].forEach((df) => {
      var _a;
      const frameValueField = df.fields[1];
      const promLabels = (_a = frameValueField == null ? void 0 : frameValueField.labels) != null ? _a : {};
      Object.keys(promLabels).sort().forEach((label) => {
        if (!labelFields.some((l) => l.name === label)) {
          labelFields.push({
            name: label,
            config: { filterable: true },
            type: data.FieldType.string,
            values: []
          });
        }
      });
    });
    let prevTime = -Infinity;
    let needsSort = false;
    dataFramesByRefId[refId].forEach((df) => {
      var _a, _b, _c, _d, _e, _f, _g;
      (_c = (_b = timeField.config).interval) != null ? _c : _b.interval = (_a = df.fields[0]) == null ? void 0 : _a.config.interval;
      const timeFields = (_e = (_d = df.fields[0]) == null ? void 0 : _d.values) != null ? _e : [];
      const dataFields = (_g = (_f = df.fields[1]) == null ? void 0 : _f.values) != null ? _g : [];
      timeFields.forEach((value) => {
        timeField.values.push(value);
        if (value < prevTime) {
          needsSort = true;
        }
        prevTime = value;
      });
      dataFields.forEach((value) => {
        var _a2;
        valueField.values.push(parseSampleValue(value));
        const labelsForField = (_a2 = df.fields[1].labels) != null ? _a2 : {};
        labelFields.forEach((field) => field.values.push(getLabelValue(labelsForField, field.name)));
      });
    });
    const fields = [timeField, ...labelFields, valueField];
    const frame = {
      refId,
      fields,
      // Prometheus specific UI for instant queries
      meta: {
        ...dataFramesByRefId[refId][0].meta,
        preferredVisualisationType: "rawPrometheus"
      },
      length: timeField.values.length
    };
    return needsSort ? data.sortDataFrame(frame, 0) : frame;
  });
  return frames;
}
function getValueText(responseLength, refId = "") {
  return responseLength > 1 ? `Value #${refId}` : "Value";
}
function getDataLinks(options) {
  var _a;
  const dataLinks = [];
  if (options.datasourceUid) {
    const dataSourceSrv = runtime.getDataSourceSrv();
    const dsSettings = dataSourceSrv.getInstanceSettings(options.datasourceUid);
    if (dsSettings) {
      dataLinks.push({
        title: options.urlDisplayLabel || `Query with ${dsSettings == null ? void 0 : dsSettings.name}`,
        url: "",
        internal: {
          query: { query: "${__value.raw}", queryType: "traceql" },
          panelsState: {
            trace: {
              spanId: '${__data.fields["span_id"]}'
            }
          },
          datasourceUid: options.datasourceUid,
          datasourceName: (_a = dsSettings == null ? void 0 : dsSettings.name) != null ? _a : "Data source not found"
        }
      });
    }
  }
  if (options.url) {
    dataLinks.push({
      title: options.urlDisplayLabel || `Go to ${options.url}`,
      url: options.url,
      targetBlank: true
    });
  }
  return dataLinks;
}
function getLabelValue(metric, label) {
  if (metric.hasOwnProperty(label)) {
    return metric[label];
  }
  return "";
}
function getTimeField(data$1, isMs = false) {
  return {
    name: data.TIME_SERIES_TIME_FIELD_NAME,
    type: data.FieldType.time,
    config: {},
    values: data$1.map((val) => isMs ? val[0] : val[0] * 1e3)
  };
}
function getValueField({
  data: data$1,
  valueName = data.TIME_SERIES_VALUE_FIELD_NAME,
  parseValue = true,
  labels,
  displayNameFromDS
}) {
  return {
    name: valueName,
    type: data.FieldType.number,
    display: data.getDisplayProcessor(),
    config: {
      displayNameFromDS
    },
    labels,
    values: data$1.map((val) => parseValue ? parseSampleValue(val[1]) : val[1])
  };
}
function getOriginalMetricName(labelData) {
  const metricName = labelData.__name__ || "";
  delete labelData.__name__;
  const labelPart = Object.entries(labelData).map((label) => `${label[0]}="${label[1]}"`).join(",");
  return `${metricName}{${labelPart}}`;
}
function mergeHeatmapFrames(frames) {
  if (frames.length === 0 || frames.length === 1 && frames[0].length === 0) {
    return [];
  }
  const timeField = frames[0].fields.find((field) => field.type === data.FieldType.time);
  const countFields = frames.map((frame) => {
    let field = frame.fields.find((field2) => field2.type === data.FieldType.number);
    return {
      ...field,
      name: field.config.displayNameFromDS
    };
  });
  return [
    {
      ...frames[0],
      meta: {
        ...frames[0].meta,
        type: data.DataFrameType.HeatmapRows
      },
      fields: [timeField, ...countFields]
    }
  ];
}
function transformToHistogramOverTime(seriesList) {
  for (let i = seriesList.length - 1; i > 0; i--) {
    const topSeries = seriesList[i].fields.find((s) => s.type === data.FieldType.number);
    const bottomSeries = seriesList[i - 1].fields.find((s) => s.type === data.FieldType.number);
    if (!topSeries || !bottomSeries) {
      throw new Error("Prometheus heatmap transform error: data should be a time series");
    }
    for (let j = 0; j < topSeries.values.length; j++) {
      const bottomPoint = bottomSeries.values[j] || [0];
      topSeries.values[j] -= bottomPoint;
      if (topSeries.values[j] < 1e-9) {
        topSeries.values[j] = 0;
      }
    }
  }
  return seriesList;
}
function sortSeriesByLabel(s1, s2) {
  var _a, _b, _c, _d, _e, _f;
  let le1, le2;
  try {
    le1 = parseSampleValue((_c = (_b = (_a = s1.fields[1].state) == null ? void 0 : _a.displayName) != null ? _b : s1.name) != null ? _c : s1.fields[1].name);
    le2 = parseSampleValue((_f = (_e = (_d = s2.fields[1].state) == null ? void 0 : _d.displayName) != null ? _e : s2.name) != null ? _f : s2.fields[1].name);
  } catch (err) {
    console.error(err);
    return 0;
  }
  if (le1 > le2) {
    return 1;
  }
  if (le1 < le2) {
    return -1;
  }
  return 0;
}
function parseSampleValue(value) {
  if (INFINITY_SAMPLE_REGEX.test(value)) {
    return value[0] === "-" ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY;
  }
  return parseFloat(value);
}

"use strict";
class PrometheusMetricFindQuery {
  constructor(datasource, query) {
    this.datasource = datasource;
    this.query = query;
    this.datasource = datasource;
    this.query = query;
  }
  async process(timeRange) {
    const labelNamesRegex = PrometheusLabelNamesRegex;
    const labelNamesRegexWithMatch = PrometheusLabelNamesRegexWithMatch;
    const labelValuesRegex = PrometheusLabelValuesRegex;
    const metricNamesRegex = PrometheusMetricNamesRegex;
    const queryResultRegex = PrometheusQueryResultRegex;
    const labelNamesQuery = this.query.match(labelNamesRegex);
    const labelNamesMatchQuery = this.query.match(labelNamesRegexWithMatch);
    if (labelNamesMatchQuery) {
      const selector = `{__name__=~".*${labelNamesMatchQuery[1]}.*"}`;
      const keys = await this.datasource.languageProvider.queryLabelKeys(timeRange, selector);
      return keys.filter((key) => key !== METRIC_LABEL).map((result) => ({ text: result }));
    }
    if (labelNamesQuery) {
      return this.datasource.getTagKeys({ filters: [], timeRange });
    }
    const labelValuesQuery = this.query.match(labelValuesRegex);
    if (labelValuesQuery) {
      const filter = labelValuesQuery[1];
      const label = labelValuesQuery[2];
      if (isFilterDefined(filter)) {
        return await this.labelValuesQuery(label, timeRange, filter);
      } else {
        return await this.labelValuesQuery(label, timeRange);
      }
    }
    const metricNamesQuery = this.query.match(metricNamesRegex);
    if (metricNamesQuery) {
      return await this.metricNameQuery(metricNamesQuery[1], timeRange);
    }
    const queryResultQuery = this.query.match(queryResultRegex);
    if (queryResultQuery) {
      return this.queryResultQuery(queryResultQuery[1], timeRange);
    }
    const expressions = ["label_values()", "metrics()", "query_result()"];
    if (!expressions.includes(this.query)) {
      return await this.metricNameAndLabelsQuery(this.query, timeRange);
    }
    return Promise.resolve([]);
  }
  async labelValuesQuery(label, range, metric) {
    const values = await this.datasource.languageProvider.queryLabelValues(range, label, metric);
    return values.map((value) => ({ text: value }));
  }
  async metricNameQuery(metricFilterPattern, range) {
    const names = await this.datasource.languageProvider.queryLabelValues(
      range,
      METRIC_LABEL,
      `{__name__=~"${metricFilterPattern}"}`
    );
    return names.map((n) => ({ text: n, expandable: true }));
  }
  queryResultQuery(query, range) {
    const url = "/api/v1/query";
    const params = {
      query,
      time: getPrometheusTime(range.to, true).toString()
    };
    return this.datasource.metadataRequest(url, params).then((result) => {
      switch (result.data.data.resultType) {
        case "scalar":
        // [ <unix_time>, "<scalar_value>" ]
        case "string":
          return [
            {
              text: result.data.data.result[1] || "",
              expandable: false
            }
          ];
        case "vector":
          return lodash.map(result.data.data.result, (metricData) => {
            let text = metricData.metric.__name__ || "";
            delete metricData.metric.__name__;
            text += "{" + lodash.map(metricData.metric, (v, k) => {
              return k + '="' + v + '"';
            }).join(",") + "}";
            text += " " + metricData.value[1] + " " + metricData.value[0] * 1e3;
            return {
              text,
              expandable: true
            };
          });
        default:
          throw Error(`Unknown/Unhandled result type: [${result.data.data.resultType}]`);
      }
    });
  }
  async metricNameAndLabelsQuery(query, range) {
    const start = getPrometheusTime(range.from, false);
    const end = getPrometheusTime(range.to, true);
    const params = {
      "match[]": query,
      start: start.toString(),
      end: end.toString()
    };
    const result = await this.datasource.metadataRequest(`/api/v1/series`, params);
    return result.data.data.map((metric) => ({
      text: getOriginalMetricName(metric),
      expandable: true
    }));
  }
}
function isFilterDefined(filter) {
  return filter && filter.split(" ").join("") !== "{}";
}

"use strict";
function trackQuery(response, request, startTime) {
  var _a, _b, _c, _d;
  const { app, targets: queries } = request;
  if (app !== data.CoreApp.Explore) {
    return;
  }
  for (const query of queries) {
    runtime.reportInteraction("grafana_prometheus_query_executed", {
      app,
      grafana_version: runtime.config.buildInfo.version,
      has_data: response.data.some((frame) => frame.length > 0),
      has_error: response.error !== void 0,
      expr: query.expr,
      format: query.format,
      instant: query.instant,
      range: query.range,
      exemplar: query.exemplar,
      hinting: query.hinting,
      interval: query.interval,
      intervalFactor: query.intervalFactor,
      utcOffsetSec: query.utcOffsetSec,
      legend: query.legendFormat,
      valueWithRefId: query.valueWithRefId,
      requestId: request.requestId,
      showingGraph: query.showingGraph,
      showingTable: query.showingTable,
      editor_mode: query.editorMode,
      simultaneously_sent_query_count: queries.length,
      time_range_from: (_b = (_a = request == null ? void 0 : request.range) == null ? void 0 : _a.from) == null ? void 0 : _b.toISOString(),
      time_range_to: (_d = (_c = request == null ? void 0 : request.range) == null ? void 0 : _c.to) == null ? void 0 : _d.toISOString(),
      time_taken: Date.now() - startTime.getTime()
    });
  }
}

"use strict";
class PrometheusVariableSupport extends data.CustomVariableSupport {
  constructor(datasource, templateSrv = runtime.getTemplateSrv()) {
    super();
    this.datasource = datasource;
    this.templateSrv = templateSrv;
    this.editor = PromVariableQueryEditor;
  }
  query(request) {
    let query;
    if (typeof request.targets[0] === "string") {
      query = request.targets[0];
    } else {
      query = request.targets[0].query;
    }
    if (!query) {
      return rxjs.of({ data: [] });
    }
    const scopedVars = {
      ...request.scopedVars,
      __interval: { text: this.datasource.interval, value: this.datasource.interval },
      __interval_ms: {
        text: data.rangeUtil.intervalToMs(this.datasource.interval),
        value: data.rangeUtil.intervalToMs(this.datasource.interval)
      },
      ...this.datasource.getRangeScopedVars(request.range)
    };
    const interpolated = this.templateSrv.replace(query, scopedVars, this.datasource.interpolateQueryExpr);
    const metricFindQuery = new PrometheusMetricFindQuery(this.datasource, interpolated);
    const metricFindStream = rxjs.from(metricFindQuery.process(request.range));
    return metricFindStream.pipe(operators$3.map((results) => ({ data: results })));
  }
}

"use strict";
class PrometheusDatasource extends runtime.DataSourceWithBackend {
  constructor(instanceSettings, templateSrv = runtime.getTemplateSrv(), languageProvider) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    super(instanceSettings);
    this.templateSrv = templateSrv;
    /**
     * Initializes the Prometheus datasource by loading recording rules and checking exemplar availability.
     *
     * This method performs two key initialization tasks: Loads recording rules from the
     * Prometheus API and checks if exemplars are available by testing the exemplars API endpoint.
     */
    this.init = async () => {
      if (!this.disableRecordingRules) {
        this.loadRules();
      }
      this.exemplarsAvailable = await this.areExemplarsAvailable();
    };
    this.access = instanceSettings.access;
    this.basicAuth = instanceSettings.basicAuth;
    this.cache = new QueryCache({
      getTargetSignature: this.getPrometheusTargetSignature.bind(this),
      overlapString: (_a = instanceSettings.jsonData.incrementalQueryOverlapWindow) != null ? _a : defaultPrometheusQueryOverlapWindow,
      applyInterpolation: this.interpolateString.bind(this)
    });
    this.cacheLevel = (_b = instanceSettings.jsonData.cacheLevel) != null ? _b : PrometheusCacheLevel.Low;
    this.customQueryParameters = new URLSearchParams(instanceSettings.jsonData.customQueryParameters);
    this.datasourceConfigurationPrometheusFlavor = instanceSettings.jsonData.prometheusType;
    this.datasourceConfigurationPrometheusVersion = instanceSettings.jsonData.prometheusVersion;
    this.disableRecordingRules = (_c = instanceSettings.jsonData.disableRecordingRules) != null ? _c : false;
    this.exemplarTraceIdDestinations = instanceSettings.jsonData.exemplarTraceIdDestinations;
    this.exemplarsAvailable = true;
    this.hasIncrementalQuery = (_d = instanceSettings.jsonData.incrementalQuerying) != null ? _d : false;
    this.httpMethod = instanceSettings.jsonData.httpMethod || "GET";
    this.id = instanceSettings.id;
    this.interval = instanceSettings.jsonData.timeInterval || "15s";
    this.lookupsDisabled = (_e = instanceSettings.jsonData.disableMetricsLookup) != null ? _e : false;
    this.metricNamesAutocompleteSuggestionLimit = (_f = instanceSettings.jsonData.codeModeMetricNamesSuggestionLimit) != null ? _f : SUGGESTIONS_LIMIT;
    this.ruleMappings = {};
    this.seriesEndpoint = (_g = instanceSettings.jsonData.seriesEndpoint) != null ? _g : false;
    this.seriesLimit = (_h = instanceSettings.jsonData.seriesLimit) != null ? _h : DEFAULT_SERIES_LIMIT;
    this.type = "prometheus";
    this.url = instanceSettings.url;
    this.withCredentials = Boolean(instanceSettings.withCredentials);
    this.defaultEditor = instanceSettings.jsonData.defaultEditor;
    this.annotations = PrometheusAnnotationSupport(this);
    this.variables = new PrometheusVariableSupport(this, this.templateSrv);
    this.languageProvider = languageProvider != null ? languageProvider : new PrometheusLanguageProvider(this);
  }
  /**
   * Loads recording rules from the Prometheus API and extracts rule mappings.
   *
   * This method fetches rules from the `/api/v1/rules` endpoint and processes
   * them to create a mapping of rule names to their corresponding queries and labels.
   * The rules API is experimental, so errors are logged but not thrown.
   */
  async loadRules() {
    var _a, _b;
    try {
      const params = {};
      const options = { showErrorAlert: false };
      const res = await this.metadataRequest("/api/v1/rules", params, options);
      const ruleGroups = (_b = (_a = res.data) == null ? void 0 : _a.data) == null ? void 0 : _b.groups;
      if (ruleGroups) {
        this.ruleMappings = extractRuleMappingFromGroups(ruleGroups);
      }
    } catch (err) {
      console.log("Rules API is experimental. Ignore next error.");
      console.error(err);
    }
  }
  /**
   * Checks if exemplars are available by testing the exemplars API endpoint.
   *
   * This method makes a test request to the `/api/v1/query_exemplars` endpoint to determine
   * if the Prometheus instance supports exemplars. The test uses a simple query with a
   * 30-minute time range. If the request succeeds with a 'success' status, exemplars
   * are considered available. Errors are caught and return false to avoid breaking
   * the datasource initialization.
   */
  async areExemplarsAvailable() {
    try {
      const params = {
        query: "test",
        start: data.dateTime().subtract(30, "minutes").valueOf().toString(),
        end: data.dateTime().valueOf().toString()
      };
      const options = { showErrorAlert: false };
      const res = await this.metadataRequest("/api/v1/query_exemplars", params, options);
      return res.data.status === "success";
    } catch (err) {
      return false;
    }
  }
  getQueryDisplayText(query) {
    return query.expr;
  }
  /**
   * Get target signature for query caching
   * @param request
   * @param query
   */
  getPrometheusTargetSignature(request, query) {
    var _a, _b;
    const targExpr = this.interpolateString(query.expr);
    return `${targExpr}|${(_a = query.interval) != null ? _a : request.interval}|${JSON.stringify((_b = request.rangeRaw) != null ? _b : "")}|${query.exemplar}`;
  }
  hasLabelsMatchAPISupport() {
    if (this.seriesEndpoint) {
      return false;
    }
    return (
      // https://github.com/prometheus/prometheus/releases/tag/v2.24.0
      this._isDatasourceVersionGreaterOrEqualTo("2.24.0", PromApplication.Prometheus) || // All versions of Mimir support matchers for labels API
      this._isDatasourceVersionGreaterOrEqualTo("2.0.0", PromApplication.Mimir) || // https://github.com/cortexproject/cortex/discussions/4542
      this._isDatasourceVersionGreaterOrEqualTo("1.11.0", PromApplication.Cortex) || // https://github.com/thanos-io/thanos/pull/3566
      //https://github.com/thanos-io/thanos/releases/tag/v0.18.0
      this._isDatasourceVersionGreaterOrEqualTo("0.18.0", PromApplication.Thanos)
    );
  }
  _isDatasourceVersionGreaterOrEqualTo(targetVersion, targetFlavor) {
    if (!this.datasourceConfigurationPrometheusVersion || !this.datasourceConfigurationPrometheusFlavor) {
      return true;
    }
    if (targetFlavor !== this.datasourceConfigurationPrometheusFlavor) {
      return false;
    }
    return semver.gte(this.datasourceConfigurationPrometheusVersion, targetVersion);
  }
  _addTracingHeaders(httpOptions, options) {
    httpOptions.headers = {};
    if (this.access === "proxy") {
      httpOptions.headers["X-Dashboard-UID"] = options.dashboardUID;
      httpOptions.headers["X-Panel-Id"] = options.panelId;
    }
  }
  directAccessError() {
    return rxjs.throwError(
      () => new Error(
        "Browser access mode in the Prometheus datasource is no longer available. Switch to server access mode."
      )
    );
  }
  /**
   * Any request done from this data source should go through here as it contains some common processing for the
   * request. Any processing done here needs to be also copied on the backend as this goes through data source proxy
   * but not through the same code as alerting.
   */
  _request(url, data, overrides = {}) {
    if (this.access === "direct") {
      return this.directAccessError();
    }
    data = data || {};
    for (const [key, value] of this.customQueryParameters) {
      if (data[key] == null) {
        data[key] = value;
      }
    }
    let queryUrl = this.url + url;
    if (url.startsWith(`/api/datasources/uid/${this.uid}`)) {
      queryUrl = url;
    }
    const options = lodash.defaults(overrides, {
      url: queryUrl,
      method: this.httpMethod,
      headers: {}
    });
    if (options.method === "GET") {
      if (data && Object.keys(data).length) {
        options.url = options.url + (options.url.search(/\?/) >= 0 ? "&" : "?") + Object.entries(data).map(([k, v]) => `${encodeURIComponent(k)}=${encodeURIComponent(v)}`).join("&");
      }
    } else {
      if (!options.headers["Content-Type"]) {
        options.headers["Content-Type"] = "application/x-www-form-urlencoded";
      }
      options.data = data;
    }
    if (this.basicAuth || this.withCredentials) {
      options.withCredentials = true;
    }
    if (this.basicAuth) {
      options.headers.Authorization = this.basicAuth;
    }
    return runtime.getBackendSrv().fetch(options);
  }
  async importFromAbstractQueries(abstractQueries) {
    return abstractQueries.map((abstractQuery) => importFromAbstractQuery(abstractQuery));
  }
  async exportToAbstractQueries(queries) {
    return queries.map((query) => exportToAbstractQuery(query));
  }
  // Use this for tab completion features, wont publish response to other components
  async metadataRequest(url, params = {}, options) {
    if (GET_AND_POST_METADATA_ENDPOINTS.some((endpoint) => url.includes(endpoint))) {
      try {
        return await rxjs.lastValueFrom(
          this._request(`/api/datasources/uid/${this.uid}/resources${url}`, params, {
            method: this.httpMethod,
            hideFromInspector: true,
            showErrorAlert: false,
            ...options
          })
        );
      } catch (err) {
        if (this.httpMethod === "POST" && runtime.isFetchError(err) && (err.status === 405 || err.status === 400)) {
          console.warn(`Couldn't use configured POST HTTP method for this request. Trying to use GET method instead.`);
        } else {
          throw err;
        }
      }
    }
    return await rxjs.lastValueFrom(
      this._request(`/api/datasources/uid/${this.uid}/resources${url}`, params, {
        method: "GET",
        hideFromInspector: true,
        ...options
      })
    );
  }
  interpolateQueryExpr(value = [], variable) {
    if (!variable.multi && !variable.includeAll) {
      return prometheusRegularEscape(value);
    }
    if (typeof value === "string") {
      return prometheusSpecialRegexEscape(value);
    }
    const escapedValues = value.map((val) => prometheusSpecialRegexEscape(val));
    if (escapedValues.length === 1) {
      return escapedValues[0];
    }
    return "(" + escapedValues.join("|") + ")";
  }
  targetContainsTemplate(target) {
    return this.templateSrv.containsTemplate(target.expr);
  }
  shouldRunExemplarQuery(target, request) {
    if (target.exemplar) {
      const metricName = this.languageProvider.retrieveHistogramMetrics().find((m) => target.expr.includes(m));
      const currentTargetIdx = request.targets.findIndex((t) => t.refId === target.refId);
      const targets = request.targets.slice(0, currentTargetIdx).filter((t) => !t.hide);
      if (!metricName || metricName && !targets.some((t) => t.expr.includes(metricName))) {
        return true;
      }
      return false;
    }
    return false;
  }
  processTargetV2(target, request) {
    var _a;
    let utcOffset = request.range.to.utcOffset();
    if (request.timezone === "browser") {
      utcOffset = this.isUsingRelativeTimeRange(request.range) ? utcOffset : 0;
    } else {
      utcOffset = momentTimezone.tz(request.timezone).utcOffset();
    }
    const processedTargets = [];
    const processedTarget = {
      ...target,
      exemplar: this.shouldRunExemplarQuery(target, request),
      requestId: request.panelId + target.refId,
      utcOffsetSec: utcOffset * 60
    };
    if (runtime.config.featureToggles.promQLScope) {
      processedTarget.scopes = ((_a = request.scopes) != null ? _a : []).map((scope) => ({
        name: scope.metadata.name,
        ...scope.spec
      }));
    }
    if (runtime.config.featureToggles.groupByVariable) {
      processedTarget.groupByKeys = request.groupByKeys;
    }
    if (target.instant && target.range) {
      processedTargets.push(
        {
          ...processedTarget,
          refId: processedTarget.refId,
          instant: false
        },
        {
          ...processedTarget,
          refId: processedTarget.refId + InstantQueryRefIdIndex,
          range: false,
          exemplar: false
        }
      );
    } else {
      processedTargets.push(processedTarget);
    }
    return processedTargets;
  }
  query(request) {
    if (this.access === "direct") {
      return this.directAccessError();
    }
    let fullOrPartialRequest;
    let requestInfo = void 0;
    const hasInstantQuery = request.targets.some((target) => target.instant);
    if (this.hasIncrementalQuery && !hasInstantQuery) {
      requestInfo = this.cache.requestInfo(request);
      fullOrPartialRequest = requestInfo.requests[0];
    } else {
      fullOrPartialRequest = request;
    }
    const targets = fullOrPartialRequest.targets.map((target) => this.processTargetV2(target, fullOrPartialRequest));
    const startTime = /* @__PURE__ */ new Date();
    return super.query({ ...fullOrPartialRequest, targets: targets.flat() }).pipe(
      operators$3.map((response) => {
        const amendedResponse = {
          ...response,
          data: this.cache.procFrames(request, requestInfo, response.data)
        };
        return transformV2(amendedResponse, request, {
          exemplarTraceIdDestinations: this.exemplarTraceIdDestinations
        });
      }),
      operators$3.tap((response) => {
        trackQuery(response, request, startTime);
      })
    );
  }
  metricFindQuery(query, options) {
    var _a;
    if (!query) {
      return Promise.resolve([]);
    }
    const timeRange = (_a = options == null ? void 0 : options.range) != null ? _a : data.getDefaultTimeRange();
    const scopedVars = {
      ...this.getIntervalVars(),
      ...this.getRangeScopedVars(timeRange)
    };
    const interpolated = this.templateSrv.replace(query, scopedVars, this.interpolateQueryExpr);
    const metricFindQuery = new PrometheusMetricFindQuery(this, interpolated);
    return metricFindQuery.process(timeRange);
  }
  getIntervalVars() {
    return {
      __interval: { text: this.interval, value: this.interval },
      __interval_ms: { text: data.rangeUtil.intervalToMs(this.interval), value: data.rangeUtil.intervalToMs(this.interval) }
    };
  }
  getRangeScopedVars(range) {
    const msRange = range.to.diff(range.from);
    const sRange = Math.round(msRange / 1e3);
    return {
      __range_ms: { text: msRange, value: msRange },
      __range_s: { text: sRange, value: sRange },
      __range: { text: sRange + "s", value: sRange + "s" }
    };
  }
  // By implementing getTagKeys and getTagValues we add ad-hoc filters functionality
  // this is used to get label keys, a.k.a label names
  // it is used in metric_find_query.ts
  // and in Tempo here grafana/public/app/plugins/datasource/tempo/QueryEditor/ServiceGraphSection.tsx
  async getTagKeys(options) {
    var _a, _b, _c;
    if (!options.timeRange) {
      options.timeRange = data.getDefaultTimeRange();
    }
    if (runtime.config.featureToggles.promQLScope && ((_b = (_a = options == null ? void 0 : options.scopes) == null ? void 0 : _a.length) != null ? _b : 0) > 0) {
      const suggestions = await this.languageProvider.fetchSuggestions(
        options.timeRange,
        options.queries,
        options.scopes,
        options.filters
      );
      return suggestions.filter((labelName) => !!labelName && !options.filters.find((filter) => filter.key === labelName)).map((k) => ({ value: k, text: k }));
    }
    const match = extractResourceMatcher((_c = options.queries) != null ? _c : [], options.filters);
    let labelKeys = await this.languageProvider.queryLabelKeys(options.timeRange, match);
    return labelKeys.filter((labelName) => !options.filters.find((filter) => filter.key === labelName)).map((k) => ({ value: k, text: k }));
  }
  // By implementing getTagKeys and getTagValues we add ad-hoc filters functionality
  async getTagValues(options) {
    var _a, _b, _c;
    if (!options.timeRange) {
      options.timeRange = data.getDefaultTimeRange();
    }
    const requestId = `[${this.uid}][${options.key}]`;
    if (runtime.config.featureToggles.promQLScope && ((_b = (_a = options == null ? void 0 : options.scopes) == null ? void 0 : _a.length) != null ? _b : 0) > 0) {
      return (await this.languageProvider.fetchSuggestions(
        options.timeRange,
        options.queries,
        options.scopes,
        options.filters,
        options.key,
        void 0,
        requestId
      )).map((v) => ({ value: v, text: v }));
    }
    const match = extractResourceMatcher((_c = options.queries) != null ? _c : [], options.filters);
    return (await this.languageProvider.queryLabelValues(options.timeRange, options.key, match)).map((v) => ({
      value: v,
      text: v
    }));
  }
  interpolateVariablesInQueries(queries, scopedVars, filters) {
    let expandedQueries = queries;
    if (queries && queries.length) {
      expandedQueries = queries.map((query) => {
        const interpolatedQuery = this.templateSrv.replace(
          query.expr,
          scopedVars,
          this.interpolateExploreMetrics(query.fromExploreMetrics)
        );
        const replacedInterpolatedQuery = runtime.config.featureToggles.promQLScope ? interpolatedQuery : this.templateSrv.replace(
          this.enhanceExprWithAdHocFilters(filters, interpolatedQuery),
          scopedVars,
          this.interpolateQueryExpr
        );
        const expandedQuery = {
          ...query,
          ...runtime.config.featureToggles.promQLScope ? { adhocFilters: this.generateScopeFilters(filters) } : {},
          datasource: this.getRef(),
          expr: replacedInterpolatedQuery,
          interval: this.templateSrv.replace(query.interval, scopedVars)
        };
        return expandedQuery;
      });
    }
    return expandedQueries;
  }
  getQueryHints(query, result) {
    var _a;
    return getQueryHints((_a = query.expr) != null ? _a : "", result, this);
  }
  modifyQuery(query, action) {
    var _a, _b, _c;
    let expression = (_a = query.expr) != null ? _a : "";
    switch (action.type) {
      case "ADD_FILTER": {
        const { key, value } = (_b = action.options) != null ? _b : {};
        if (key && value) {
          expression = addLabelToQuery(expression, key, value);
        }
        break;
      }
      case "ADD_FILTER_OUT": {
        const { key, value } = (_c = action.options) != null ? _c : {};
        if (key && value) {
          expression = addLabelToQuery(expression, key, value, "!=");
        }
        break;
      }
      case "ADD_HISTOGRAM_QUANTILE": {
        expression = `histogram_quantile(0.95, sum(rate(${expression}[$__rate_interval])) by (le))`;
        break;
      }
      case "ADD_HISTOGRAM_AVG": {
        expression = `histogram_avg(rate(${expression}[$__rate_interval]))`;
        break;
      }
      case "ADD_HISTOGRAM_FRACTION": {
        expression = `histogram_fraction(0,0.2,rate(${expression}[$__rate_interval]))`;
        break;
      }
      case "ADD_HISTOGRAM_COUNT": {
        expression = `histogram_count(rate(${expression}[$__rate_interval]))`;
        break;
      }
      case "ADD_HISTOGRAM_SUM": {
        expression = `histogram_sum(rate(${expression}[$__rate_interval]))`;
        break;
      }
      case "ADD_HISTOGRAM_STDDEV": {
        expression = `histogram_stddev(rate(${expression}[$__rate_interval]))`;
        break;
      }
      case "ADD_HISTOGRAM_STDVAR": {
        expression = `histogram_stdvar(rate(${expression}[$__rate_interval]))`;
        break;
      }
      case "ADD_RATE": {
        expression = `rate(${expression}[$__rate_interval])`;
        break;
      }
      case "ADD_SUM": {
        expression = `sum(${expression.trim()}) by ($1)`;
        break;
      }
      case "EXPAND_RULES": {
        if (action.options) {
          expression = expandRecordingRules(expression, action.options);
        }
        break;
      }
      default:
        break;
    }
    return { ...query, expr: expression };
  }
  /**
   * Returns the adjusted "snapped" interval parameters
   */
  getAdjustedInterval(timeRange) {
    return getRangeSnapInterval(this.cacheLevel, timeRange);
  }
  /**
   * This will return a time range that always includes the users current time range,
   * and then a little extra padding to round up/down to the nearest nth minute,
   * defined by the result of the getCacheDurationInMinutes.
   *
   * For longer cache durations, and shorter query durations,
   * the window we're calculating might be much bigger then the user's current window,
   * resulting in us returning labels/values that might not be applicable for the given window,
   * this is a necessary trade-off if we want to cache larger durations
   */
  getTimeRangeParams(timeRange) {
    return {
      start: getPrometheusTime(timeRange.from, false).toString(),
      end: getPrometheusTime(timeRange.to, true).toString()
    };
  }
  /**
   * This converts the adhocVariableFilter array and converts it to scopeFilter array
   * @param filters
   */
  generateScopeFilters(filters) {
    if (!filters) {
      return [];
    }
    return filters.map((f) => {
      var _a;
      return {
        key: f.key,
        operator: data.scopeFilterOperatorMap[f.operator],
        value: this.templateSrv.replace(f.value, {}, this.interpolateQueryExpr),
        values: (_a = f.values) == null ? void 0 : _a.map((v) => this.templateSrv.replace(v, {}, this.interpolateQueryExpr))
      };
    });
  }
  enhanceExprWithAdHocFilters(filters, expr) {
    if (!filters || filters.length === 0) {
      return expr;
    }
    const finalQuery = filters.reduce((acc, filter) => {
      const { key, operator } = filter;
      let { value } = filter;
      if (operator === "=~" || operator === "!~") {
        value = prometheusRegularEscape(value);
      }
      return addLabelToQuery(acc, key, value, operator);
    }, expr);
    return finalQuery;
  }
  // Used when running queries through backend
  filterQuery(query) {
    if (query.hide || !query.expr) {
      return false;
    }
    return true;
  }
  // Used when running queries through backend
  applyTemplateVariables(target, scopedVars, filters) {
    const variables = { ...scopedVars };
    variables.__interval = {
      value: "$__interval"
    };
    variables.__interval_ms = {
      value: "$__interval_ms"
    };
    const expr = this.templateSrv.replace(
      target.expr,
      variables,
      this.interpolateExploreMetrics(target.fromExploreMetrics)
    );
    const exprWithAdhoc = runtime.config.featureToggles.promQLScope ? expr : this.templateSrv.replace(this.enhanceExprWithAdHocFilters(filters, expr), variables, this.interpolateQueryExpr);
    return {
      ...target,
      ...runtime.config.featureToggles.promQLScope ? { adhocFilters: this.generateScopeFilters(filters) } : {},
      expr: exprWithAdhoc,
      interval: this.templateSrv.replace(target.interval, variables),
      legendFormat: this.templateSrv.replace(target.legendFormat, variables)
    };
  }
  getVariables() {
    return this.templateSrv.getVariables().map((v) => `$${v.name}`);
  }
  interpolateString(string, scopedVars) {
    return this.templateSrv.replace(string, scopedVars, this.interpolateQueryExpr);
  }
  interpolateExploreMetrics(fromExploreMetrics) {
    return (value = [], variable) => {
      if (typeof value === "string" && fromExploreMetrics) {
        if (variable.name === "filters") {
          return wrapUtf8Filters(value);
        }
        if (variable.name === "groupby") {
          return utf8Support(value);
        }
      }
      return this.interpolateQueryExpr(value, variable);
    };
  }
  isUsingRelativeTimeRange(range) {
    if (typeof range.raw.from !== "string" || typeof range.raw.to !== "string") {
      return false;
    }
    return range.raw.from.includes("now") || range.raw.to.includes("now");
  }
  getDefaultQuery(app) {
    const defaults2 = {
      refId: "A",
      expr: "",
      range: true,
      instant: false
    };
    if (app === data.CoreApp.UnifiedAlerting) {
      return {
        ...defaults2,
        instant: true,
        range: false
      };
    }
    if (app === data.CoreApp.Explore) {
      return {
        ...defaults2,
        instant: true,
        range: true
      };
    }
    return defaults2;
  }
}
function extractRuleMappingFromGroups(groups) {
  return groups.reduce(
    (mapping, group) => group.rules.filter((rule) => rule.type === "recording").reduce((acc, rule) => {
      var _a;
      const existingRule = (_a = acc[rule.name]) != null ? _a : [];
      existingRule.push({
        query: rule.query,
        labels: rule.labels
      });
      acc[rule.name] = existingRule;
      return acc;
    }, mapping),
    {}
  );
}
const extractResourceMatcher = (queries, adhocFilters) => {
  const metricMatch = populateMatchParamsFromQueries(queries);
  const labelFilters = adhocFilters.map((f) => ({
    label: f.key,
    value: f.value,
    op: f.operator
  }));
  const labelsMatch = renderLabelsWithoutBrackets(labelFilters);
  if (metricMatch.length === 0 && labelsMatch.length === 0) {
    return void 0;
  }
  return `{${[...metricMatch, ...labelsMatch].join(",")}}`;
};

function __variableDynamicImportRuntime0__(path) {
  switch (path) {
    case './locales/cs-CZ/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-DEce8gKT.js'); });
    case './locales/de-DE/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-Ch87_CEc.js'); });
    case './locales/en-US/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-B8UdHyaQ.js'); });
    case './locales/es-ES/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-DPOedvQM.js'); });
    case './locales/fr-FR/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-C9Q0ipB7.js'); });
    case './locales/hu-HU/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-B3zh2xre.js'); });
    case './locales/id-ID/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-B9dNy-Er.js'); });
    case './locales/it-IT/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-CNTQzt27.js'); });
    case './locales/ja-JP/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-B5a2HiwV.js'); });
    case './locales/ko-KR/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-QW-EgrSF.js'); });
    case './locales/nl-NL/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-DMgFjf14.js'); });
    case './locales/pl-PL/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-B8WeEuki.js'); });
    case './locales/pt-BR/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-BeMVGgex.js'); });
    case './locales/pt-PT/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-B0jOWxw9.js'); });
    case './locales/ru-RU/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-DPIAanuf.js'); });
    case './locales/sv-SE/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-BmpjG5ts.js'); });
    case './locales/tr-TR/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-KiOzzP9y.js'); });
    case './locales/zh-Hans/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-ClSuXKBJ.js'); });
    case './locales/zh-Hant/grafana-prometheus.json': return Promise.resolve().then(function () { return require('./grafana-prometheus-nuhIWGwe.js'); });
    default: return new Promise(function(resolve, reject) {
      (typeof queueMicrotask === 'function' ? queueMicrotask : setTimeout)(
        reject.bind(null, new Error("Unknown variable dynamic import: " + path))
      );
    })
   }
 }

"use strict";
const resources = i18n.LANGUAGES.reduce((acc, lang) => {
  acc[lang.code] = async () => await __variableDynamicImportRuntime0__(`./locales/${lang.code}/grafana-prometheus.json`);
  return acc;
}, {});
const loadResources = async (resolvedLanguage) => {
  const translation = await resources[resolvedLanguage]();
  return translation.default;
};

"use strict";

exports.AlertingSettingsOverhaul = AlertingSettingsOverhaul;
exports.AnnotationQueryEditor = AnnotationQueryEditor;
exports.ConfigEditor = ConfigEditor;
exports.DataSourceHttpSettingsOverhaul = DataSourceHttpSettingsOverhaul;
exports.ExemplarSetting = ExemplarSetting;
exports.ExemplarsSettings = ExemplarsSettings;
exports.InstantQueryRefIdIndex = InstantQueryRefIdIndex;
exports.LabelFilterItem = LabelFilterItem;
exports.LabelFilters = LabelFilters;
exports.LabelParamEditor = LabelParamEditor;
exports.MetricCombobox = MetricCombobox;
exports.MetricsBrowser = MetricsBrowser;
exports.MetricsLabelsSection = MetricsLabelsSection;
exports.MetricsModal = MetricsModal;
exports.MonacoQueryFieldLazy = MonacoQueryFieldLazy;
exports.NestedQuery = NestedQuery;
exports.NestedQueryList = NestedQueryList;
exports.PROM_CONFIG_LABEL_WIDTH = PROM_CONFIG_LABEL_WIDTH;
exports.PromCheatSheet = PromCheatSheet;
exports.PromExemplarField = PromExemplarField;
exports.PromExploreExtraField = PromExploreExtraField;
exports.PromFlavorVersions = PromFlavorVersions;
exports.PromQlLanguageProvider = PromQlLanguageProvider;
exports.PromQueryBuilder = PromQueryBuilder;
exports.PromQueryBuilderContainer = PromQueryBuilderContainer;
exports.PromQueryBuilderExplained = PromQueryBuilderExplained;
exports.PromQueryBuilderOptions = PromQueryBuilderOptions;
exports.PromQueryCodeEditor = PromQueryCodeEditor;
exports.PromQueryEditorByApp = PromQueryEditorByApp;
exports.PromQueryEditorForAlerting = PromQueryEditorForAlerting;
exports.PromQueryEditorSelector = PromQueryEditorSelector;
exports.PromQueryField = PromQueryField;
exports.PromQueryLegendEditor = PromQueryLegendEditor;
exports.PromQueryModeller = PromQueryModeller;
exports.PromSettings = PromSettings;
exports.PromVariableQueryEditor = PromVariableQueryEditor;
exports.PrometheusDatasource = PrometheusDatasource;
exports.PrometheusMetricFindQuery = PrometheusMetricFindQuery;
exports.PrometheusVariableSupport = PrometheusVariableSupport;
exports.QueryPattern = QueryPattern;
exports.QueryPatternsModal = QueryPatternsModal;
exports.QueryPreview = QueryPreview;
exports.addLabelToQuery = addLabelToQuery;
exports.buildVisualQueryFromString = buildVisualQueryFromString;
exports.docsTip = docsTip;
exports.getInitHints = getInitHints;
exports.getPrometheusTime = getPrometheusTime;
exports.getQueryHints = getQueryHints;
exports.isValidLegacyName = isValidLegacyName;
exports.loadResources = loadResources;
exports.overhaulStyles = overhaulStyles;
exports.parseSampleValue = parseSampleValue;
exports.promqlGrammar = promqlGrammar;
exports.sortSeriesByLabel = sortSeriesByLabel;
exports.transformDFToTable = transformDFToTable;
exports.transformV2 = transformV2;
exports.utf8Support = utf8Support;
exports.validateInput = validateInput;
exports.wrapUtf8Filters = wrapUtf8Filters;
//# sourceMappingURL=index.cjs.map
