import { config } from '@grafana/runtime';

"use strict";
const getAPINamespace = () => config.namespace;
const getAPIBaseURL = (group, version) => {
  const subPath = config.appSubUrl || "";
  return `${subPath}/apis/${group}/${version}/namespaces/${getAPINamespace()}`;
};
const getAPIReducerPath = (group, version) => `${group}/${version}`;

export { getAPIBaseURL, getAPINamespace, getAPIReducerPath };
//# sourceMappingURL=util.mjs.map
