import { Component } from 'react';
import uPlot from 'uplot';
import { PlotProps } from './types';
import 'uplot/dist/uPlot.min.css';
type UPlotChartState = {
    plot: uPlot | null;
};
/**
 * @internal
 * uPlot abstraction responsible for plot initialisation, setup and refresh
 * Receives a data frame that is x-axis aligned, as of https://github.com/leeoniya/uPlot/tree/master/docs#data-format
 * Exposes context for uPlot instance access
 */
export declare class UPlotChart extends Component<PlotProps, UPlotChartState> {
    plotContainer: import("react").RefObject<HTMLDivElement>;
    plotCanvasBBox: import("react").RefObject<DOMRect>;
    plotInstance: uPlot | null;
    constructor(props: PlotProps);
    reinitPlot(): void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    componentDidUpdate(prevProps: PlotProps): void;
    render(): import("react/jsx-runtime").JSX.Element;
}
export {};
