import { Property } from 'csstype';
import { SyntheticEvent } from 'react';
import { Column } from 'react-data-grid';
import { DataFrame, Field, GrafanaTheme2, KeyValue, TimeRange, FieldConfigSource, ActionModel, FieldType, DataFrameWithValue, SelectableValue } from '@grafana/data';
import { TableCellHeight, TableFieldOptions } from '@grafana/schema';
import { TableCellInspectorMode } from '../TableCellInspector';
import { TableCellOptions } from '../types';
export declare const FILTER_FOR_OPERATOR = "=";
export declare const FILTER_OUT_OPERATOR = "!=";
export type AdHocFilterOperator = typeof FILTER_FOR_OPERATOR | typeof FILTER_OUT_OPERATOR;
export type AdHocFilterItem = {
    key: string;
    value: string;
    operator: AdHocFilterOperator;
};
export type TableFilterActionCallback = (item: AdHocFilterItem) => void;
export type TableColumnResizeActionCallback = (fieldDisplayName: string, width: number) => void;
export type TableSortByActionCallback = (state: TableSortByFieldState[]) => void;
export type FooterItem = Array<KeyValue<string>> | string | undefined;
export type GetActionsFunction = (frame: DataFrame, field: Field, rowIndex: number) => ActionModel[];
export type GetActionsFunctionLocal = (field: Field, rowIndex: number) => ActionModel[];
export type TableFieldOptionsType = Omit<TableFieldOptions, 'cellOptions'> & {
    cellOptions: TableCellOptions;
    headerComponent?: React.ComponentType<CustomHeaderRendererProps>;
};
export type FilterType = Record<string, {
    filteredSet: Set<string>;
    filtered?: Array<SelectableValue<unknown>>;
    searchFilter?: string;
    operator?: SelectableValue<string>;
}>;
export interface TableSummaryRow {
    [columnName: string]: string | number | undefined;
}
export interface TableColumn extends Column<TableRow, TableSummaryRow> {
    field: Field;
    width?: number | string;
    minWidth?: number;
}
export type TableCellValue = string | number | boolean | Date | DataFrame | DataFrame[] | DataFrameWithValue | undefined;
export interface TableRow {
    __depth: number;
    __index: number;
    data?: DataFrame;
    __nestedFrames?: DataFrame[];
    __expanded?: boolean;
    [columnName: string]: TableCellValue;
}
export interface CustomCellRendererProps {
    field: Field;
    rowIndex: number;
    frame: DataFrame;
    value: unknown;
}
export interface CustomHeaderRendererProps {
    field: Field;
    defaultContent: React.ReactNode;
}
export interface TableSortByFieldState {
    displayName: string;
    desc?: boolean;
}
export interface TableFooterCalc {
    show: boolean;
    reducer?: string[];
    fields?: string[];
    enablePagination?: boolean;
    countRows?: boolean;
}
export interface BaseTableProps {
    ariaLabel?: string;
    data: DataFrame;
    width: number;
    height: number;
    maxHeight?: number;
    /** Minimal column width specified in pixels */
    columnMinWidth?: number;
    noHeader?: boolean;
    showTypeIcons?: boolean;
    resizable?: boolean;
    initialSortBy?: TableSortByFieldState[];
    onColumnResize?: TableColumnResizeActionCallback;
    onSortByChange?: TableSortByActionCallback;
    onCellFilterAdded?: TableFilterActionCallback;
    footerOptions?: TableFooterCalc;
    footerValues?: FooterItem[];
    enablePagination?: boolean;
    cellHeight?: TableCellHeight;
    structureRev?: number;
    /** @alpha Used by SparklineCell when provided */
    timeRange?: TimeRange;
    enableSharedCrosshair?: boolean;
    initialRowIndex?: number;
    fieldConfig?: FieldConfigSource;
    getActions?: GetActionsFunction;
    enableVirtualization?: boolean;
}
export interface TableNGProps extends BaseTableProps {
}
export interface TableCellRendererProps {
    rowIdx: number;
    frame: DataFrame;
    timeRange?: TimeRange;
    value: TableCellValue;
    height: number;
    field: Field;
    cellOptions: TableCellOptions;
    width: number;
    theme: GrafanaTheme2;
    cellInspect: boolean;
    showFilters: boolean;
    justifyContent: Property.JustifyContent;
    getActions?: GetActionsFunctionLocal;
}
export type ContextMenuProps = {
    rowIdx?: number;
    value: string;
    mode?: TableCellInspectorMode.code | TableCellInspectorMode.text;
    top?: number;
    left?: number;
};
export interface TableCellActionsProps {
    field: Field;
    value: TableCellValue;
    cellOptions: TableCellOptions;
    displayName: string;
    cellInspect: boolean;
    showFilters: boolean;
    setIsInspecting: React.Dispatch<React.SetStateAction<boolean>>;
    setContextMenuProps: React.Dispatch<React.SetStateAction<ContextMenuProps | null>>;
    className?: string;
    onCellFilterAdded?: TableFilterActionCallback;
}
export interface RowExpanderNGProps {
    height: number;
    onCellExpand: (e: SyntheticEvent) => void;
    isExpanded?: boolean;
}
export interface SparklineCellProps {
    field: Field;
    justifyContent: Property.JustifyContent;
    rowIdx: number;
    theme: GrafanaTheme2;
    timeRange?: TimeRange;
    value: TableCellValue;
    width: number;
}
export interface BarGaugeCellProps {
    field: Field;
    height: number;
    rowIdx: number;
    theme: GrafanaTheme2;
    value: TableCellValue;
    width: number;
}
export interface ImageCellProps {
    cellOptions: TableCellOptions;
    field: Field;
    height: number;
    justifyContent: Property.JustifyContent;
    value: TableCellValue;
    rowIdx: number;
}
export interface JSONCellProps {
    justifyContent: Property.JustifyContent;
    value: TableCellValue;
    field: Field;
    rowIdx: number;
}
export interface DataLinksCellProps {
    field: Field;
    rowIdx: number;
}
export interface GeoCellProps {
    value: TableCellValue;
    justifyContent: Property.JustifyContent;
    height: number;
}
export interface CellColors {
    textColor?: string;
    bgColor?: string;
    bgHoverColor?: string;
}
export interface AutoCellProps {
    field: Field;
    value: TableCellValue;
    justifyContent: Property.JustifyContent;
    rowIdx: number;
    cellOptions: TableCellOptions;
}
export interface ActionCellProps {
    field: Field;
    rowIdx: number;
    getActions: GetActionsFunctionLocal;
}
export type Comparator = (a: TableCellValue, b: TableCellValue) => number;
export type FrameToRowsConverter = (frame: DataFrame) => TableRow[];
export type ColumnTypes = Record<string, FieldType>;
export interface ScrollPosition {
    x: number;
    y: number;
}
