import { Props as InputProps } from '../Input/Input';
import { ComboboxOption } from './types';
interface ComboboxStaticProps<T extends string | number> extends Pick<InputProps, 'placeholder' | 'autoFocus' | 'id' | 'aria-labelledby' | 'disabled' | 'loading' | 'invalid'> {
    /**
     * Allows the user to set a value which is not in the list of options.
     */
    createCustomValue?: boolean;
    /**
     * An array of options, or a function that returns a promise resolving to an array of options.
     * If a function, it will be called when the menu is opened and on keypress with the current search query.
     */
    options: Array<ComboboxOption<T>> | ((inputValue: string) => Promise<Array<ComboboxOption<T>>>);
    /**
     * Current selected value. Most consumers should pass a scalar value (string | number). However, sometimes with Async
     * it may be better to pass in an Option with a label to display.
     */
    value?: T | ComboboxOption<T> | null;
    /**
     * Defaults to full width of container. Number is a multiple of the spacing unit. 'auto' will size the input to the content.
     * */
    width?: number | 'auto';
    ['data-testid']?: string;
    /**
     * Called when the input loses focus.
     */
    onBlur?: () => void;
}
interface ClearableProps<T extends string | number> {
    /**
     * An `X` appears in the UI, which clears the input and sets the value to `null`. Do not use if you have no `null` case.
     */
    isClearable: true;
    /**
     * onChange handler is called with the newly selected option.
     */
    onChange: (option: ComboboxOption<T> | null) => void;
}
interface NotClearableProps<T extends string | number> {
    /**
     * An `X` appears in the UI, which clears the input and sets the value to `null`. Do not use if you have no `null` case.
     */
    isClearable?: false;
    /**
     * onChange handler is called with the newly selected option.
     */
    onChange: (option: ComboboxOption<T>) => void;
}
export type ComboboxBaseProps<T extends string | number> = (ClearableProps<T> | NotClearableProps<T>) & ComboboxStaticProps<T>;
export type AutoSizeConditionals = {
    width: 'auto';
    /**
     * Needs to be set when width is 'auto' to prevent the input from shrinking too much
     */
    minWidth: number;
    /**
     * Recommended to set when width is 'auto' to prevent the input from growing too much.
     */
    maxWidth?: number;
} | {
    width?: number;
    minWidth?: never;
    maxWidth?: never;
};
export type ComboboxProps<T extends string | number> = ComboboxBaseProps<T> & AutoSizeConditionals;
export declare const VIRTUAL_OVERSCAN_ITEMS = 4;
/**
 * A performant Select replacement.
 *
 * @alpha
 */
export declare const Combobox: <T extends string | number>(props: ComboboxProps<T>) => import("react/jsx-runtime").JSX.Element;
export {};
