import { jsx } from 'react/jsx-runtime';
import { t } from '@grafana/i18n';
import { Icon } from '../../Icon/Icon.mjs';

"use strict";
function RowExpander({ row, tableStyles }) {
  return /* @__PURE__ */ jsx("div", { className: tableStyles.expanderCell, ...row.getToggleRowExpandedProps(), children: /* @__PURE__ */ jsx(
    Icon,
    {
      "aria-label": row.isExpanded ? t("grafana-ui.row-expander.collapse", "Collapse row") : t("grafana-ui.row-expander.expand", "Expand row"),
      name: row.isExpanded ? "angle-down" : "angle-right",
      size: "lg"
    }
  ) });
}

export { RowExpander };
//# sourceMappingURL=RowExpander.mjs.map
