import { jsx, jsxs } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useMemo, useState, useCallback } from 'react';
import { Trans, t } from '@grafana/i18n';
import { useTheme2, useStyles2 } from '../../../themes/ThemeContext.mjs';
import { Button } from '../../Button/Button.mjs';
import { ClickOutsideWrapper } from '../../ClickOutsideWrapper/ClickOutsideWrapper.mjs';
import { Label } from '../../Forms/Label.mjs';
import { IconButton } from '../../IconButton/IconButton.mjs';
import { Stack } from '../../Layout/Stack/Stack.mjs';
import { calculateUniqueFieldValues, valuesToOptions, getFilteredOptions } from '../utils.mjs';
import { FilterList } from './FilterList.mjs';

"use strict";
const FilterPopup = ({
  column: { preFilteredRows, filterValue, setFilter },
  onClose,
  field,
  searchFilter,
  setSearchFilter,
  operator,
  setOperator
}) => {
  const theme = useTheme2();
  const uniqueValues = useMemo(() => calculateUniqueFieldValues(preFilteredRows, field), [preFilteredRows, field]);
  const options = useMemo(() => valuesToOptions(uniqueValues), [uniqueValues]);
  const filteredOptions = useMemo(() => getFilteredOptions(options, filterValue), [options, filterValue]);
  const [values, setValues] = useState(filteredOptions);
  const [matchCase, setMatchCase] = useState(false);
  const onCancel = useCallback((event) => onClose(), [onClose]);
  const onFilter = useCallback(
    (event) => {
      const filtered = values.length ? values : void 0;
      setFilter(filtered);
      onClose();
    },
    [setFilter, values, onClose]
  );
  const onClearFilter = useCallback(
    (event) => {
      setFilter(void 0);
      onClose();
    },
    [setFilter, onClose]
  );
  const clearFilterVisible = useMemo(() => filterValue !== void 0, [filterValue]);
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx(ClickOutsideWrapper, { onClick: onCancel, useCapture: true, children: /* @__PURE__ */ jsx("div", { className: cx(styles.filterContainer), onClick: stopPropagation, children: /* @__PURE__ */ jsxs(Stack, { direction: "column", gap: 3, children: [
    /* @__PURE__ */ jsxs(Stack, { direction: "column", gap: 0.5, children: [
      /* @__PURE__ */ jsxs(Stack, { justifyContent: "space-between", alignItems: "center", children: [
        /* @__PURE__ */ jsx(Label, { className: styles.label, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-heading", children: "Filter by values:" }) }),
        /* @__PURE__ */ jsx(
          IconButton,
          {
            name: "text-fields",
            tooltip: t("grafana-ui.table.filter-popup-match-case", "Match case"),
            style: { color: matchCase ? theme.colors.text.link : theme.colors.text.disabled },
            onClick: () => {
              setMatchCase((s) => !s);
            }
          }
        )
      ] }),
      /* @__PURE__ */ jsx("div", { className: cx(styles.listDivider) }),
      /* @__PURE__ */ jsx(
        FilterList,
        {
          onChange: setValues,
          values,
          options,
          caseSensitive: matchCase,
          showOperators: true,
          searchFilter,
          setSearchFilter,
          operator,
          setOperator
        }
      )
    ] }),
    /* @__PURE__ */ jsxs(Stack, { gap: 3, children: [
      /* @__PURE__ */ jsxs(Stack, { children: [
        /* @__PURE__ */ jsx(Button, { size: "sm", onClick: onFilter, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-apply", children: "Ok" }) }),
        /* @__PURE__ */ jsx(Button, { size: "sm", variant: "secondary", onClick: onCancel, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-cancel", children: "Cancel" }) })
      ] }),
      clearFilterVisible && /* @__PURE__ */ jsx(Stack, { children: /* @__PURE__ */ jsx(Button, { fill: "text", size: "sm", onClick: onClearFilter, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-clear", children: "Clear filter" }) }) })
    ] })
  ] }) }) });
};
const getStyles = (theme) => ({
  filterContainer: css({
    label: "filterContainer",
    width: "100%",
    minWidth: "250px",
    height: "100%",
    maxHeight: "400px",
    backgroundColor: theme.colors.background.primary,
    border: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(2),
    boxShadow: theme.shadows.z3,
    borderRadius: theme.shape.radius.default
  }),
  listDivider: css({
    label: "listDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  }),
  label: css({
    marginBottom: 0
  })
});
const stopPropagation = (event) => {
  event.stopPropagation();
};

export { FilterPopup };
//# sourceMappingURL=FilterPopup.mjs.map
