import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import { getCellLinks } from '../utils.mjs';

"use strict";
const DataLinksCell = ({ field, rowIdx }) => {
  const styles = useStyles2(getStyles);
  const links = getCellLinks(field, rowIdx);
  return /* @__PURE__ */ jsx("div", { children: links && links.map((link, idx) => {
    return !link.href && link.onClick == null ? /* @__PURE__ */ jsx("span", { className: styles.cellLinkEmpty, children: link.title }, idx) : (
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
      /* @__PURE__ */ jsx("span", { className: styles.linkCell, onClick: link.onClick, children: /* @__PURE__ */ jsx("a", { href: link.href, target: link.target, children: link.title }) }, idx)
    );
  }) });
};
const getStyles = (theme) => ({
  linkCell: css({
    cursor: "pointer",
    overflow: "hidden",
    textOverflow: "ellipsis",
    userSelect: "text",
    whiteSpace: "nowrap",
    color: theme.colors.text.link,
    fontWeight: theme.typography.fontWeightMedium,
    paddingRight: theme.spacing(1.5),
    a: {
      color: theme.colors.text.link
    },
    "&:hover": {
      textDecoration: "underline",
      color: theme.colors.text.link
    }
  }),
  cellLinkEmpty: css({
    overflow: "hidden",
    textOverflow: "ellipsis",
    userSelect: "text",
    whiteSpace: "nowrap",
    fontWeight: theme.typography.fontWeightMedium,
    paddingRight: theme.spacing(1.5)
  })
});

export { DataLinksCell };
//# sourceMappingURL=DataLinksCell.mjs.map
