import { jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { isEqual } from 'lodash';
import { Component, createRef } from 'react';
import { withTheme2 } from '../../themes/ThemeContext.mjs';
import { getSelectStyles } from './getSelectStyles.mjs';

"use strict";
class UnthemedValueContainer extends Component {
  constructor() {
    super(...arguments);
    this.ref = createRef();
  }
  componentDidUpdate(prevProps) {
    if (this.ref.current && this.props.selectProps.autoWidth && !isEqual(prevProps.selectProps.value, this.props.selectProps.value)) {
      this.ref.current.style.minWidth = "0px";
      const width = this.ref.current.offsetWidth;
      this.ref.current.style.minWidth = `${width}px`;
    }
  }
  render() {
    const { children } = this.props;
    const { selectProps } = this.props;
    if (selectProps && Array.isArray(children) && Array.isArray(children[0]) && selectProps.maxVisibleValues !== void 0 && !(selectProps.showAllSelectedWhenOpen && selectProps.menuIsOpen)) {
      const [valueChildren, ...otherChildren] = children;
      const truncatedValues = valueChildren.slice(0, selectProps.maxVisibleValues);
      return this.renderContainer([truncatedValues, ...otherChildren]);
    }
    return this.renderContainer(children);
  }
  renderContainer(children) {
    var _a, _b;
    const { isMulti, theme, selectProps } = this.props;
    const noWrap = ((_a = this.props.selectProps) == null ? void 0 : _a.noMultiValueWrap) && !((_b = this.props.selectProps) == null ? void 0 : _b.menuIsOpen);
    const styles = getSelectStyles(theme);
    const dataTestid = selectProps["data-testid"];
    const className = cx(styles.valueContainer, {
      [styles.valueContainerMulti]: isMulti && !noWrap,
      [styles.valueContainerMultiNoWrap]: isMulti && noWrap
    });
    return /* @__PURE__ */ jsx("div", { ref: this.ref, "data-testid": dataTestid, className, children });
  }
}
const ValueContainer = withTheme2(UnthemedValueContainer);

export { ValueContainer };
//# sourceMappingURL=ValueContainer.mjs.map
