import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { selectors } from '@grafana/e2e-selectors';
import { t } from '@grafana/i18n';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { useAsyncDependency } from '../../utils/useAsyncDependency.mjs';
import { ErrorWithStack } from '../ErrorBoundary/ErrorWithStack.mjs';
import { LoadingPlaceholder } from '../LoadingPlaceholder/LoadingPlaceholder.mjs';

"use strict";
const ReactMonacoEditorLazy = (props) => {
  var _a, _b;
  const styles = useStyles2(getStyles);
  const { loading, error, dependency } = useAsyncDependency(
    import(
      /* webpackChunkName: "react-monaco-editor" */
      './ReactMonacoEditor.mjs'
    )
  );
  if (loading) {
    return /* @__PURE__ */ jsx(
      LoadingPlaceholder,
      {
        text: t("grafana-ui.monaco.loading-placeholder", "Loading editor"),
        className: styles.container
      }
    );
  }
  if (error) {
    return /* @__PURE__ */ jsx(
      ErrorWithStack,
      {
        title: t("grafana-ui.monaco.error-label", "React Monaco Editor failed to load"),
        error,
        errorInfo: { componentStack: (_a = error == null ? void 0 : error.stack) != null ? _a : "" }
      }
    );
  }
  const ReactMonacoEditor = dependency.ReactMonacoEditor;
  return /* @__PURE__ */ jsx(
    ReactMonacoEditor,
    {
      ...props,
      loading: (_b = props.loading) != null ? _b : null,
      wrapperProps: {
        "data-testid": selectors.components.ReactMonacoEditor.editorLazy
      }
    }
  );
};
const getStyles = (theme) => {
  return {
    container: css({
      marginBottom: "unset",
      marginLeft: theme.spacing(1)
    })
  };
};

export { ReactMonacoEditorLazy };
//# sourceMappingURL=ReactMonacoEditorLazy.mjs.map
