import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Spinner } from '../Spinner/Spinner.mjs';

"use strict";
const LoadingPlaceholder = ({ text, className, ...rest }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("div", { className: cx(styles.container, className), ...rest, children: [
    text,
    " ",
    /* @__PURE__ */ jsx(Spinner, { inline: true })
  ] });
};
const getStyles = (theme) => {
  return {
    container: css({
      marginBottom: theme.spacing(4)
    })
  };
};

export { LoadingPlaceholder };
//# sourceMappingURL=LoadingPlaceholder.mjs.map
