import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo, forwardRef } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { FeatureBadge } from '../FeatureBadge/FeatureBadge.mjs';
import { InfoBox } from './InfoBox.mjs';

"use strict";
const FeatureInfoBox = memo(
  forwardRef(({ title, featureState, ...otherProps }, ref) => {
    const styles = useStyles2(getFeatureInfoBoxStyles);
    const titleEl = featureState ? /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx("div", { className: styles.badge, children: /* @__PURE__ */ jsx(FeatureBadge, { featureState }) }),
      /* @__PURE__ */ jsx("h3", { children: title })
    ] }) : /* @__PURE__ */ jsx("h3", { children: title });
    return /* @__PURE__ */ jsx(InfoBox, { branded: true, title: titleEl, urlTitle: "Read documentation", ref, ...otherProps });
  })
);
FeatureInfoBox.displayName = "FeatureInfoBox";
const getFeatureInfoBoxStyles = (theme) => {
  return {
    badge: css({
      marginBottom: theme.spacing(1)
    })
  };
};

export { FeatureInfoBox };
//# sourceMappingURL=FeatureInfoBox.mjs.map
