import { jsx } from 'react/jsx-runtime';
import { forwardRef, useRef } from 'react';
import { unEscapeStringFromRegex, escapeStringForRegex } from '@grafana/data';
import { Trans } from '@grafana/i18n';
import { useCombinedRefs } from '../../utils/useCombinedRefs.mjs';
import { Button } from '../Button/Button.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { Input } from '../Input/Input.mjs';

"use strict";
const FilterInput = forwardRef(
  ({ value, width, onChange, escapeRegex = true, ...restProps }, ref) => {
    const innerRef = useRef(null);
    const combinedRef = useCombinedRefs(ref, innerRef);
    const suffix = value !== "" ? /* @__PURE__ */ jsx(
      Button,
      {
        icon: "times",
        fill: "text",
        size: "sm",
        onClick: (e) => {
          var _a;
          (_a = innerRef.current) == null ? void 0 : _a.focus();
          onChange("");
          e.stopPropagation();
        },
        children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.filter-input.clear", children: "Clear" })
      }
    ) : null;
    return /* @__PURE__ */ jsx(
      Input,
      {
        prefix: /* @__PURE__ */ jsx(Icon, { name: "search" }),
        suffix,
        width,
        type: "text",
        value: escapeRegex ? unEscapeStringFromRegex(value != null ? value : "") : value,
        onChange: (event) => onChange(escapeRegex ? escapeStringForRegex(event.currentTarget.value) : event.currentTarget.value),
        ...restProps,
        ref: combinedRef
      }
    );
  }
);
FilterInput.displayName = "FilterInput";

export { FilterInput };
//# sourceMappingURL=FilterInput.mjs.map
