import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { FocusScope } from '@react-aria/focus';
import * as React from 'react';
import { Component } from 'react';
import { colorManipulator } from '@grafana/data';
import { t } from '@grafana/i18n';
import { withTheme2 } from '../../themes/ThemeContext.mjs';
import { stylesFactory } from '../../themes/stylesFactory.mjs';
import { Tab } from '../Tabs/Tab.mjs';
import { TabsBar } from '../Tabs/TabsBar.mjs';
import { NamedColorsPalette } from './NamedColorsPalette.mjs';
import SpectrumPalette from './SpectrumPalette.mjs';

"use strict";
class UnThemedColorPickerPopover extends Component {
  constructor(props) {
    super(props);
    this.handleChange = (color) => {
      const { onChange, enableNamedColors, theme } = this.props;
      if (enableNamedColors) {
        return onChange(color);
      }
      onChange(colorManipulator.asHexString(theme.visualization.getColorByName(color)));
    };
    this.onTabChange = (tab) => {
      return () => this.setState({ activePicker: tab });
    };
    this.renderPicker = () => {
      const { activePicker } = this.state;
      const { color } = this.props;
      switch (activePicker) {
        case "spectrum":
          return /* @__PURE__ */ jsx(SpectrumPalette, { color, onChange: this.handleChange });
        case "palette":
          return /* @__PURE__ */ jsx(NamedColorsPalette, { color, onChange: this.handleChange });
        default:
          return this.renderCustomPicker(activePicker);
      }
    };
    this.renderCustomPicker = (tabKey) => {
      const { customPickers, color, theme } = this.props;
      if (!customPickers) {
        return null;
      }
      return React.createElement(customPickers[tabKey].tabComponent, {
        color,
        theme,
        onChange: this.handleChange
      });
    };
    this.renderCustomPickerTabs = () => {
      const { customPickers } = this.props;
      if (!customPickers) {
        return null;
      }
      return /* @__PURE__ */ jsx(Fragment, { children: Object.keys(customPickers).map((key) => {
        return /* @__PURE__ */ jsx(Tab, { label: customPickers[key].name, onChangeTab: this.onTabChange(key) }, key);
      }) });
    };
    this.state = {
      activePicker: "palette"
    };
  }
  render() {
    const { theme } = this.props;
    const { activePicker } = this.state;
    const styles = getStyles(theme);
    return /* @__PURE__ */ jsx(FocusScope, { contain: true, restoreFocus: true, autoFocus: true, children: /* @__PURE__ */ jsxs("div", { tabIndex: -1, className: styles.colorPickerPopover, children: [
      /* @__PURE__ */ jsxs(TabsBar, { children: [
        /* @__PURE__ */ jsx(
          Tab,
          {
            label: t("grafana-ui.color-picker-popover.palette-tab", "Colors"),
            onChangeTab: this.onTabChange("palette"),
            active: activePicker === "palette"
          }
        ),
        /* @__PURE__ */ jsx(
          Tab,
          {
            label: t("grafana-ui.color-picker-popover.spectrum-tab", "Custom"),
            onChangeTab: this.onTabChange("spectrum"),
            active: activePicker === "spectrum"
          }
        ),
        this.renderCustomPickerTabs()
      ] }),
      /* @__PURE__ */ jsx("div", { className: styles.colorPickerPopoverContent, children: this.renderPicker() })
    ] }) });
  }
}
const ColorPickerPopover = withTheme2(UnThemedColorPickerPopover);
ColorPickerPopover.displayName = "ColorPickerPopover";
const getStyles = stylesFactory((theme) => {
  return {
    colorPickerPopover: css({
      borderRadius: theme.shape.radius.default,
      boxShadow: theme.shadows.z3,
      background: theme.colors.background.elevated,
      padding: theme.spacing(0.5),
      border: `1px solid ${theme.colors.border.weak}`
    }),
    colorPickerPopoverContent: css({
      width: "246px",
      fontSize: theme.typography.bodySmall.fontSize,
      minHeight: "184px",
      height: "290px",
      padding: theme.spacing(1),
      display: "flex",
      flexDirection: "column"
    }),
    colorPickerPopoverTabs: css({
      display: "flex",
      width: "100%",
      borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
    })
  };
});

export { ColorPickerPopover };
//# sourceMappingURL=ColorPickerPopover.mjs.map
