import * as common from '@grafana/schema';
export declare const pluginVersion = "12.1.4";
export interface Options {
    controlsStorageKey?: string;
    dedupStrategy: common.LogsDedupStrategy;
    detailsMode?: ('inline' | 'sidebar');
    displayedFields?: Array<string>;
    enableInfiniteScrolling?: boolean;
    enableLogDetails: boolean;
    fontSize?: ('default' | 'small');
    isFilterLabelActive?: unknown;
    logLineMenuCustomItems?: unknown;
    logRowMenuIconsAfter?: unknown;
    logRowMenuIconsBefore?: unknown;
    /**
     * TODO: figure out how to define callbacks
     */
    onClickFilterLabel?: unknown;
    onClickFilterOutLabel?: unknown;
    onClickFilterOutString?: unknown;
    onClickFilterString?: unknown;
    onClickHideField?: unknown;
    onClickShowField?: unknown;
    onLogOptionsChange?: unknown;
    onNewLogsReceived?: unknown;
    prettifyLogMessage: boolean;
    showCommonLabels: boolean;
    showControls?: boolean;
    showLabels: boolean;
    showLogContextToggle: boolean;
    showTime: boolean;
    sortOrder: common.LogsSortOrder;
    syntaxHighlighting?: boolean;
    wrapLogMessage: boolean;
}
export declare const defaultOptions: Partial<Options>;
