import { FieldType } from '../../../types/dataFrame.mjs';
import { ValueMatcherID } from '../ids.mjs';

"use strict";
const isBetweenValueMatcher = {
  id: ValueMatcherID.between,
  name: "Is between",
  description: "Match when field value is between given option values.",
  get: (options) => {
    return (valueIndex, field) => {
      const value = field.values[valueIndex];
      if (isNaN(value)) {
        return false;
      }
      const fromVal = typeof options.from !== "number" ? parseInt(options.from, 10) : options.from;
      const toVal = typeof options.to !== "number" ? parseInt(options.to, 10) : options.to;
      return value > fromVal && value < toVal;
    };
  },
  getOptionsDisplayText: (options) => {
    return `Matches all rows where field value is between ${options.from} and ${options.to}.`;
  },
  isApplicable: (field) => field.type === FieldType.number || field.type === FieldType.time,
  getDefaultOptions: (field) => {
    if (field.type === FieldType.time) {
      return { from: "$__from", to: "$__to" };
    } else {
      return { from: 0, to: 100 };
    }
  }
};
const getRangeValueMatchers = () => [isBetweenValueMatcher];

export { getRangeValueMatchers };
//# sourceMappingURL=rangeMatchers.mjs.map
