import { PropsWithChildren } from 'react';
import { TimeRange } from '@grafana/data';
import { PrometheusLanguageProviderInterface } from '../../language_provider';
export interface Metric {
    name: string;
    details?: string;
}
/**
 * Context for the Metrics Browser component
 * Provides state and handlers for browsing and selecting Prometheus metrics and labels
 */
interface MetricsBrowserContextType {
    err: string;
    setErr: (err: string) => void;
    status: string;
    setStatus: (status: string) => void;
    seriesLimit: number;
    setSeriesLimit: (limit: number) => void;
    onChange: (selector: string) => void;
    metrics: Metric[];
    labelKeys: string[];
    labelValues: Record<string, string[]>;
    selectedMetric: string;
    selectedLabelKeys: string[];
    selectedLabelValues: Record<string, string[]>;
    onMetricClick: (name: string) => void;
    onLabelKeyClick: (name: string) => void;
    onLabelValueClick: (labelKey: string, labelValue: string, isSelected: boolean) => void;
    getSelector: () => string;
    onClearClick: () => void;
    validationStatus: string;
    onValidationClick: () => void;
}
type MetricsBrowserProviderProps = {
    timeRange: TimeRange;
    languageProvider: PrometheusLanguageProviderInterface;
    onChange: (selector: string) => void;
};
/**
 * Provider component for the Metrics Browser context
 * Manages state and data fetching for metrics, labels, and values
 */
export declare function MetricsBrowserProvider({ children, timeRange, languageProvider, onChange, }: PropsWithChildren<MetricsBrowserProviderProps>): import("react/jsx-runtime").JSX.Element;
/**
 * Hook to access the MetricsBrowser context
 * Must be used within a MetricsBrowserProvider
 */
export declare function useMetricsBrowser(): MetricsBrowserContextType;
export {};
