import { api } from './api.mjs';

"use strict";
const addTagTypes = ["API Discovery", "Receiver", "RoutingTree", "TemplateGroup", "TimeInterval"];
const injectedRtkApi = api.enhanceEndpoints({
  addTagTypes
}).injectEndpoints({
  endpoints: (build) => ({
    getApiResources: build.query({
      query: () => ({ url: `/apis/notifications.alerting.grafana.app/v0alpha1/` }),
      providesTags: ["API Discovery"]
    }),
    listReceiver: build.query({
      query: (queryArg) => ({
        url: `/receivers`,
        params: {
          pretty: queryArg.pretty,
          allowWatchBookmarks: queryArg.allowWatchBookmarks,
          continue: queryArg["continue"],
          fieldSelector: queryArg.fieldSelector,
          labelSelector: queryArg.labelSelector,
          limit: queryArg.limit,
          resourceVersion: queryArg.resourceVersion,
          resourceVersionMatch: queryArg.resourceVersionMatch,
          sendInitialEvents: queryArg.sendInitialEvents,
          timeoutSeconds: queryArg.timeoutSeconds,
          watch: queryArg.watch
        }
      }),
      providesTags: ["Receiver"]
    }),
    createReceiver: build.mutation({
      query: (queryArg) => ({
        url: `/receivers`,
        method: "POST",
        body: queryArg.receiver,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation
        }
      }),
      invalidatesTags: ["Receiver"]
    }),
    deletecollectionReceiver: build.mutation({
      query: (queryArg) => ({
        url: `/receivers`,
        method: "DELETE",
        params: {
          pretty: queryArg.pretty,
          continue: queryArg["continue"],
          dryRun: queryArg.dryRun,
          fieldSelector: queryArg.fieldSelector,
          gracePeriodSeconds: queryArg.gracePeriodSeconds,
          ignoreStoreReadErrorWithClusterBreakingPotential: queryArg.ignoreStoreReadErrorWithClusterBreakingPotential,
          labelSelector: queryArg.labelSelector,
          limit: queryArg.limit,
          orphanDependents: queryArg.orphanDependents,
          propagationPolicy: queryArg.propagationPolicy,
          resourceVersion: queryArg.resourceVersion,
          resourceVersionMatch: queryArg.resourceVersionMatch,
          sendInitialEvents: queryArg.sendInitialEvents,
          timeoutSeconds: queryArg.timeoutSeconds
        }
      }),
      invalidatesTags: ["Receiver"]
    }),
    getReceiver: build.query({
      query: (queryArg) => ({
        url: `/receivers/${queryArg.name}`,
        params: {
          pretty: queryArg.pretty
        }
      }),
      providesTags: ["Receiver"]
    }),
    replaceReceiver: build.mutation({
      query: (queryArg) => ({
        url: `/receivers/${queryArg.name}`,
        method: "PUT",
        body: queryArg.receiver,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation
        }
      }),
      invalidatesTags: ["Receiver"]
    }),
    deleteReceiver: build.mutation({
      query: (queryArg) => ({
        url: `/receivers/${queryArg.name}`,
        method: "DELETE",
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          gracePeriodSeconds: queryArg.gracePeriodSeconds,
          ignoreStoreReadErrorWithClusterBreakingPotential: queryArg.ignoreStoreReadErrorWithClusterBreakingPotential,
          orphanDependents: queryArg.orphanDependents,
          propagationPolicy: queryArg.propagationPolicy
        }
      }),
      invalidatesTags: ["Receiver"]
    }),
    updateReceiver: build.mutation({
      query: (queryArg) => ({
        url: `/receivers/${queryArg.name}`,
        method: "PATCH",
        body: queryArg.patch,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation,
          force: queryArg.force
        }
      }),
      invalidatesTags: ["Receiver"]
    }),
    listRoutingTree: build.query({
      query: (queryArg) => ({
        url: `/routingtrees`,
        params: {
          pretty: queryArg.pretty,
          allowWatchBookmarks: queryArg.allowWatchBookmarks,
          continue: queryArg["continue"],
          fieldSelector: queryArg.fieldSelector,
          labelSelector: queryArg.labelSelector,
          limit: queryArg.limit,
          resourceVersion: queryArg.resourceVersion,
          resourceVersionMatch: queryArg.resourceVersionMatch,
          sendInitialEvents: queryArg.sendInitialEvents,
          timeoutSeconds: queryArg.timeoutSeconds,
          watch: queryArg.watch
        }
      }),
      providesTags: ["RoutingTree"]
    }),
    createRoutingTree: build.mutation({
      query: (queryArg) => ({
        url: `/routingtrees`,
        method: "POST",
        body: queryArg.routingTree,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation
        }
      }),
      invalidatesTags: ["RoutingTree"]
    }),
    deletecollectionRoutingTree: build.mutation({
      query: (queryArg) => ({
        url: `/routingtrees`,
        method: "DELETE",
        params: {
          pretty: queryArg.pretty,
          continue: queryArg["continue"],
          dryRun: queryArg.dryRun,
          fieldSelector: queryArg.fieldSelector,
          gracePeriodSeconds: queryArg.gracePeriodSeconds,
          ignoreStoreReadErrorWithClusterBreakingPotential: queryArg.ignoreStoreReadErrorWithClusterBreakingPotential,
          labelSelector: queryArg.labelSelector,
          limit: queryArg.limit,
          orphanDependents: queryArg.orphanDependents,
          propagationPolicy: queryArg.propagationPolicy,
          resourceVersion: queryArg.resourceVersion,
          resourceVersionMatch: queryArg.resourceVersionMatch,
          sendInitialEvents: queryArg.sendInitialEvents,
          timeoutSeconds: queryArg.timeoutSeconds
        }
      }),
      invalidatesTags: ["RoutingTree"]
    }),
    getRoutingTree: build.query({
      query: (queryArg) => ({
        url: `/routingtrees/${queryArg.name}`,
        params: {
          pretty: queryArg.pretty
        }
      }),
      providesTags: ["RoutingTree"]
    }),
    replaceRoutingTree: build.mutation({
      query: (queryArg) => ({
        url: `/routingtrees/${queryArg.name}`,
        method: "PUT",
        body: queryArg.routingTree,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation
        }
      }),
      invalidatesTags: ["RoutingTree"]
    }),
    deleteRoutingTree: build.mutation({
      query: (queryArg) => ({
        url: `/routingtrees/${queryArg.name}`,
        method: "DELETE",
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          gracePeriodSeconds: queryArg.gracePeriodSeconds,
          ignoreStoreReadErrorWithClusterBreakingPotential: queryArg.ignoreStoreReadErrorWithClusterBreakingPotential,
          orphanDependents: queryArg.orphanDependents,
          propagationPolicy: queryArg.propagationPolicy
        }
      }),
      invalidatesTags: ["RoutingTree"]
    }),
    updateRoutingTree: build.mutation({
      query: (queryArg) => ({
        url: `/routingtrees/${queryArg.name}`,
        method: "PATCH",
        body: queryArg.patch,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation,
          force: queryArg.force
        }
      }),
      invalidatesTags: ["RoutingTree"]
    }),
    listTemplateGroup: build.query({
      query: (queryArg) => ({
        url: `/templategroups`,
        params: {
          pretty: queryArg.pretty,
          allowWatchBookmarks: queryArg.allowWatchBookmarks,
          continue: queryArg["continue"],
          fieldSelector: queryArg.fieldSelector,
          labelSelector: queryArg.labelSelector,
          limit: queryArg.limit,
          resourceVersion: queryArg.resourceVersion,
          resourceVersionMatch: queryArg.resourceVersionMatch,
          sendInitialEvents: queryArg.sendInitialEvents,
          timeoutSeconds: queryArg.timeoutSeconds,
          watch: queryArg.watch
        }
      }),
      providesTags: ["TemplateGroup"]
    }),
    createTemplateGroup: build.mutation({
      query: (queryArg) => ({
        url: `/templategroups`,
        method: "POST",
        body: queryArg.templateGroup,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation
        }
      }),
      invalidatesTags: ["TemplateGroup"]
    }),
    deletecollectionTemplateGroup: build.mutation({
      query: (queryArg) => ({
        url: `/templategroups`,
        method: "DELETE",
        params: {
          pretty: queryArg.pretty,
          continue: queryArg["continue"],
          dryRun: queryArg.dryRun,
          fieldSelector: queryArg.fieldSelector,
          gracePeriodSeconds: queryArg.gracePeriodSeconds,
          ignoreStoreReadErrorWithClusterBreakingPotential: queryArg.ignoreStoreReadErrorWithClusterBreakingPotential,
          labelSelector: queryArg.labelSelector,
          limit: queryArg.limit,
          orphanDependents: queryArg.orphanDependents,
          propagationPolicy: queryArg.propagationPolicy,
          resourceVersion: queryArg.resourceVersion,
          resourceVersionMatch: queryArg.resourceVersionMatch,
          sendInitialEvents: queryArg.sendInitialEvents,
          timeoutSeconds: queryArg.timeoutSeconds
        }
      }),
      invalidatesTags: ["TemplateGroup"]
    }),
    getTemplateGroup: build.query({
      query: (queryArg) => ({
        url: `/templategroups/${queryArg.name}`,
        params: {
          pretty: queryArg.pretty
        }
      }),
      providesTags: ["TemplateGroup"]
    }),
    replaceTemplateGroup: build.mutation({
      query: (queryArg) => ({
        url: `/templategroups/${queryArg.name}`,
        method: "PUT",
        body: queryArg.templateGroup,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation
        }
      }),
      invalidatesTags: ["TemplateGroup"]
    }),
    deleteTemplateGroup: build.mutation({
      query: (queryArg) => ({
        url: `/templategroups/${queryArg.name}`,
        method: "DELETE",
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          gracePeriodSeconds: queryArg.gracePeriodSeconds,
          ignoreStoreReadErrorWithClusterBreakingPotential: queryArg.ignoreStoreReadErrorWithClusterBreakingPotential,
          orphanDependents: queryArg.orphanDependents,
          propagationPolicy: queryArg.propagationPolicy
        }
      }),
      invalidatesTags: ["TemplateGroup"]
    }),
    updateTemplateGroup: build.mutation({
      query: (queryArg) => ({
        url: `/templategroups/${queryArg.name}`,
        method: "PATCH",
        body: queryArg.patch,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation,
          force: queryArg.force
        }
      }),
      invalidatesTags: ["TemplateGroup"]
    }),
    listTimeInterval: build.query({
      query: (queryArg) => ({
        url: `/timeintervals`,
        params: {
          pretty: queryArg.pretty,
          allowWatchBookmarks: queryArg.allowWatchBookmarks,
          continue: queryArg["continue"],
          fieldSelector: queryArg.fieldSelector,
          labelSelector: queryArg.labelSelector,
          limit: queryArg.limit,
          resourceVersion: queryArg.resourceVersion,
          resourceVersionMatch: queryArg.resourceVersionMatch,
          sendInitialEvents: queryArg.sendInitialEvents,
          timeoutSeconds: queryArg.timeoutSeconds,
          watch: queryArg.watch
        }
      }),
      providesTags: ["TimeInterval"]
    }),
    createTimeInterval: build.mutation({
      query: (queryArg) => ({
        url: `/timeintervals`,
        method: "POST",
        body: queryArg.timeInterval,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation
        }
      }),
      invalidatesTags: ["TimeInterval"]
    }),
    deletecollectionTimeInterval: build.mutation({
      query: (queryArg) => ({
        url: `/timeintervals`,
        method: "DELETE",
        params: {
          pretty: queryArg.pretty,
          continue: queryArg["continue"],
          dryRun: queryArg.dryRun,
          fieldSelector: queryArg.fieldSelector,
          gracePeriodSeconds: queryArg.gracePeriodSeconds,
          ignoreStoreReadErrorWithClusterBreakingPotential: queryArg.ignoreStoreReadErrorWithClusterBreakingPotential,
          labelSelector: queryArg.labelSelector,
          limit: queryArg.limit,
          orphanDependents: queryArg.orphanDependents,
          propagationPolicy: queryArg.propagationPolicy,
          resourceVersion: queryArg.resourceVersion,
          resourceVersionMatch: queryArg.resourceVersionMatch,
          sendInitialEvents: queryArg.sendInitialEvents,
          timeoutSeconds: queryArg.timeoutSeconds
        }
      }),
      invalidatesTags: ["TimeInterval"]
    }),
    getTimeInterval: build.query({
      query: (queryArg) => ({
        url: `/timeintervals/${queryArg.name}`,
        params: {
          pretty: queryArg.pretty
        }
      }),
      providesTags: ["TimeInterval"]
    }),
    replaceTimeInterval: build.mutation({
      query: (queryArg) => ({
        url: `/timeintervals/${queryArg.name}`,
        method: "PUT",
        body: queryArg.timeInterval,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation
        }
      }),
      invalidatesTags: ["TimeInterval"]
    }),
    deleteTimeInterval: build.mutation({
      query: (queryArg) => ({
        url: `/timeintervals/${queryArg.name}`,
        method: "DELETE",
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          gracePeriodSeconds: queryArg.gracePeriodSeconds,
          ignoreStoreReadErrorWithClusterBreakingPotential: queryArg.ignoreStoreReadErrorWithClusterBreakingPotential,
          orphanDependents: queryArg.orphanDependents,
          propagationPolicy: queryArg.propagationPolicy
        }
      }),
      invalidatesTags: ["TimeInterval"]
    }),
    updateTimeInterval: build.mutation({
      query: (queryArg) => ({
        url: `/timeintervals/${queryArg.name}`,
        method: "PATCH",
        body: queryArg.patch,
        params: {
          pretty: queryArg.pretty,
          dryRun: queryArg.dryRun,
          fieldManager: queryArg.fieldManager,
          fieldValidation: queryArg.fieldValidation,
          force: queryArg.force
        }
      }),
      invalidatesTags: ["TimeInterval"]
    })
  }),
  overrideExisting: false
});

export { addTagTypes, injectedRtkApi as alertingAPI };
//# sourceMappingURL=api.gen.mjs.map
